/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.runtime;

import java.util.Collection;
import org.camunda.bpm.engine.authorization.Permission;
import org.camunda.bpm.engine.authorization.Permissions;
import org.camunda.bpm.engine.authorization.Resource;
import org.camunda.bpm.engine.authorization.Resources;
import org.camunda.bpm.engine.repository.ProcessDefinition;
import org.camunda.bpm.engine.runtime.ProcessInstance;
import org.camunda.bpm.engine.runtime.RestartProcessInstanceBuilder;
import org.camunda.bpm.engine.test.ProcessEngineRule;
import org.camunda.bpm.engine.test.RequiredHistoryLevel;
import org.camunda.bpm.engine.test.api.authorization.util.AuthorizationScenario;
import org.camunda.bpm.engine.test.api.authorization.util.AuthorizationSpec;
import org.camunda.bpm.engine.test.api.authorization.util.AuthorizationTestRule;
import org.camunda.bpm.engine.test.api.runtime.migration.models.ProcessModels;
import org.camunda.bpm.engine.test.util.ProcessEngineTestRule;
import org.camunda.bpm.engine.test.util.ProvidedProcessEngineRule;
import org.junit.After;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RequiredHistoryLevel(value="full")
@RunWith(value=Parameterized.class)
public class RestartAuthorizationTest {
    protected static final String TEST_REASON = "test reason";
    protected ProcessEngineRule engineRule = new ProvidedProcessEngineRule();
    protected AuthorizationTestRule authRule = new AuthorizationTestRule(this.engineRule);
    protected ProcessEngineTestRule testRule = new ProcessEngineTestRule(this.engineRule);
    @Rule
    public RuleChain ruleChain = RuleChain.outerRule((TestRule)this.engineRule).around((TestRule)this.authRule).around((TestRule)this.testRule);
    @Parameterized.Parameter
    public AuthorizationScenario scenario;

    @Parameterized.Parameters(name="Scenario {index}")
    public static Collection<AuthorizationScenario[]> scenarios() {
        return AuthorizationTestRule.asParameters(AuthorizationScenario.scenario().withoutAuthorizations().failsDueToRequired(AuthorizationSpec.grant((Resource)Resources.PROCESS_DEFINITION, "Process", "userId", new Permission[]{Permissions.READ_HISTORY})), AuthorizationScenario.scenario().withAuthorizations(AuthorizationSpec.grant((Resource)Resources.PROCESS_DEFINITION, "Process", "userId", new Permission[]{Permissions.READ_HISTORY})).failsDueToRequired(AuthorizationSpec.grant((Resource)Resources.PROCESS_INSTANCE, "*", "userId", new Permission[]{Permissions.CREATE})), AuthorizationScenario.scenario().withAuthorizations(AuthorizationSpec.grant((Resource)Resources.PROCESS_DEFINITION, "Process", "userId", new Permission[]{Permissions.READ_HISTORY, Permissions.CREATE_INSTANCE}), AuthorizationSpec.grant((Resource)Resources.PROCESS_INSTANCE, "*", "userId", new Permission[]{Permissions.CREATE})).succeeds());
    }

    @After
    public void tearDown() {
        this.authRule.deleteUsersAndGroups();
    }

    @Test
    public void execute() {
        ProcessDefinition processDefinition = this.testRule.deployAndGetDefinition(ProcessModels.TWO_TASKS_PROCESS);
        ProcessInstance processInstance1 = this.engineRule.getRuntimeService().startProcessInstanceByKey("Process");
        ProcessInstance processInstance2 = this.engineRule.getRuntimeService().startProcessInstanceByKey("Process");
        this.engineRule.getRuntimeService().deleteProcessInstance(processInstance1.getId(), TEST_REASON);
        this.engineRule.getRuntimeService().deleteProcessInstance(processInstance2.getId(), TEST_REASON);
        this.authRule.init(this.scenario).withUser("userId").bindResource("processInstance1", processInstance1.getId()).bindResource("restartedProcessInstance", "*").bindResource("processInstance2", processInstance2.getId()).bindResource("processDefinition", "Process").start();
        ((RestartProcessInstanceBuilder)this.engineRule.getRuntimeService().restartProcessInstances(processDefinition.getId()).processInstanceIds(new String[]{processInstance1.getId(), processInstance2.getId()}).startAfterActivity("userTask1")).execute();
        this.authRule.assertScenario(this.scenario);
    }
}

