/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.variables;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.camunda.bpm.engine.runtime.ProcessInstance;
import org.camunda.bpm.engine.test.Deployment;
import org.camunda.bpm.engine.test.history.RemoveAndUpdateValueDelegate;
import org.camunda.bpm.engine.test.history.ReplaceAndUpdateValueDelegate;
import org.camunda.bpm.engine.test.history.UpdateValueDelegate;
import org.camunda.bpm.engine.test.util.PluggableProcessEngineTest;
import org.camunda.bpm.engine.variable.Variables;
import org.junit.Assert;
import org.junit.Test;

public class ImplicitVariableUpdateTest
extends PluggableProcessEngineTest {
    @Deployment(resources={"org/camunda/bpm/engine/test/api/variables/ImplicitVariableUpdateTest.sequence.bpmn20.xml"})
    @Test
    public void testUpdate() {
        ProcessInstance instance = this.runtimeService.startProcessInstanceByKey("serviceTaskProcess", (Map)Variables.createVariables().putValue("listVar", new ArrayList()).putValue("delegate", (Object)new UpdateValueDelegate()));
        List list = (List)this.runtimeService.getVariable(instance.getId(), "listVar");
        Assert.assertNotNull((Object)list);
        Assert.assertEquals((long)1L, (long)list.size());
        Assert.assertEquals((Object)"new element", list.get(0));
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/variables/ImplicitVariableUpdateTest.parallel.bpmn20.xml"})
    @Test
    public void testUpdateParallelFlow() {
        ProcessInstance instance = this.runtimeService.startProcessInstanceByKey("serviceTaskProcess", (Map)Variables.createVariables().putValue("listVar", new ArrayList()).putValue("delegate", (Object)new UpdateValueDelegate()));
        List list = (List)this.runtimeService.getVariable(instance.getId(), "listVar");
        Assert.assertNotNull((Object)list);
        Assert.assertEquals((long)1L, (long)list.size());
        Assert.assertEquals((Object)"new element", list.get(0));
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/variables/ImplicitVariableUpdateTest.sequence.bpmn20.xml"})
    @Test
    public void testUpdatePreviousValue() {
        ProcessInstance instance = this.runtimeService.startProcessInstanceByKey("serviceTaskProcess", (Map)Variables.createVariables().putValue("listVar", new ArrayList()).putValue("delegate", (Object)new ReplaceAndUpdateValueDelegate()));
        List list = (List)this.runtimeService.getVariable(instance.getId(), "listVar");
        Assert.assertNotNull((Object)list);
        Assert.assertTrue((boolean)list.isEmpty());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/variables/ImplicitVariableUpdateTest.sequence.bpmn20.xml"})
    @Test
    public void testRemoveAndUpdateValue() {
        ProcessInstance instance = this.runtimeService.startProcessInstanceByKey("serviceTaskProcess", (Map)Variables.createVariables().putValue("listVar", new ArrayList()).putValue("delegate", (Object)new RemoveAndUpdateValueDelegate()));
        Object variableValue = this.runtimeService.getVariable(instance.getId(), "listVar");
        Assert.assertNull((Object)variableValue);
    }
}

