/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.history.removaltime.batch;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.camunda.bpm.engine.BadUserRequestException;
import org.camunda.bpm.engine.DecisionService;
import org.camunda.bpm.engine.HistoryService;
import org.camunda.bpm.engine.ManagementService;
import org.camunda.bpm.engine.RuntimeService;
import org.camunda.bpm.engine.batch.Batch;
import org.camunda.bpm.engine.batch.history.HistoricBatch;
import org.camunda.bpm.engine.batch.history.HistoricBatchQuery;
import org.camunda.bpm.engine.history.CleanableHistoricBatchReportResult;
import org.camunda.bpm.engine.history.CleanableHistoricDecisionInstanceReportResult;
import org.camunda.bpm.engine.history.CleanableHistoricProcessInstanceReportResult;
import org.camunda.bpm.engine.history.HistoricDecisionInstance;
import org.camunda.bpm.engine.history.HistoricDecisionInstanceQuery;
import org.camunda.bpm.engine.history.HistoricProcessInstance;
import org.camunda.bpm.engine.history.HistoricProcessInstanceQuery;
import org.camunda.bpm.engine.history.SetRemovalTimeSelectModeForHistoricBatchesBuilder;
import org.camunda.bpm.engine.history.SetRemovalTimeSelectModeForHistoricDecisionInstancesBuilder;
import org.camunda.bpm.engine.history.SetRemovalTimeSelectModeForHistoricProcessInstancesBuilder;
import org.camunda.bpm.engine.history.SetRemovalTimeToHistoricBatchesBuilder;
import org.camunda.bpm.engine.history.SetRemovalTimeToHistoricDecisionInstancesBuilder;
import org.camunda.bpm.engine.history.SetRemovalTimeToHistoricProcessInstancesBuilder;
import org.camunda.bpm.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.camunda.bpm.engine.impl.util.ClockUtil;
import org.camunda.bpm.engine.runtime.Job;
import org.camunda.bpm.engine.test.Deployment;
import org.camunda.bpm.engine.test.ProcessEngineRule;
import org.camunda.bpm.engine.test.RequiredHistoryLevel;
import org.camunda.bpm.engine.test.api.history.removaltime.batch.helper.BatchSetRemovalTimeRule;
import org.camunda.bpm.engine.test.util.ProcessEngineTestRule;
import org.camunda.bpm.engine.test.util.ProvidedProcessEngineRule;
import org.camunda.bpm.engine.variable.Variables;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;

@RequiredHistoryLevel(value="full")
public class BatchSetRemovalTimeTest {
    protected ProcessEngineRule engineRule = new ProvidedProcessEngineRule();
    protected ProcessEngineTestRule engineTestRule = new ProcessEngineTestRule(this.engineRule);
    protected BatchSetRemovalTimeRule testRule = new BatchSetRemovalTimeRule(this.engineRule, this.engineTestRule);
    @Rule
    public RuleChain ruleChain = RuleChain.outerRule((TestRule)this.engineRule).around((TestRule)this.engineTestRule).around((TestRule)this.testRule);
    protected final Date CURRENT_DATE;
    protected final Date REMOVAL_TIME;
    protected RuntimeService runtimeService;
    private DecisionService decisionService;
    protected HistoryService historyService;
    protected ManagementService managementService;

    public BatchSetRemovalTimeTest() {
        this.CURRENT_DATE = this.testRule.CURRENT_DATE;
        this.REMOVAL_TIME = this.testRule.REMOVAL_TIME;
    }

    @Before
    public void assignServices() {
        this.runtimeService = this.engineRule.getRuntimeService();
        this.decisionService = this.engineRule.getDecisionService();
        this.historyService = this.engineRule.getHistoryService();
        this.managementService = this.engineRule.getManagementService();
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/dmn/deployment/drdDish.dmn11.xml"})
    public void shouldNotSetRemovalTime_DmnDisabled() {
        this.testRule.getProcessEngineConfiguration().setDmnEnabled(false);
        this.testRule.process().ruleTask("dish-decision").deploy().startWithVariables((Map<String, Object>)Variables.createVariables().putValue("temperature", (Object)32).putValue("dayType", (Object)"Weekend"));
        List historicDecisionInstances = this.historyService.createHistoricDecisionInstanceQuery().list();
        Assertions.assertThat((Date)((HistoricDecisionInstance)historicDecisionInstances.get(0)).getRemovalTime()).isNull();
        Assertions.assertThat((Date)((HistoricDecisionInstance)historicDecisionInstances.get(1)).getRemovalTime()).isNull();
        Assertions.assertThat((Date)((HistoricDecisionInstance)historicDecisionInstances.get(2)).getRemovalTime()).isNull();
        HistoricProcessInstanceQuery query = this.historyService.createHistoricProcessInstanceQuery();
        this.testRule.syncExec(this.historyService.setRemovalTimeToHistoricProcessInstances().absoluteRemovalTime(this.REMOVAL_TIME).byQuery(query).executeAsync());
        historicDecisionInstances = this.historyService.createHistoricDecisionInstanceQuery().list();
        Assertions.assertThat((Date)((HistoricDecisionInstance)historicDecisionInstances.get(0)).getRemovalTime()).isNull();
        Assertions.assertThat((Date)((HistoricDecisionInstance)historicDecisionInstances.get(1)).getRemovalTime()).isNull();
        Assertions.assertThat((Date)((HistoricDecisionInstance)historicDecisionInstances.get(2)).getRemovalTime()).isNull();
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/dmn/deployment/drdDish.dmn11.xml"})
    public void shouldNotSetRemovalTimeInHierarchy_DmnDisabled() {
        this.testRule.getProcessEngineConfiguration().setDmnEnabled(false);
        this.testRule.process().call().passVars("temperature", "dayType").ruleTask("dish-decision").deploy().startWithVariables((Map<String, Object>)Variables.createVariables().putValue("temperature", (Object)32).putValue("dayType", (Object)"Weekend"));
        List historicDecisionInstances = this.historyService.createHistoricDecisionInstanceQuery().list();
        Assertions.assertThat((Date)((HistoricDecisionInstance)historicDecisionInstances.get(0)).getRemovalTime()).isNull();
        Assertions.assertThat((Date)((HistoricDecisionInstance)historicDecisionInstances.get(1)).getRemovalTime()).isNull();
        Assertions.assertThat((Date)((HistoricDecisionInstance)historicDecisionInstances.get(2)).getRemovalTime()).isNull();
        HistoricProcessInstanceQuery query = this.historyService.createHistoricProcessInstanceQuery().rootProcessInstances();
        this.testRule.syncExec(this.historyService.setRemovalTimeToHistoricProcessInstances().calculatedRemovalTime().byQuery(query).hierarchical().executeAsync());
        historicDecisionInstances = this.historyService.createHistoricDecisionInstanceQuery().list();
        Assertions.assertThat((Date)((HistoricDecisionInstance)historicDecisionInstances.get(0)).getRemovalTime()).isNull();
        Assertions.assertThat((Date)((HistoricDecisionInstance)historicDecisionInstances.get(1)).getRemovalTime()).isNull();
        Assertions.assertThat((Date)((HistoricDecisionInstance)historicDecisionInstances.get(2)).getRemovalTime()).isNull();
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/dmn/deployment/drdDish.dmn11.xml"})
    public void shouldNotSetRemovalTimeForStandaloneDecision_DmnDisabled() {
        this.testRule.getProcessEngineConfiguration().setDmnEnabled(false);
        this.decisionService.evaluateDecisionByKey("dish-decision").variables((Map)Variables.createVariables().putValue("temperature", (Object)32).putValue("dayType", (Object)"Weekend")).evaluate();
        List historicDecisionInstances = this.historyService.createHistoricDecisionInstanceQuery().list();
        Assertions.assertThat((Date)((HistoricDecisionInstance)historicDecisionInstances.get(0)).getRemovalTime()).isNull();
        Assertions.assertThat((Date)((HistoricDecisionInstance)historicDecisionInstances.get(1)).getRemovalTime()).isNull();
        Assertions.assertThat((Date)((HistoricDecisionInstance)historicDecisionInstances.get(2)).getRemovalTime()).isNull();
        HistoricDecisionInstanceQuery query = this.historyService.createHistoricDecisionInstanceQuery();
        this.testRule.syncExec(this.historyService.setRemovalTimeToHistoricDecisionInstances().absoluteRemovalTime(this.REMOVAL_TIME).byQuery(query).executeAsync());
        historicDecisionInstances = this.historyService.createHistoricDecisionInstanceQuery().list();
        Assertions.assertThat((Date)((HistoricDecisionInstance)historicDecisionInstances.get(0)).getRemovalTime()).isNull();
        Assertions.assertThat((Date)((HistoricDecisionInstance)historicDecisionInstances.get(1)).getRemovalTime()).isNull();
        Assertions.assertThat((Date)((HistoricDecisionInstance)historicDecisionInstances.get(2)).getRemovalTime()).isNull();
    }

    @Test
    public void shouldCreateDeploymentAwareBatchJobs_ProcessInstances() {
        this.testRule.getProcessEngineConfiguration().setInvocationsPerBatchJob(2);
        this.testRule.process().userTask().deploy().start();
        this.testRule.process().userTask().deploy().start();
        List deploymentIds = this.engineRule.getRepositoryService().createDeploymentQuery().list().stream().map(org.camunda.bpm.engine.repository.Deployment::getId).collect(Collectors.toList());
        Batch batch = this.historyService.setRemovalTimeToHistoricProcessInstances().absoluteRemovalTime(this.REMOVAL_TIME).byQuery(this.historyService.createHistoricProcessInstanceQuery()).executeAsync();
        this.testRule.executeSeedJobs(batch);
        List<Job> executionJobs = this.testRule.getExecutionJobs(batch);
        Assertions.assertThat(executionJobs).hasSize(2);
        Assertions.assertThat((String)executionJobs.get(0).getDeploymentId()).isIn(deploymentIds);
        Assertions.assertThat((String)executionJobs.get(1).getDeploymentId()).isIn(deploymentIds);
        Assertions.assertThat((String)executionJobs.get(0).getDeploymentId()).isNotEqualTo((Object)executionJobs.get(1).getDeploymentId());
        this.managementService.deleteBatch(batch.getId(), true);
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/dmn/deployment/drdDish.dmn11.xml"})
    public void shouldCreateDeploymentAwareBatchJobs_StandaloneDecision() {
        this.testRule.getProcessEngineConfiguration().setInvocationsPerBatchJob(3);
        this.decisionService.evaluateDecisionByKey("dish-decision").variables((Map)Variables.createVariables().putValue("temperature", (Object)32).putValue("dayType", (Object)"Weekend")).evaluate();
        this.engineTestRule.deploy("org/camunda/bpm/engine/test/dmn/deployment/drdDish.dmn11.xml");
        this.decisionService.evaluateDecisionByKey("dish-decision").variables((Map)Variables.createVariables().putValue("temperature", (Object)32).putValue("dayType", (Object)"Weekend")).evaluate();
        List deploymentIds = this.engineRule.getRepositoryService().createDeploymentQuery().list().stream().map(org.camunda.bpm.engine.repository.Deployment::getId).collect(Collectors.toList());
        Batch batch = this.historyService.setRemovalTimeToHistoricDecisionInstances().absoluteRemovalTime(this.REMOVAL_TIME).byQuery(this.historyService.createHistoricDecisionInstanceQuery()).executeAsync();
        this.testRule.executeSeedJobs(batch);
        List<Job> executionJobs = this.testRule.getExecutionJobs(batch);
        Assertions.assertThat(executionJobs).hasSize(2);
        Assertions.assertThat((String)executionJobs.get(0).getDeploymentId()).isIn(deploymentIds);
        Assertions.assertThat((String)executionJobs.get(1).getDeploymentId()).isIn(deploymentIds);
        Assertions.assertThat((String)executionJobs.get(0).getDeploymentId()).isNotEqualTo((Object)executionJobs.get(1).getDeploymentId());
        this.managementService.deleteBatch(batch.getId(), true);
    }

    @Test
    public void shouldSetRemovalTime_MultipleInvocationsPerBatchJob() {
        this.testRule.getProcessEngineConfiguration().setInvocationsPerBatchJob(2);
        this.testRule.process().userTask().deploy().start();
        this.testRule.process().userTask().deploy().start();
        List historicProcessInstances = this.historyService.createHistoricProcessInstanceQuery().list();
        Assertions.assertThat((Date)((HistoricProcessInstance)historicProcessInstances.get(0)).getRemovalTime()).isNull();
        Assertions.assertThat((Date)((HistoricProcessInstance)historicProcessInstances.get(1)).getRemovalTime()).isNull();
        HistoricProcessInstanceQuery query = this.historyService.createHistoricProcessInstanceQuery();
        this.testRule.syncExec(this.historyService.setRemovalTimeToHistoricProcessInstances().absoluteRemovalTime(this.REMOVAL_TIME).byQuery(query).executeAsync());
        historicProcessInstances = this.historyService.createHistoricProcessInstanceQuery().list();
        Assertions.assertThat((Date)((HistoricProcessInstance)historicProcessInstances.get(0)).getRemovalTime()).isEqualTo((Object)this.REMOVAL_TIME);
        Assertions.assertThat((Date)((HistoricProcessInstance)historicProcessInstances.get(1)).getRemovalTime()).isEqualTo((Object)this.REMOVAL_TIME);
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/dmn/deployment/drdDish.dmn11.xml"})
    public void shouldSetRemovalTimeForStandaloneDecision_MultipleInvocationsPerBatchJob() {
        this.testRule.getProcessEngineConfiguration().setInvocationsPerBatchJob(2);
        this.decisionService.evaluateDecisionByKey("dish-decision").variables((Map)Variables.createVariables().putValue("temperature", (Object)32).putValue("dayType", (Object)"Weekend")).evaluate();
        List historicDecisionInstances = this.historyService.createHistoricDecisionInstanceQuery().list();
        Assertions.assertThat((Date)((HistoricDecisionInstance)historicDecisionInstances.get(0)).getRemovalTime()).isNull();
        Assertions.assertThat((Date)((HistoricDecisionInstance)historicDecisionInstances.get(1)).getRemovalTime()).isNull();
        Assertions.assertThat((Date)((HistoricDecisionInstance)historicDecisionInstances.get(2)).getRemovalTime()).isNull();
        HistoricDecisionInstanceQuery query = this.historyService.createHistoricDecisionInstanceQuery();
        this.testRule.syncExec(this.historyService.setRemovalTimeToHistoricDecisionInstances().absoluteRemovalTime(this.REMOVAL_TIME).byQuery(query).executeAsync());
        historicDecisionInstances = this.historyService.createHistoricDecisionInstanceQuery().list();
        Assertions.assertThat((Date)((HistoricDecisionInstance)historicDecisionInstances.get(0)).getRemovalTime()).isEqualTo((Object)this.REMOVAL_TIME);
        Assertions.assertThat((Date)((HistoricDecisionInstance)historicDecisionInstances.get(1)).getRemovalTime()).isEqualTo((Object)this.REMOVAL_TIME);
        Assertions.assertThat((Date)((HistoricDecisionInstance)historicDecisionInstances.get(2)).getRemovalTime()).isEqualTo((Object)this.REMOVAL_TIME);
    }

    @Test
    public void shouldSetRemovalTimeForBatch_MultipleInvocationsPerBatchJob() {
        this.testRule.getProcessEngineConfiguration().setInvocationsPerBatchJob(2);
        String processInstanceIdOne = this.testRule.process().userTask().deploy().start();
        Batch batchOne = this.historyService.deleteHistoricProcessInstancesAsync(Collections.singletonList(processInstanceIdOne), "");
        String processInstanceIdTwo = this.testRule.process().userTask().deploy().start();
        Batch batchTwo = this.historyService.deleteHistoricProcessInstancesAsync(Collections.singletonList(processInstanceIdTwo), "");
        List historicBatches = this.historyService.createHistoricBatchQuery().type("historic-instance-deletion").list();
        Assertions.assertThat((Date)((HistoricBatch)historicBatches.get(0)).getRemovalTime()).isNull();
        Assertions.assertThat((Date)((HistoricBatch)historicBatches.get(1)).getRemovalTime()).isNull();
        HistoricBatchQuery query = this.historyService.createHistoricBatchQuery();
        this.testRule.syncExec(this.historyService.setRemovalTimeToHistoricBatches().absoluteRemovalTime(this.REMOVAL_TIME).byQuery(query).executeAsync());
        historicBatches = this.historyService.createHistoricBatchQuery().type("historic-instance-deletion").list();
        Assertions.assertThat((Date)((HistoricBatch)historicBatches.get(0)).getRemovalTime()).isEqualTo((Object)this.REMOVAL_TIME);
        Assertions.assertThat((Date)((HistoricBatch)historicBatches.get(1)).getRemovalTime()).isEqualTo((Object)this.REMOVAL_TIME);
        this.managementService.deleteBatch(batchOne.getId(), true);
        this.managementService.deleteBatch(batchTwo.getId(), true);
    }

    @Test
    public void shouldSetRemovalTime_SingleInvocationPerBatchJob() {
        this.testRule.getProcessEngineConfiguration().setInvocationsPerBatchJob(1);
        this.testRule.process().userTask().deploy().start();
        this.testRule.process().userTask().deploy().start();
        List historicProcessInstances = this.historyService.createHistoricProcessInstanceQuery().list();
        Assertions.assertThat((Date)((HistoricProcessInstance)historicProcessInstances.get(0)).getRemovalTime()).isNull();
        Assertions.assertThat((Date)((HistoricProcessInstance)historicProcessInstances.get(1)).getRemovalTime()).isNull();
        HistoricProcessInstanceQuery query = this.historyService.createHistoricProcessInstanceQuery();
        this.testRule.syncExec(this.historyService.setRemovalTimeToHistoricProcessInstances().absoluteRemovalTime(this.REMOVAL_TIME).byQuery(query).executeAsync());
        historicProcessInstances = this.historyService.createHistoricProcessInstanceQuery().list();
        Assertions.assertThat((Date)((HistoricProcessInstance)historicProcessInstances.get(0)).getRemovalTime()).isEqualTo((Object)this.REMOVAL_TIME);
        Assertions.assertThat((Date)((HistoricProcessInstance)historicProcessInstances.get(1)).getRemovalTime()).isEqualTo((Object)this.REMOVAL_TIME);
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/dmn/deployment/drdDish.dmn11.xml"})
    public void shouldSetRemovalTimeForStandaloneDecision_SingleInvocationPerBatchJob() {
        this.testRule.getProcessEngineConfiguration().setInvocationsPerBatchJob(1);
        this.decisionService.evaluateDecisionByKey("dish-decision").variables((Map)Variables.createVariables().putValue("temperature", (Object)32).putValue("dayType", (Object)"Weekend")).evaluate();
        List historicDecisionInstances = this.historyService.createHistoricDecisionInstanceQuery().list();
        Assertions.assertThat((Date)((HistoricDecisionInstance)historicDecisionInstances.get(0)).getRemovalTime()).isNull();
        Assertions.assertThat((Date)((HistoricDecisionInstance)historicDecisionInstances.get(1)).getRemovalTime()).isNull();
        Assertions.assertThat((Date)((HistoricDecisionInstance)historicDecisionInstances.get(2)).getRemovalTime()).isNull();
        HistoricDecisionInstanceQuery query = this.historyService.createHistoricDecisionInstanceQuery();
        this.testRule.syncExec(this.historyService.setRemovalTimeToHistoricDecisionInstances().absoluteRemovalTime(this.REMOVAL_TIME).byQuery(query).executeAsync());
        historicDecisionInstances = this.historyService.createHistoricDecisionInstanceQuery().list();
        Assertions.assertThat((Date)((HistoricDecisionInstance)historicDecisionInstances.get(0)).getRemovalTime()).isEqualTo((Object)this.REMOVAL_TIME);
        Assertions.assertThat((Date)((HistoricDecisionInstance)historicDecisionInstances.get(1)).getRemovalTime()).isEqualTo((Object)this.REMOVAL_TIME);
        Assertions.assertThat((Date)((HistoricDecisionInstance)historicDecisionInstances.get(2)).getRemovalTime()).isEqualTo((Object)this.REMOVAL_TIME);
    }

    @Test
    public void shouldSetRemovalTimeForBatch_SingleInvocationPerBatchJob() {
        this.testRule.getProcessEngineConfiguration().setInvocationsPerBatchJob(1);
        String processInstanceIdOne = this.testRule.process().userTask().deploy().start();
        Batch batchOne = this.historyService.deleteHistoricProcessInstancesAsync(Collections.singletonList(processInstanceIdOne), "");
        String processInstanceIdTwo = this.testRule.process().userTask().deploy().start();
        Batch batchTwo = this.historyService.deleteHistoricProcessInstancesAsync(Collections.singletonList(processInstanceIdTwo), "");
        List historicBatches = this.historyService.createHistoricBatchQuery().type("historic-instance-deletion").list();
        Assertions.assertThat((Date)((HistoricBatch)historicBatches.get(0)).getRemovalTime()).isNull();
        Assertions.assertThat((Date)((HistoricBatch)historicBatches.get(1)).getRemovalTime()).isNull();
        HistoricBatchQuery query = this.historyService.createHistoricBatchQuery();
        this.testRule.syncExec(this.historyService.setRemovalTimeToHistoricBatches().absoluteRemovalTime(this.REMOVAL_TIME).byQuery(query).executeAsync());
        historicBatches = this.historyService.createHistoricBatchQuery().type("historic-instance-deletion").list();
        Assertions.assertThat((Date)((HistoricBatch)historicBatches.get(0)).getRemovalTime()).isEqualTo((Object)this.REMOVAL_TIME);
        Assertions.assertThat((Date)((HistoricBatch)historicBatches.get(1)).getRemovalTime()).isEqualTo((Object)this.REMOVAL_TIME);
        this.managementService.deleteBatch(batchOne.getId(), true);
        this.managementService.deleteBatch(batchTwo.getId(), true);
    }

    @Test
    public void shouldNotSetRemovalTime_BaseTimeNone() {
        this.testRule.getProcessEngineConfiguration().setHistoryRemovalTimeStrategy("none").initHistoryRemovalTime();
        this.testRule.process().ttl(5).serviceTask().deploy().start();
        HistoricProcessInstance historicProcessInstance = (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().singleResult();
        Assertions.assertThat((Date)historicProcessInstance.getRemovalTime()).isNull();
        HistoricProcessInstanceQuery query = this.historyService.createHistoricProcessInstanceQuery();
        this.testRule.syncExec(this.historyService.setRemovalTimeToHistoricProcessInstances().calculatedRemovalTime().byQuery(query).executeAsync());
        historicProcessInstance = (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().singleResult();
        Assertions.assertThat((Date)historicProcessInstance.getRemovalTime()).isNull();
    }

    @Test
    public void shouldClearRemovalTime_BaseTimeNone() {
        this.testRule.process().ttl(5).serviceTask().deploy().start();
        HistoricProcessInstance historicProcessInstance = (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().singleResult();
        Assertions.assertThat((Date)historicProcessInstance.getRemovalTime()).isNotNull();
        this.testRule.getProcessEngineConfiguration().setHistoryRemovalTimeStrategy("none").initHistoryRemovalTime();
        HistoricProcessInstanceQuery query = this.historyService.createHistoricProcessInstanceQuery();
        this.testRule.syncExec(this.historyService.setRemovalTimeToHistoricProcessInstances().calculatedRemovalTime().byQuery(query).executeAsync());
        historicProcessInstance = (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().singleResult();
        Assertions.assertThat((Date)historicProcessInstance.getRemovalTime()).isNull();
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/dmn/deployment/drdDish.dmn11.xml"})
    public void shouldNotSetRemovalTimeForStandaloneDecision_BaseTimeNone() {
        this.testRule.getProcessEngineConfiguration().setHistoryRemovalTimeStrategy("none").initHistoryRemovalTime();
        this.decisionService.evaluateDecisionByKey("dish-decision").variables((Map)Variables.createVariables().putValue("temperature", (Object)32).putValue("dayType", (Object)"Weekend")).evaluate();
        this.testRule.updateHistoryTimeToLiveDmn("dish-decision", 5);
        List historicDecisionInstances = this.historyService.createHistoricDecisionInstanceQuery().list();
        Assertions.assertThat((Date)((HistoricDecisionInstance)historicDecisionInstances.get(0)).getRemovalTime()).isNull();
        Assertions.assertThat((Date)((HistoricDecisionInstance)historicDecisionInstances.get(1)).getRemovalTime()).isNull();
        Assertions.assertThat((Date)((HistoricDecisionInstance)historicDecisionInstances.get(2)).getRemovalTime()).isNull();
        HistoricDecisionInstanceQuery query = this.historyService.createHistoricDecisionInstanceQuery();
        this.testRule.syncExec(this.historyService.setRemovalTimeToHistoricDecisionInstances().calculatedRemovalTime().byQuery(query).executeAsync());
        historicDecisionInstances = this.historyService.createHistoricDecisionInstanceQuery().list();
        Assertions.assertThat((Date)((HistoricDecisionInstance)historicDecisionInstances.get(0)).getRemovalTime()).isNull();
        Assertions.assertThat((Date)((HistoricDecisionInstance)historicDecisionInstances.get(1)).getRemovalTime()).isNull();
        Assertions.assertThat((Date)((HistoricDecisionInstance)historicDecisionInstances.get(2)).getRemovalTime()).isNull();
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/dmn/deployment/drdDish.dmn11.xml"})
    public void shouldClearRemovalTimeForStandaloneDecision_BaseTimeNone() {
        this.testRule.updateHistoryTimeToLiveDmn("dish-decision", 5);
        this.decisionService.evaluateDecisionByKey("dish-decision").variables((Map)Variables.createVariables().putValue("temperature", (Object)32).putValue("dayType", (Object)"Weekend")).evaluate();
        List historicDecisionInstances = this.historyService.createHistoricDecisionInstanceQuery().list();
        Assertions.assertThat((Date)((HistoricDecisionInstance)historicDecisionInstances.get(0)).getRemovalTime()).isNotNull();
        Assertions.assertThat((Date)((HistoricDecisionInstance)historicDecisionInstances.get(1)).getRemovalTime()).isNotNull();
        Assertions.assertThat((Date)((HistoricDecisionInstance)historicDecisionInstances.get(2)).getRemovalTime()).isNotNull();
        this.testRule.getProcessEngineConfiguration().setHistoryRemovalTimeStrategy("none").initHistoryRemovalTime();
        HistoricDecisionInstanceQuery query = this.historyService.createHistoricDecisionInstanceQuery();
        this.testRule.syncExec(this.historyService.setRemovalTimeToHistoricDecisionInstances().calculatedRemovalTime().byQuery(query).executeAsync());
        historicDecisionInstances = this.historyService.createHistoricDecisionInstanceQuery().list();
        Assertions.assertThat((Date)((HistoricDecisionInstance)historicDecisionInstances.get(0)).getRemovalTime()).isNull();
        Assertions.assertThat((Date)((HistoricDecisionInstance)historicDecisionInstances.get(1)).getRemovalTime()).isNull();
        Assertions.assertThat((Date)((HistoricDecisionInstance)historicDecisionInstances.get(2)).getRemovalTime()).isNull();
    }

    @Test
    public void shouldNotSetRemovalTimeInHierarchy_BaseTimeNone() {
        this.testRule.getProcessEngineConfiguration().setHistoryRemovalTimeStrategy("none").initHistoryRemovalTime();
        this.testRule.process().ttl(5).call().serviceTask().deploy().start();
        List historicProcessInstances = this.historyService.createHistoricProcessInstanceQuery().list();
        Assertions.assertThat((Date)((HistoricProcessInstance)historicProcessInstances.get(0)).getRemovalTime()).isNull();
        Assertions.assertThat((Date)((HistoricProcessInstance)historicProcessInstances.get(1)).getRemovalTime()).isNull();
        HistoricProcessInstanceQuery query = this.historyService.createHistoricProcessInstanceQuery().rootProcessInstances();
        this.testRule.syncExec(this.historyService.setRemovalTimeToHistoricProcessInstances().calculatedRemovalTime().byQuery(query).hierarchical().executeAsync());
        historicProcessInstances = this.historyService.createHistoricProcessInstanceQuery().list();
        Assertions.assertThat((Date)((HistoricProcessInstance)historicProcessInstances.get(0)).getRemovalTime()).isNull();
        Assertions.assertThat((Date)((HistoricProcessInstance)historicProcessInstances.get(1)).getRemovalTime()).isNull();
    }

    @Test
    public void shouldClearRemovalTimeInHierarchy_BaseTimeNone() {
        this.testRule.process().ttl(5).call().serviceTask().deploy().start();
        List historicProcessInstances = this.historyService.createHistoricProcessInstanceQuery().list();
        Assertions.assertThat((Date)((HistoricProcessInstance)historicProcessInstances.get(0)).getRemovalTime()).isNotNull();
        Assertions.assertThat((Date)((HistoricProcessInstance)historicProcessInstances.get(1)).getRemovalTime()).isNotNull();
        this.testRule.getProcessEngineConfiguration().setHistoryRemovalTimeStrategy("none").initHistoryRemovalTime();
        HistoricProcessInstanceQuery query = this.historyService.createHistoricProcessInstanceQuery().rootProcessInstances();
        this.testRule.syncExec(this.historyService.setRemovalTimeToHistoricProcessInstances().calculatedRemovalTime().byQuery(query).hierarchical().executeAsync());
        historicProcessInstances = this.historyService.createHistoricProcessInstanceQuery().list();
        Assertions.assertThat((Date)((HistoricProcessInstance)historicProcessInstances.get(0)).getRemovalTime()).isNull();
        Assertions.assertThat((Date)((HistoricProcessInstance)historicProcessInstances.get(1)).getRemovalTime()).isNull();
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/dmn/deployment/drdDish.dmn11.xml"})
    public void shouldNotSetRemovalTimeForStandaloneDecisionInHierarchy_BaseTimeNone() {
        this.testRule.getProcessEngineConfiguration().setHistoryRemovalTimeStrategy("none").initHistoryRemovalTime();
        this.decisionService.evaluateDecisionByKey("dish-decision").variables((Map)Variables.createVariables().putValue("temperature", (Object)32).putValue("dayType", (Object)"Weekend")).evaluate();
        this.testRule.updateHistoryTimeToLiveDmn("dish-decision", 5);
        HistoricDecisionInstance historicDecisionInstance = (HistoricDecisionInstance)this.historyService.createHistoricDecisionInstanceQuery().decisionDefinitionKey("season").singleResult();
        Assertions.assertThat((Date)historicDecisionInstance.getRemovalTime()).isNull();
        HistoricDecisionInstanceQuery query = this.historyService.createHistoricDecisionInstanceQuery().rootDecisionInstancesOnly();
        this.testRule.syncExec(this.historyService.setRemovalTimeToHistoricDecisionInstances().calculatedRemovalTime().byQuery(query).hierarchical().executeAsync());
        historicDecisionInstance = (HistoricDecisionInstance)this.historyService.createHistoricDecisionInstanceQuery().decisionDefinitionKey("season").singleResult();
        Assertions.assertThat((Date)historicDecisionInstance.getRemovalTime()).isNull();
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/dmn/deployment/drdDish.dmn11.xml"})
    public void shouldClearRemovalTimeForStandaloneDecisionInHierarchy_BaseTimeNone() {
        this.testRule.updateHistoryTimeToLiveDmn("dish-decision", 5);
        this.decisionService.evaluateDecisionByKey("dish-decision").variables((Map)Variables.createVariables().putValue("temperature", (Object)32).putValue("dayType", (Object)"Weekend")).evaluate();
        HistoricDecisionInstance historicDecisionInstance = (HistoricDecisionInstance)this.historyService.createHistoricDecisionInstanceQuery().decisionDefinitionKey("season").singleResult();
        Assertions.assertThat((Date)historicDecisionInstance.getRemovalTime()).isNotNull();
        this.testRule.getProcessEngineConfiguration().setHistoryRemovalTimeStrategy("none").initHistoryRemovalTime();
        HistoricDecisionInstanceQuery query = this.historyService.createHistoricDecisionInstanceQuery().rootDecisionInstancesOnly();
        this.testRule.syncExec(this.historyService.setRemovalTimeToHistoricDecisionInstances().calculatedRemovalTime().byQuery(query).hierarchical().executeAsync());
        historicDecisionInstance = (HistoricDecisionInstance)this.historyService.createHistoricDecisionInstanceQuery().decisionDefinitionKey("season").singleResult();
        Assertions.assertThat((Date)historicDecisionInstance.getRemovalTime()).isNull();
    }

    @Test
    public void shouldNotSetRemovalTimeForBatch_BaseTimeNone() {
        ProcessEngineConfigurationImpl configuration = this.testRule.getProcessEngineConfiguration();
        configuration.setHistoryCleanupStrategy("endTimeBased");
        configuration.setHistoryRemovalTimeStrategy("none");
        configuration.setBatchOperationHistoryTimeToLive("P5D");
        configuration.initHistoryCleanup();
        String processInstanceIdOne = this.testRule.process().serviceTask().deploy().start();
        Batch batchOne = this.historyService.deleteHistoricProcessInstancesAsync(Collections.singletonList(processInstanceIdOne), "");
        this.testRule.syncExec(batchOne);
        String processInstanceIdTwo = this.testRule.process().serviceTask().deploy().start();
        Batch batchTwo = this.historyService.deleteHistoricProcessInstancesAsync(Collections.singletonList(processInstanceIdTwo), "");
        this.testRule.syncExec(batchTwo);
        List historicBatches = this.historyService.createHistoricBatchQuery().type("historic-instance-deletion").list();
        Assertions.assertThat((Date)((HistoricBatch)historicBatches.get(0)).getRemovalTime()).isNull();
        Assertions.assertThat((Date)((HistoricBatch)historicBatches.get(1)).getRemovalTime()).isNull();
        HistoricBatchQuery query = this.historyService.createHistoricBatchQuery();
        this.testRule.syncExec(this.historyService.setRemovalTimeToHistoricBatches().calculatedRemovalTime().byQuery(query).executeAsync());
        historicBatches = this.historyService.createHistoricBatchQuery().type("historic-instance-deletion").list();
        Assertions.assertThat((Date)((HistoricBatch)historicBatches.get(0)).getRemovalTime()).isNull();
        Assertions.assertThat((Date)((HistoricBatch)historicBatches.get(1)).getRemovalTime()).isNull();
    }

    @Test
    public void shouldClearRemovalTimeForBatch_BaseTimeNone() {
        ProcessEngineConfigurationImpl configuration = this.testRule.getProcessEngineConfiguration();
        configuration.setBatchOperationHistoryTimeToLive("P5D");
        configuration.initHistoryCleanup();
        String processInstanceIdOne = this.testRule.process().serviceTask().deploy().start();
        Batch batchOne = this.historyService.deleteHistoricProcessInstancesAsync(Collections.singletonList(processInstanceIdOne), "");
        this.testRule.syncExec(batchOne);
        String processInstanceIdTwo = this.testRule.process().serviceTask().deploy().start();
        Batch batchTwo = this.historyService.deleteHistoricProcessInstancesAsync(Collections.singletonList(processInstanceIdTwo), "");
        this.testRule.syncExec(batchTwo);
        List historicBatches = this.historyService.createHistoricBatchQuery().type("historic-instance-deletion").list();
        Assertions.assertThat((Date)((HistoricBatch)historicBatches.get(0)).getRemovalTime()).isNotNull();
        Assertions.assertThat((Date)((HistoricBatch)historicBatches.get(1)).getRemovalTime()).isNotNull();
        configuration.setHistoryRemovalTimeStrategy("none");
        HistoricBatchQuery query = this.historyService.createHistoricBatchQuery();
        this.testRule.syncExec(this.historyService.setRemovalTimeToHistoricBatches().calculatedRemovalTime().byQuery(query).executeAsync());
        historicBatches = this.historyService.createHistoricBatchQuery().type("historic-instance-deletion").list();
        Assertions.assertThat((Date)((HistoricBatch)historicBatches.get(0)).getRemovalTime()).isNull();
        Assertions.assertThat((Date)((HistoricBatch)historicBatches.get(1)).getRemovalTime()).isNull();
    }

    @Test
    public void shouldSetRemovalTime_BaseTimeStart() {
        this.testRule.getProcessEngineConfiguration().setHistoryRemovalTimeStrategy("start").initHistoryRemovalTime();
        this.testRule.process().userTask().deploy().start();
        HistoricProcessInstance historicProcessInstance = (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().singleResult();
        Assertions.assertThat((Date)historicProcessInstance.getRemovalTime()).isNull();
        this.testRule.updateHistoryTimeToLive("process", 5);
        HistoricProcessInstanceQuery query = this.historyService.createHistoricProcessInstanceQuery();
        this.testRule.syncExec(this.historyService.setRemovalTimeToHistoricProcessInstances().calculatedRemovalTime().byQuery(query).executeAsync());
        historicProcessInstance = (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().singleResult();
        Assertions.assertThat((Date)historicProcessInstance.getRemovalTime()).isEqualTo((Object)BatchSetRemovalTimeRule.addDays(this.CURRENT_DATE, 5));
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/dmn/deployment/drdDish.dmn11.xml"})
    public void shouldSetRemovalTimeForStandaloneDecision_BaseTimeStart() {
        this.testRule.getProcessEngineConfiguration().setHistoryRemovalTimeStrategy("start").initHistoryRemovalTime();
        this.decisionService.evaluateDecisionByKey("dish-decision").variables((Map)Variables.createVariables().putValue("temperature", (Object)32).putValue("dayType", (Object)"Weekend")).evaluate();
        HistoricDecisionInstance historicDecisionInstance = (HistoricDecisionInstance)this.historyService.createHistoricDecisionInstanceQuery().rootDecisionInstancesOnly().singleResult();
        Assertions.assertThat((Date)historicDecisionInstance.getRemovalTime()).isNull();
        this.testRule.updateHistoryTimeToLiveDmn("dish-decision", 5);
        HistoricDecisionInstanceQuery query = this.historyService.createHistoricDecisionInstanceQuery();
        this.testRule.syncExec(this.historyService.setRemovalTimeToHistoricDecisionInstances().calculatedRemovalTime().byQuery(query).executeAsync());
        historicDecisionInstance = (HistoricDecisionInstance)this.historyService.createHistoricDecisionInstanceQuery().rootDecisionInstancesOnly().singleResult();
        Assertions.assertThat((Date)historicDecisionInstance.getRemovalTime()).isEqualTo((Object)BatchSetRemovalTimeRule.addDays(this.CURRENT_DATE, 5));
    }

    @Test
    public void shouldSetRemovalTimeForBatch_BaseTimeStart() {
        String processInstanceId = this.testRule.process().serviceTask().deploy().start();
        Batch batch = this.historyService.deleteHistoricProcessInstancesAsync(Collections.singletonList(processInstanceId), "");
        HistoricBatch historicBatch = (HistoricBatch)this.historyService.createHistoricBatchQuery().type("historic-instance-deletion").singleResult();
        Assertions.assertThat((Date)historicBatch.getRemovalTime()).isNull();
        ProcessEngineConfigurationImpl configuration = this.testRule.getProcessEngineConfiguration();
        configuration.setBatchOperationHistoryTimeToLive("P5D");
        configuration.initHistoryCleanup();
        HistoricBatchQuery query = this.historyService.createHistoricBatchQuery().type("historic-instance-deletion");
        this.testRule.syncExec(this.historyService.setRemovalTimeToHistoricBatches().calculatedRemovalTime().byQuery(query).executeAsync());
        historicBatch = (HistoricBatch)this.historyService.createHistoricBatchQuery().type("historic-instance-deletion").singleResult();
        Assertions.assertThat((Date)historicBatch.getRemovalTime()).isEqualTo((Object)BatchSetRemovalTimeRule.addDays(this.CURRENT_DATE, 5));
        this.managementService.deleteBatch(batch.getId(), true);
    }

    @Test
    public void shouldSetRemovalTimeInHierarchy_BaseTimeStart() {
        this.testRule.getProcessEngineConfiguration().setHistoryRemovalTimeStrategy("start").initHistoryRemovalTime();
        this.testRule.process().call().userTask().deploy().start();
        List historicProcessInstances = this.historyService.createHistoricProcessInstanceQuery().list();
        Assertions.assertThat((Date)((HistoricProcessInstance)historicProcessInstances.get(0)).getRemovalTime()).isNull();
        Assertions.assertThat((Date)((HistoricProcessInstance)historicProcessInstances.get(1)).getRemovalTime()).isNull();
        this.testRule.updateHistoryTimeToLive("rootProcess", 5);
        HistoricProcessInstanceQuery query = this.historyService.createHistoricProcessInstanceQuery().rootProcessInstances();
        this.testRule.syncExec(this.historyService.setRemovalTimeToHistoricProcessInstances().calculatedRemovalTime().byQuery(query).hierarchical().executeAsync());
        historicProcessInstances = this.historyService.createHistoricProcessInstanceQuery().list();
        Assertions.assertThat((Date)((HistoricProcessInstance)historicProcessInstances.get(0)).getRemovalTime()).isEqualTo((Object)BatchSetRemovalTimeRule.addDays(this.CURRENT_DATE, 5));
        Assertions.assertThat((Date)((HistoricProcessInstance)historicProcessInstances.get(1)).getRemovalTime()).isEqualTo((Object)BatchSetRemovalTimeRule.addDays(this.CURRENT_DATE, 5));
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/dmn/deployment/drdDish.dmn11.xml"})
    public void shouldSetRemovalTimeInHierarchyForStandaloneDecision_BaseTimeStart() {
        this.testRule.getProcessEngineConfiguration().setHistoryRemovalTimeStrategy("start").initHistoryRemovalTime();
        this.decisionService.evaluateDecisionByKey("dish-decision").variables((Map)Variables.createVariables().putValue("temperature", (Object)32).putValue("dayType", (Object)"Weekend")).evaluate();
        HistoricDecisionInstance historicDecisionInstance = (HistoricDecisionInstance)this.historyService.createHistoricDecisionInstanceQuery().decisionDefinitionKey("season").singleResult();
        Assertions.assertThat((Date)historicDecisionInstance.getRemovalTime()).isNull();
        this.testRule.updateHistoryTimeToLiveDmn("dish-decision", 5);
        HistoricDecisionInstanceQuery query = this.historyService.createHistoricDecisionInstanceQuery();
        this.testRule.syncExec(this.historyService.setRemovalTimeToHistoricDecisionInstances().calculatedRemovalTime().byQuery(query).hierarchical().executeAsync());
        historicDecisionInstance = (HistoricDecisionInstance)this.historyService.createHistoricDecisionInstanceQuery().decisionDefinitionKey("season").singleResult();
        Assertions.assertThat((Date)historicDecisionInstance.getRemovalTime()).isEqualTo((Object)BatchSetRemovalTimeRule.addDays(this.CURRENT_DATE, 5));
    }

    @Test
    public void shouldNotSetRemovalTime_BaseTimeEnd() {
        this.testRule.getProcessEngineConfiguration().setHistoryRemovalTimeStrategy("end").initHistoryRemovalTime();
        this.testRule.process().ttl(5).userTask().deploy().start();
        HistoricProcessInstance historicProcessInstance = (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().singleResult();
        Assertions.assertThat((Date)historicProcessInstance.getRemovalTime()).isNull();
        HistoricProcessInstanceQuery query = this.historyService.createHistoricProcessInstanceQuery();
        this.testRule.syncExec(this.historyService.setRemovalTimeToHistoricProcessInstances().calculatedRemovalTime().byQuery(query).executeAsync());
        historicProcessInstance = (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().singleResult();
        Assertions.assertThat((Date)historicProcessInstance.getRemovalTime()).isNull();
    }

    @Test
    public void shouldClearRemovalTime_BaseTimeEnd() {
        this.testRule.process().ttl(5).userTask().deploy().start();
        HistoricProcessInstance historicProcessInstance = (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().singleResult();
        Assertions.assertThat((Date)historicProcessInstance.getRemovalTime()).isNotNull();
        this.testRule.getProcessEngineConfiguration().setHistoryRemovalTimeStrategy("end").initHistoryRemovalTime();
        HistoricProcessInstanceQuery query = this.historyService.createHistoricProcessInstanceQuery();
        this.testRule.syncExec(this.historyService.setRemovalTimeToHistoricProcessInstances().calculatedRemovalTime().byQuery(query).executeAsync());
        historicProcessInstance = (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().singleResult();
        Assertions.assertThat((Date)historicProcessInstance.getRemovalTime()).isNull();
    }

    @Test
    public void shouldNotSetRemovalTimeForBatch_BaseTimeEnd() {
        ProcessEngineConfigurationImpl configuration = this.testRule.getProcessEngineConfiguration();
        configuration.setHistoryRemovalTimeStrategy("end");
        String processInstanceId = this.testRule.process().serviceTask().deploy().start();
        Batch batch = this.historyService.deleteHistoricProcessInstancesAsync(Collections.singletonList(processInstanceId), "");
        HistoricBatch historicBatch = (HistoricBatch)this.historyService.createHistoricBatchQuery().type("historic-instance-deletion").singleResult();
        Assertions.assertThat((Date)historicBatch.getRemovalTime()).isNull();
        configuration.setBatchOperationHistoryTimeToLive("P5D");
        configuration.initHistoryCleanup();
        HistoricBatchQuery query = this.historyService.createHistoricBatchQuery().type("historic-instance-deletion");
        this.testRule.syncExec(this.historyService.setRemovalTimeToHistoricBatches().calculatedRemovalTime().byQuery(query).executeAsync());
        historicBatch = (HistoricBatch)this.historyService.createHistoricBatchQuery().type("historic-instance-deletion").singleResult();
        Assertions.assertThat((Date)historicBatch.getRemovalTime()).isNull();
        this.managementService.deleteBatch(batch.getId(), true);
    }

    @Test
    public void shouldClearRemovalTimeForBatch_BaseTimeEnd() {
        ProcessEngineConfigurationImpl configuration = this.testRule.getProcessEngineConfiguration();
        configuration.setBatchOperationHistoryTimeToLive("P5D");
        configuration.initHistoryCleanup();
        String processInstanceId = this.testRule.process().serviceTask().deploy().start();
        Batch batch = this.historyService.deleteHistoricProcessInstancesAsync(Collections.singletonList(processInstanceId), "");
        HistoricBatch historicBatch = (HistoricBatch)this.historyService.createHistoricBatchQuery().type("historic-instance-deletion").singleResult();
        Assertions.assertThat((Date)historicBatch.getRemovalTime()).isNotNull();
        configuration.setHistoryRemovalTimeStrategy("end");
        HistoricBatchQuery query = this.historyService.createHistoricBatchQuery().type("historic-instance-deletion");
        this.testRule.syncExec(this.historyService.setRemovalTimeToHistoricBatches().calculatedRemovalTime().byQuery(query).executeAsync());
        historicBatch = (HistoricBatch)this.historyService.createHistoricBatchQuery().type("historic-instance-deletion").singleResult();
        Assertions.assertThat((Date)historicBatch.getRemovalTime()).isNull();
        this.managementService.deleteBatch(batch.getId(), true);
    }

    @Test
    public void shouldNotSetRemovalTimeInHierarchy_BaseTimeEnd() {
        this.testRule.getProcessEngineConfiguration().setHistoryRemovalTimeStrategy("end").initHistoryRemovalTime();
        this.testRule.process().call().ttl(5).userTask().deploy().start();
        List historicProcessInstances = this.historyService.createHistoricProcessInstanceQuery().list();
        Assertions.assertThat((Date)((HistoricProcessInstance)historicProcessInstances.get(0)).getRemovalTime()).isNull();
        Assertions.assertThat((Date)((HistoricProcessInstance)historicProcessInstances.get(1)).getRemovalTime()).isNull();
        HistoricProcessInstanceQuery query = this.historyService.createHistoricProcessInstanceQuery().rootProcessInstances();
        this.testRule.syncExec(this.historyService.setRemovalTimeToHistoricProcessInstances().calculatedRemovalTime().byQuery(query).hierarchical().executeAsync());
        historicProcessInstances = this.historyService.createHistoricProcessInstanceQuery().list();
        Assertions.assertThat((Date)((HistoricProcessInstance)historicProcessInstances.get(0)).getRemovalTime()).isNull();
        Assertions.assertThat((Date)((HistoricProcessInstance)historicProcessInstances.get(1)).getRemovalTime()).isNull();
    }

    @Test
    public void shouldClearRemovalTimeInHierarchy_BaseTimeEnd() {
        this.testRule.process().call().ttl(5).userTask().deploy().start();
        List historicProcessInstances = this.historyService.createHistoricProcessInstanceQuery().list();
        Assertions.assertThat((Date)((HistoricProcessInstance)historicProcessInstances.get(0)).getRemovalTime()).isNotNull();
        Assertions.assertThat((Date)((HistoricProcessInstance)historicProcessInstances.get(1)).getRemovalTime()).isNotNull();
        this.testRule.getProcessEngineConfiguration().setHistoryRemovalTimeStrategy("end").initHistoryRemovalTime();
        HistoricProcessInstanceQuery query = this.historyService.createHistoricProcessInstanceQuery().rootProcessInstances();
        this.testRule.syncExec(this.historyService.setRemovalTimeToHistoricProcessInstances().calculatedRemovalTime().byQuery(query).hierarchical().executeAsync());
        historicProcessInstances = this.historyService.createHistoricProcessInstanceQuery().list();
        Assertions.assertThat((Date)((HistoricProcessInstance)historicProcessInstances.get(0)).getRemovalTime()).isNull();
        Assertions.assertThat((Date)((HistoricProcessInstance)historicProcessInstances.get(1)).getRemovalTime()).isNull();
    }

    @Test
    public void shouldSetRemovalTime_BaseTimeEnd() {
        this.testRule.getProcessEngineConfiguration().setHistoryRemovalTimeStrategy("end").initHistoryRemovalTime();
        this.testRule.process().serviceTask().deploy().start();
        HistoricProcessInstance historicProcessInstance = (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().singleResult();
        Assertions.assertThat((Date)historicProcessInstance.getRemovalTime()).isNull();
        this.testRule.updateHistoryTimeToLive("process", 5);
        HistoricProcessInstanceQuery query = this.historyService.createHistoricProcessInstanceQuery();
        this.testRule.syncExec(this.historyService.setRemovalTimeToHistoricProcessInstances().calculatedRemovalTime().byQuery(query).executeAsync());
        historicProcessInstance = (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().singleResult();
        Assertions.assertThat((Date)historicProcessInstance.getRemovalTime()).isEqualTo((Object)BatchSetRemovalTimeRule.addDays(this.CURRENT_DATE, 5));
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/dmn/deployment/drdDish.dmn11.xml"})
    public void shouldSetRemovalTimeForStandaloneDecision_BaseTimeEnd() {
        this.testRule.getProcessEngineConfiguration().setHistoryRemovalTimeStrategy("end").initHistoryRemovalTime();
        this.decisionService.evaluateDecisionByKey("dish-decision").variables((Map)Variables.createVariables().putValue("temperature", (Object)32).putValue("dayType", (Object)"Weekend")).evaluate();
        HistoricDecisionInstance historicDecisionInstance = (HistoricDecisionInstance)this.historyService.createHistoricDecisionInstanceQuery().rootDecisionInstancesOnly().singleResult();
        Assertions.assertThat((Date)historicDecisionInstance.getRemovalTime()).isNull();
        this.testRule.updateHistoryTimeToLiveDmn("dish-decision", 5);
        HistoricDecisionInstanceQuery query = this.historyService.createHistoricDecisionInstanceQuery();
        this.testRule.syncExec(this.historyService.setRemovalTimeToHistoricDecisionInstances().calculatedRemovalTime().byQuery(query).executeAsync());
        historicDecisionInstance = (HistoricDecisionInstance)this.historyService.createHistoricDecisionInstanceQuery().rootDecisionInstancesOnly().singleResult();
        Assertions.assertThat((Date)historicDecisionInstance.getRemovalTime()).isEqualTo((Object)BatchSetRemovalTimeRule.addDays(this.CURRENT_DATE, 5));
    }

    @Test
    public void shouldSetRemovalTimeForBatch_BaseTimeEnd() {
        ProcessEngineConfigurationImpl configuration = this.testRule.getProcessEngineConfiguration();
        configuration.setHistoryRemovalTimeStrategy("end");
        String processInstanceId = this.testRule.process().serviceTask().deploy().start();
        Batch batch = this.historyService.deleteHistoricProcessInstancesAsync(Collections.singletonList(processInstanceId), "");
        ClockUtil.setCurrentTime((Date)BatchSetRemovalTimeRule.addDays(this.CURRENT_DATE, 1));
        this.testRule.syncExec(batch);
        HistoricBatch historicBatch = (HistoricBatch)this.historyService.createHistoricBatchQuery().type("historic-instance-deletion").singleResult();
        Assertions.assertThat((Date)historicBatch.getRemovalTime()).isNull();
        configuration.setBatchOperationHistoryTimeToLive("P5D");
        configuration.initHistoryCleanup();
        HistoricBatchQuery query = this.historyService.createHistoricBatchQuery().type("historic-instance-deletion");
        this.testRule.syncExec(this.historyService.setRemovalTimeToHistoricBatches().calculatedRemovalTime().byQuery(query).executeAsync());
        historicBatch = (HistoricBatch)this.historyService.createHistoricBatchQuery().type("historic-instance-deletion").singleResult();
        Assertions.assertThat((Date)historicBatch.getRemovalTime()).isEqualTo((Object)BatchSetRemovalTimeRule.addDays(this.CURRENT_DATE, 6));
    }

    @Test
    public void shouldSetRemovalTimeInHierarchy_BaseTimeEnd() {
        this.testRule.getProcessEngineConfiguration().setHistoryRemovalTimeStrategy("end").initHistoryRemovalTime();
        this.testRule.process().call().serviceTask().deploy().start();
        List historicProcessInstances = this.historyService.createHistoricProcessInstanceQuery().list();
        Assertions.assertThat((Date)((HistoricProcessInstance)historicProcessInstances.get(0)).getRemovalTime()).isNull();
        Assertions.assertThat((Date)((HistoricProcessInstance)historicProcessInstances.get(1)).getRemovalTime()).isNull();
        this.testRule.updateHistoryTimeToLive("rootProcess", 5);
        HistoricProcessInstanceQuery query = this.historyService.createHistoricProcessInstanceQuery().rootProcessInstances();
        this.testRule.syncExec(this.historyService.setRemovalTimeToHistoricProcessInstances().calculatedRemovalTime().byQuery(query).hierarchical().executeAsync());
        historicProcessInstances = this.historyService.createHistoricProcessInstanceQuery().list();
        Assertions.assertThat((Date)((HistoricProcessInstance)historicProcessInstances.get(0)).getRemovalTime()).isEqualTo((Object)BatchSetRemovalTimeRule.addDays(this.CURRENT_DATE, 5));
        Assertions.assertThat((Date)((HistoricProcessInstance)historicProcessInstances.get(1)).getRemovalTime()).isEqualTo((Object)BatchSetRemovalTimeRule.addDays(this.CURRENT_DATE, 5));
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/dmn/deployment/drdDish.dmn11.xml"})
    public void shouldSetRemovalTimeInHierarchyForStandaloneDecision_BaseTimeEnd() {
        this.testRule.getProcessEngineConfiguration().setHistoryRemovalTimeStrategy("end").initHistoryRemovalTime();
        this.decisionService.evaluateDecisionByKey("dish-decision").variables((Map)Variables.createVariables().putValue("temperature", (Object)32).putValue("dayType", (Object)"Weekend")).evaluate();
        HistoricDecisionInstance historicDecisionInstance = (HistoricDecisionInstance)this.historyService.createHistoricDecisionInstanceQuery().decisionDefinitionKey("season").singleResult();
        Assertions.assertThat((Date)historicDecisionInstance.getRemovalTime()).isNull();
        this.testRule.updateHistoryTimeToLiveDmn("dish-decision", 5);
        HistoricDecisionInstanceQuery query = this.historyService.createHistoricDecisionInstanceQuery().rootDecisionInstancesOnly();
        this.testRule.syncExec(this.historyService.setRemovalTimeToHistoricDecisionInstances().calculatedRemovalTime().byQuery(query).hierarchical().executeAsync());
        historicDecisionInstance = (HistoricDecisionInstance)this.historyService.createHistoricDecisionInstanceQuery().decisionDefinitionKey("season").singleResult();
        Assertions.assertThat((Date)historicDecisionInstance.getRemovalTime()).isEqualTo((Object)BatchSetRemovalTimeRule.addDays(this.CURRENT_DATE, 5));
    }

    @Test
    public void shouldSetRemovalTime_Null() {
        this.testRule.getProcessEngineConfiguration().setHistoryRemovalTimeStrategy("start").initHistoryRemovalTime();
        this.testRule.process().ttl(5).userTask().deploy().start();
        HistoricProcessInstance historicProcessInstance = (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().singleResult();
        Assertions.assertThat((Date)historicProcessInstance.getRemovalTime()).isEqualTo((Object)BatchSetRemovalTimeRule.addDays(this.CURRENT_DATE, 5));
        HistoricProcessInstanceQuery query = this.historyService.createHistoricProcessInstanceQuery();
        this.testRule.syncExec(this.historyService.setRemovalTimeToHistoricProcessInstances().clearedRemovalTime().byQuery(query).executeAsync());
        historicProcessInstance = (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().singleResult();
        Assertions.assertThat((Date)historicProcessInstance.getRemovalTime()).isNull();
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/dmn/deployment/drdDish.dmn11.xml"})
    public void shouldSetRemovalTimeForStandaloneDecision_Null() {
        this.testRule.updateHistoryTimeToLiveDmn("dish-decision", 5);
        this.decisionService.evaluateDecisionByKey("dish-decision").variables((Map)Variables.createVariables().putValue("temperature", (Object)32).putValue("dayType", (Object)"Weekend")).evaluate();
        HistoricDecisionInstance historicDecisionInstance = (HistoricDecisionInstance)this.historyService.createHistoricDecisionInstanceQuery().rootDecisionInstancesOnly().singleResult();
        Assertions.assertThat((Date)historicDecisionInstance.getRemovalTime()).isEqualTo((Object)BatchSetRemovalTimeRule.addDays(this.CURRENT_DATE, 5));
        HistoricDecisionInstanceQuery query = this.historyService.createHistoricDecisionInstanceQuery();
        this.testRule.syncExec(this.historyService.setRemovalTimeToHistoricDecisionInstances().clearedRemovalTime().byQuery(query).executeAsync());
        historicDecisionInstance = (HistoricDecisionInstance)this.historyService.createHistoricDecisionInstanceQuery().rootDecisionInstancesOnly().singleResult();
        Assertions.assertThat((Date)historicDecisionInstance.getRemovalTime()).isEqualTo(null);
    }

    @Test
    public void shouldSetRemovalTimeForBatch_Null() {
        ProcessEngineConfigurationImpl configuration = this.testRule.getProcessEngineConfiguration();
        configuration.setBatchOperationHistoryTimeToLive("P5D");
        configuration.initHistoryCleanup();
        String processInstanceId = this.testRule.process().serviceTask().deploy().start();
        Batch batch = this.historyService.deleteHistoricProcessInstancesAsync(Collections.singletonList(processInstanceId), "");
        HistoricBatch historicBatch = (HistoricBatch)this.historyService.createHistoricBatchQuery().type("historic-instance-deletion").singleResult();
        Assertions.assertThat((Date)historicBatch.getRemovalTime()).isNotNull();
        HistoricBatchQuery query = this.historyService.createHistoricBatchQuery().type("historic-instance-deletion");
        this.testRule.syncExec(this.historyService.setRemovalTimeToHistoricBatches().clearedRemovalTime().byQuery(query).executeAsync());
        historicBatch = (HistoricBatch)this.historyService.createHistoricBatchQuery().type("historic-instance-deletion").singleResult();
        Assertions.assertThat((Date)historicBatch.getRemovalTime()).isNull();
        this.managementService.deleteBatch(batch.getId(), true);
    }

    @Test
    public void shouldSetRemovalTimeInHierarchy_Null() {
        this.testRule.getProcessEngineConfiguration().setHistoryRemovalTimeStrategy("start").initHistoryRemovalTime();
        this.testRule.process().call().ttl(5).userTask().deploy().start();
        List historicProcessInstances = this.historyService.createHistoricProcessInstanceQuery().list();
        Assertions.assertThat((Date)((HistoricProcessInstance)historicProcessInstances.get(0)).getRemovalTime()).isEqualTo((Object)BatchSetRemovalTimeRule.addDays(this.CURRENT_DATE, 5));
        Assertions.assertThat((Date)((HistoricProcessInstance)historicProcessInstances.get(1)).getRemovalTime()).isEqualTo((Object)BatchSetRemovalTimeRule.addDays(this.CURRENT_DATE, 5));
        HistoricProcessInstanceQuery query = this.historyService.createHistoricProcessInstanceQuery().rootProcessInstances();
        this.testRule.syncExec(this.historyService.setRemovalTimeToHistoricProcessInstances().clearedRemovalTime().byQuery(query).hierarchical().executeAsync());
        historicProcessInstances = this.historyService.createHistoricProcessInstanceQuery().list();
        Assertions.assertThat((Date)((HistoricProcessInstance)historicProcessInstances.get(0)).getRemovalTime()).isNull();
        Assertions.assertThat((Date)((HistoricProcessInstance)historicProcessInstances.get(1)).getRemovalTime()).isNull();
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/dmn/deployment/drdDish.dmn11.xml"})
    public void shouldSetRemovalTimeInHierarchyForStandaloneDecision_Null() {
        this.testRule.updateHistoryTimeToLiveDmn("dish-decision", 5);
        this.decisionService.evaluateDecisionByKey("dish-decision").variables((Map)Variables.createVariables().putValue("temperature", (Object)32).putValue("dayType", (Object)"Weekend")).evaluate();
        HistoricDecisionInstance historicDecisionInstance = (HistoricDecisionInstance)this.historyService.createHistoricDecisionInstanceQuery().decisionDefinitionKey("season").singleResult();
        Assertions.assertThat((Date)historicDecisionInstance.getRemovalTime()).isEqualTo((Object)BatchSetRemovalTimeRule.addDays(this.CURRENT_DATE, 5));
        HistoricDecisionInstanceQuery query = this.historyService.createHistoricDecisionInstanceQuery().rootDecisionInstancesOnly();
        this.testRule.syncExec(this.historyService.setRemovalTimeToHistoricDecisionInstances().clearedRemovalTime().byQuery(query).hierarchical().executeAsync());
        historicDecisionInstance = (HistoricDecisionInstance)this.historyService.createHistoricDecisionInstanceQuery().decisionDefinitionKey("season").singleResult();
        Assertions.assertThat((Date)historicDecisionInstance.getRemovalTime()).isEqualTo(null);
    }

    @Test
    public void shouldSetRemovalTime_Absolute() {
        this.testRule.getProcessEngineConfiguration().setHistoryRemovalTimeStrategy("start").initHistoryRemovalTime();
        this.testRule.process().ttl(5).userTask().deploy().start();
        HistoricProcessInstance historicProcessInstance = (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().singleResult();
        Assertions.assertThat((Date)historicProcessInstance.getRemovalTime()).isEqualTo((Object)BatchSetRemovalTimeRule.addDays(this.CURRENT_DATE, 5));
        HistoricProcessInstanceQuery query = this.historyService.createHistoricProcessInstanceQuery();
        this.testRule.syncExec(this.historyService.setRemovalTimeToHistoricProcessInstances().absoluteRemovalTime(this.REMOVAL_TIME).byQuery(query).executeAsync());
        historicProcessInstance = (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().singleResult();
        Assertions.assertThat((Date)historicProcessInstance.getRemovalTime()).isEqualTo((Object)this.REMOVAL_TIME);
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/dmn/deployment/drdDish.dmn11.xml"})
    public void shouldSetRemovalTimeForStandaloneDecision_Absolute() {
        this.testRule.updateHistoryTimeToLiveDmn("dish-decision", 5);
        this.decisionService.evaluateDecisionByKey("dish-decision").variables((Map)Variables.createVariables().putValue("temperature", (Object)32).putValue("dayType", (Object)"Weekend")).evaluate();
        HistoricDecisionInstance historicDecisionInstance = (HistoricDecisionInstance)this.historyService.createHistoricDecisionInstanceQuery().rootDecisionInstancesOnly().singleResult();
        Assertions.assertThat((Date)historicDecisionInstance.getRemovalTime()).isEqualTo((Object)BatchSetRemovalTimeRule.addDays(this.CURRENT_DATE, 5));
        HistoricDecisionInstanceQuery query = this.historyService.createHistoricDecisionInstanceQuery();
        this.testRule.syncExec(this.historyService.setRemovalTimeToHistoricDecisionInstances().absoluteRemovalTime(this.REMOVAL_TIME).byQuery(query).executeAsync());
        historicDecisionInstance = (HistoricDecisionInstance)this.historyService.createHistoricDecisionInstanceQuery().rootDecisionInstancesOnly().singleResult();
        Assertions.assertThat((Date)historicDecisionInstance.getRemovalTime()).isEqualTo((Object)this.REMOVAL_TIME);
    }

    @Test
    public void shouldSetRemovalTimeForBatch_Absolute() {
        String processInstanceId = this.testRule.process().serviceTask().deploy().start();
        Batch batch = this.historyService.deleteHistoricProcessInstancesAsync(Collections.singletonList(processInstanceId), "");
        HistoricBatch historicBatch = (HistoricBatch)this.historyService.createHistoricBatchQuery().type("historic-instance-deletion").singleResult();
        Assertions.assertThat((Date)historicBatch.getRemovalTime()).isNull();
        HistoricBatchQuery query = this.historyService.createHistoricBatchQuery().type("historic-instance-deletion");
        this.testRule.syncExec(this.historyService.setRemovalTimeToHistoricBatches().absoluteRemovalTime(this.REMOVAL_TIME).byQuery(query).executeAsync());
        historicBatch = (HistoricBatch)this.historyService.createHistoricBatchQuery().type("historic-instance-deletion").singleResult();
        Assertions.assertThat((Date)historicBatch.getRemovalTime()).isEqualTo((Object)this.REMOVAL_TIME);
        this.managementService.deleteBatch(batch.getId(), true);
    }

    @Test
    public void shouldSetRemovalTimeInHierarchy_Absolute() {
        this.testRule.getProcessEngineConfiguration().setHistoryRemovalTimeStrategy("start").initHistoryRemovalTime();
        this.testRule.process().call().ttl(5).userTask().deploy().start();
        List historicProcessInstances = this.historyService.createHistoricProcessInstanceQuery().list();
        Assertions.assertThat((Date)((HistoricProcessInstance)historicProcessInstances.get(0)).getRemovalTime()).isEqualTo((Object)BatchSetRemovalTimeRule.addDays(this.CURRENT_DATE, 5));
        Assertions.assertThat((Date)((HistoricProcessInstance)historicProcessInstances.get(1)).getRemovalTime()).isEqualTo((Object)BatchSetRemovalTimeRule.addDays(this.CURRENT_DATE, 5));
        HistoricProcessInstanceQuery query = this.historyService.createHistoricProcessInstanceQuery().rootProcessInstances();
        this.testRule.syncExec(this.historyService.setRemovalTimeToHistoricProcessInstances().absoluteRemovalTime(this.REMOVAL_TIME).byQuery(query).hierarchical().executeAsync());
        historicProcessInstances = this.historyService.createHistoricProcessInstanceQuery().list();
        Assertions.assertThat((Date)((HistoricProcessInstance)historicProcessInstances.get(0)).getRemovalTime()).isEqualTo((Object)this.REMOVAL_TIME);
        Assertions.assertThat((Date)((HistoricProcessInstance)historicProcessInstances.get(1)).getRemovalTime()).isEqualTo((Object)this.REMOVAL_TIME);
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/dmn/deployment/drdDish.dmn11.xml"})
    public void shouldSetRemovalTimeInHierarchyForStandaloneDecision_Absolute() {
        this.testRule.updateHistoryTimeToLiveDmn("dish-decision", 5);
        this.decisionService.evaluateDecisionByKey("dish-decision").variables((Map)Variables.createVariables().putValue("temperature", (Object)32).putValue("dayType", (Object)"Weekend")).evaluate();
        HistoricDecisionInstance historicDecisionInstance = (HistoricDecisionInstance)this.historyService.createHistoricDecisionInstanceQuery().decisionDefinitionKey("season").singleResult();
        Assertions.assertThat((Date)historicDecisionInstance.getRemovalTime()).isEqualTo((Object)BatchSetRemovalTimeRule.addDays(this.CURRENT_DATE, 5));
        HistoricDecisionInstanceQuery query = this.historyService.createHistoricDecisionInstanceQuery().rootDecisionInstancesOnly();
        this.testRule.syncExec(this.historyService.setRemovalTimeToHistoricDecisionInstances().absoluteRemovalTime(this.REMOVAL_TIME).byQuery(query).hierarchical().executeAsync());
        historicDecisionInstance = (HistoricDecisionInstance)this.historyService.createHistoricDecisionInstanceQuery().decisionDefinitionKey("season").singleResult();
        Assertions.assertThat((Date)historicDecisionInstance.getRemovalTime()).isEqualTo((Object)this.REMOVAL_TIME);
    }

    @Test
    public void shouldSetRemovalTimeInHierarchy_ByChildInstance() {
        String rootProcessInstance = this.testRule.process().call().ttl(5).userTask().deploy().start();
        List historicProcessInstances = this.historyService.createHistoricProcessInstanceQuery().list();
        Assertions.assertThat((Date)((HistoricProcessInstance)historicProcessInstances.get(0)).getRemovalTime()).isEqualTo((Object)BatchSetRemovalTimeRule.addDays(this.CURRENT_DATE, 5));
        Assertions.assertThat((Date)((HistoricProcessInstance)historicProcessInstances.get(1)).getRemovalTime()).isEqualTo((Object)BatchSetRemovalTimeRule.addDays(this.CURRENT_DATE, 5));
        HistoricProcessInstanceQuery query = this.historyService.createHistoricProcessInstanceQuery().superProcessInstanceId(rootProcessInstance);
        this.testRule.syncExec(this.historyService.setRemovalTimeToHistoricProcessInstances().absoluteRemovalTime(this.REMOVAL_TIME).byQuery(query).hierarchical().executeAsync());
        historicProcessInstances = this.historyService.createHistoricProcessInstanceQuery().list();
        Assertions.assertThat((Date)((HistoricProcessInstance)historicProcessInstances.get(0)).getRemovalTime()).isEqualTo((Object)this.REMOVAL_TIME);
        Assertions.assertThat((Date)((HistoricProcessInstance)historicProcessInstances.get(1)).getRemovalTime()).isEqualTo((Object)this.REMOVAL_TIME);
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/dmn/deployment/drdDish.dmn11.xml"})
    public void shouldSetRemovalTimeInHierarchyForStandaloneDecision_ByChildInstance() {
        this.decisionService.evaluateDecisionByKey("dish-decision").variables((Map)Variables.createVariables().putValue("temperature", (Object)32).putValue("dayType", (Object)"Weekend")).evaluate();
        HistoricDecisionInstance historicDecisionInstance = (HistoricDecisionInstance)this.historyService.createHistoricDecisionInstanceQuery().decisionDefinitionKey("season").singleResult();
        Assertions.assertThat((Date)historicDecisionInstance.getRemovalTime()).isNull();
        this.testRule.updateHistoryTimeToLiveDmn("dish-decision", 5);
        HistoricDecisionInstanceQuery query = this.historyService.createHistoricDecisionInstanceQuery().decisionInstanceId(historicDecisionInstance.getId());
        this.testRule.syncExec(this.historyService.setRemovalTimeToHistoricDecisionInstances().calculatedRemovalTime().byQuery(query).hierarchical().executeAsync());
        List historicDecisionInstances = this.historyService.createHistoricDecisionInstanceQuery().list();
        Assertions.assertThat((Date)((HistoricDecisionInstance)historicDecisionInstances.get(0)).getRemovalTime()).isEqualTo((Object)BatchSetRemovalTimeRule.addDays(this.CURRENT_DATE, 5));
        Assertions.assertThat((Date)((HistoricDecisionInstance)historicDecisionInstances.get(1)).getRemovalTime()).isEqualTo((Object)BatchSetRemovalTimeRule.addDays(this.CURRENT_DATE, 5));
        Assertions.assertThat((Date)((HistoricDecisionInstance)historicDecisionInstances.get(2)).getRemovalTime()).isEqualTo((Object)BatchSetRemovalTimeRule.addDays(this.CURRENT_DATE, 5));
    }

    @Test
    public void shouldSetRemovalTime_ByIds() {
        this.testRule.process().call().userTask().deploy().start();
        List historicProcessInstances = this.historyService.createHistoricProcessInstanceQuery().list();
        Assertions.assertThat((Date)((HistoricProcessInstance)historicProcessInstances.get(0)).getRemovalTime()).isNull();
        Assertions.assertThat((Date)((HistoricProcessInstance)historicProcessInstances.get(1)).getRemovalTime()).isNull();
        this.testRule.updateHistoryTimeToLive(5, "process", "rootProcess");
        ArrayList<String> ids = new ArrayList<String>();
        for (HistoricProcessInstance historicProcessInstance : historicProcessInstances) {
            ids.add(historicProcessInstance.getId());
        }
        this.testRule.syncExec(this.historyService.setRemovalTimeToHistoricProcessInstances().calculatedRemovalTime().byIds(ids.toArray(new String[0])).executeAsync());
        historicProcessInstances = this.historyService.createHistoricProcessInstanceQuery().list();
        Assertions.assertThat((Date)((HistoricProcessInstance)historicProcessInstances.get(0)).getRemovalTime()).isEqualTo((Object)BatchSetRemovalTimeRule.addDays(this.CURRENT_DATE, 5));
        Assertions.assertThat((Date)((HistoricProcessInstance)historicProcessInstances.get(1)).getRemovalTime()).isEqualTo((Object)BatchSetRemovalTimeRule.addDays(this.CURRENT_DATE, 5));
    }

    @Test
    public void shouldThrowBadUserRequestException_NotExistingIds() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.historyService.setRemovalTimeToHistoricProcessInstances().absoluteRemovalTime(this.REMOVAL_TIME).byIds(new String[]{"aNotExistingId", "anotherNotExistingId"}).executeAsync()).isInstanceOf(BadUserRequestException.class)).hasMessageContaining("historicProcessInstances is empty");
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/dmn/deployment/drdDish.dmn11.xml"})
    public void shouldSetRemovalTimeForStandaloneDecision_ByIds() {
        this.decisionService.evaluateDecisionByKey("dish-decision").variables((Map)Variables.createVariables().putValue("temperature", (Object)32).putValue("dayType", (Object)"Weekend")).evaluate();
        List historicDecisionInstances = this.historyService.createHistoricDecisionInstanceQuery().list();
        Assertions.assertThat((Date)((HistoricDecisionInstance)historicDecisionInstances.get(0)).getRemovalTime()).isNull();
        Assertions.assertThat((Date)((HistoricDecisionInstance)historicDecisionInstances.get(1)).getRemovalTime()).isNull();
        Assertions.assertThat((Date)((HistoricDecisionInstance)historicDecisionInstances.get(2)).getRemovalTime()).isNull();
        this.testRule.updateHistoryTimeToLiveDmn(5, "dish-decision", "season", "guestCount");
        ArrayList<String> ids = new ArrayList<String>();
        for (HistoricDecisionInstance historicDecisionInstance : historicDecisionInstances) {
            ids.add(historicDecisionInstance.getId());
        }
        this.testRule.syncExec(this.historyService.setRemovalTimeToHistoricDecisionInstances().calculatedRemovalTime().byIds(ids.toArray(new String[0])).executeAsync());
        historicDecisionInstances = this.historyService.createHistoricDecisionInstanceQuery().list();
        Assertions.assertThat((Date)((HistoricDecisionInstance)historicDecisionInstances.get(0)).getRemovalTime()).isEqualTo((Object)BatchSetRemovalTimeRule.addDays(this.CURRENT_DATE, 5));
        Assertions.assertThat((Date)((HistoricDecisionInstance)historicDecisionInstances.get(1)).getRemovalTime()).isEqualTo((Object)BatchSetRemovalTimeRule.addDays(this.CURRENT_DATE, 5));
        Assertions.assertThat((Date)((HistoricDecisionInstance)historicDecisionInstances.get(2)).getRemovalTime()).isEqualTo((Object)BatchSetRemovalTimeRule.addDays(this.CURRENT_DATE, 5));
    }

    @Test
    public void shouldThrowBadUserRequestExceptionForStandaloneDecision_NotExistingIds() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.historyService.setRemovalTimeToHistoricDecisionInstances().absoluteRemovalTime(this.REMOVAL_TIME).byIds(new String[]{"aNotExistingId", "anotherNotExistingId"}).executeAsync()).isInstanceOf(BadUserRequestException.class)).hasMessageContaining("historicDecisionInstances is empty");
    }

    @Test
    public void shouldSetRemovalTimeForBatch_ByIds() {
        String processInstanceId = this.testRule.process().serviceTask().deploy().start();
        Batch batchOne = this.historyService.deleteHistoricProcessInstancesAsync(Collections.singletonList(processInstanceId), "");
        Batch batchTwo = this.historyService.deleteHistoricProcessInstancesAsync(Collections.singletonList(processInstanceId), "");
        List historicBatches = this.historyService.createHistoricBatchQuery().type("historic-instance-deletion").list();
        Assertions.assertThat((Date)((HistoricBatch)historicBatches.get(0)).getRemovalTime()).isNull();
        Assertions.assertThat((Date)((HistoricBatch)historicBatches.get(1)).getRemovalTime()).isNull();
        ArrayList<String> ids = new ArrayList<String>();
        for (HistoricBatch historicBatch : historicBatches) {
            ids.add(historicBatch.getId());
        }
        this.testRule.syncExec(this.historyService.setRemovalTimeToHistoricBatches().absoluteRemovalTime(this.REMOVAL_TIME).byIds(ids.toArray(new String[0])).executeAsync());
        historicBatches = this.historyService.createHistoricBatchQuery().type("historic-instance-deletion").list();
        Assertions.assertThat((Date)((HistoricBatch)historicBatches.get(0)).getRemovalTime()).isEqualTo((Object)this.REMOVAL_TIME);
        Assertions.assertThat((Date)((HistoricBatch)historicBatches.get(1)).getRemovalTime()).isEqualTo((Object)this.REMOVAL_TIME);
        this.managementService.deleteBatch(batchOne.getId(), true);
        this.managementService.deleteBatch(batchTwo.getId(), true);
    }

    @Test
    public void shouldThrowBadUserRequestExceptionForBatch_NotExistingIds() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.historyService.setRemovalTimeToHistoricBatches().absoluteRemovalTime(this.REMOVAL_TIME).byIds(new String[]{"aNotExistingId", "anotherNotExistingId"}).executeAsync()).isInstanceOf(BadUserRequestException.class)).hasMessageContaining("historicBatches is empty");
    }

    @Test
    public void shouldThrowBadUserRequestException() {
        HistoricProcessInstanceQuery query = this.historyService.createHistoricProcessInstanceQuery();
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.historyService.setRemovalTimeToHistoricProcessInstances().absoluteRemovalTime(this.REMOVAL_TIME).byQuery(query).executeAsync()).isInstanceOf(BadUserRequestException.class)).hasMessageContaining("historicProcessInstances is empty");
    }

    @Test
    public void shouldThrowBadUserRequestExceptionForStandaloneDecision() {
        HistoricDecisionInstanceQuery query = this.historyService.createHistoricDecisionInstanceQuery();
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.historyService.setRemovalTimeToHistoricDecisionInstances().absoluteRemovalTime(this.REMOVAL_TIME).byQuery(query).executeAsync()).isInstanceOf(BadUserRequestException.class)).hasMessageContaining("historicDecisionInstances is empty");
    }

    @Test
    public void shouldThrowBadUserRequestExceptionForBatch() {
        HistoricBatchQuery query = this.historyService.createHistoricBatchQuery();
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.historyService.setRemovalTimeToHistoricBatches().absoluteRemovalTime(this.REMOVAL_TIME).byQuery(query).executeAsync()).isInstanceOf(BadUserRequestException.class)).hasMessageContaining("historicBatches is empty");
    }

    @Test
    public void shouldProduceHistory() {
        this.testRule.process().serviceTask().deploy().start();
        HistoricProcessInstanceQuery query = this.historyService.createHistoricProcessInstanceQuery();
        this.testRule.syncExec(this.historyService.setRemovalTimeToHistoricProcessInstances().calculatedRemovalTime().byQuery(query).executeAsync());
        HistoricBatch historicBatch = (HistoricBatch)this.historyService.createHistoricBatchQuery().singleResult();
        Assertions.assertThat((String)historicBatch.getType()).isEqualTo((Object)"process-set-removal-time");
        Assertions.assertThat((Date)historicBatch.getStartTime()).isEqualTo((Object)this.CURRENT_DATE);
        Assertions.assertThat((Date)historicBatch.getEndTime()).isEqualTo((Object)this.CURRENT_DATE);
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/dmn/deployment/drdDish.dmn11.xml"})
    public void shouldProduceHistoryForStandaloneDecision() {
        this.decisionService.evaluateDecisionByKey("dish-decision").variables((Map)Variables.createVariables().putValue("temperature", (Object)32).putValue("dayType", (Object)"Weekend")).evaluate();
        HistoricDecisionInstanceQuery query = this.historyService.createHistoricDecisionInstanceQuery();
        this.testRule.syncExec(this.historyService.setRemovalTimeToHistoricDecisionInstances().calculatedRemovalTime().byQuery(query).executeAsync());
        HistoricBatch historicBatch = (HistoricBatch)this.historyService.createHistoricBatchQuery().singleResult();
        Assertions.assertThat((String)historicBatch.getType()).isEqualTo((Object)"decision-set-removal-time");
        Assertions.assertThat((Date)historicBatch.getStartTime()).isEqualTo((Object)this.CURRENT_DATE);
        Assertions.assertThat((Date)historicBatch.getEndTime()).isEqualTo((Object)this.CURRENT_DATE);
    }

    @Test
    public void shouldProduceHistoryForBatch() {
        String processInstanceId = this.testRule.process().serviceTask().deploy().start();
        Batch batch = this.historyService.deleteHistoricProcessInstancesAsync(Collections.singletonList(processInstanceId), "");
        this.testRule.syncExec(batch);
        HistoricBatchQuery query = this.historyService.createHistoricBatchQuery();
        this.testRule.syncExec(this.historyService.setRemovalTimeToHistoricBatches().calculatedRemovalTime().byQuery(query).executeAsync());
        HistoricBatch historicBatch = (HistoricBatch)this.historyService.createHistoricBatchQuery().type("batch-set-removal-time").singleResult();
        Assertions.assertThat((Date)historicBatch.getStartTime()).isEqualTo((Object)this.CURRENT_DATE);
        Assertions.assertThat((Date)historicBatch.getEndTime()).isEqualTo((Object)this.CURRENT_DATE);
    }

    @Test
    public void shouldThrowExceptionIfNoRemovalTimeSettingDefined() {
        HistoricProcessInstanceQuery query = this.historyService.createHistoricProcessInstanceQuery();
        SetRemovalTimeToHistoricProcessInstancesBuilder batchBuilder = this.historyService.setRemovalTimeToHistoricProcessInstances().byQuery(query);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> batchBuilder.executeAsync()).isInstanceOf(BadUserRequestException.class)).hasMessageContaining("removalTime is null");
    }

    @Test
    public void shouldThrowExceptionIfNoRemovalTimeSettingDefinedForStandaloneDecision() {
        HistoricDecisionInstanceQuery query = this.historyService.createHistoricDecisionInstanceQuery();
        SetRemovalTimeToHistoricDecisionInstancesBuilder batchBuilder = this.historyService.setRemovalTimeToHistoricDecisionInstances().byQuery(query);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> batchBuilder.executeAsync()).isInstanceOf(BadUserRequestException.class)).hasMessageContaining("removalTime is null");
    }

    @Test
    public void shouldThrowExceptionIfNoRemovalTimeSettingDefinedForBatch() {
        HistoricBatchQuery query = this.historyService.createHistoricBatchQuery();
        SetRemovalTimeToHistoricBatchesBuilder batchBuilder = this.historyService.setRemovalTimeToHistoricBatches().byQuery(query);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> batchBuilder.executeAsync()).isInstanceOf(BadUserRequestException.class)).hasMessageContaining("removalTime is null");
    }

    @Test
    public void shouldThrowExceptionIfNoQueryAndNoIdsDefined() {
        SetRemovalTimeToHistoricProcessInstancesBuilder batchBuilder = this.historyService.setRemovalTimeToHistoricProcessInstances().absoluteRemovalTime(new Date());
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> batchBuilder.executeAsync()).isInstanceOf(BadUserRequestException.class)).hasMessageContaining("Neither query nor ids provided.");
    }

    @Test
    public void shouldThrowExceptionIfNoQueryAndNoIdsDefinedForStandaloneDecision() {
        SetRemovalTimeToHistoricDecisionInstancesBuilder batchBuilder = this.historyService.setRemovalTimeToHistoricDecisionInstances().absoluteRemovalTime(new Date());
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> batchBuilder.executeAsync()).isInstanceOf(BadUserRequestException.class)).hasMessageContaining("Neither query nor ids provided.");
    }

    @Test
    public void shouldThrowExceptionIfNoQueryAndNoIdsDefinedForBatch() {
        SetRemovalTimeToHistoricBatchesBuilder batchBuilder = this.historyService.setRemovalTimeToHistoricBatches().absoluteRemovalTime(new Date());
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> batchBuilder.executeAsync()).isInstanceOf(BadUserRequestException.class)).hasMessageContaining("Neither query nor ids provided.");
    }

    @Test
    public void shouldSetRemovalTime_BothQueryAndIdsDefined() {
        String rootProcessInstanceId = this.testRule.process().call().userTask().deploy().start();
        List historicProcessInstances = this.historyService.createHistoricProcessInstanceQuery().list();
        Assertions.assertThat((Date)((HistoricProcessInstance)historicProcessInstances.get(0)).getRemovalTime()).isNull();
        this.testRule.updateHistoryTimeToLive(5, "rootProcess", "process");
        HistoricProcessInstanceQuery query = this.historyService.createHistoricProcessInstanceQuery().superProcessInstanceId(rootProcessInstanceId);
        this.testRule.syncExec(this.historyService.setRemovalTimeToHistoricProcessInstances().calculatedRemovalTime().byQuery(query).byIds(new String[]{rootProcessInstanceId}).executeAsync());
        historicProcessInstances = this.historyService.createHistoricProcessInstanceQuery().list();
        Assertions.assertThat((Date)((HistoricProcessInstance)historicProcessInstances.get(0)).getRemovalTime()).isEqualTo((Object)BatchSetRemovalTimeRule.addDays(this.CURRENT_DATE, 5));
        Assertions.assertThat((Date)((HistoricProcessInstance)historicProcessInstances.get(1)).getRemovalTime()).isEqualTo((Object)BatchSetRemovalTimeRule.addDays(this.CURRENT_DATE, 5));
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/dmn/deployment/drdDish.dmn11.xml"})
    public void shouldSetRemovalTimeForStandaloneDecision_BothQueryAndIdsDefined() {
        this.decisionService.evaluateDecisionByKey("dish-decision").variables((Map)Variables.createVariables().putValue("temperature", (Object)32).putValue("dayType", (Object)"Weekend")).evaluate();
        List historicDecisionInstances = this.historyService.createHistoricDecisionInstanceQuery().decisionDefinitionKeyIn(new String[]{"season", "dish-decision"}).list();
        Assertions.assertThat((Date)((HistoricDecisionInstance)historicDecisionInstances.get(0)).getRemovalTime()).isNull();
        Assertions.assertThat((Date)((HistoricDecisionInstance)historicDecisionInstances.get(1)).getRemovalTime()).isNull();
        this.testRule.updateHistoryTimeToLiveDmn(5, "dish-decision", "season");
        HistoricDecisionInstanceQuery query = this.historyService.createHistoricDecisionInstanceQuery().decisionDefinitionKey("dish-decision");
        String id = ((HistoricDecisionInstance)this.historyService.createHistoricDecisionInstanceQuery().decisionDefinitionKey("season").singleResult()).getId();
        this.testRule.syncExec(this.historyService.setRemovalTimeToHistoricDecisionInstances().calculatedRemovalTime().byQuery(query).byIds(new String[]{id}).executeAsync());
        historicDecisionInstances = this.historyService.createHistoricDecisionInstanceQuery().decisionDefinitionKeyIn(new String[]{"season", "dish-decision"}).list();
        Assertions.assertThat((Date)((HistoricDecisionInstance)historicDecisionInstances.get(0)).getRemovalTime()).isEqualTo((Object)BatchSetRemovalTimeRule.addDays(this.CURRENT_DATE, 5));
        Assertions.assertThat((Date)((HistoricDecisionInstance)historicDecisionInstances.get(1)).getRemovalTime()).isEqualTo((Object)BatchSetRemovalTimeRule.addDays(this.CURRENT_DATE, 5));
    }

    @Test
    public void shouldSetRemovalTimeForBatch_BothQueryAndIdsDefined() {
        String processInstanceId = this.testRule.process().serviceTask().deploy().start();
        Batch batchOne = this.historyService.deleteHistoricProcessInstancesAsync(Collections.singletonList(processInstanceId), "");
        Batch batchTwo = this.historyService.deleteHistoricProcessInstancesAsync(Collections.singletonList(processInstanceId), "");
        List historicBatches = this.historyService.createHistoricBatchQuery().type("historic-instance-deletion").list();
        Assertions.assertThat((Date)((HistoricBatch)historicBatches.get(0)).getRemovalTime()).isNull();
        Assertions.assertThat((Date)((HistoricBatch)historicBatches.get(1)).getRemovalTime()).isNull();
        ProcessEngineConfigurationImpl configuration = this.testRule.getProcessEngineConfiguration();
        configuration.setBatchOperationHistoryTimeToLive("P5D");
        configuration.initHistoryCleanup();
        HistoricBatchQuery query = this.historyService.createHistoricBatchQuery().type("historic-instance-deletion").batchId(batchOne.getId());
        this.testRule.syncExec(this.historyService.setRemovalTimeToHistoricBatches().calculatedRemovalTime().byQuery(query).byIds(new String[]{batchTwo.getId()}).executeAsync());
        historicBatches = this.historyService.createHistoricBatchQuery().type("historic-instance-deletion").list();
        Assertions.assertThat((Date)((HistoricBatch)historicBatches.get(0)).getRemovalTime()).isEqualTo((Object)BatchSetRemovalTimeRule.addDays(this.CURRENT_DATE, 5));
        Assertions.assertThat((Date)((HistoricBatch)historicBatches.get(1)).getRemovalTime()).isEqualTo((Object)BatchSetRemovalTimeRule.addDays(this.CURRENT_DATE, 5));
        this.managementService.deleteBatch(batchOne.getId(), true);
        this.managementService.deleteBatch(batchTwo.getId(), true);
    }

    @Test
    public void shouldSetRemovalTime_ExistingAndNotExistingId() {
        String processInstanceId = this.testRule.process().userTask().deploy().start();
        List historicProcessInstances = this.historyService.createHistoricProcessInstanceQuery().list();
        Assertions.assertThat((Date)((HistoricProcessInstance)historicProcessInstances.get(0)).getRemovalTime()).isNull();
        this.testRule.updateHistoryTimeToLive(5, "process");
        this.testRule.syncExec(this.historyService.setRemovalTimeToHistoricProcessInstances().calculatedRemovalTime().byIds(new String[]{"notExistingId", processInstanceId}).executeAsync());
        historicProcessInstances = this.historyService.createHistoricProcessInstanceQuery().list();
        Assertions.assertThat((Date)((HistoricProcessInstance)historicProcessInstances.get(0)).getRemovalTime()).isEqualTo((Object)BatchSetRemovalTimeRule.addDays(this.CURRENT_DATE, 5));
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/dmn/deployment/drdDish.dmn11.xml"})
    public void shouldSetRemovalTimeForStandaloneDecision_ExistingAndNotExistingId() {
        this.decisionService.evaluateDecisionByKey("dish-decision").variables((Map)Variables.createVariables().putValue("temperature", (Object)32).putValue("dayType", (Object)"Weekend")).evaluate();
        HistoricDecisionInstance historicDecisionInstance = (HistoricDecisionInstance)this.historyService.createHistoricDecisionInstanceQuery().decisionDefinitionKeyIn(new String[]{"season"}).singleResult();
        Assertions.assertThat((Date)historicDecisionInstance.getRemovalTime()).isNull();
        this.testRule.updateHistoryTimeToLiveDmn(5, "season");
        String id = ((HistoricDecisionInstance)this.historyService.createHistoricDecisionInstanceQuery().decisionDefinitionKey("season").singleResult()).getId();
        this.testRule.syncExec(this.historyService.setRemovalTimeToHistoricDecisionInstances().calculatedRemovalTime().byIds(new String[]{"notExistingId", id}).executeAsync());
        historicDecisionInstance = (HistoricDecisionInstance)this.historyService.createHistoricDecisionInstanceQuery().decisionDefinitionKeyIn(new String[]{"season"}).singleResult();
        Assertions.assertThat((Date)historicDecisionInstance.getRemovalTime()).isEqualTo((Object)BatchSetRemovalTimeRule.addDays(this.CURRENT_DATE, 5));
    }

    @Test
    public void shouldSetRemovalTimeForBatch_ExistingAndNotExistingId() {
        String processInstanceId = this.testRule.process().serviceTask().deploy().start();
        Batch batchOne = this.historyService.deleteHistoricProcessInstancesAsync(Collections.singletonList(processInstanceId), "");
        HistoricBatch historicBatch = (HistoricBatch)this.historyService.createHistoricBatchQuery().type("historic-instance-deletion").singleResult();
        Assertions.assertThat((Date)historicBatch.getRemovalTime()).isNull();
        ProcessEngineConfigurationImpl configuration = this.testRule.getProcessEngineConfiguration();
        configuration.setBatchOperationHistoryTimeToLive("P5D");
        configuration.initHistoryCleanup();
        this.testRule.syncExec(this.historyService.setRemovalTimeToHistoricBatches().calculatedRemovalTime().byIds(new String[]{"notExistingId", batchOne.getId()}).executeAsync());
        historicBatch = (HistoricBatch)this.historyService.createHistoricBatchQuery().type("historic-instance-deletion").singleResult();
        Assertions.assertThat((Date)historicBatch.getRemovalTime()).isEqualTo((Object)BatchSetRemovalTimeRule.addDays(this.CURRENT_DATE, 5));
        this.managementService.deleteBatch(batchOne.getId(), true);
    }

    @Test
    public void ThrowBadUserRequestException_SelectMultipleModes_ModeCleared() {
        SetRemovalTimeSelectModeForHistoricProcessInstancesBuilder builder = this.historyService.setRemovalTimeToHistoricProcessInstances();
        builder.calculatedRemovalTime();
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> builder.clearedRemovalTime()).isInstanceOf(BadUserRequestException.class)).hasMessageContaining("The removal time modes are mutually exclusive: mode is not null");
    }

    @Test
    public void ThrowBadUserRequestException_SelectMultipleModes_ModeAbsolute() {
        SetRemovalTimeSelectModeForHistoricProcessInstancesBuilder builder = this.historyService.setRemovalTimeToHistoricProcessInstances();
        builder.calculatedRemovalTime();
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> builder.absoluteRemovalTime(new Date())).isInstanceOf(BadUserRequestException.class)).hasMessageContaining("The removal time modes are mutually exclusive: mode is not null");
    }

    @Test
    public void ThrowBadUserRequestExceptionForStandaloneDecision_SelectMultipleModes_ModeCleared() {
        SetRemovalTimeSelectModeForHistoricDecisionInstancesBuilder builder = this.historyService.setRemovalTimeToHistoricDecisionInstances();
        builder.calculatedRemovalTime();
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> builder.clearedRemovalTime()).isInstanceOf(BadUserRequestException.class)).hasMessageContaining("The removal time modes are mutually exclusive: mode is not null");
    }

    @Test
    public void ThrowBadUserRequestExceptionForStandaloneDecision_SelectMultipleModes_ModeAbsolute() {
        SetRemovalTimeSelectModeForHistoricDecisionInstancesBuilder builder = this.historyService.setRemovalTimeToHistoricDecisionInstances();
        builder.calculatedRemovalTime();
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> builder.absoluteRemovalTime(new Date())).isInstanceOf(BadUserRequestException.class)).hasMessageContaining("The removal time modes are mutually exclusive: mode is not null");
    }

    @Test
    public void ThrowBadUserRequestExceptionForBatch_SelectMultipleModes_ModeCleared() {
        SetRemovalTimeSelectModeForHistoricBatchesBuilder builder = this.historyService.setRemovalTimeToHistoricBatches();
        builder.calculatedRemovalTime();
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> builder.clearedRemovalTime()).isInstanceOf(BadUserRequestException.class)).hasMessageContaining("The removal time modes are mutually exclusive: mode is not null");
    }

    @Test
    public void ThrowBadUserRequestExceptionForBatch_SelectMultipleModes_ModeAbsolute() {
        SetRemovalTimeSelectModeForHistoricBatchesBuilder builder = this.historyService.setRemovalTimeToHistoricBatches();
        builder.calculatedRemovalTime();
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> builder.absoluteRemovalTime(new Date())).isInstanceOf(BadUserRequestException.class)).hasMessageContaining("The removal time modes are mutually exclusive: mode is not null");
    }

    @Test
    public void shouldSeeCleanableButNotFinishedProcessInstanceInReport() {
        String processInstanceId = this.testRule.process().userTask().deploy().start();
        this.testRule.syncExec(this.historyService.setRemovalTimeToHistoricProcessInstances().absoluteRemovalTime(this.CURRENT_DATE).byIds(new String[]{processInstanceId}).executeAsync());
        CleanableHistoricProcessInstanceReportResult report = (CleanableHistoricProcessInstanceReportResult)this.historyService.createCleanableHistoricProcessInstanceReport().singleResult();
        Assertions.assertThat((long)report.getFinishedProcessInstanceCount()).isEqualTo(0L);
        Assertions.assertThat((long)report.getCleanableProcessInstanceCount()).isEqualTo(1L);
        Assertions.assertThat((Integer)report.getHistoryTimeToLive()).isNull();
    }

    @Test
    public void shouldSeeCleanableAndFinishedProcessInstanceInReport() {
        String processInstanceId = this.testRule.process().serviceTask().deploy().start();
        this.testRule.syncExec(this.historyService.setRemovalTimeToHistoricProcessInstances().absoluteRemovalTime(this.CURRENT_DATE).byIds(new String[]{processInstanceId}).executeAsync());
        CleanableHistoricProcessInstanceReportResult report = (CleanableHistoricProcessInstanceReportResult)this.historyService.createCleanableHistoricProcessInstanceReport().singleResult();
        Assertions.assertThat((long)report.getFinishedProcessInstanceCount()).isEqualTo(1L);
        Assertions.assertThat((long)report.getCleanableProcessInstanceCount()).isEqualTo(1L);
        Assertions.assertThat((Integer)report.getHistoryTimeToLive()).isNull();
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/dmn/deployment/drdDish.dmn11.xml"})
    public void shouldSeeCleanableAndFinishedDecisionInstanceInReport() {
        this.decisionService.evaluateDecisionByKey("dish-decision").variables((Map)Variables.createVariables().putValue("temperature", (Object)32).putValue("dayType", (Object)"Weekend")).evaluate();
        HistoricDecisionInstanceQuery query = this.historyService.createHistoricDecisionInstanceQuery().decisionDefinitionKey("dish-decision");
        this.testRule.syncExec(this.historyService.setRemovalTimeToHistoricDecisionInstances().absoluteRemovalTime(this.CURRENT_DATE).byQuery(query).executeAsync());
        CleanableHistoricDecisionInstanceReportResult report = (CleanableHistoricDecisionInstanceReportResult)this.historyService.createCleanableHistoricDecisionInstanceReport().decisionDefinitionKeyIn(new String[]{"dish-decision"}).singleResult();
        Assertions.assertThat((long)report.getFinishedDecisionInstanceCount()).isEqualTo(1L);
        Assertions.assertThat((long)report.getCleanableDecisionInstanceCount()).isEqualTo(1L);
        Assertions.assertThat((Integer)report.getHistoryTimeToLive()).isNull();
    }

    @Test
    public void shouldSeeCleanableButNotFinishedBatchInReport() {
        String processInstanceId = this.testRule.process().serviceTask().deploy().start();
        Batch batchOne = this.historyService.deleteHistoricProcessInstancesAsync(Collections.singletonList(processInstanceId), "");
        this.testRule.syncExec(this.historyService.setRemovalTimeToHistoricBatches().absoluteRemovalTime(this.CURRENT_DATE).byIds(new String[]{batchOne.getId()}).executeAsync());
        this.testRule.clearDatabase();
        CleanableHistoricBatchReportResult report = (CleanableHistoricBatchReportResult)this.historyService.createCleanableHistoricBatchReport().singleResult();
        Assertions.assertThat((long)report.getFinishedBatchesCount()).isEqualTo(0L);
        Assertions.assertThat((long)report.getCleanableBatchesCount()).isEqualTo(1L);
        Assertions.assertThat((Integer)report.getHistoryTimeToLive()).isNull();
        this.managementService.deleteBatch(batchOne.getId(), true);
    }

    @Test
    public void shouldSeeCleanableAndFinishedBatchInReport() {
        String processInstanceId = this.testRule.process().serviceTask().deploy().start();
        Batch batchOne = this.historyService.deleteHistoricProcessInstancesAsync(Collections.singletonList(processInstanceId), "");
        this.testRule.syncExec(batchOne, false);
        this.testRule.syncExec(this.historyService.setRemovalTimeToHistoricBatches().absoluteRemovalTime(this.CURRENT_DATE).byIds(new String[]{batchOne.getId()}).executeAsync());
        this.testRule.clearDatabase();
        CleanableHistoricBatchReportResult report = (CleanableHistoricBatchReportResult)this.historyService.createCleanableHistoricBatchReport().singleResult();
        Assertions.assertThat((long)report.getFinishedBatchesCount()).isEqualTo(1L);
        Assertions.assertThat((long)report.getCleanableBatchesCount()).isEqualTo(1L);
        Assertions.assertThat((Integer)report.getHistoryTimeToLive()).isNull();
        this.historyService.deleteHistoricBatch(batchOne.getId());
    }

    @Test
    public void shouldSetInvocationsPerBatchTypeForProcesses() {
        this.engineRule.getProcessEngineConfiguration().getInvocationsPerBatchJobByBatchType().put("process-set-removal-time", 42);
        this.testRule.process().serviceTask().deploy().start();
        Batch batch = this.historyService.setRemovalTimeToHistoricProcessInstances().absoluteRemovalTime(this.CURRENT_DATE).byQuery(this.historyService.createHistoricProcessInstanceQuery()).executeAsync();
        Assertions.assertThat((int)batch.getInvocationsPerBatchJob()).isEqualTo(42);
        this.engineRule.getProcessEngineConfiguration().setInvocationsPerBatchJobByBatchType(new HashMap());
        this.managementService.deleteBatch(batch.getId(), true);
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/dmn/deployment/drdDish.dmn11.xml"})
    public void shouldSetInvocationsPerBatchTypeForDecisions() {
        this.engineRule.getProcessEngineConfiguration().getInvocationsPerBatchJobByBatchType().put("decision-set-removal-time", 42);
        this.decisionService.evaluateDecisionByKey("dish-decision").variables((Map)Variables.createVariables().putValue("temperature", (Object)32).putValue("dayType", (Object)"Weekend")).evaluate();
        Batch batch = this.historyService.setRemovalTimeToHistoricDecisionInstances().absoluteRemovalTime(this.CURRENT_DATE).byQuery(this.historyService.createHistoricDecisionInstanceQuery()).executeAsync();
        Assertions.assertThat((int)batch.getInvocationsPerBatchJob()).isEqualTo(42);
        this.engineRule.getProcessEngineConfiguration().setInvocationsPerBatchJobByBatchType(new HashMap());
        this.managementService.deleteBatch(batch.getId(), true);
    }

    @Test
    public void shouldSetInvocationsPerBatchTypeForBatches() {
        this.engineRule.getProcessEngineConfiguration().getInvocationsPerBatchJobByBatchType().put("batch-set-removal-time", 42);
        String processInstanceId = this.testRule.process().serviceTask().deploy().start();
        Batch batchOne = this.historyService.deleteHistoricProcessInstancesAsync(Collections.singletonList(processInstanceId), "");
        this.testRule.syncExec(batchOne, false);
        Batch batchTwo = this.historyService.setRemovalTimeToHistoricBatches().absoluteRemovalTime(this.CURRENT_DATE).byQuery(this.historyService.createHistoricBatchQuery()).executeAsync();
        Assertions.assertThat((int)batchTwo.getInvocationsPerBatchJob()).isEqualTo(42);
        this.engineRule.getProcessEngineConfiguration().setInvocationsPerBatchJobByBatchType(new HashMap());
        this.managementService.deleteBatch(batchTwo.getId(), true);
        this.historyService.deleteHistoricBatch(batchOne.getId());
    }
}

