/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.history.removaltime.cleanup;

import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.camunda.bpm.engine.test.ProcessEngineRule;
import org.camunda.bpm.engine.test.util.ProcessEngineTestRule;
import org.camunda.bpm.engine.test.util.ProvidedProcessEngineRule;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.core.Is;
import org.junit.AfterClass;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;

public class HistoryCleanupStrategyConfigurationTest {
    protected ProcessEngineRule engineRule = new ProvidedProcessEngineRule();
    protected ProcessEngineTestRule testRule = new ProcessEngineTestRule(this.engineRule);
    @Rule
    public RuleChain ruleChain = RuleChain.outerRule((TestRule)this.engineRule).around((TestRule)this.testRule);
    protected static ProcessEngineConfigurationImpl engineConfiguration;

    @Before
    public void init() {
        engineConfiguration = this.engineRule.getProcessEngineConfiguration();
        engineConfiguration.setHistoryCleanupStrategy(null).setHistoryRemovalTimeStrategy(null).initHistoryCleanup();
    }

    @AfterClass
    public static void tearDown() {
        engineConfiguration.setHistoryRemovalTimeStrategy(null).initHistoryRemovalTime();
        engineConfiguration.setHistoryCleanupStrategy(null).initHistoryCleanup();
    }

    @Test
    public void shouldAutomaticallyConfigure() {
        engineConfiguration.setHistoryCleanupStrategy(null);
        engineConfiguration.initHistoryCleanup();
        MatcherAssert.assertThat((Object)engineConfiguration.getHistoryCleanupStrategy(), (Matcher)Is.is((Object)"removalTimeBased"));
    }

    @Test
    public void shouldConfigureToRemovalTimeBased() {
        engineConfiguration.setHistoryCleanupStrategy("removalTimeBased");
        engineConfiguration.initHistoryCleanup();
        MatcherAssert.assertThat((Object)engineConfiguration.getHistoryCleanupStrategy(), (Matcher)Is.is((Object)"removalTimeBased"));
    }

    @Test
    public void shouldConfigureToRemovalTimeBasedWithRemovalTimeStrategyToEnd() {
        engineConfiguration.setHistoryCleanupStrategy("removalTimeBased").setHistoryRemovalTimeStrategy("end");
        engineConfiguration.initHistoryCleanup();
        MatcherAssert.assertThat((Object)engineConfiguration.getHistoryCleanupStrategy(), (Matcher)Is.is((Object)"removalTimeBased"));
        MatcherAssert.assertThat((Object)engineConfiguration.getHistoryRemovalTimeStrategy(), (Matcher)Is.is((Object)"end"));
    }

    @Test
    public void shouldConfigureToRemovalTimeBasedWithRemovalTimeStrategyToStart() {
        engineConfiguration.setHistoryCleanupStrategy("removalTimeBased").setHistoryRemovalTimeStrategy("start");
        engineConfiguration.initHistoryCleanup();
        MatcherAssert.assertThat((Object)engineConfiguration.getHistoryCleanupStrategy(), (Matcher)Is.is((Object)"removalTimeBased"));
        MatcherAssert.assertThat((Object)engineConfiguration.getHistoryRemovalTimeStrategy(), (Matcher)Is.is((Object)"start"));
    }

    @Test
    public void shouldConfigureToEndTimeBased() {
        engineConfiguration.setHistoryCleanupStrategy("endTimeBased");
        engineConfiguration.initHistoryCleanup();
        MatcherAssert.assertThat((Object)engineConfiguration.getHistoryCleanupStrategy(), (Matcher)Is.is((Object)"endTimeBased"));
    }

    @Test
    public void shouldConfigureWithNotExistentStrategy() {
        engineConfiguration.setHistoryCleanupStrategy("nonExistentStrategy");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> engineConfiguration.initHistoryCleanup()).isInstanceOf(ProcessEngineException.class)).hasMessageContaining("history cleanup strategy must be either set to 'removalTimeBased' or 'endTimeBased'.");
    }

    @Test
    public void shouldConfigureToRemovalTimeBasedWithRemovalTimeStrategyToNone() {
        engineConfiguration.setHistoryCleanupStrategy("removalTimeBased").setHistoryRemovalTimeStrategy("none");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> engineConfiguration.initHistoryCleanup()).isInstanceOf(ProcessEngineException.class)).hasMessageContaining("history removal time strategy cannot be set to 'none' in conjunction with 'removalTimeBased' history cleanup strategy.");
    }
}

