/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.mgmt.license;

import java.util.Map;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.camunda.bpm.engine.IdentityService;
import org.camunda.bpm.engine.ManagementService;
import org.camunda.bpm.engine.ProcessEngine;
import org.camunda.bpm.engine.exception.NullValueException;
import org.camunda.bpm.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.camunda.bpm.engine.impl.interceptor.Command;
import org.camunda.bpm.engine.impl.persistence.entity.ByteArrayEntity;
import org.camunda.bpm.engine.test.api.resources.GetByteArrayCommand;
import org.camunda.bpm.engine.test.util.ProcessEngineTestRule;
import org.camunda.bpm.engine.test.util.ProvidedProcessEngineRule;
import org.junit.After;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;

public class LicenseKeyTest {
    public ProvidedProcessEngineRule engineRule = new ProvidedProcessEngineRule();
    public ProcessEngineTestRule testRule = new ProcessEngineTestRule(this.engineRule);
    @Rule
    public RuleChain ruleChain = RuleChain.outerRule((TestRule)this.testRule).around((TestRule)this.engineRule);
    ProcessEngine processEngine;
    ProcessEngineConfigurationImpl processEngineConfiguration;
    ManagementService managementService;
    IdentityService identityService;

    @Before
    public void init() {
        this.processEngine = this.engineRule.getProcessEngine();
        this.processEngineConfiguration = (ProcessEngineConfigurationImpl)this.processEngine.getProcessEngineConfiguration();
        this.managementService = this.processEngine.getManagementService();
        this.identityService = this.processEngine.getIdentityService();
    }

    @After
    public void tearDown() {
        this.managementService.deleteLicenseKey();
    }

    @Test
    public void shouldSetLicenseKey() {
        String licenseKey = "testLicenseKey";
        this.managementService.setLicenseKey(licenseKey);
        Map properties = this.managementService.getProperties();
        String licenseKeyLegacyProperty = (String)properties.get("camunda-license-key");
        String licenseByteArrayId = (String)properties.get("camunda-license-key-id");
        Assertions.assertThat((String)licenseKeyLegacyProperty).isNull();
        Assertions.assertThat((String)licenseByteArrayId).isNotNull();
        Assertions.assertThat((String)licenseByteArrayId).isNotEqualTo((Object)licenseKey);
        Assertions.assertThat((byte[])((ByteArrayEntity)this.processEngineConfiguration.getCommandExecutorTxRequired().execute((Command)new GetByteArrayCommand(licenseByteArrayId))).getBytes()).isEqualTo((Object)licenseKey.getBytes());
    }

    @Test
    public void shouldGetLicenseKey() {
        String licenseKey = "testLicenseKey";
        this.managementService.setLicenseKey(licenseKey);
        String storedLicenseKey = this.managementService.getLicenseKey();
        Assertions.assertThat((String)storedLicenseKey).isEqualTo((Object)licenseKey);
    }

    @Test
    public void shouldGetLegacyLicenseKey() {
        String legacyLicenseKey = "testLegacyLicenseKey";
        this.managementService.setProperty("camunda-license-key", legacyLicenseKey);
        String storedLegacyLicenseKey = this.managementService.getLicenseKey();
        Assertions.assertThat((String)storedLegacyLicenseKey).isEqualTo((Object)legacyLicenseKey);
    }

    @Test
    public void shouldGetNullWithNoLicenseKeySet() {
        String storedLegacyLicenseKey = this.managementService.getLicenseKey();
        Assertions.assertThat((String)storedLegacyLicenseKey).isNull();
    }

    @Test
    public void shouldDeleteLicenseKey() {
        String licenseKey = "testLicenseKey";
        this.managementService.setLicenseKey(licenseKey);
        String licenseByteArrayId = (String)this.managementService.getProperties().get("camunda-license-key-id");
        this.managementService.deleteLicenseKey();
        String storedLicenseKey = this.managementService.getLicenseKey();
        Assertions.assertThat((String)storedLicenseKey).isNull();
        Assertions.assertThat((boolean)this.managementService.getProperties().containsKey("camunda-license-key-id")).isFalse();
        Assertions.assertThat((Object)this.processEngineConfiguration.getCommandExecutorTxRequired().execute((Command)new GetByteArrayCommand(licenseByteArrayId))).isNull();
    }

    @Test
    public void shouldDeleteLegacyLicenseKey() {
        String legacyLicenseKey = "testLegacyLicenseKey";
        this.managementService.setProperty("camunda-license-key", legacyLicenseKey);
        this.managementService.deleteLicenseKey();
        String storedLicenseKey = this.managementService.getLicenseKey();
        Assertions.assertThat((String)storedLicenseKey).isNull();
        Assertions.assertThat((boolean)this.managementService.getProperties().containsKey("camunda-license-key")).isFalse();
    }

    @Test
    public void shouldIgnoreDeleteWithNoLicenseKeySet() {
        String noLicenseKey = this.managementService.getLicenseKey();
        this.managementService.deleteLicenseKey();
        String noLicenseKeyAfterDelete = this.managementService.getLicenseKey();
        Assertions.assertThat((String)noLicenseKey).isNull();
        Assertions.assertThat((String)noLicenseKeyAfterDelete).isNull();
    }

    @Test
    public void shouldUpdateLicenseKey() {
        String licenseKey = "testLicenseKey";
        String licenseKey2 = "testLicenseKey2";
        this.managementService.setLicenseKey(licenseKey);
        String storedLicenseKey = this.managementService.getLicenseKey();
        this.managementService.setLicenseKey(licenseKey2);
        String storedLicenseKey2 = this.managementService.getLicenseKey();
        Assertions.assertThat((String)storedLicenseKey).isEqualTo((Object)licenseKey);
        Assertions.assertThat((String)storedLicenseKey2).isEqualTo((Object)licenseKey2);
        Assertions.assertThat((String)storedLicenseKey).isNotEqualTo((Object)storedLicenseKey2);
    }

    @Test
    public void shouldUpdateLegacyLicenseKey() {
        String legacyLicenseKey = "testLegacyLicenseKey";
        String licenseKey = "testLicenseKey";
        this.managementService.setProperty("camunda-license-key", legacyLicenseKey);
        String storedLegacyLicense = (String)this.managementService.getProperties().get("camunda-license-key");
        this.managementService.setLicenseKey(licenseKey);
        String storedByteArrayId = (String)this.managementService.getProperties().get("camunda-license-key-id");
        byte[] licenseBytes = ((ByteArrayEntity)this.processEngineConfiguration.getCommandExecutorTxRequired().execute((Command)new GetByteArrayCommand(storedByteArrayId))).getBytes();
        Assertions.assertThat((String)((String)this.managementService.getProperties().get("camunda-license-key"))).isNull();
        Assertions.assertThat((String)legacyLicenseKey).isEqualTo((Object)storedLegacyLicense);
        Assertions.assertThat((String)storedByteArrayId).isNotEqualTo((Object)legacyLicenseKey);
        Assertions.assertThat((byte[])licenseBytes).isEqualTo((Object)licenseKey.getBytes());
    }

    @Test
    public void shouldUpdateDuplicateLicenseKey() {
        String licenseKey = "testLicenseKey";
        this.managementService.setLicenseKey(licenseKey);
        String storedLicenseKey = this.managementService.getLicenseKey();
        String storedByteArrayId = (String)this.managementService.getProperties().get("camunda-license-key-id");
        this.managementService.setLicenseKey(licenseKey);
        String storedLicenseKey2 = this.managementService.getLicenseKey();
        String storedByteArrayId2 = (String)this.managementService.getProperties().get("camunda-license-key-id");
        Assertions.assertThat((String)storedLicenseKey).isEqualTo((Object)licenseKey);
        Assertions.assertThat((String)storedLicenseKey2).isEqualTo((Object)licenseKey);
        Assertions.assertThat((String)storedByteArrayId).isNotEqualTo((Object)storedByteArrayId2);
    }

    @Test
    public void shouldThrowExceptionWhenSetNullLicenseKey() {
        String licenseKey = null;
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.managementService.setLicenseKey(licenseKey)).isInstanceOf(NullValueException.class)).hasMessageContaining("licenseKey is null");
        String storedLicenseKey = this.managementService.getLicenseKey();
        Assertions.assertThat((String)storedLicenseKey).isNull();
    }
}

