/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.cmmn.milestone;

import org.camunda.bpm.engine.runtime.CaseExecution;
import org.camunda.bpm.engine.runtime.CaseInstance;
import org.camunda.bpm.engine.test.Deployment;
import org.camunda.bpm.engine.test.util.PluggableProcessEngineTest;
import org.junit.Assert;
import org.junit.Test;

public class MilestoneTest
extends PluggableProcessEngineTest {
    @Deployment(resources={"org/camunda/bpm/engine/test/cmmn/milestone/MilestoneTest.testWithoutEntryCriterias.cmmn"})
    @Test
    public void testWithoutEntryCriterias() {
        String caseInstanceId = this.caseService.withCaseDefinitionByKey("case").create().getId();
        CaseInstance caseInstance = (CaseInstance)this.caseService.createCaseInstanceQuery().caseInstanceId(caseInstanceId).singleResult();
        Assert.assertTrue((boolean)caseInstance.isCompleted());
        Object occurVariable = this.caseService.getVariable(caseInstanceId, "occur");
        Assert.assertNotNull((Object)occurVariable);
        Assert.assertTrue((boolean)((Boolean)occurVariable));
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/cmmn/milestone/MilestoneTest.testWithEntryCriteria.cmmn"})
    @Test
    public void testWithEntryCriteria() {
        String caseInstanceId = this.caseService.withCaseDefinitionByKey("case").create().getId();
        CaseExecution milestone = (CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_Milestone_1").singleResult();
        String humanTaskId = ((CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_1").singleResult()).getId();
        Assert.assertTrue((boolean)milestone.isAvailable());
        Assert.assertNull((Object)this.caseService.getVariable(caseInstanceId, "occur"));
        milestone = (CaseExecution)this.caseService.createCaseExecutionQuery().available().singleResult();
        Assert.assertTrue((boolean)milestone.isAvailable());
        this.caseService.withCaseExecution(humanTaskId).complete();
        Object occurVariable = this.caseService.getVariable(caseInstanceId, "occur");
        Assert.assertNotNull((Object)occurVariable);
        Assert.assertTrue((boolean)((Boolean)occurVariable));
        milestone = (CaseExecution)this.caseService.createCaseExecutionQuery().available().singleResult();
        Assert.assertNull((Object)milestone);
        CaseInstance caseInstance = (CaseInstance)this.caseService.createCaseInstanceQuery().caseInstanceId(caseInstanceId).singleResult();
        Assert.assertTrue((boolean)caseInstance.isCompleted());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/cmmn/milestone/MilestoneTest.testWithMultipleEntryCriterias.cmmn"})
    @Test
    public void testWithMultipleEntryCriterias() {
        String caseInstanceId = this.caseService.withCaseDefinitionByKey("case").create().getId();
        CaseExecution milestone = (CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_Milestone_1").singleResult();
        String humanTaskId = ((CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_2").singleResult()).getId();
        Assert.assertTrue((boolean)milestone.isAvailable());
        Assert.assertNull((Object)this.caseService.getVariable(caseInstanceId, "occur"));
        milestone = (CaseExecution)this.caseService.createCaseExecutionQuery().available().singleResult();
        Assert.assertTrue((boolean)milestone.isAvailable());
        this.caseService.withCaseExecution(humanTaskId).complete();
        Object occurVariable = this.caseService.getVariable(caseInstanceId, "occur");
        Assert.assertNotNull((Object)occurVariable);
        Assert.assertTrue((boolean)((Boolean)occurVariable));
        milestone = (CaseExecution)this.caseService.createCaseExecutionQuery().available().singleResult();
        Assert.assertNull((Object)milestone);
        CaseInstance caseInstance = (CaseInstance)this.caseService.createCaseInstanceQuery().caseInstanceId(caseInstanceId).singleResult();
        Assert.assertTrue((boolean)caseInstance.isActive());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/cmmn/milestone/MilestoneTest.testWithEntryCriteria.cmmn"})
    @Test
    public void testActivityType() {
        this.caseService.withCaseDefinitionByKey("case").create().getId();
        CaseExecution milestone = (CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_Milestone_1").singleResult();
        Assert.assertEquals((Object)"milestone", (Object)milestone.getActivityType());
    }
}

