/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.cmmn.sentry;

import org.camunda.bpm.engine.impl.cmmn.entity.runtime.CaseExecutionEntity;
import org.camunda.bpm.engine.runtime.CaseExecution;
import org.camunda.bpm.engine.task.Task;
import org.camunda.bpm.engine.test.Deployment;
import org.camunda.bpm.engine.test.cmmn.CmmnTest;
import org.junit.Assert;
import org.junit.Test;

public class SentryExitCriteriaTest
extends CmmnTest {
    @Deployment(resources={"org/camunda/bpm/engine/test/cmmn/sentry/SentryExitCriteriaTest.testExitTask.cmmn"})
    @Test
    public void testExitTask() {
        String caseInstanceId = this.createCaseInstance().getId();
        CaseExecution firstHumanTask = this.queryCaseExecutionByActivityId("PI_HumanTask_1");
        String firstHumanTaskId = firstHumanTask.getId();
        Assert.assertTrue((boolean)firstHumanTask.isActive());
        CaseExecution secondHumanTask = this.queryCaseExecutionByActivityId("PI_HumanTask_2");
        String secondHumanTaskId = secondHumanTask.getId();
        Assert.assertTrue((boolean)secondHumanTask.isActive());
        Assert.assertNull((Object)this.caseService.getVariable(caseInstanceId, "exit"));
        this.complete(firstHumanTaskId);
        secondHumanTask = this.queryCaseExecutionById(secondHumanTaskId);
        Assert.assertNull((Object)secondHumanTask);
        Object exitVariable = this.caseService.getVariable(caseInstanceId, "exit");
        Assert.assertNotNull((Object)exitVariable);
        Assert.assertTrue((boolean)((Boolean)exitVariable));
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/cmmn/sentry/SentryExitCriteriaTest.testExitStage.cmmn"})
    @Test
    public void testExitStage() {
        String caseInstanceId = this.createCaseInstance().getId();
        CaseExecution firstHumanTask = this.queryCaseExecutionByActivityId("PI_HumanTask_1");
        String firstHumanTaskId = firstHumanTask.getId();
        Assert.assertTrue((boolean)firstHumanTask.isActive());
        CaseExecution stage = this.queryCaseExecutionByActivityId("PI_Stage_1");
        String stageId = stage.getId();
        Assert.assertTrue((boolean)stage.isActive());
        stage = this.queryCaseExecutionById(stageId);
        Assert.assertTrue((boolean)stage.isActive());
        CaseExecution milestone = this.queryCaseExecutionByActivityId("PI_Milestone_1");
        String milestoneId = milestone.getId();
        Assert.assertTrue((boolean)milestone.isAvailable());
        CaseExecution secondHumanTask = this.queryCaseExecutionByActivityId("PI_HumanTask_2");
        String secondHumanTaskId = secondHumanTask.getId();
        Assert.assertTrue((boolean)secondHumanTask.isActive());
        stage = this.queryCaseExecutionById(stageId);
        Assert.assertTrue((boolean)stage.isActive());
        Assert.assertNull((Object)this.caseService.getVariable(caseInstanceId, "exit"));
        Assert.assertNull((Object)this.caseService.getVariable(caseInstanceId, "parentTerminate"));
        this.complete(firstHumanTaskId);
        stage = this.queryCaseExecutionById(stageId);
        Assert.assertNull((Object)stage);
        milestone = this.queryCaseExecutionById(milestoneId);
        Assert.assertNull((Object)milestone);
        secondHumanTask = this.queryCaseExecutionById(secondHumanTaskId);
        Assert.assertNull((Object)secondHumanTask);
        Object exitVariable = this.caseService.getVariable(caseInstanceId, "exit");
        Assert.assertNotNull((Object)exitVariable);
        Assert.assertTrue((boolean)((Boolean)exitVariable));
        Object parentTerminateVariable = this.caseService.getVariable(caseInstanceId, "parentTerminate");
        Assert.assertNotNull((Object)parentTerminateVariable);
        Assert.assertTrue((boolean)((Boolean)parentTerminateVariable));
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/cmmn/sentry/SentryExitCriteriaTest.testAndJoin.cmmn"})
    @Test
    public void testAndJoin() {
        String caseInstanceId = this.createCaseInstance().getId();
        CaseExecution firstHumanTask = this.queryCaseExecutionByActivityId("PI_HumanTask_1");
        String firstHumanTaskId = firstHumanTask.getId();
        Assert.assertTrue((boolean)firstHumanTask.isActive());
        CaseExecution secondHumanTask = this.queryCaseExecutionByActivityId("PI_HumanTask_2");
        String secondHumanTaskId = secondHumanTask.getId();
        Assert.assertTrue((boolean)secondHumanTask.isActive());
        CaseExecution thirdHumanTask = this.queryCaseExecutionByActivityId("PI_HumanTask_3");
        String thirdHumanTaskId = thirdHumanTask.getId();
        Assert.assertTrue((boolean)thirdHumanTask.isActive());
        this.complete(firstHumanTaskId);
        thirdHumanTask = this.queryCaseExecutionById(thirdHumanTaskId);
        Assert.assertTrue((boolean)thirdHumanTask.isActive());
        Assert.assertNull((Object)this.caseService.getVariable(caseInstanceId, "exit"));
        this.complete(secondHumanTaskId);
        thirdHumanTask = this.queryCaseExecutionById(thirdHumanTaskId);
        Assert.assertNull((Object)thirdHumanTask);
        Object exitVariable = this.caseService.getVariable(caseInstanceId, "exit");
        Assert.assertNotNull((Object)exitVariable);
        Assert.assertTrue((boolean)((Boolean)exitVariable));
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/cmmn/sentry/SentryExitCriteriaTest.testAndFork.cmmn"})
    @Test
    public void testAndFork() {
        this.createCaseInstance();
        CaseExecution firstHumanTask = this.queryCaseExecutionByActivityId("PI_HumanTask_1");
        String firstHumanTaskId = firstHumanTask.getId();
        Assert.assertTrue((boolean)firstHumanTask.isActive());
        CaseExecution secondHumanTask = this.queryCaseExecutionByActivityId("PI_HumanTask_2");
        String secondHumanTaskId = secondHumanTask.getId();
        Assert.assertTrue((boolean)secondHumanTask.isActive());
        CaseExecution thirdHumanTask = this.queryCaseExecutionByActivityId("PI_HumanTask_3");
        String thirdHumanTaskId = thirdHumanTask.getId();
        Assert.assertTrue((boolean)thirdHumanTask.isActive());
        this.complete(firstHumanTaskId);
        secondHumanTask = this.queryCaseExecutionById(secondHumanTaskId);
        Assert.assertNull((Object)secondHumanTask);
        thirdHumanTask = this.queryCaseExecutionById(thirdHumanTaskId);
        Assert.assertNull((Object)thirdHumanTask);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/cmmn/sentry/SentryExitCriteriaTest.testOrJoin.cmmn"})
    @Test
    public void testOrJoin() {
        String caseInstanceId = this.createCaseInstance().getId();
        CaseExecution firstHumanTask = this.queryCaseExecutionByActivityId("PI_HumanTask_1");
        String firstHumanTaskId = firstHumanTask.getId();
        Assert.assertTrue((boolean)firstHumanTask.isActive());
        CaseExecution secondHumanTask = this.queryCaseExecutionByActivityId("PI_HumanTask_2");
        String secondHumanTaskId = secondHumanTask.getId();
        Assert.assertTrue((boolean)secondHumanTask.isActive());
        CaseExecution thirdHumanTask = this.queryCaseExecutionByActivityId("PI_HumanTask_3");
        String thirdHumanTaskId = thirdHumanTask.getId();
        Assert.assertTrue((boolean)thirdHumanTask.isActive());
        this.complete(firstHumanTaskId);
        thirdHumanTask = this.queryCaseExecutionById(thirdHumanTaskId);
        Assert.assertNull((Object)thirdHumanTask);
        Object exitVariable = this.caseService.getVariable(caseInstanceId, "exit");
        Assert.assertNotNull((Object)exitVariable);
        Assert.assertTrue((boolean)((Boolean)exitVariable));
        this.complete(secondHumanTaskId);
        thirdHumanTask = this.queryCaseExecutionById(thirdHumanTaskId);
        Assert.assertNull((Object)thirdHumanTask);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/cmmn/sentry/SentryExitCriteriaTest.testOrFork.cmmn"})
    @Test
    public void testOrFork() {
        this.createCaseInstance();
        CaseExecution firstHumanTask = this.queryCaseExecutionByActivityId("PI_HumanTask_1");
        String firstHumanTaskId = firstHumanTask.getId();
        Assert.assertTrue((boolean)firstHumanTask.isActive());
        CaseExecution secondHumanTask = this.queryCaseExecutionByActivityId("PI_HumanTask_2");
        String secondHumanTaskId = secondHumanTask.getId();
        Assert.assertTrue((boolean)secondHumanTask.isActive());
        CaseExecution thirdHumanTask = this.queryCaseExecutionByActivityId("PI_HumanTask_3");
        String thirdHumanTaskId = thirdHumanTask.getId();
        Assert.assertTrue((boolean)thirdHumanTask.isActive());
        this.caseService.withCaseExecution(firstHumanTaskId).setVariable("value", (Object)80).complete();
        secondHumanTask = this.queryCaseExecutionById(secondHumanTaskId);
        Assert.assertNotNull((Object)secondHumanTask);
        Assert.assertTrue((boolean)secondHumanTask.isActive());
        thirdHumanTask = this.queryCaseExecutionById(thirdHumanTaskId);
        Assert.assertNull((Object)thirdHumanTask);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/cmmn/sentry/SentryExitCriteriaTest.testCycle.cmmn"})
    @Test
    public void testCycle() {
        this.createCaseInstance();
        CaseExecution firstHumanTask = this.queryCaseExecutionByActivityId("PI_HumanTask_1");
        String firstHumanTaskId = firstHumanTask.getId();
        Assert.assertTrue((boolean)firstHumanTask.isActive());
        CaseExecution secondHumanTask = this.queryCaseExecutionByActivityId("PI_HumanTask_2");
        String secondHumanTaskId = secondHumanTask.getId();
        Assert.assertTrue((boolean)secondHumanTask.isActive());
        CaseExecution thirdHumanTask = this.queryCaseExecutionByActivityId("PI_HumanTask_3");
        String thirdHumanTaskId = thirdHumanTask.getId();
        Assert.assertTrue((boolean)thirdHumanTask.isActive());
        this.complete(firstHumanTaskId);
        firstHumanTask = this.queryCaseExecutionById(firstHumanTaskId);
        Assert.assertNull((Object)firstHumanTask);
        secondHumanTask = this.queryCaseExecutionById(secondHumanTaskId);
        Assert.assertNull((Object)secondHumanTask);
        thirdHumanTask = this.queryCaseExecutionById(thirdHumanTaskId);
        Assert.assertNull((Object)thirdHumanTask);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/cmmn/sentry/SentryExitCriteriaTest.testExitTaskWithIfPart.cmmn"})
    @Test
    public void testExitTaskWithIfPartSatisfied() {
        this.createCaseInstance();
        CaseExecution firstHumanTask = this.queryCaseExecutionByActivityId("PI_HumanTask_1");
        String firstHumanTaskId = firstHumanTask.getId();
        Assert.assertTrue((boolean)firstHumanTask.isActive());
        CaseExecution secondHumanTask = this.queryCaseExecutionByActivityId("PI_HumanTask_2");
        String secondHumanTaskId = secondHumanTask.getId();
        Assert.assertTrue((boolean)secondHumanTask.isActive());
        this.caseService.withCaseExecution(firstHumanTaskId).setVariable("value", (Object)100).complete();
        firstHumanTask = this.queryCaseExecutionById(firstHumanTaskId);
        Assert.assertNull((Object)firstHumanTask);
        secondHumanTask = this.queryCaseExecutionById(secondHumanTaskId);
        Assert.assertNull((Object)secondHumanTask);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/cmmn/sentry/SentryExitCriteriaTest.testExitTaskWithIfPart.cmmn"})
    @Test
    public void testExitTaskWithIfPartNotSatisfied() {
        this.createCaseInstance();
        CaseExecution firstHumanTask = this.queryCaseExecutionByActivityId("PI_HumanTask_1");
        String firstHumanTaskId = firstHumanTask.getId();
        Assert.assertTrue((boolean)firstHumanTask.isActive());
        CaseExecution secondHumanTask = this.queryCaseExecutionByActivityId("PI_HumanTask_2");
        String secondHumanTaskId = secondHumanTask.getId();
        Assert.assertTrue((boolean)secondHumanTask.isActive());
        this.caseService.withCaseExecution(firstHumanTaskId).setVariable("value", (Object)99).complete();
        firstHumanTask = this.queryCaseExecutionById(firstHumanTaskId);
        Assert.assertNull((Object)firstHumanTask);
        secondHumanTask = this.queryCaseExecutionById(secondHumanTaskId);
        Assert.assertTrue((boolean)secondHumanTask.isActive());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/cmmn/sentry/SentryExitCriteriaTest.testExitCriteriaOnCasePlanModel.cmmn"})
    @Test
    public void testExitCriteriaOnCasePlanModel() {
        String caseInstanceId = this.createCaseInstance().getId();
        CaseExecution firstHumanTask = this.queryCaseExecutionByActivityId("PI_HumanTask_1");
        String firstHumanTaskId = firstHumanTask.getId();
        Assert.assertTrue((boolean)firstHumanTask.isActive());
        this.complete(firstHumanTaskId);
        CaseExecution caseInstance = this.queryCaseExecutionById(caseInstanceId);
        Assert.assertTrue((boolean)caseInstance.isTerminated());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/cmmn/sentry/SentryExitCriteriaTest.testExitOnParentSuspendInsideStage.cmmn"})
    public void FAILING_testExitOnParentSuspendInsideStage() {
        this.createCaseInstance();
        CaseExecution stage = this.queryCaseExecutionByActivityId("PI_Stage_1");
        String stageId = stage.getId();
        this.manualStart(stageId);
        CaseExecution firstHumanTask = this.queryCaseExecutionByActivityId("PI_HumanTask_1");
        String firstHumanTaskId = firstHumanTask.getId();
        Assert.assertTrue((boolean)firstHumanTask.isEnabled());
        CaseExecution secondHumanTask = this.queryCaseExecutionByActivityId("PI_HumanTask_2");
        String secondHumanTaskId = secondHumanTask.getId();
        Assert.assertTrue((boolean)secondHumanTask.isEnabled());
        this.suspend(stageId);
        stage = this.queryCaseExecutionById(stageId);
        Assert.assertTrue((boolean)((CaseExecutionEntity)stage).isSuspended());
        firstHumanTask = this.queryCaseExecutionById(firstHumanTaskId);
        Assert.assertTrue((boolean)((CaseExecutionEntity)firstHumanTask).isSuspended());
        secondHumanTask = this.queryCaseExecutionById(secondHumanTaskId);
        Assert.assertNull((Object)secondHumanTask);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/cmmn/sentry/SentryExitCriteriaTest.testExitOnParentResumeInsideStage.cmmn"})
    public void FAILING_testExitOnParentResumeInsideStage() {
        this.createCaseInstance();
        CaseExecution stage = this.queryCaseExecutionByActivityId("PI_Stage_1");
        String stageId = stage.getId();
        this.manualStart(stageId);
        CaseExecution firstHumanTask = this.queryCaseExecutionByActivityId("PI_HumanTask_1");
        String firstHumanTaskId = firstHumanTask.getId();
        Assert.assertTrue((boolean)firstHumanTask.isEnabled());
        CaseExecution secondHumanTask = this.queryCaseExecutionByActivityId("PI_HumanTask_2");
        String secondHumanTaskId = secondHumanTask.getId();
        Assert.assertTrue((boolean)secondHumanTask.isEnabled());
        this.suspend(stageId);
        stage = this.queryCaseExecutionById(stageId);
        Assert.assertTrue((boolean)((CaseExecutionEntity)stage).isSuspended());
        firstHumanTask = this.queryCaseExecutionById(firstHumanTaskId);
        Assert.assertTrue((boolean)((CaseExecutionEntity)firstHumanTask).isSuspended());
        secondHumanTask = this.queryCaseExecutionById(secondHumanTaskId);
        Assert.assertTrue((boolean)((CaseExecutionEntity)secondHumanTask).isSuspended());
        this.resume(stageId);
        stage = this.queryCaseExecutionById(stageId);
        Assert.assertTrue((boolean)((CaseExecutionEntity)stage).isActive());
        firstHumanTask = this.queryCaseExecutionById(firstHumanTaskId);
        Assert.assertTrue((boolean)firstHumanTask.isEnabled());
        secondHumanTask = this.queryCaseExecutionById(secondHumanTaskId);
        Assert.assertNull((Object)secondHumanTask);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/cmmn/sentry/SentryExitCriteriaTest.testExitActiveTask.cmmn"})
    @Test
    public void testExitActiveTask() {
        this.createCaseInstance();
        CaseExecution firstHumanTask = this.queryCaseExecutionByActivityId("PI_HumanTask_1");
        String firstHumanTaskId = firstHumanTask.getId();
        Assert.assertTrue((boolean)firstHumanTask.isEnabled());
        CaseExecution secondHumanTask = this.queryCaseExecutionByActivityId("PI_HumanTask_2");
        String secondHumanTaskId = secondHumanTask.getId();
        Assert.assertTrue((boolean)secondHumanTask.isEnabled());
        this.manualStart(secondHumanTaskId);
        secondHumanTask = this.queryCaseExecutionById(secondHumanTaskId);
        Assert.assertTrue((boolean)secondHumanTask.isActive());
        Task secondTask = (Task)this.taskService.createTaskQuery().singleResult();
        Assert.assertNotNull((Object)secondTask);
        this.manualStart(firstHumanTaskId);
        firstHumanTask = this.queryCaseExecutionById(firstHumanTaskId);
        Assert.assertTrue((boolean)firstHumanTask.isActive());
        secondHumanTask = this.queryCaseExecutionById(secondHumanTaskId);
        Assert.assertNull((Object)secondHumanTask);
        secondTask = (Task)this.taskService.createTaskQuery().taskId(secondTask.getId()).singleResult();
        Assert.assertNull((Object)secondTask);
    }
}

