/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.batch.job;

import camundajar.impl.com.google.gson.JsonObject;
import java.util.List;
import org.camunda.bpm.engine.impl.batch.DeploymentMappingJsonConverter;
import org.camunda.bpm.engine.impl.batch.DeploymentMappings;
import org.camunda.bpm.engine.impl.batch.SetRetriesBatchConfiguration;
import org.camunda.bpm.engine.impl.json.JsonObjectConverter;
import org.camunda.bpm.engine.impl.util.JsonUtil;

public class SetJobRetriesBatchConfigurationJsonConverter
extends JsonObjectConverter<SetRetriesBatchConfiguration> {
    public static final SetJobRetriesBatchConfigurationJsonConverter INSTANCE = new SetJobRetriesBatchConfigurationJsonConverter();
    public static final String JOB_IDS = "jobIds";
    public static final String JOB_ID_MAPPINGS = "jobIdMappings";
    public static final String RETRIES = "retries";

    @Override
    public JsonObject toJsonObject(SetRetriesBatchConfiguration configuration) {
        JsonObject json = JsonUtil.createObject();
        JsonUtil.addListField(json, JOB_IDS, configuration.getIds());
        JsonUtil.addListField(json, JOB_ID_MAPPINGS, DeploymentMappingJsonConverter.INSTANCE, configuration.getIdMappings());
        JsonUtil.addField(json, RETRIES, configuration.getRetries());
        return json;
    }

    @Override
    public SetRetriesBatchConfiguration toObject(JsonObject json) {
        SetRetriesBatchConfiguration configuration = new SetRetriesBatchConfiguration(this.readJobIds(json), this.readIdMappings(json), JsonUtil.getInt(json, RETRIES));
        return configuration;
    }

    protected List<String> readJobIds(JsonObject jsonObject) {
        return JsonUtil.asStringList(JsonUtil.getArray(jsonObject, JOB_IDS));
    }

    protected DeploymentMappings readIdMappings(JsonObject jsonObject) {
        return JsonUtil.asList(JsonUtil.getArray(jsonObject, JOB_ID_MAPPINGS), DeploymentMappingJsonConverter.INSTANCE, DeploymentMappings::new);
    }
}

