/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.authorization.migration;

import java.util.Arrays;
import java.util.Collection;
import org.camunda.bpm.engine.authorization.Permission;
import org.camunda.bpm.engine.authorization.Permissions;
import org.camunda.bpm.engine.authorization.Resource;
import org.camunda.bpm.engine.authorization.Resources;
import org.camunda.bpm.engine.migration.MigrationPlan;
import org.camunda.bpm.engine.repository.ProcessDefinition;
import org.camunda.bpm.engine.runtime.ProcessInstance;
import org.camunda.bpm.engine.runtime.ProcessInstanceQuery;
import org.camunda.bpm.engine.test.Deployment;
import org.camunda.bpm.engine.test.ProcessEngineRule;
import org.camunda.bpm.engine.test.api.authorization.util.AuthorizationScenario;
import org.camunda.bpm.engine.test.api.authorization.util.AuthorizationSpec;
import org.camunda.bpm.engine.test.api.authorization.util.AuthorizationTestRule;
import org.camunda.bpm.engine.test.api.runtime.migration.ModifiableBpmnModelInstance;
import org.camunda.bpm.engine.test.api.runtime.migration.models.ProcessModels;
import org.camunda.bpm.engine.test.util.ProcessEngineTestRule;
import org.camunda.bpm.engine.test.util.ProvidedProcessEngineRule;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class MigrateProcessInstanceSyncTest {
    public ProcessEngineRule engineRule = new ProvidedProcessEngineRule();
    public AuthorizationTestRule authRule = new AuthorizationTestRule(this.engineRule);
    public ProcessEngineTestRule testHelper = new ProcessEngineTestRule(this.engineRule);
    @Rule
    public RuleChain chain = RuleChain.outerRule((TestRule)this.engineRule).around((TestRule)this.authRule).around((TestRule)this.testHelper);
    @Parameterized.Parameter
    public AuthorizationScenario scenario;

    @Parameterized.Parameters(name="Scenario {index}")
    public static Collection<AuthorizationScenario[]> scenarios() {
        return AuthorizationTestRule.asParameters(AuthorizationScenario.scenario().withAuthorizations(AuthorizationSpec.grant((Resource)Resources.PROCESS_INSTANCE, "processInstance", "userId", new Permission[]{Permissions.READ})).failsDueToRequired(AuthorizationSpec.grant((Resource)Resources.PROCESS_DEFINITION, "sourceDefinitionKey", "userId", new Permission[]{Permissions.MIGRATE_INSTANCE}), AuthorizationSpec.grant((Resource)Resources.PROCESS_DEFINITION, "targetDefinitionKey", "userId", new Permission[]{Permissions.MIGRATE_INSTANCE})), AuthorizationScenario.scenario().withAuthorizations(AuthorizationSpec.grant((Resource)Resources.PROCESS_INSTANCE, "processInstance", "userId", new Permission[]{Permissions.READ}), AuthorizationSpec.grant((Resource)Resources.PROCESS_DEFINITION, "sourceDefinitionKey", "userId", new Permission[]{Permissions.MIGRATE_INSTANCE})).failsDueToRequired(AuthorizationSpec.grant((Resource)Resources.PROCESS_DEFINITION, "sourceDefinitionKey", "userId", new Permission[]{Permissions.MIGRATE_INSTANCE}), AuthorizationSpec.grant((Resource)Resources.PROCESS_DEFINITION, "targetDefinitionKey", "userId", new Permission[]{Permissions.MIGRATE_INSTANCE})), AuthorizationScenario.scenario().withAuthorizations(AuthorizationSpec.grant((Resource)Resources.PROCESS_INSTANCE, "processInstance", "userId", new Permission[]{Permissions.READ}), AuthorizationSpec.grant((Resource)Resources.PROCESS_DEFINITION, "targetDefinitionKey", "userId", new Permission[]{Permissions.MIGRATE_INSTANCE})).failsDueToRequired(AuthorizationSpec.grant((Resource)Resources.PROCESS_DEFINITION, "sourceDefinitionKey", "userId", new Permission[]{Permissions.MIGRATE_INSTANCE}), AuthorizationSpec.grant((Resource)Resources.PROCESS_DEFINITION, "targetDefinitionKey", "userId", new Permission[]{Permissions.MIGRATE_INSTANCE})), AuthorizationScenario.scenario().withAuthorizations(AuthorizationSpec.grant((Resource)Resources.PROCESS_INSTANCE, "processInstance", "userId", new Permission[]{Permissions.READ}), AuthorizationSpec.grant((Resource)Resources.PROCESS_DEFINITION, "sourceDefinitionKey", "userId", new Permission[]{Permissions.MIGRATE_INSTANCE}), AuthorizationSpec.grant((Resource)Resources.PROCESS_DEFINITION, "targetDefinitionKey", "userId", new Permission[]{Permissions.MIGRATE_INSTANCE})).succeeds(), AuthorizationScenario.scenario().withAuthorizations(AuthorizationSpec.grant((Resource)Resources.PROCESS_INSTANCE, "processInstance", "userId", new Permission[]{Permissions.READ}), AuthorizationSpec.grant((Resource)Resources.PROCESS_DEFINITION, "*", "userId", new Permission[]{Permissions.MIGRATE_INSTANCE})).succeeds());
    }

    @Before
    public void setUp() {
        this.authRule.createUserAndGroup("userId", "groupId");
    }

    @After
    public void tearDown() {
        this.authRule.deleteUsersAndGroups();
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/api/authorization/oneIncidentProcess.bpmn20.xml"})
    public void testMigrate() {
        ProcessDefinition sourceDefinition = this.testHelper.deployAndGetDefinition(ProcessModels.ONE_TASK_PROCESS);
        ProcessDefinition targetDefinition = this.testHelper.deployAndGetDefinition(ModifiableBpmnModelInstance.modify(ProcessModels.ONE_TASK_PROCESS).changeElementId("Process", "newProcess"));
        ProcessInstance processInstance = this.engineRule.getRuntimeService().startProcessInstanceById(sourceDefinition.getId());
        MigrationPlan migrationPlan = this.engineRule.getRuntimeService().createMigrationPlan(sourceDefinition.getId(), targetDefinition.getId()).mapEqualActivities().build();
        this.authRule.init(this.scenario).withUser("userId").bindResource("sourceDefinitionKey", sourceDefinition.getKey()).bindResource("targetDefinitionKey", targetDefinition.getKey()).bindResource("processInstance", processInstance.getId()).start();
        this.engineRule.getRuntimeService().newMigration(migrationPlan).processInstanceIds(Arrays.asList(processInstance.getId())).execute();
        if (this.authRule.assertScenario(this.scenario)) {
            ProcessInstance processInstanceAfterMigration = (ProcessInstance)this.engineRule.getRuntimeService().createProcessInstanceQuery().singleResult();
            Assert.assertEquals((Object)targetDefinition.getId(), (Object)processInstanceAfterMigration.getProcessDefinitionId());
        }
    }

    @Test
    public void testMigrateWithQuery() {
        ProcessDefinition sourceDefinition = this.testHelper.deployAndGetDefinition(ProcessModels.ONE_TASK_PROCESS);
        ProcessDefinition targetDefinition = this.testHelper.deployAndGetDefinition(ModifiableBpmnModelInstance.modify(ProcessModels.ONE_TASK_PROCESS).changeElementId("Process", "newProcess"));
        ProcessInstance processInstance = this.engineRule.getRuntimeService().startProcessInstanceById(sourceDefinition.getId());
        MigrationPlan migrationPlan = this.engineRule.getRuntimeService().createMigrationPlan(sourceDefinition.getId(), targetDefinition.getId()).mapEqualActivities().build();
        ProcessInstanceQuery query = this.engineRule.getRuntimeService().createProcessInstanceQuery();
        this.authRule.init(this.scenario).withUser("userId").bindResource("sourceDefinitionKey", sourceDefinition.getKey()).bindResource("targetDefinitionKey", targetDefinition.getKey()).bindResource("processInstance", processInstance.getId()).start();
        this.engineRule.getRuntimeService().newMigration(migrationPlan).processInstanceQuery(query).execute();
        if (this.authRule.assertScenario(this.scenario)) {
            ProcessInstance processInstanceAfterMigration = (ProcessInstance)this.engineRule.getRuntimeService().createProcessInstanceQuery().singleResult();
            Assert.assertEquals((Object)targetDefinition.getId(), (Object)processInstanceAfterMigration.getProcessDefinitionId());
        }
    }
}

