/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.identity;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.camunda.bpm.engine.authorization.Authorization;
import org.camunda.bpm.engine.authorization.Permission;
import org.camunda.bpm.engine.authorization.Resource;
import org.camunda.bpm.engine.exception.NullValueException;
import org.camunda.bpm.engine.identity.User;
import org.camunda.bpm.engine.test.api.identity.TestPermissions;
import org.camunda.bpm.engine.test.api.identity.TestResource;
import org.camunda.bpm.engine.test.util.PluggableProcessEngineTest;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class AuthorizationServiceWithEnabledAuthorizationTest
extends PluggableProcessEngineTest {
    @Before
    public void setUp() throws Exception {
        this.processEngineConfiguration.setAuthorizationEnabled(true);
    }

    @After
    public void tearDown() throws Exception {
        this.processEngineConfiguration.setAuthorizationEnabled(false);
        this.cleanupAfterTest();
    }

    @Test
    public void testAuthorizationCheckEmptyDb() {
        TestResource resource1 = TestResource.RESOURCE1;
        TestResource resource2 = TestResource.RESOURCE2;
        List<String> jonnysGroups = Arrays.asList("sales", "marketing");
        List<String> someOneElsesGroups = Collections.singletonList("marketing");
        Assert.assertFalse((boolean)this.authorizationService.isUserAuthorized("jonny", jonnysGroups, (Permission)TestPermissions.ALL, (Resource)resource1));
        Assert.assertFalse((boolean)this.authorizationService.isUserAuthorized("someone", someOneElsesGroups, (Permission)TestPermissions.CREATE, (Resource)resource2));
        Assert.assertFalse((boolean)this.authorizationService.isUserAuthorized("someone else", null, (Permission)TestPermissions.DELETE, (Resource)resource1));
        Assert.assertFalse((boolean)this.authorizationService.isUserAuthorized("jonny", jonnysGroups, (Permission)TestPermissions.ALL, (Resource)resource1, "someId"));
        Assert.assertFalse((boolean)this.authorizationService.isUserAuthorized("someone", someOneElsesGroups, (Permission)TestPermissions.CREATE, (Resource)resource2, "someId"));
        Assert.assertFalse((boolean)this.authorizationService.isUserAuthorized("someone else", null, (Permission)TestPermissions.DELETE, (Resource)resource1, "someOtherId"));
    }

    @Test
    public void testUserOverrideGlobalGrantAuthorizationCheck() {
        TestResource resource1 = TestResource.RESOURCE1;
        Authorization globalGrant = this.authorizationService.createNewAuthorization(0);
        globalGrant.setResource((Resource)resource1);
        globalGrant.setResourceId("*");
        globalGrant.addPermission((Permission)TestPermissions.ALL);
        this.authorizationService.saveAuthorization(globalGrant);
        Authorization localRevoke = this.authorizationService.createNewAuthorization(2);
        localRevoke.setUserId("jonny");
        localRevoke.setResource((Resource)resource1);
        localRevoke.setResourceId("*");
        localRevoke.removePermission((Permission)TestPermissions.READ);
        this.authorizationService.saveAuthorization(localRevoke);
        List<String> jonnysGroups = Arrays.asList("sales", "marketing");
        List<String> someOneElsesGroups = Collections.singletonList("marketing");
        Assert.assertFalse((boolean)this.authorizationService.isUserAuthorized("jonny", null, (Permission)TestPermissions.ALL, (Resource)resource1));
        Assert.assertFalse((boolean)this.authorizationService.isUserAuthorized("jonny", jonnysGroups, (Permission)TestPermissions.ALL, (Resource)resource1));
        Assert.assertFalse((boolean)this.authorizationService.isUserAuthorized("jonny", null, (Permission)TestPermissions.READ, (Resource)resource1));
        Assert.assertFalse((boolean)this.authorizationService.isUserAuthorized("jonny", jonnysGroups, (Permission)TestPermissions.READ, (Resource)resource1));
        Assert.assertTrue((boolean)this.authorizationService.isUserAuthorized("someone else", null, (Permission)TestPermissions.ALL, (Resource)resource1));
        Assert.assertTrue((boolean)this.authorizationService.isUserAuthorized("someone else", someOneElsesGroups, (Permission)TestPermissions.READ, (Resource)resource1));
        Assert.assertTrue((boolean)this.authorizationService.isUserAuthorized("someone else", null, (Permission)TestPermissions.ALL, (Resource)resource1));
        Assert.assertTrue((boolean)this.authorizationService.isUserAuthorized("someone else", someOneElsesGroups, (Permission)TestPermissions.READ, (Resource)resource1));
        Assert.assertTrue((boolean)this.authorizationService.isUserAuthorized("jonny", null, (Permission)TestPermissions.DELETE, (Resource)resource1));
        Assert.assertTrue((boolean)this.authorizationService.isUserAuthorized("jonny", jonnysGroups, (Permission)TestPermissions.DELETE, (Resource)resource1));
    }

    @Test
    public void testGroupOverrideGlobalGrantAuthorizationCheck() {
        TestResource resource1 = TestResource.RESOURCE1;
        Authorization globalGrant = this.authorizationService.createNewAuthorization(0);
        globalGrant.setResource((Resource)resource1);
        globalGrant.setResourceId("*");
        globalGrant.addPermission((Permission)TestPermissions.ALL);
        this.authorizationService.saveAuthorization(globalGrant);
        Authorization groupRevoke = this.authorizationService.createNewAuthorization(2);
        groupRevoke.setGroupId("sales");
        groupRevoke.setResource((Resource)resource1);
        groupRevoke.setResourceId("*");
        groupRevoke.removePermission((Permission)TestPermissions.READ);
        this.authorizationService.saveAuthorization(groupRevoke);
        List<String> jonnysGroups = Arrays.asList("sales", "marketing");
        List<String> someOneElsesGroups = Collections.singletonList("marketing");
        Assert.assertFalse((boolean)this.authorizationService.isUserAuthorized("jonny", jonnysGroups, (Permission)TestPermissions.ALL, (Resource)resource1));
        Assert.assertTrue((boolean)this.authorizationService.isUserAuthorized("jonny", null, (Permission)TestPermissions.ALL, (Resource)resource1));
        Assert.assertFalse((boolean)this.authorizationService.isUserAuthorized("jonny", jonnysGroups, (Permission)TestPermissions.READ, (Resource)resource1));
        Assert.assertTrue((boolean)this.authorizationService.isUserAuthorized("jonny", null, (Permission)TestPermissions.READ, (Resource)resource1));
        Assert.assertTrue((boolean)this.authorizationService.isUserAuthorized("someone else", someOneElsesGroups, (Permission)TestPermissions.ALL, (Resource)resource1));
        Assert.assertTrue((boolean)this.authorizationService.isUserAuthorized("someone else", someOneElsesGroups, (Permission)TestPermissions.READ, (Resource)resource1));
        Assert.assertTrue((boolean)this.authorizationService.isUserAuthorized("someone else", null, (Permission)TestPermissions.ALL, (Resource)resource1));
        Assert.assertTrue((boolean)this.authorizationService.isUserAuthorized("someone else", null, (Permission)TestPermissions.READ, (Resource)resource1));
        Assert.assertFalse((boolean)this.authorizationService.isUserAuthorized("someone else", jonnysGroups, (Permission)TestPermissions.ALL, (Resource)resource1));
        Assert.assertFalse((boolean)this.authorizationService.isUserAuthorized("someone else", jonnysGroups, (Permission)TestPermissions.READ, (Resource)resource1));
        Assert.assertTrue((boolean)this.authorizationService.isUserAuthorized("jonny", jonnysGroups, (Permission)TestPermissions.DELETE, (Resource)resource1));
        Assert.assertTrue((boolean)this.authorizationService.isUserAuthorized("jonny", null, (Permission)TestPermissions.DELETE, (Resource)resource1));
    }

    @Test
    public void testUserOverrideGlobalRevokeAuthorizationCheck() {
        TestResource resource1 = TestResource.RESOURCE1;
        Authorization globalGrant = this.authorizationService.createNewAuthorization(0);
        globalGrant.setResource((Resource)resource1);
        globalGrant.setResourceId("*");
        globalGrant.removePermission((Permission)TestPermissions.ALL);
        this.authorizationService.saveAuthorization(globalGrant);
        Authorization localRevoke = this.authorizationService.createNewAuthorization(1);
        localRevoke.setUserId("jonny");
        localRevoke.setResource((Resource)resource1);
        localRevoke.setResourceId("*");
        localRevoke.addPermission((Permission)TestPermissions.READ);
        this.authorizationService.saveAuthorization(localRevoke);
        Assert.assertFalse((boolean)this.authorizationService.isUserAuthorized("jonny", null, (Permission)TestPermissions.ALL, (Resource)resource1));
        Assert.assertTrue((boolean)this.authorizationService.isUserAuthorized("jonny", null, (Permission)TestPermissions.READ, (Resource)resource1));
        Assert.assertFalse((boolean)this.authorizationService.isUserAuthorized("jonny", null, (Permission)TestPermissions.DELETE, (Resource)resource1));
        Assert.assertFalse((boolean)this.authorizationService.isUserAuthorized("someone else", null, (Permission)TestPermissions.ALL, (Resource)resource1));
        Assert.assertFalse((boolean)this.authorizationService.isUserAuthorized("someone else", null, (Permission)TestPermissions.READ, (Resource)resource1));
        Assert.assertFalse((boolean)this.authorizationService.isUserAuthorized("someone else", null, (Permission)TestPermissions.DELETE, (Resource)resource1));
    }

    @Test
    public void testNullAuthorizationCheckUserGroup() {
        try {
            this.authorizationService.isUserAuthorized(null, null, (Permission)TestPermissions.UPDATE, (Resource)TestResource.RESOURCE1);
            Assert.fail((String)"Expected NullValueException");
        }
        catch (NullValueException e) {
            Assert.assertTrue((boolean)e.getMessage().contains("Authorization must have a 'userId' or/and a 'groupId'"));
        }
    }

    @Test
    public void testNullAuthorizationCheckPermission() {
        try {
            this.authorizationService.isUserAuthorized("jonny", null, null, (Resource)TestResource.RESOURCE1);
            Assert.fail((String)"Expected NullValueException");
        }
        catch (NullValueException e) {
            Assert.assertTrue((boolean)e.getMessage().contains("Invalid permission for an authorization"));
        }
    }

    @Test
    public void testNullAuthorizationCheckResource() {
        try {
            this.authorizationService.isUserAuthorized("jonny", null, (Permission)TestPermissions.UPDATE, null);
            Assert.fail((String)"Expected NullValueException");
        }
        catch (NullValueException e) {
            Assert.assertTrue((boolean)e.getMessage().contains("Invalid resource for an authorization"));
        }
    }

    @Test
    public void testUserOverrideGroupOverrideGlobalAuthorizationCheck() {
        TestResource resource1 = TestResource.RESOURCE1;
        Authorization globalGrant = this.authorizationService.createNewAuthorization(0);
        globalGrant.setResource((Resource)resource1);
        globalGrant.setResourceId("*");
        globalGrant.addPermission((Permission)TestPermissions.ALL);
        this.authorizationService.saveAuthorization(globalGrant);
        Authorization groupRevoke = this.authorizationService.createNewAuthorization(2);
        groupRevoke.setGroupId("sales");
        groupRevoke.setResource((Resource)resource1);
        groupRevoke.setResourceId("*");
        groupRevoke.removePermission((Permission)TestPermissions.READ);
        this.authorizationService.saveAuthorization(groupRevoke);
        Authorization userGrant = this.authorizationService.createNewAuthorization(1);
        userGrant.setUserId("jonny");
        userGrant.setResource((Resource)resource1);
        userGrant.setResourceId("*");
        userGrant.addPermission((Permission)TestPermissions.READ);
        this.authorizationService.saveAuthorization(userGrant);
        List<String> jonnysGroups = Arrays.asList("sales", "marketing");
        List<String> someOneElsesGroups = Collections.singletonList("marketing");
        Assert.assertTrue((boolean)this.authorizationService.isUserAuthorized("jonny", jonnysGroups, (Permission)TestPermissions.READ, (Resource)resource1));
        Assert.assertTrue((boolean)this.authorizationService.isUserAuthorized("jonny", null, (Permission)TestPermissions.READ, (Resource)resource1));
        Assert.assertFalse((boolean)this.authorizationService.isUserAuthorized("someone else", jonnysGroups, (Permission)TestPermissions.READ, (Resource)resource1));
        Assert.assertTrue((boolean)this.authorizationService.isUserAuthorized("someone else", someOneElsesGroups, (Permission)TestPermissions.READ, (Resource)resource1));
    }

    @Test
    public void testEnabledAuthorizationCheck() {
        TestResource resource1 = TestResource.RESOURCE1;
        boolean isAuthorized = this.authorizationService.isUserAuthorized("jonny", null, (Permission)TestPermissions.UPDATE, (Resource)resource1);
        Assert.assertFalse((boolean)isAuthorized);
    }

    protected void cleanupAfterTest() {
        for (User user : this.identityService.createUserQuery().list()) {
            this.identityService.deleteUser(user.getId());
        }
        for (Authorization authorization : this.authorizationService.createAuthorizationQuery().list()) {
            this.authorizationService.deleteAuthorization(authorization.getId());
        }
    }
}

