/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.identity;

import java.util.List;
import org.assertj.core.api.Assertions;
import org.camunda.bpm.engine.IdentityService;
import org.camunda.bpm.engine.identity.Group;
import org.camunda.bpm.engine.identity.Tenant;
import org.camunda.bpm.engine.identity.TenantQuery;
import org.camunda.bpm.engine.identity.User;
import org.camunda.bpm.engine.test.ProcessEngineRule;
import org.camunda.bpm.engine.test.util.ProvidedProcessEngineRule;
import org.junit.After;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;

public class TenantQueryTest {
    protected static final String TENANT_ONE = "tenant1";
    protected static final String TENANT_TWO = "tenant2";
    protected static final String USER = "user";
    protected static final String GROUP = "group";
    @Rule
    public ProcessEngineRule engineRule = new ProvidedProcessEngineRule();
    protected IdentityService identityService;

    @Before
    public void setUp() {
        this.identityService = this.engineRule.getIdentityService();
        this.createTenant(TENANT_ONE, "Tenant_1");
        this.createTenant(TENANT_TWO, "Tenant_2");
        User user = this.identityService.newUser(USER);
        this.identityService.saveUser(user);
        Group group = this.identityService.newGroup(GROUP);
        this.identityService.saveGroup(group);
        this.identityService.createMembership(USER, GROUP);
        this.identityService.createTenantUserMembership(TENANT_ONE, USER);
        this.identityService.createTenantGroupMembership(TENANT_TWO, GROUP);
    }

    @Test
    public void queryById() {
        TenantQuery query = this.identityService.createTenantQuery().tenantId(TENANT_ONE);
        Assertions.assertThat((long)query.count()).isEqualTo(1L);
        Assertions.assertThat((List)query.list()).hasSize(1);
        Tenant tenant = (Tenant)query.singleResult();
        Assertions.assertThat((Object)tenant).isNotNull();
        Assertions.assertThat((String)tenant.getName()).isEqualTo((Object)"Tenant_1");
    }

    @Test
    public void queryByNonExistingId() {
        TenantQuery query = this.identityService.createTenantQuery().tenantId("nonExisting");
        Assertions.assertThat((long)query.count()).isEqualTo(0L);
    }

    @Test
    public void queryByIdIn() {
        TenantQuery query = this.identityService.createTenantQuery();
        Assertions.assertThat((long)query.tenantIdIn(new String[]{"non", "existing"}).count()).isEqualTo(0L);
        Assertions.assertThat((long)query.tenantIdIn(new String[]{TENANT_ONE, TENANT_TWO}).count()).isEqualTo(2L);
    }

    @Test
    public void queryByName() {
        TenantQuery query = this.identityService.createTenantQuery();
        Assertions.assertThat((long)query.tenantName("nonExisting").count()).isEqualTo(0L);
        Assertions.assertThat((long)query.tenantName("Tenant_1").count()).isEqualTo(1L);
        Assertions.assertThat((long)query.tenantName("Tenant_2").count()).isEqualTo(1L);
    }

    @Test
    public void queryByNameLike() {
        TenantQuery query = this.identityService.createTenantQuery();
        Assertions.assertThat((long)query.tenantNameLike("%nonExisting%").count()).isEqualTo(0L);
        Assertions.assertThat((long)query.tenantNameLike("%Tenant\\_1%").count()).isEqualTo(1L);
        Assertions.assertThat((long)query.tenantNameLike("%Tenant%").count()).isEqualTo(2L);
    }

    @Test
    public void queryByUser() {
        TenantQuery query = this.identityService.createTenantQuery();
        Assertions.assertThat((long)query.userMember("nonExisting").count()).isEqualTo(0L);
        Assertions.assertThat((long)query.userMember(USER).count()).isEqualTo(1L);
        Assertions.assertThat((long)query.userMember(USER).tenantId(TENANT_ONE).count()).isEqualTo(1L);
    }

    @Test
    public void queryByGroup() {
        TenantQuery query = this.identityService.createTenantQuery();
        Assertions.assertThat((long)query.groupMember("nonExisting").count()).isEqualTo(0L);
        Assertions.assertThat((long)query.groupMember(GROUP).count()).isEqualTo(1L);
        Assertions.assertThat((long)query.groupMember(GROUP).tenantId(TENANT_TWO).count()).isEqualTo(1L);
    }

    @Test
    public void queryByUserIncludingGroups() {
        TenantQuery query = this.identityService.createTenantQuery().userMember(USER);
        Assertions.assertThat((long)query.includingGroupsOfUser(false).count()).isEqualTo(1L);
        Assertions.assertThat((long)query.includingGroupsOfUser(true).count()).isEqualTo(2L);
    }

    @Test
    public void queryOrderById() {
        List tenants = ((TenantQuery)this.identityService.createTenantQuery().orderByTenantId().asc()).list();
        Assertions.assertThat((int)tenants.size()).isEqualTo(2);
        Assertions.assertThat((String)((Tenant)tenants.get(0)).getId()).isEqualTo((Object)TENANT_ONE);
        Assertions.assertThat((String)((Tenant)tenants.get(1)).getId()).isEqualTo((Object)TENANT_TWO);
        tenants = ((TenantQuery)this.identityService.createTenantQuery().orderByTenantId().desc()).list();
        Assertions.assertThat((String)((Tenant)tenants.get(0)).getId()).isEqualTo((Object)TENANT_TWO);
        Assertions.assertThat((String)((Tenant)tenants.get(1)).getId()).isEqualTo((Object)TENANT_ONE);
    }

    @Test
    public void queryOrderByName() {
        List tenants = ((TenantQuery)this.identityService.createTenantQuery().orderByTenantName().asc()).list();
        Assertions.assertThat((int)tenants.size()).isEqualTo(2);
        Assertions.assertThat((String)((Tenant)tenants.get(0)).getName()).isEqualTo((Object)"Tenant_1");
        Assertions.assertThat((String)((Tenant)tenants.get(1)).getName()).isEqualTo((Object)"Tenant_2");
        tenants = ((TenantQuery)this.identityService.createTenantQuery().orderByTenantName().desc()).list();
        Assertions.assertThat((String)((Tenant)tenants.get(0)).getName()).isEqualTo((Object)"Tenant_2");
        Assertions.assertThat((String)((Tenant)tenants.get(1)).getName()).isEqualTo((Object)"Tenant_1");
    }

    protected Tenant createTenant(String id, String name) {
        Tenant tenant = this.engineRule.getIdentityService().newTenant(id);
        tenant.setName(name);
        this.identityService.saveTenant(tenant);
        return tenant;
    }

    @After
    public void tearDown() throws Exception {
        this.identityService.deleteTenant(TENANT_ONE);
        this.identityService.deleteTenant(TENANT_TWO);
        this.identityService.deleteUser(USER);
        this.identityService.deleteGroup(GROUP);
    }
}

