/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.mgmt.telemetry;

import com.github.tomakehurst.wiremock.WireMockServer;
import com.github.tomakehurst.wiremock.client.UrlMatchingStrategy;
import com.github.tomakehurst.wiremock.client.WireMock;
import com.github.tomakehurst.wiremock.core.Options;
import com.github.tomakehurst.wiremock.core.WireMockConfiguration;
import org.assertj.core.api.Assertions;
import org.camunda.bpm.engine.ProcessEngine;
import org.camunda.bpm.engine.impl.ProcessEngineImpl;
import org.camunda.bpm.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.camunda.bpm.engine.impl.telemetry.dto.LicenseKeyData;
import org.camunda.bpm.engine.impl.telemetry.reporter.TelemetryReporter;
import org.camunda.bpm.engine.test.util.NoInitMessageInMemProcessEngineConfiguration;
import org.camunda.commons.testing.ProcessEngineLoggingRule;
import org.camunda.commons.testing.WatchLogger;
import org.junit.After;
import org.junit.Rule;
import org.junit.Test;

public class TelemetryConfigurationTest {
    protected static final String TELEMETRY_ENDPOINT = "http://localhost:8086/pings";
    @Rule
    public ProcessEngineLoggingRule loggingRule = new ProcessEngineLoggingRule();
    protected ProcessEngineConfigurationImpl inMemoryConfiguration;
    WireMockServer wireMockServer;

    @After
    public void reset() {
        if (this.inMemoryConfiguration != null) {
            if (Boolean.TRUE.equals(this.inMemoryConfiguration.getManagementService().isTelemetryEnabled())) {
                this.inMemoryConfiguration.getManagementService().toggleTelemetry(false);
            }
            ProcessEngineImpl processEngineImpl = this.inMemoryConfiguration.getProcessEngine();
            processEngineImpl.close();
            Object var1_1 = null;
        }
        if (this.wireMockServer != null) {
            this.wireMockServer.stop();
        }
    }

    @Test
    public void shouldStartEngineWithTelemetryDefaults() {
        this.inMemoryConfiguration = new NoInitMessageInMemProcessEngineConfiguration();
        this.inMemoryConfiguration.setJdbcUrl("jdbc:h2:mem:camunda" + this.getClass().getSimpleName());
        this.inMemoryConfiguration.buildProcessEngine();
        Assertions.assertThat((Boolean)this.inMemoryConfiguration.isInitializeTelemetry()).isNull();
        Assertions.assertThat((Boolean)this.inMemoryConfiguration.getManagementService().isTelemetryEnabled()).isNull();
        Assertions.assertThat((boolean)this.inMemoryConfiguration.getTelemetryRegistry().isCollectingTelemetryDataEnabled()).isFalse();
        Assertions.assertThat((boolean)this.inMemoryConfiguration.getMetricsRegistry().isCollectingTelemetryMetrics()).isFalse();
        Assertions.assertThat((boolean)this.inMemoryConfiguration.isTelemetryReporterActivate()).isTrue();
        Assertions.assertThat((boolean)this.inMemoryConfiguration.getTelemetryReporter().isScheduled()).isTrue();
        Assertions.assertThat((long)this.inMemoryConfiguration.getTelemetryReporter().getInitialReportingDelaySeconds()).isEqualTo(TelemetryReporter.EXTENDED_INIT_REPORT_DELAY_SECONDS);
    }

    @Test
    public void shouldStartEngineWithTelemetryDisabled() {
        this.inMemoryConfiguration = new NoInitMessageInMemProcessEngineConfiguration();
        this.inMemoryConfiguration.setJdbcUrl("jdbc:h2:mem:camunda" + this.getClass().getSimpleName()).setInitializeTelemetry(false);
        this.inMemoryConfiguration.buildProcessEngine();
        Assertions.assertThat((Boolean)this.inMemoryConfiguration.isInitializeTelemetry()).isFalse();
        Assertions.assertThat((Boolean)this.inMemoryConfiguration.getManagementService().isTelemetryEnabled()).isFalse();
        Assertions.assertThat((boolean)this.inMemoryConfiguration.getTelemetryRegistry().isCollectingTelemetryDataEnabled()).isFalse();
        Assertions.assertThat((boolean)this.inMemoryConfiguration.getMetricsRegistry().isCollectingTelemetryMetrics()).isFalse();
        Assertions.assertThat((boolean)this.inMemoryConfiguration.isTelemetryReporterActivate()).isTrue();
        Assertions.assertThat((boolean)this.inMemoryConfiguration.getTelemetryReporter().isScheduled()).isTrue();
        Assertions.assertThat((long)this.inMemoryConfiguration.getTelemetryReporter().getInitialReportingDelaySeconds()).isEqualTo(TelemetryReporter.DEFAULT_INIT_REPORT_DELAY_SECONDS);
    }

    @Test
    public void shouldStartEngineWithTelemetryEnabled() {
        this.inMemoryConfiguration = new NoInitMessageInMemProcessEngineConfiguration();
        this.inMemoryConfiguration.setJdbcUrl("jdbc:h2:mem:camunda" + this.getClass().getSimpleName()).setTelemetryEndpoint(TELEMETRY_ENDPOINT).setInitializeTelemetry(true);
        this.inMemoryConfiguration.buildProcessEngine();
        Assertions.assertThat((Boolean)this.inMemoryConfiguration.isInitializeTelemetry()).isTrue();
        Assertions.assertThat((Boolean)this.inMemoryConfiguration.getManagementService().isTelemetryEnabled()).isTrue();
        Assertions.assertThat((boolean)this.inMemoryConfiguration.getTelemetryRegistry().isCollectingTelemetryDataEnabled()).isTrue();
        Assertions.assertThat((boolean)this.inMemoryConfiguration.getMetricsRegistry().isCollectingTelemetryMetrics()).isTrue();
        Assertions.assertThat((long)this.inMemoryConfiguration.getTelemetryReporter().getInitialReportingDelaySeconds()).isEqualTo(TelemetryReporter.DEFAULT_INIT_REPORT_DELAY_SECONDS);
    }

    @Test
    public void shouldStartEngineWithChangedTelemetryEndpoint() {
        this.inMemoryConfiguration = new NoInitMessageInMemProcessEngineConfiguration();
        this.inMemoryConfiguration.setJdbcUrl("jdbc:h2:mem:camunda" + this.getClass().getSimpleName()).setTelemetryEndpoint(TELEMETRY_ENDPOINT);
        this.inMemoryConfiguration.buildProcessEngine();
        Assertions.assertThat((String)this.inMemoryConfiguration.getTelemetryEndpoint()).isEqualTo((Object)TELEMETRY_ENDPOINT);
    }

    @Test
    public void shouldStartEngineWithTelemetryEnabledAndLicenseKeyAlreadyPresent() {
        String testLicenseKey = "signature=;my company;unlimited";
        this.inMemoryConfiguration = new NoInitMessageInMemProcessEngineConfiguration();
        this.inMemoryConfiguration.setJdbcUrl("jdbc:h2:mem:camunda-test" + this.getClass().getSimpleName()).setDatabaseSchemaUpdate("create").setInitializeTelemetry(false).setDbMetricsReporterActivate(false);
        ProcessEngine processEngine = this.inMemoryConfiguration.buildProcessEngine();
        processEngine.getManagementService().setLicenseKey(testLicenseKey);
        processEngine.close();
        this.inMemoryConfiguration.setInitializeTelemetry(true).setTelemetryEndpoint(TELEMETRY_ENDPOINT);
        this.inMemoryConfiguration.buildProcessEngine();
        Assertions.assertThat((Object)this.inMemoryConfiguration.getTelemetryRegistry().getLicenseKey()).isEqualToComparingFieldByField((Object)new LicenseKeyData(null, null, null, null, null, "my company;unlimited"));
        this.inMemoryConfiguration.setDatabaseSchemaUpdate("create-drop");
    }

    @Test
    @WatchLogger(loggerNames={"org.camunda.bpm.engine.persistence"}, level="DEBUG")
    public void shouldLogDefaultTelemetryValue() {
        Object telemetryInitializedValue = null;
        this.inMemoryConfiguration = new NoInitMessageInMemProcessEngineConfiguration();
        this.inMemoryConfiguration.setJdbcUrl("jdbc:h2:mem:camunda" + this.getClass().getSimpleName());
        this.inMemoryConfiguration.buildProcessEngine();
        Assertions.assertThat((int)this.loggingRule.getFilteredLog("Creating the telemetry property in database with the value: " + telemetryInitializedValue).size()).isOne();
    }

    @Test
    @WatchLogger(loggerNames={"org.camunda.bpm.engine.persistence"}, level="DEBUG")
    public void shouldLogTelemetryPersistenceLog() {
        boolean telemetryInitialized = true;
        this.inMemoryConfiguration = new NoInitMessageInMemProcessEngineConfiguration();
        this.inMemoryConfiguration.setInitializeTelemetry(telemetryInitialized).setJdbcUrl("jdbc:h2:mem:camunda" + this.getClass().getSimpleName());
        this.inMemoryConfiguration.buildProcessEngine();
        Assertions.assertThat((int)this.loggingRule.getFilteredLog("No telemetry property found in the database").size()).isOne();
        Assertions.assertThat((int)this.loggingRule.getFilteredLog("Creating the telemetry property in database with the value: " + telemetryInitialized).size()).isOne();
    }

    @Test
    @WatchLogger(loggerNames={"org.camunda.bpm.engine.telemetry"}, level="INFO")
    public void shouldThrowAnException() {
        this.wireMockServer = new WireMockServer((Options)WireMockConfiguration.wireMockConfig().port(8085));
        this.wireMockServer.start();
        this.inMemoryConfiguration = new NoInitMessageInMemProcessEngineConfiguration();
        this.inMemoryConfiguration.setJdbcUrl("jdbc:h2:mem:camunda" + this.getClass().getSimpleName()).setInitializeTelemetry(true).setTelemetryRequestRetries(0).setTelemetryRequestTimeout(1).setTelemetryEndpoint(TELEMETRY_ENDPOINT);
        this.inMemoryConfiguration.buildProcessEngine();
        this.wireMockServer.stubFor(WireMock.post((UrlMatchingStrategy)WireMock.urlEqualTo((String)"/pings")).willReturn(WireMock.aResponse().withStatus(202)));
        this.inMemoryConfiguration.getTelemetryReporter().reportNow();
        Assertions.assertThat((int)this.loggingRule.getFilteredLog("Could not send telemetry data. Reason: ConnectorRequestException with message 'HTCL-02007 Unable to execute HTTP request'").size()).isOne();
    }
}

