/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.multitenancy.suspensionstate;

import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import org.assertj.core.api.Assertions;
import org.camunda.bpm.engine.impl.interceptor.Command;
import org.camunda.bpm.engine.impl.interceptor.CommandContext;
import org.camunda.bpm.engine.impl.interceptor.CommandExecutor;
import org.camunda.bpm.engine.management.JobDefinition;
import org.camunda.bpm.engine.management.JobDefinitionQuery;
import org.camunda.bpm.engine.repository.ProcessDefinition;
import org.camunda.bpm.engine.runtime.Job;
import org.camunda.bpm.engine.runtime.JobQuery;
import org.camunda.bpm.engine.test.ProcessEngineRule;
import org.camunda.bpm.engine.test.util.ProcessEngineTestRule;
import org.camunda.bpm.engine.test.util.ProvidedProcessEngineRule;
import org.camunda.bpm.model.bpmn.Bpmn;
import org.camunda.bpm.model.bpmn.BpmnModelInstance;
import org.camunda.bpm.model.bpmn.builder.UserTaskBuilder;
import org.junit.After;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;

public class MultiTenancyJobDefinitionSuspensionStateTest {
    protected static final String TENANT_ONE = "tenant1";
    protected static final String TENANT_TWO = "tenant2";
    protected static final String PROCESS_DEFINITION_KEY = "testProcess";
    protected static final BpmnModelInstance PROCESS = ((UserTaskBuilder)Bpmn.createExecutableProcess((String)"testProcess").startEvent().userTask().camundaAsyncBefore()).endEvent().done();
    protected ProcessEngineRule engineRule = new ProvidedProcessEngineRule();
    protected ProcessEngineTestRule testRule = new ProcessEngineTestRule(this.engineRule);
    @Rule
    public RuleChain ruleChain = RuleChain.outerRule((TestRule)this.engineRule).around((TestRule)this.testRule);

    @Before
    public void setUp() throws Exception {
        this.testRule.deployForTenant(TENANT_ONE, PROCESS);
        this.testRule.deployForTenant(TENANT_TWO, PROCESS);
        this.testRule.deploy(PROCESS);
        this.engineRule.getRuntimeService().createProcessInstanceByKey(PROCESS_DEFINITION_KEY).processDefinitionTenantId(TENANT_ONE).execute();
        this.engineRule.getRuntimeService().createProcessInstanceByKey(PROCESS_DEFINITION_KEY).processDefinitionTenantId(TENANT_TWO).execute();
        this.engineRule.getRuntimeService().createProcessInstanceByKey(PROCESS_DEFINITION_KEY).processDefinitionWithoutTenantId().execute();
    }

    @Test
    public void suspendAndActivateJobDefinitionsForAllTenants() {
        JobDefinitionQuery query = this.engineRule.getManagementService().createJobDefinitionQuery();
        Assertions.assertThat((long)query.active().count()).isEqualTo(3L);
        Assertions.assertThat((long)query.suspended().count()).isEqualTo(0L);
        this.engineRule.getManagementService().updateJobDefinitionSuspensionState().byProcessDefinitionKey(PROCESS_DEFINITION_KEY).suspend();
        Assertions.assertThat((long)query.active().count()).isEqualTo(0L);
        Assertions.assertThat((long)query.suspended().count()).isEqualTo(3L);
        this.engineRule.getManagementService().updateJobDefinitionSuspensionState().byProcessDefinitionKey(PROCESS_DEFINITION_KEY).activate();
        Assertions.assertThat((long)query.active().count()).isEqualTo(3L);
        Assertions.assertThat((long)query.suspended().count()).isEqualTo(0L);
    }

    @Test
    public void suspendJobDefinitionForTenant() {
        JobDefinitionQuery query = this.engineRule.getManagementService().createJobDefinitionQuery();
        Assertions.assertThat((long)query.active().count()).isEqualTo(3L);
        Assertions.assertThat((long)query.suspended().count()).isEqualTo(0L);
        this.engineRule.getManagementService().updateJobDefinitionSuspensionState().byProcessDefinitionKey(PROCESS_DEFINITION_KEY).processDefinitionTenantId(TENANT_ONE).suspend();
        Assertions.assertThat((long)query.active().count()).isEqualTo(2L);
        Assertions.assertThat((long)query.suspended().count()).isEqualTo(1L);
        Assertions.assertThat((long)query.suspended().tenantIdIn(new String[]{TENANT_ONE}).count()).isEqualTo(1L);
    }

    @Test
    public void suspendJobDefinitionForNonTenant() {
        JobDefinitionQuery query = this.engineRule.getManagementService().createJobDefinitionQuery();
        Assertions.assertThat((long)query.active().count()).isEqualTo(3L);
        Assertions.assertThat((long)query.suspended().count()).isEqualTo(0L);
        this.engineRule.getManagementService().updateJobDefinitionSuspensionState().byProcessDefinitionKey(PROCESS_DEFINITION_KEY).processDefinitionWithoutTenantId().suspend();
        Assertions.assertThat((long)query.active().count()).isEqualTo(2L);
        Assertions.assertThat((long)query.suspended().count()).isEqualTo(1L);
        Assertions.assertThat((long)query.suspended().withoutTenantId().count()).isEqualTo(1L);
    }

    @Test
    public void activateJobDefinitionForTenant() {
        this.engineRule.getManagementService().updateJobDefinitionSuspensionState().byProcessDefinitionKey(PROCESS_DEFINITION_KEY).suspend();
        JobDefinitionQuery query = this.engineRule.getManagementService().createJobDefinitionQuery();
        Assertions.assertThat((long)query.suspended().count()).isEqualTo(3L);
        Assertions.assertThat((long)query.active().count()).isEqualTo(0L);
        this.engineRule.getManagementService().updateJobDefinitionSuspensionState().byProcessDefinitionKey(PROCESS_DEFINITION_KEY).processDefinitionTenantId(TENANT_ONE).activate();
        Assertions.assertThat((long)query.suspended().count()).isEqualTo(2L);
        Assertions.assertThat((long)query.active().count()).isEqualTo(1L);
        Assertions.assertThat((long)query.active().tenantIdIn(new String[]{TENANT_ONE}).count()).isEqualTo(1L);
    }

    @Test
    public void jobProcessDefinitionForNonTenant() {
        this.engineRule.getManagementService().updateJobDefinitionSuspensionState().byProcessDefinitionKey(PROCESS_DEFINITION_KEY).suspend();
        JobDefinitionQuery query = this.engineRule.getManagementService().createJobDefinitionQuery();
        Assertions.assertThat((long)query.suspended().count()).isEqualTo(3L);
        Assertions.assertThat((long)query.active().count()).isEqualTo(0L);
        this.engineRule.getManagementService().updateJobDefinitionSuspensionState().byProcessDefinitionKey(PROCESS_DEFINITION_KEY).processDefinitionWithoutTenantId().activate();
        Assertions.assertThat((long)query.suspended().count()).isEqualTo(2L);
        Assertions.assertThat((long)query.active().count()).isEqualTo(1L);
        Assertions.assertThat((long)query.active().withoutTenantId().count()).isEqualTo(1L);
    }

    @Test
    public void suspendAndActivateJobDefinitionsIncludingJobsForAllTenants() {
        JobQuery query = this.engineRule.getManagementService().createJobQuery();
        Assertions.assertThat((long)query.active().count()).isEqualTo(3L);
        Assertions.assertThat((long)query.suspended().count()).isEqualTo(0L);
        this.engineRule.getManagementService().updateJobDefinitionSuspensionState().byProcessDefinitionKey(PROCESS_DEFINITION_KEY).includeJobs(true).suspend();
        Assertions.assertThat((long)query.active().count()).isEqualTo(0L);
        Assertions.assertThat((long)query.suspended().count()).isEqualTo(3L);
        this.engineRule.getManagementService().updateJobDefinitionSuspensionState().byProcessDefinitionKey(PROCESS_DEFINITION_KEY).includeJobs(true).activate();
        Assertions.assertThat((long)query.active().count()).isEqualTo(3L);
        Assertions.assertThat((long)query.suspended().count()).isEqualTo(0L);
    }

    @Test
    public void suspendJobDefinitionIncludingJobsForTenant() {
        JobQuery query = this.engineRule.getManagementService().createJobQuery();
        Assertions.assertThat((long)query.active().count()).isEqualTo(3L);
        Assertions.assertThat((long)query.suspended().count()).isEqualTo(0L);
        this.engineRule.getManagementService().updateJobDefinitionSuspensionState().byProcessDefinitionKey(PROCESS_DEFINITION_KEY).processDefinitionTenantId(TENANT_ONE).includeJobs(true).suspend();
        Assertions.assertThat((long)query.active().count()).isEqualTo(2L);
        Assertions.assertThat((long)query.suspended().count()).isEqualTo(1L);
        Assertions.assertThat((long)query.suspended().tenantIdIn(new String[]{TENANT_ONE}).count()).isEqualTo(1L);
    }

    @Test
    public void suspendJobDefinitionIncludingJobsForNonTenant() {
        JobQuery query = this.engineRule.getManagementService().createJobQuery();
        Assertions.assertThat((long)query.active().count()).isEqualTo(3L);
        Assertions.assertThat((long)query.suspended().count()).isEqualTo(0L);
        this.engineRule.getManagementService().updateJobDefinitionSuspensionState().byProcessDefinitionKey(PROCESS_DEFINITION_KEY).processDefinitionWithoutTenantId().includeJobs(true).suspend();
        Assertions.assertThat((long)query.active().count()).isEqualTo(2L);
        Assertions.assertThat((long)query.suspended().count()).isEqualTo(1L);
        Assertions.assertThat((long)query.suspended().withoutTenantId().count()).isEqualTo(1L);
    }

    @Test
    public void activateJobDefinitionIncludingJobsForTenant() {
        this.engineRule.getManagementService().updateJobDefinitionSuspensionState().byProcessDefinitionKey(PROCESS_DEFINITION_KEY).includeJobs(true).suspend();
        JobQuery query = this.engineRule.getManagementService().createJobQuery();
        Assertions.assertThat((long)query.suspended().count()).isEqualTo(3L);
        Assertions.assertThat((long)query.active().count()).isEqualTo(0L);
        this.engineRule.getManagementService().updateJobDefinitionSuspensionState().byProcessDefinitionKey(PROCESS_DEFINITION_KEY).processDefinitionTenantId(TENANT_ONE).includeJobs(true).activate();
        Assertions.assertThat((long)query.suspended().count()).isEqualTo(2L);
        Assertions.assertThat((long)query.active().count()).isEqualTo(1L);
        Assertions.assertThat((long)query.active().tenantIdIn(new String[]{TENANT_ONE}).count()).isEqualTo(1L);
    }

    @Test
    public void activateJobDefinitionIncludingJobsForNonTenant() {
        this.engineRule.getManagementService().updateJobDefinitionSuspensionState().byProcessDefinitionKey(PROCESS_DEFINITION_KEY).includeJobs(true).suspend();
        JobQuery query = this.engineRule.getManagementService().createJobQuery();
        Assertions.assertThat((long)query.suspended().count()).isEqualTo(3L);
        Assertions.assertThat((long)query.active().count()).isEqualTo(0L);
        this.engineRule.getManagementService().updateJobDefinitionSuspensionState().byProcessDefinitionKey(PROCESS_DEFINITION_KEY).processDefinitionWithoutTenantId().includeJobs(true).activate();
        Assertions.assertThat((long)query.suspended().count()).isEqualTo(2L);
        Assertions.assertThat((long)query.active().count()).isEqualTo(1L);
        Assertions.assertThat((long)query.active().withoutTenantId().count()).isEqualTo(1L);
    }

    @Test
    public void delayedSuspendJobDefinitionsForAllTenants() {
        this.engineRule.getManagementService().updateJobDefinitionSuspensionState().byProcessDefinitionKey(PROCESS_DEFINITION_KEY).executionDate(this.tomorrow()).suspend();
        JobDefinitionQuery query = this.engineRule.getManagementService().createJobDefinitionQuery();
        Assertions.assertThat((long)query.active().count()).isEqualTo(3L);
        Assertions.assertThat((long)query.suspended().count()).isEqualTo(0L);
        Job job = (Job)this.engineRule.getManagementService().createJobQuery().timers().singleResult();
        Assertions.assertThat((Object)job).isNotNull();
        Assertions.assertThat(this.getDeploymentIds(query.active())).contains((Object[])new String[]{job.getDeploymentId()});
        this.engineRule.getManagementService().executeJob(job.getId());
        Assertions.assertThat((long)query.active().count()).isEqualTo(0L);
        Assertions.assertThat((long)query.suspended().count()).isEqualTo(3L);
    }

    @Test
    public void delayedSuspendJobDefinitionsForTenant() {
        this.engineRule.getManagementService().updateJobDefinitionSuspensionState().byProcessDefinitionKey(PROCESS_DEFINITION_KEY).processDefinitionTenantId(TENANT_ONE).executionDate(this.tomorrow()).suspend();
        JobDefinitionQuery query = this.engineRule.getManagementService().createJobDefinitionQuery();
        Assertions.assertThat((long)query.active().count()).isEqualTo(3L);
        Assertions.assertThat((long)query.suspended().count()).isEqualTo(0L);
        Job job = (Job)this.engineRule.getManagementService().createJobQuery().timers().singleResult();
        Assertions.assertThat((Object)job).isNotNull();
        JobDefinition expectedJobDefinition = (JobDefinition)this.engineRule.getManagementService().createJobDefinitionQuery().active().tenantIdIn(new String[]{TENANT_ONE}).singleResult();
        Assertions.assertThat((String)job.getDeploymentId()).isEqualTo((Object)this.getDeploymentId(expectedJobDefinition));
        this.engineRule.getManagementService().executeJob(job.getId());
        Assertions.assertThat((long)query.active().count()).isEqualTo(2L);
        Assertions.assertThat((long)query.suspended().count()).isEqualTo(1L);
        Assertions.assertThat((long)query.suspended().tenantIdIn(new String[]{TENANT_ONE}).count()).isEqualTo(1L);
    }

    @Test
    public void delayedSuspendJobDefinitionsForNonTenant() {
        this.engineRule.getManagementService().updateJobDefinitionSuspensionState().byProcessDefinitionKey(PROCESS_DEFINITION_KEY).processDefinitionWithoutTenantId().executionDate(this.tomorrow()).suspend();
        JobDefinitionQuery query = this.engineRule.getManagementService().createJobDefinitionQuery();
        Assertions.assertThat((long)query.active().count()).isEqualTo(3L);
        Assertions.assertThat((long)query.suspended().count()).isEqualTo(0L);
        Job job = (Job)this.engineRule.getManagementService().createJobQuery().timers().singleResult();
        Assertions.assertThat((Object)job).isNotNull();
        JobDefinition expectedJobDefinition = (JobDefinition)this.engineRule.getManagementService().createJobDefinitionQuery().active().withoutTenantId().singleResult();
        Assertions.assertThat((String)job.getDeploymentId()).isEqualTo((Object)this.getDeploymentId(expectedJobDefinition));
        this.engineRule.getManagementService().executeJob(job.getId());
        Assertions.assertThat((long)query.active().count()).isEqualTo(2L);
        Assertions.assertThat((long)query.suspended().count()).isEqualTo(1L);
        Assertions.assertThat((long)query.suspended().withoutTenantId().count()).isEqualTo(1L);
    }

    @Test
    public void delayedActivateJobDefinitionsForAllTenants() {
        this.engineRule.getManagementService().updateJobDefinitionSuspensionState().byProcessDefinitionKey(PROCESS_DEFINITION_KEY).suspend();
        this.engineRule.getManagementService().updateJobDefinitionSuspensionState().byProcessDefinitionKey(PROCESS_DEFINITION_KEY).executionDate(this.tomorrow()).activate();
        JobDefinitionQuery query = this.engineRule.getManagementService().createJobDefinitionQuery();
        Assertions.assertThat((long)query.active().count()).isEqualTo(0L);
        Assertions.assertThat((long)query.suspended().count()).isEqualTo(3L);
        Job job = (Job)this.engineRule.getManagementService().createJobQuery().timers().singleResult();
        Assertions.assertThat((Object)job).isNotNull();
        Assertions.assertThat(this.getDeploymentIds(query.suspended())).contains((Object[])new String[]{job.getDeploymentId()});
        this.engineRule.getManagementService().executeJob(job.getId());
        Assertions.assertThat((long)query.suspended().count()).isEqualTo(0L);
        Assertions.assertThat((long)query.active().count()).isEqualTo(3L);
    }

    @Test
    public void delayedActivateJobDefinitionsForTenant() {
        this.engineRule.getManagementService().updateJobDefinitionSuspensionState().byProcessDefinitionKey(PROCESS_DEFINITION_KEY).suspend();
        this.engineRule.getManagementService().updateJobDefinitionSuspensionState().byProcessDefinitionKey(PROCESS_DEFINITION_KEY).processDefinitionTenantId(TENANT_ONE).executionDate(this.tomorrow()).activate();
        JobDefinitionQuery query = this.engineRule.getManagementService().createJobDefinitionQuery();
        Assertions.assertThat((long)query.active().count()).isEqualTo(0L);
        Assertions.assertThat((long)query.suspended().count()).isEqualTo(3L);
        Job job = (Job)this.engineRule.getManagementService().createJobQuery().timers().singleResult();
        Assertions.assertThat((Object)job).isNotNull();
        JobDefinition expectedJobDefinition = (JobDefinition)this.engineRule.getManagementService().createJobDefinitionQuery().suspended().tenantIdIn(new String[]{TENANT_ONE}).singleResult();
        Assertions.assertThat((String)job.getDeploymentId()).isEqualTo((Object)this.getDeploymentId(expectedJobDefinition));
        this.engineRule.getManagementService().executeJob(job.getId());
        Assertions.assertThat((long)query.suspended().count()).isEqualTo(2L);
        Assertions.assertThat((long)query.active().count()).isEqualTo(1L);
        Assertions.assertThat((long)query.active().tenantIdIn(new String[]{TENANT_ONE}).count()).isEqualTo(1L);
    }

    @Test
    public void delayedActivateJobDefinitionsForNonTenant() {
        this.engineRule.getManagementService().updateJobDefinitionSuspensionState().byProcessDefinitionKey(PROCESS_DEFINITION_KEY).suspend();
        this.engineRule.getManagementService().updateJobDefinitionSuspensionState().byProcessDefinitionKey(PROCESS_DEFINITION_KEY).processDefinitionWithoutTenantId().executionDate(this.tomorrow()).activate();
        JobDefinitionQuery query = this.engineRule.getManagementService().createJobDefinitionQuery();
        Assertions.assertThat((long)query.active().count()).isEqualTo(0L);
        Assertions.assertThat((long)query.suspended().count()).isEqualTo(3L);
        Job job = (Job)this.engineRule.getManagementService().createJobQuery().timers().singleResult();
        Assertions.assertThat((Object)job).isNotNull();
        JobDefinition expectedJobDefinition = (JobDefinition)this.engineRule.getManagementService().createJobDefinitionQuery().suspended().withoutTenantId().singleResult();
        Assertions.assertThat((String)job.getDeploymentId()).isEqualTo((Object)this.getDeploymentId(expectedJobDefinition));
        this.engineRule.getManagementService().executeJob(job.getId());
        Assertions.assertThat((long)query.suspended().count()).isEqualTo(2L);
        Assertions.assertThat((long)query.active().count()).isEqualTo(1L);
        Assertions.assertThat((long)query.active().withoutTenantId().count()).isEqualTo(1L);
    }

    @Test
    public void suspendJobDefinitionNoAuthenticatedTenants() {
        JobDefinitionQuery query = this.engineRule.getManagementService().createJobDefinitionQuery();
        Assertions.assertThat((long)query.active().count()).isEqualTo(3L);
        Assertions.assertThat((long)query.suspended().count()).isEqualTo(0L);
        this.engineRule.getIdentityService().setAuthentication("user", null, null);
        this.engineRule.getManagementService().updateJobDefinitionSuspensionState().byProcessDefinitionKey(PROCESS_DEFINITION_KEY).suspend();
        this.engineRule.getIdentityService().clearAuthentication();
        Assertions.assertThat((long)query.active().count()).isEqualTo(2L);
        Assertions.assertThat((long)query.suspended().count()).isEqualTo(1L);
        Assertions.assertThat((long)query.suspended().withoutTenantId().count()).isEqualTo(1L);
    }

    @Test
    public void suspendJobDefinitionWithAuthenticatedTenant() {
        JobDefinitionQuery query = this.engineRule.getManagementService().createJobDefinitionQuery();
        Assertions.assertThat((long)query.active().count()).isEqualTo(3L);
        Assertions.assertThat((long)query.suspended().count()).isEqualTo(0L);
        this.engineRule.getIdentityService().setAuthentication("user", null, Arrays.asList(TENANT_ONE));
        this.engineRule.getManagementService().updateJobDefinitionSuspensionState().byProcessDefinitionKey(PROCESS_DEFINITION_KEY).suspend();
        this.engineRule.getIdentityService().clearAuthentication();
        Assertions.assertThat((long)query.active().count()).isEqualTo(1L);
        Assertions.assertThat((long)query.suspended().count()).isEqualTo(2L);
        Assertions.assertThat((long)query.active().tenantIdIn(new String[]{TENANT_TWO}).count()).isEqualTo(1L);
        Assertions.assertThat((long)query.suspended().withoutTenantId().count()).isEqualTo(1L);
        Assertions.assertThat((long)query.suspended().tenantIdIn(new String[]{TENANT_ONE}).count()).isEqualTo(1L);
    }

    @Test
    public void suspendJobDefinitionDisabledTenantCheck() {
        JobDefinitionQuery query = this.engineRule.getManagementService().createJobDefinitionQuery();
        Assertions.assertThat((long)query.active().count()).isEqualTo(3L);
        Assertions.assertThat((long)query.suspended().count()).isEqualTo(0L);
        this.engineRule.getProcessEngineConfiguration().setTenantCheckEnabled(false);
        this.engineRule.getIdentityService().setAuthentication("user", null, null);
        this.engineRule.getManagementService().updateJobDefinitionSuspensionState().byProcessDefinitionKey(PROCESS_DEFINITION_KEY).suspend();
        Assertions.assertThat((long)query.active().count()).isEqualTo(0L);
        Assertions.assertThat((long)query.suspended().count()).isEqualTo(3L);
        Assertions.assertThat((long)query.suspended().tenantIdIn(new String[]{TENANT_ONE, TENANT_TWO}).includeJobDefinitionsWithoutTenantId().count()).isEqualTo(3L);
    }

    protected Date tomorrow() {
        Calendar calendar = Calendar.getInstance();
        calendar.add(6, 1);
        return calendar.getTime();
    }

    protected List<String> getDeploymentIds(JobDefinitionQuery jobDefinitionQuery) {
        return jobDefinitionQuery.list().stream().map(this::getDeploymentId).collect(Collectors.toList());
    }

    protected String getDeploymentId(JobDefinition jobDefinition) {
        return ((ProcessDefinition)this.engineRule.getRepositoryService().createProcessDefinitionQuery().processDefinitionId(jobDefinition.getProcessDefinitionId()).singleResult()).getDeploymentId();
    }

    @After
    public void tearDown() throws Exception {
        CommandExecutor commandExecutor = this.engineRule.getProcessEngineConfiguration().getCommandExecutorTxRequired();
        commandExecutor.execute((Command)new Command<Object>(){

            public Object execute(CommandContext commandContext) {
                commandContext.getHistoricJobLogManager().deleteHistoricJobLogsByHandlerType("activate-job-definition");
                commandContext.getHistoricJobLogManager().deleteHistoricJobLogsByHandlerType("suspend-job-definition");
                return null;
            }
        });
    }
}

