/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.multitenancy.tenantcheck;

import java.util.Arrays;
import java.util.HashMap;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.camunda.bpm.engine.FormService;
import org.camunda.bpm.engine.IdentityService;
import org.camunda.bpm.engine.ProcessEngineConfiguration;
import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.RepositoryService;
import org.camunda.bpm.engine.RuntimeService;
import org.camunda.bpm.engine.TaskService;
import org.camunda.bpm.engine.form.StartFormData;
import org.camunda.bpm.engine.form.TaskFormData;
import org.camunda.bpm.engine.repository.ProcessDefinition;
import org.camunda.bpm.engine.runtime.ProcessInstance;
import org.camunda.bpm.engine.task.Task;
import org.camunda.bpm.engine.test.ProcessEngineRule;
import org.camunda.bpm.engine.test.util.ProcessEngineTestRule;
import org.camunda.bpm.engine.test.util.ProvidedProcessEngineRule;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;

public class MultiTenancyFormServiceCmdsTenantCheckTest {
    protected static final String TENANT_ONE = "tenant1";
    protected static final String PROCESS_DEFINITION_KEY = "formKeyProcess";
    protected ProcessEngineRule engineRule = new ProvidedProcessEngineRule();
    protected ProcessEngineTestRule testRule = new ProcessEngineTestRule(this.engineRule);
    protected TaskService taskService;
    protected FormService formService;
    protected RuntimeService runtimeService;
    protected IdentityService identityService;
    protected RepositoryService repositoryService;
    protected ProcessEngineConfiguration processEngineConfiguration;
    @Rule
    public RuleChain ruleChain = RuleChain.outerRule((TestRule)this.engineRule).around((TestRule)this.testRule);

    @Before
    public void init() {
        this.taskService = this.engineRule.getTaskService();
        this.formService = this.engineRule.getFormService();
        this.identityService = this.engineRule.getIdentityService();
        this.runtimeService = this.engineRule.getRuntimeService();
        this.repositoryService = this.engineRule.getRepositoryService();
        this.processEngineConfiguration = this.engineRule.getProcessEngineConfiguration();
    }

    @Test
    public void testGetStartFormWithAuthenticatedTenant() {
        this.testRule.deployForTenant(TENANT_ONE, "org/camunda/bpm/engine/test/api/authorization/formKeyProcess.bpmn20.xml");
        ProcessInstance instance = this.runtimeService.startProcessInstanceByKey(PROCESS_DEFINITION_KEY);
        this.identityService.setAuthentication("aUserId", null, Arrays.asList(TENANT_ONE));
        StartFormData startFormData = this.formService.getStartFormData(instance.getProcessDefinitionId());
        Assert.assertNotNull((Object)startFormData);
        Assert.assertEquals((Object)"aStartFormKey", (Object)startFormData.getFormKey());
    }

    @Test
    public void testGetStartFormWithNoAuthenticatedTenant() {
        this.testRule.deployForTenant(TENANT_ONE, "org/camunda/bpm/engine/test/api/authorization/formKeyProcess.bpmn20.xml");
        ProcessInstance instance = this.runtimeService.startProcessInstanceByKey(PROCESS_DEFINITION_KEY);
        this.identityService.setAuthentication("aUserId", null);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.formService.getStartFormData(instance.getProcessDefinitionId())).isInstanceOf(ProcessEngineException.class)).hasMessageContaining("Cannot get the process definition '" + instance.getProcessDefinitionId() + "' because it belongs to no authenticated tenant.");
    }

    @Test
    public void testGetStartFormWithDisabledTenantCheck() {
        this.testRule.deployForTenant(TENANT_ONE, "org/camunda/bpm/engine/test/api/authorization/formKeyProcess.bpmn20.xml");
        ProcessInstance instance = this.runtimeService.startProcessInstanceByKey(PROCESS_DEFINITION_KEY);
        this.identityService.setAuthentication("aUserId", null);
        this.processEngineConfiguration.setTenantCheckEnabled(false);
        StartFormData startFormData = this.formService.getStartFormData(instance.getProcessDefinitionId());
        Assert.assertNotNull((Object)startFormData);
        Assert.assertEquals((Object)"aStartFormKey", (Object)startFormData.getFormKey());
    }

    @Test
    public void testGetRenderedStartFormWithAuthenticatedTenant() {
        this.testRule.deployForTenant(TENANT_ONE, "org/camunda/bpm/engine/test/api/form/util/VacationRequest_deprecated_forms.bpmn20.xml", "org/camunda/bpm/engine/test/api/form/util/request.form");
        String processDefinitionId = ((ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().singleResult()).getId();
        this.identityService.setAuthentication("aUserId", null, Arrays.asList(TENANT_ONE));
        Assert.assertNotNull((Object)this.formService.getRenderedStartForm(processDefinitionId, "juel"));
    }

    @Test
    public void testGetRenderedStartFormWithNoAuthenticatedTenant() {
        this.testRule.deployForTenant(TENANT_ONE, "org/camunda/bpm/engine/test/api/form/util/VacationRequest_deprecated_forms.bpmn20.xml", "org/camunda/bpm/engine/test/api/form/util/request.form");
        String processDefinitionId = ((ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().singleResult()).getId();
        this.identityService.setAuthentication("aUserId", null);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.formService.getRenderedStartForm(processDefinitionId, "juel")).isInstanceOf(ProcessEngineException.class)).hasMessageContaining("Cannot get the process definition '" + processDefinitionId + "' because it belongs to no authenticated tenant.");
    }

    @Test
    public void testGetRenderedStartFormWithDisabledTenantCheck() {
        this.testRule.deployForTenant(TENANT_ONE, "org/camunda/bpm/engine/test/api/form/util/VacationRequest_deprecated_forms.bpmn20.xml", "org/camunda/bpm/engine/test/api/form/util/request.form");
        String processDefinitionId = ((ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().singleResult()).getId();
        this.identityService.setAuthentication("aUserId", null);
        this.processEngineConfiguration.setTenantCheckEnabled(false);
        Assert.assertNotNull((Object)this.formService.getRenderedStartForm(processDefinitionId, "juel"));
    }

    @Test
    public void testSubmitStartFormWithAuthenticatedTenant() {
        this.testRule.deployForTenant(TENANT_ONE, "org/camunda/bpm/engine/test/api/form/util/VacationRequest_deprecated_forms.bpmn20.xml", "org/camunda/bpm/engine/test/api/form/util/request.form");
        String processDefinitionId = ((ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().singleResult()).getId();
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("employeeName", "demo");
        this.identityService.setAuthentication("aUserId", null, Arrays.asList(TENANT_ONE));
        Assert.assertNotNull((Object)this.formService.submitStartForm(processDefinitionId, properties));
    }

    @Test
    public void testSubmitStartFormWithNoAuthenticatedTenant() {
        this.testRule.deployForTenant(TENANT_ONE, "org/camunda/bpm/engine/test/api/form/util/VacationRequest_deprecated_forms.bpmn20.xml", "org/camunda/bpm/engine/test/api/form/util/request.form");
        String processDefinitionId = ((ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().singleResult()).getId();
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("employeeName", "demo");
        this.identityService.setAuthentication("aUserId", null);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.formService.submitStartForm(processDefinitionId, properties)).isInstanceOf(ProcessEngineException.class)).hasMessageContaining("Cannot create an instance of the process definition '" + processDefinitionId + "' because it belongs to no authenticated tenant.");
    }

    @Test
    public void testSubmitStartFormWithDisabledTenantcheck() {
        this.testRule.deployForTenant(TENANT_ONE, "org/camunda/bpm/engine/test/api/form/util/VacationRequest_deprecated_forms.bpmn20.xml", "org/camunda/bpm/engine/test/api/form/util/request.form");
        String processDefinitionId = ((ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().singleResult()).getId();
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("employeeName", "demo");
        this.identityService.setAuthentication("aUserId", null);
        this.processEngineConfiguration.setTenantCheckEnabled(false);
        Assert.assertNotNull((Object)this.formService.submitStartForm(processDefinitionId, properties));
    }

    @Test
    public void testGetStartFormKeyWithAuthenticatedTenant() {
        this.testRule.deployForTenant(TENANT_ONE, "org/camunda/bpm/engine/test/api/authorization/formKeyProcess.bpmn20.xml");
        String processDefinitionId = this.runtimeService.startProcessInstanceByKey(PROCESS_DEFINITION_KEY).getProcessDefinitionId();
        this.identityService.setAuthentication("aUserId", null, Arrays.asList(TENANT_ONE));
        Assert.assertEquals((Object)"aStartFormKey", (Object)this.formService.getStartFormKey(processDefinitionId));
    }

    @Test
    public void testGetStartFormKeyWithNoAuthenticatedTenant() {
        this.testRule.deployForTenant(TENANT_ONE, "org/camunda/bpm/engine/test/api/authorization/formKeyProcess.bpmn20.xml");
        String processDefinitionId = this.runtimeService.startProcessInstanceByKey(PROCESS_DEFINITION_KEY).getProcessDefinitionId();
        this.identityService.setAuthentication("aUserId", null);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.formService.getStartFormKey(processDefinitionId)).isInstanceOf(ProcessEngineException.class)).hasMessageContaining("Cannot get the process definition '" + processDefinitionId + "' because it belongs to no authenticated tenant.");
    }

    @Test
    public void testGetStartFormKeyWithDisabledTenantCheck() {
        this.testRule.deployForTenant(TENANT_ONE, "org/camunda/bpm/engine/test/api/authorization/formKeyProcess.bpmn20.xml");
        String processDefinitionId = this.runtimeService.startProcessInstanceByKey(PROCESS_DEFINITION_KEY).getProcessDefinitionId();
        this.identityService.setAuthentication("aUserId", null);
        this.processEngineConfiguration.setTenantCheckEnabled(false);
        Assert.assertEquals((Object)"aStartFormKey", (Object)this.formService.getStartFormKey(processDefinitionId));
    }

    @Test
    public void testGetTaskFormWithAuthenticatedTenant() {
        this.testRule.deployForTenant(TENANT_ONE, "org/camunda/bpm/engine/test/api/authorization/formKeyProcess.bpmn20.xml");
        this.runtimeService.startProcessInstanceByKey(PROCESS_DEFINITION_KEY);
        this.identityService.setAuthentication("aUserId", null, Arrays.asList(TENANT_ONE));
        String taskId = ((Task)this.taskService.createTaskQuery().singleResult()).getId();
        TaskFormData taskFormData = this.formService.getTaskFormData(taskId);
        Assert.assertNotNull((Object)taskFormData);
        Assert.assertEquals((Object)"aTaskFormKey", (Object)taskFormData.getFormKey());
    }

    @Test
    public void testGetTaskFormWithNoAuthenticatedTenant() {
        this.testRule.deployForTenant(TENANT_ONE, "org/camunda/bpm/engine/test/api/authorization/formKeyProcess.bpmn20.xml");
        this.runtimeService.startProcessInstanceByKey(PROCESS_DEFINITION_KEY);
        String taskId = ((Task)this.taskService.createTaskQuery().singleResult()).getId();
        this.identityService.setAuthentication("aUserId", null);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.formService.getTaskFormData(taskId)).isInstanceOf(ProcessEngineException.class)).hasMessageContaining("Cannot read the task '" + taskId + "' because it belongs to no authenticated tenant.");
    }

    @Test
    public void testGetTaskFormWithDisabledTenantCheck() {
        this.testRule.deployForTenant(TENANT_ONE, "org/camunda/bpm/engine/test/api/authorization/formKeyProcess.bpmn20.xml");
        this.runtimeService.startProcessInstanceByKey(PROCESS_DEFINITION_KEY);
        String taskId = ((Task)this.taskService.createTaskQuery().singleResult()).getId();
        this.identityService.setAuthentication("aUserId", null);
        this.processEngineConfiguration.setTenantCheckEnabled(false);
        TaskFormData taskFormData = this.formService.getTaskFormData(taskId);
        Assert.assertNotNull((Object)taskFormData);
        Assert.assertEquals((Object)"aTaskFormKey", (Object)taskFormData.getFormKey());
    }

    @Test
    public void testSubmitTaskFormWithAuthenticatedTenant() {
        this.testRule.deployForTenant(TENANT_ONE, "org/camunda/bpm/engine/test/api/authorization/formKeyProcess.bpmn20.xml");
        String processDefinitionId = ((ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().singleResult()).getId();
        this.runtimeService.startProcessInstanceById(processDefinitionId);
        Assert.assertEquals((long)this.taskService.createTaskQuery().processDefinitionId(processDefinitionId).count(), (long)1L);
        String taskId = ((Task)this.taskService.createTaskQuery().processDefinitionId(processDefinitionId).singleResult()).getId();
        this.identityService.setAuthentication("aUserId", null, Arrays.asList(TENANT_ONE));
        this.formService.submitTaskForm(taskId, null);
        Assert.assertEquals((long)this.taskService.createTaskQuery().processDefinitionId(processDefinitionId).count(), (long)0L);
    }

    @Test
    public void testSubmitTaskFormWithNoAuthenticatedTenant() {
        this.testRule.deployForTenant(TENANT_ONE, "org/camunda/bpm/engine/test/api/authorization/formKeyProcess.bpmn20.xml");
        String processDefinitionId = ((ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().singleResult()).getId();
        this.runtimeService.startProcessInstanceById(processDefinitionId);
        String taskId = ((Task)this.taskService.createTaskQuery().processDefinitionId(processDefinitionId).singleResult()).getId();
        this.identityService.setAuthentication("aUserId", null);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.formService.submitTaskForm(taskId, null)).isInstanceOf(ProcessEngineException.class)).hasMessageContaining("Cannot work on task '" + taskId + "' because it belongs to no authenticated tenant.");
    }

    @Test
    public void testSubmitTaskFormWithDisabledTenantCheck() {
        this.testRule.deployForTenant(TENANT_ONE, "org/camunda/bpm/engine/test/api/authorization/formKeyProcess.bpmn20.xml");
        String processDefinitionId = ((ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().singleResult()).getId();
        this.runtimeService.startProcessInstanceById(processDefinitionId);
        String taskId = ((Task)this.taskService.createTaskQuery().processDefinitionId(processDefinitionId).singleResult()).getId();
        this.identityService.setAuthentication("aUserId", null);
        this.processEngineConfiguration.setTenantCheckEnabled(false);
        this.formService.submitTaskForm(taskId, null);
        Assert.assertEquals((long)this.taskService.createTaskQuery().processDefinitionId(processDefinitionId).count(), (long)0L);
    }

    @Test
    public void testGetRenderedTaskFormWithAuthenticatedTenant() {
        this.testRule.deployForTenant(TENANT_ONE, "org/camunda/bpm/engine/test/api/form/FormsProcess.bpmn20.xml", "org/camunda/bpm/engine/test/api/form/task.form").getId();
        String procDefId = ((ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().singleResult()).getId();
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("room", "5b");
        properties.put("speaker", "Mike");
        this.formService.submitStartForm(procDefId, properties).getId();
        String taskId = ((Task)this.taskService.createTaskQuery().singleResult()).getId();
        this.identityService.setAuthentication("aUserId", null, Arrays.asList(TENANT_ONE));
        Assert.assertEquals((Object)"Mike is speaking in room 5b", (Object)this.formService.getRenderedTaskForm(taskId, "juel"));
    }

    @Test
    public void testGetRenderedTaskFormWithNoAuthenticatedTenant() {
        this.testRule.deployForTenant(TENANT_ONE, "org/camunda/bpm/engine/test/api/form/FormsProcess.bpmn20.xml", "org/camunda/bpm/engine/test/api/form/task.form").getId();
        String procDefId = ((ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().singleResult()).getId();
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("room", "5b");
        properties.put("speaker", "Mike");
        this.formService.submitStartForm(procDefId, properties);
        String taskId = ((Task)this.taskService.createTaskQuery().singleResult()).getId();
        this.identityService.setAuthentication("aUserId", null);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.formService.getRenderedTaskForm(taskId, "juel")).isInstanceOf(ProcessEngineException.class)).hasMessageContaining("Cannot read the task '" + taskId + "' because it belongs to no authenticated tenant.");
    }

    @Test
    public void testGetRenderedTaskFormWithDisabledTenantCheck() {
        this.testRule.deployForTenant(TENANT_ONE, "org/camunda/bpm/engine/test/api/form/FormsProcess.bpmn20.xml", "org/camunda/bpm/engine/test/api/form/task.form").getId();
        String procDefId = ((ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().singleResult()).getId();
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("room", "5b");
        properties.put("speaker", "Mike");
        this.formService.submitStartForm(procDefId, properties);
        String taskId = ((Task)this.taskService.createTaskQuery().singleResult()).getId();
        this.identityService.setAuthentication("aUserId", null);
        this.processEngineConfiguration.setTenantCheckEnabled(false);
        Assert.assertEquals((Object)"Mike is speaking in room 5b", (Object)this.formService.getRenderedTaskForm(taskId, "juel"));
    }

    @Test
    public void testGetTaskFormKeyWithAuthenticatedTenant() {
        this.testRule.deployForTenant(TENANT_ONE, "org/camunda/bpm/engine/test/api/authorization/formKeyProcess.bpmn20.xml");
        this.runtimeService.startProcessInstanceByKey(PROCESS_DEFINITION_KEY);
        Task task = (Task)this.taskService.createTaskQuery().singleResult();
        this.identityService.setAuthentication("aUserId", null, Arrays.asList(TENANT_ONE));
        Assert.assertEquals((Object)"aTaskFormKey", (Object)this.formService.getTaskFormKey(task.getProcessDefinitionId(), task.getTaskDefinitionKey()));
    }

    @Test
    public void testGetTaskFormKeyWithNoAuthenticatedTenant() {
        this.testRule.deployForTenant(TENANT_ONE, "org/camunda/bpm/engine/test/api/authorization/formKeyProcess.bpmn20.xml");
        this.runtimeService.startProcessInstanceByKey(PROCESS_DEFINITION_KEY);
        Task task = (Task)this.taskService.createTaskQuery().singleResult();
        this.identityService.setAuthentication("aUserId", null);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.formService.getTaskFormKey(task.getProcessDefinitionId(), task.getTaskDefinitionKey())).isInstanceOf(ProcessEngineException.class)).hasMessageContaining("Cannot get the process definition '" + task.getProcessDefinitionId() + "' because it belongs to no authenticated tenant.");
    }

    @Test
    public void testGetTaskFormKeyWithDisabledTenantCheck() {
        this.testRule.deployForTenant(TENANT_ONE, "org/camunda/bpm/engine/test/api/authorization/formKeyProcess.bpmn20.xml");
        this.runtimeService.startProcessInstanceByKey(PROCESS_DEFINITION_KEY);
        Task task = (Task)this.taskService.createTaskQuery().singleResult();
        this.identityService.setAuthentication("aUserId", null);
        this.processEngineConfiguration.setTenantCheckEnabled(false);
        this.formService.getTaskFormKey(task.getProcessDefinitionId(), task.getTaskDefinitionKey());
        Assert.assertEquals((Object)"aTaskFormKey", (Object)this.formService.getTaskFormKey(task.getProcessDefinitionId(), task.getTaskDefinitionKey()));
    }
}

