/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.optimize;

import java.util.Date;
import java.util.List;
import org.camunda.bpm.engine.AuthorizationService;
import org.camunda.bpm.engine.IdentityService;
import org.camunda.bpm.engine.RuntimeService;
import org.camunda.bpm.engine.TaskService;
import org.camunda.bpm.engine.authorization.Authorization;
import org.camunda.bpm.engine.history.HistoricProcessInstance;
import org.camunda.bpm.engine.identity.Group;
import org.camunda.bpm.engine.identity.User;
import org.camunda.bpm.engine.impl.OptimizeService;
import org.camunda.bpm.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.camunda.bpm.engine.impl.util.ClockUtil;
import org.camunda.bpm.engine.runtime.ProcessInstance;
import org.camunda.bpm.engine.task.Task;
import org.camunda.bpm.engine.test.ProcessEngineRule;
import org.camunda.bpm.engine.test.RequiredHistoryLevel;
import org.camunda.bpm.engine.test.util.ProcessEngineTestRule;
import org.camunda.bpm.engine.test.util.ProvidedProcessEngineRule;
import org.camunda.bpm.model.bpmn.Bpmn;
import org.camunda.bpm.model.bpmn.BpmnModelInstance;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.After;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;

@RequiredHistoryLevel(value="full")
public class GetCompletedHistoricProcessInstancesForOptimizeTest {
    public ProcessEngineRule engineRule = new ProvidedProcessEngineRule();
    protected ProcessEngineTestRule testHelper = new ProcessEngineTestRule(this.engineRule);
    @Rule
    public RuleChain ruleChain = RuleChain.outerRule((TestRule)this.engineRule).around((TestRule)this.testHelper);
    private OptimizeService optimizeService;
    protected String userId = "test";
    protected static final String VARIABLE_NAME = "aVariableName";
    protected static final String VARIABLE_VALUE = "aVariableValue";
    private IdentityService identityService;
    private RuntimeService runtimeService;
    private AuthorizationService authorizationService;
    private TaskService taskService;

    @Before
    public void init() {
        ProcessEngineConfigurationImpl config = this.engineRule.getProcessEngineConfiguration();
        this.optimizeService = config.getOptimizeService();
        this.identityService = this.engineRule.getIdentityService();
        this.runtimeService = this.engineRule.getRuntimeService();
        this.authorizationService = this.engineRule.getAuthorizationService();
        this.taskService = this.engineRule.getTaskService();
        this.createUser(this.userId);
    }

    @After
    public void cleanUp() {
        for (User user : this.identityService.createUserQuery().list()) {
            this.identityService.deleteUser(user.getId());
        }
        for (Group group : this.identityService.createGroupQuery().list()) {
            this.identityService.deleteGroup(group.getId());
        }
        for (Authorization authorization : this.authorizationService.createAuthorizationQuery().list()) {
            this.authorizationService.deleteAuthorization(authorization.getId());
        }
        ClockUtil.reset();
    }

    @Test
    public void getCompletedHistoricProcessInstances() {
        BpmnModelInstance simpleDefinition = Bpmn.createExecutableProcess((String)"process").startEvent().endEvent().done();
        this.testHelper.deploy(simpleDefinition);
        this.runtimeService.startProcessInstanceByKey("process");
        List completedHistoricProcessInstances = this.optimizeService.getCompletedHistoricProcessInstances(this.pastDate(), null, 10);
        MatcherAssert.assertThat((Object)completedHistoricProcessInstances.size(), (Matcher)CoreMatchers.is((Object)1));
        this.assertThatInstanceHasAllImportantInformation((HistoricProcessInstance)completedHistoricProcessInstances.get(0));
    }

    @Test
    public void fishedAfterParameterWorks() {
        BpmnModelInstance simpleDefinition = Bpmn.createExecutableProcess((String)"process").startEvent().endEvent().done();
        this.testHelper.deploy(simpleDefinition);
        Date now = new Date();
        ClockUtil.setCurrentTime((Date)now);
        this.runtimeService.startProcessInstanceByKey("process");
        Date nowPlus2Seconds = new Date(now.getTime() + 2000L);
        ClockUtil.setCurrentTime((Date)nowPlus2Seconds);
        this.runtimeService.startProcessInstanceByKey("process");
        List completedHistoricProcessInstances = this.optimizeService.getCompletedHistoricProcessInstances(now, null, 10);
        MatcherAssert.assertThat((Object)completedHistoricProcessInstances.size(), (Matcher)CoreMatchers.is((Object)1));
    }

    @Test
    public void fishedAtParameterWorks() {
        BpmnModelInstance simpleDefinition = Bpmn.createExecutableProcess((String)"process").startEvent().endEvent().done();
        this.testHelper.deploy(simpleDefinition);
        Date now = new Date();
        ClockUtil.setCurrentTime((Date)now);
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("process");
        Date nowPlus2Seconds = new Date(now.getTime() + 2000L);
        ClockUtil.setCurrentTime((Date)nowPlus2Seconds);
        this.runtimeService.startProcessInstanceByKey("process");
        List completedHistoricProcessInstances = this.optimizeService.getCompletedHistoricProcessInstances(null, now, 10);
        MatcherAssert.assertThat((Object)completedHistoricProcessInstances.size(), (Matcher)CoreMatchers.is((Object)1));
        MatcherAssert.assertThat((Object)((HistoricProcessInstance)completedHistoricProcessInstances.get(0)).getId(), (Matcher)CoreMatchers.is((Object)processInstance.getId()));
    }

    @Test
    public void fishedAfterAndFinishedAtParameterWorks() {
        BpmnModelInstance simpleDefinition = Bpmn.createExecutableProcess((String)"process").startEvent().endEvent().done();
        this.testHelper.deploy(simpleDefinition);
        Date now = new Date();
        ClockUtil.setCurrentTime((Date)now);
        this.runtimeService.startProcessInstanceByKey("process");
        Date nowPlus2Seconds = new Date(now.getTime() + 2000L);
        ClockUtil.setCurrentTime((Date)nowPlus2Seconds);
        this.runtimeService.startProcessInstanceByKey("process");
        List completedHistoricProcessInstances = this.optimizeService.getCompletedHistoricProcessInstances(now, now, 10);
        MatcherAssert.assertThat((Object)completedHistoricProcessInstances.size(), (Matcher)CoreMatchers.is((Object)0));
    }

    @Test
    public void maxResultsParameterWorks() {
        BpmnModelInstance simpleDefinition = Bpmn.createExecutableProcess((String)"process").startEvent().endEvent().done();
        this.testHelper.deploy(simpleDefinition);
        this.runtimeService.startProcessInstanceByKey("process");
        this.runtimeService.startProcessInstanceByKey("process");
        this.runtimeService.startProcessInstanceByKey("process");
        this.runtimeService.startProcessInstanceByKey("process");
        this.runtimeService.startProcessInstanceByKey("process");
        List completedHistoricProcessInstances = this.optimizeService.getCompletedHistoricProcessInstances(this.pastDate(), null, 3);
        MatcherAssert.assertThat((Object)completedHistoricProcessInstances.size(), (Matcher)CoreMatchers.is((Object)3));
    }

    @Test
    public void resultIsSortedByEndTime() {
        BpmnModelInstance simpleDefinition = Bpmn.createExecutableProcess((String)"process").startEvent().endEvent().done();
        this.testHelper.deploy(simpleDefinition);
        Date now = new Date();
        Date nowPlus1Second = new Date(now.getTime() + 1000L);
        ClockUtil.setCurrentTime((Date)nowPlus1Second);
        ProcessInstance processInstance1 = this.runtimeService.startProcessInstanceByKey("process");
        Date nowPlus2Seconds = new Date(now.getTime() + 2000L);
        ClockUtil.setCurrentTime((Date)nowPlus2Seconds);
        ProcessInstance processInstance2 = this.runtimeService.startProcessInstanceByKey("process");
        Date nowPlus4Seconds = new Date(nowPlus2Seconds.getTime() + 2000L);
        ClockUtil.setCurrentTime((Date)nowPlus4Seconds);
        ProcessInstance processInstance3 = this.runtimeService.startProcessInstanceByKey("process");
        List completedHistoricProcessInstances = this.optimizeService.getCompletedHistoricProcessInstances(now, null, 10);
        MatcherAssert.assertThat((Object)completedHistoricProcessInstances.size(), (Matcher)CoreMatchers.is((Object)3));
        MatcherAssert.assertThat((Object)((HistoricProcessInstance)completedHistoricProcessInstances.get(0)).getId(), (Matcher)CoreMatchers.is((Object)processInstance1.getId()));
        MatcherAssert.assertThat((Object)((HistoricProcessInstance)completedHistoricProcessInstances.get(1)).getId(), (Matcher)CoreMatchers.is((Object)processInstance2.getId()));
        MatcherAssert.assertThat((Object)((HistoricProcessInstance)completedHistoricProcessInstances.get(2)).getId(), (Matcher)CoreMatchers.is((Object)processInstance3.getId()));
    }

    @Test
    public void fetchOnlyCompletedProcessInstances() {
        BpmnModelInstance simpleDefinition = Bpmn.createExecutableProcess((String)"process").startEvent().userTask().endEvent().done();
        this.testHelper.deploy(simpleDefinition);
        ProcessInstance processInstanceToComplete = this.runtimeService.startProcessInstanceByKey("process");
        this.completeAllUserTasks();
        this.runtimeService.startProcessInstanceByKey("process");
        List completedHistoricProcessInstances = this.optimizeService.getCompletedHistoricProcessInstances(this.pastDate(), null, 10);
        MatcherAssert.assertThat((Object)completedHistoricProcessInstances.size(), (Matcher)CoreMatchers.is((Object)1));
        MatcherAssert.assertThat((Object)((HistoricProcessInstance)completedHistoricProcessInstances.get(0)).getId(), (Matcher)CoreMatchers.is((Object)processInstanceToComplete.getId()));
    }

    private Date pastDate() {
        return new Date(2L);
    }

    private void completeAllUserTasks() {
        List list = this.taskService.createTaskQuery().list();
        for (Task task : list) {
            this.taskService.claim(task.getId(), this.userId);
            this.taskService.complete(task.getId());
        }
    }

    protected void createUser(String userId) {
        User user = this.identityService.newUser(userId);
        this.identityService.saveUser(user);
    }

    private void assertThatInstanceHasAllImportantInformation(HistoricProcessInstance historicProcessInstance) {
        MatcherAssert.assertThat((Object)historicProcessInstance, (Matcher)CoreMatchers.notNullValue());
        MatcherAssert.assertThat((Object)historicProcessInstance.getId(), (Matcher)CoreMatchers.notNullValue());
        MatcherAssert.assertThat((Object)historicProcessInstance.getProcessDefinitionKey(), (Matcher)CoreMatchers.is((Object)"process"));
        MatcherAssert.assertThat((Object)historicProcessInstance.getProcessDefinitionVersion(), (Matcher)CoreMatchers.notNullValue());
        MatcherAssert.assertThat((Object)historicProcessInstance.getProcessDefinitionId(), (Matcher)CoreMatchers.notNullValue());
        MatcherAssert.assertThat((Object)historicProcessInstance.getDurationInMillis(), (Matcher)CoreMatchers.notNullValue());
        MatcherAssert.assertThat((Object)historicProcessInstance.getStartTime(), (Matcher)CoreMatchers.notNullValue());
        MatcherAssert.assertThat((Object)historicProcessInstance.getEndTime(), (Matcher)CoreMatchers.notNullValue());
    }
}

