/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.bpmn.async;

import java.util.HashMap;
import org.camunda.bpm.engine.impl.persistence.entity.ExecutionEntity;
import org.camunda.bpm.engine.runtime.ActivityInstance;
import org.camunda.bpm.engine.runtime.ProcessInstance;
import org.camunda.bpm.engine.task.Task;
import org.camunda.bpm.engine.test.Deployment;
import org.camunda.bpm.engine.test.util.ActivityInstanceAssert;
import org.camunda.bpm.engine.test.util.PluggableProcessEngineTest;
import org.junit.Assert;
import org.junit.Test;

public class AsyncStartEventTest
extends PluggableProcessEngineTest {
    @Deployment
    @Test
    public void testAsyncStartEvent() {
        this.runtimeService.startProcessInstanceByKey("asyncStartEvent");
        Task task = (Task)this.taskService.createTaskQuery().singleResult();
        Assert.assertNull((String)"The user task should not have been reached yet", (Object)task);
        Assert.assertEquals((long)1L, (long)this.runtimeService.createExecutionQuery().activityId("startEvent").count());
        this.testRule.executeAvailableJobs();
        task = (Task)this.taskService.createTaskQuery().singleResult();
        Assert.assertEquals((long)0L, (long)this.runtimeService.createExecutionQuery().activityId("startEvent").count());
        Assert.assertNotNull((String)"The user task should have been reached", (Object)task);
    }

    @Deployment
    @Test
    public void testAsyncStartEventListeners() {
        ProcessInstance instance = this.runtimeService.startProcessInstanceByKey("asyncStartEvent");
        Assert.assertNull((Object)this.runtimeService.getVariable(instance.getId(), "listener"));
        this.testRule.executeAvailableJobs();
        Assert.assertNotNull((Object)this.runtimeService.getVariable(instance.getId(), "listener"));
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/async/AsyncStartEventTest.testAsyncStartEvent.bpmn20.xml"})
    @Test
    public void testAsyncStartEventActivityInstance() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("asyncStartEvent");
        ActivityInstance tree = this.runtimeService.getActivityInstance(processInstance.getId());
        ActivityInstanceAssert.assertThat(tree).hasStructure(ActivityInstanceAssert.describeActivityInstanceTree(processInstance.getProcessDefinitionId()).transition("startEvent").done());
    }

    @Deployment
    @Test
    public void testMultipleAsyncStartEvents() {
        HashMap<String, String> variables = new HashMap<String, String>();
        variables.put("foo", "bar");
        this.runtimeService.correlateMessage("newInvoiceMessage", new HashMap(), variables);
        Assert.assertEquals((long)1L, (long)this.runtimeService.createProcessInstanceQuery().count());
        this.testRule.executeAvailableJobs();
        Task task = (Task)this.taskService.createTaskQuery().singleResult();
        Assert.assertNotNull((Object)task);
        Assert.assertEquals((Object)"taskAfterMessageStartEvent", (Object)task.getTaskDefinitionKey());
        this.taskService.complete(task.getId());
        Assert.assertEquals((long)0L, (long)this.runtimeService.createProcessInstanceQuery().count());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/async/AsyncStartEventTest.testCallActivity-super.bpmn20.xml", "org/camunda/bpm/engine/test/bpmn/async/AsyncStartEventTest.testCallActivity-sub.bpmn20.xml"})
    @Test
    public void testCallActivity() {
        this.runtimeService.startProcessInstanceByKey("super");
        ProcessInstance pi = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().processDefinitionKey("sub").singleResult();
        Assert.assertTrue((boolean)(pi instanceof ExecutionEntity));
        Assert.assertEquals((Object)"theSubStart", (Object)((ExecutionEntity)pi).getActivityId());
    }

    @Deployment
    @Test
    public void testAsyncSubProcessStartEvent() {
        this.runtimeService.startProcessInstanceByKey("process");
        Task task = (Task)this.taskService.createTaskQuery().singleResult();
        Assert.assertNull((String)"The subprocess user task should not have been reached yet", (Object)task);
        Assert.assertEquals((long)1L, (long)this.runtimeService.createExecutionQuery().activityId("StartEvent_2").count());
        this.testRule.executeAvailableJobs();
        task = (Task)this.taskService.createTaskQuery().singleResult();
        Assert.assertEquals((long)0L, (long)this.runtimeService.createExecutionQuery().activityId("StartEvent_2").count());
        Assert.assertNotNull((String)"The subprocess user task should have been reached", (Object)task);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/async/AsyncStartEventTest.testAsyncSubProcessStartEvent.bpmn"})
    @Test
    public void testAsyncSubProcessStartEventActivityInstance() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("process");
        ActivityInstance tree = this.runtimeService.getActivityInstance(processInstance.getId());
        ActivityInstanceAssert.assertThat(tree).hasStructure(ActivityInstanceAssert.describeActivityInstanceTree(processInstance.getProcessDefinitionId()).beginScope("SubProcess_1").transition("StartEvent_2").done());
    }
}

