/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.concurrency;

import java.util.ArrayList;
import java.util.List;
import org.camunda.bpm.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.camunda.bpm.engine.impl.interceptor.Command;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;

public abstract class ConcurrencyTestHelper {
    protected ProcessEngineConfigurationImpl processEngineConfiguration;
    protected List<ControllableCommand<?>> controllableCommands;

    @Before
    public void init() {
        this.controllableCommands = new ArrayList();
    }

    @After
    public void cleanUp() throws Exception {
        for (ControllableCommand<?> controllableCommand : this.controllableCommands) {
            ThreadControl threadControl = controllableCommand.monitor;
            threadControl.executingThread.interrupt();
            threadControl.executingThread.join();
        }
        Thread.interrupted();
    }

    protected ThreadControl executeControllableCommand(ControllableCommand<?> command) {
        Thread controlThread = Thread.currentThread();
        Thread thread = new Thread(() -> {
            try {
                this.processEngineConfiguration.getCommandExecutorTxRequiresNew().execute((Command)command);
            }
            catch (RuntimeException e) {
                command.monitor.setException(e);
                controlThread.interrupt();
                throw e;
            }
        });
        this.controllableCommands.add(command);
        command.monitor.executingThread = thread;
        thread.start();
        return command.monitor;
    }

    public static class ThreadControl {
        protected volatile boolean syncAvailable = false;
        protected Thread executingThread;
        protected volatile boolean reportFailure;
        protected volatile Exception exception;
        protected boolean ignoreSync = false;

        public ThreadControl() {
        }

        public ThreadControl(Thread executingThread) {
            this.executingThread = executingThread;
        }

        public void waitForSync() {
            this.waitForSync(Long.MAX_VALUE);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void waitForSync(long timeout) {
            ThreadControl threadControl = this;
            synchronized (threadControl) {
                if (this.exception != null) {
                    if (this.reportFailure) {
                        return;
                    }
                    Assert.fail();
                }
                try {
                    if (!this.syncAvailable) {
                        try {
                            this.wait(timeout);
                        }
                        catch (InterruptedException e) {
                            if (!this.reportFailure || this.exception == null) {
                                Assert.fail((String)"unexpected interruption");
                            }
                        }
                    }
                }
                finally {
                    this.syncAvailable = false;
                }
            }
        }

        public void waitUntilDone() {
            this.waitUntilDone(false);
        }

        public void waitUntilDone(boolean ignoreUpcomingSyncs) {
            this.ignoreSync = ignoreUpcomingSyncs;
            this.makeContinue();
            this.join();
        }

        public void join() {
            try {
                this.executingThread.join();
            }
            catch (InterruptedException e) {
                if (!this.reportFailure || this.exception == null) {
                    Assert.fail((String)"Unexpected interruption");
                }
            }
            finally {
                Thread.interrupted();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void sync() {
            ThreadControl threadControl = this;
            synchronized (threadControl) {
                block6: {
                    if (this.ignoreSync) {
                        return;
                    }
                    this.syncAvailable = true;
                    try {
                        this.notifyAll();
                        this.wait();
                    }
                    catch (InterruptedException e) {
                        if (this.reportFailure && this.exception != null) break block6;
                        Assert.fail((String)"Unexpected interruption");
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void makeContinue() {
            ThreadControl threadControl = this;
            synchronized (threadControl) {
                if (this.exception != null) {
                    Assert.fail();
                }
                this.notifyAll();
            }
        }

        public void makeContinueAndWaitForSync() {
            this.makeContinue();
            this.waitForSync();
        }

        public void reportInterrupts() {
            this.reportFailure = true;
        }

        public void ignoreFutureSyncs() {
            this.ignoreSync = true;
        }

        public synchronized void setException(Exception e) {
            this.exception = e;
        }

        public Throwable getException() {
            return this.exception;
        }
    }

    public static abstract class ControllableCommand<T>
    implements Command<T> {
        protected final ThreadControl monitor;

        public ControllableCommand() {
            this.monitor = new ThreadControl();
        }

        public ControllableCommand(ThreadControl threadControl) {
            this.monitor = threadControl;
        }
    }
}

