/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.history.useroperationlog;

import java.util.List;
import org.camunda.bpm.application.impl.EmbeddedProcessApplication;
import org.camunda.bpm.engine.history.UserOperationLogEntry;
import org.camunda.bpm.engine.history.UserOperationLogQuery;
import org.camunda.bpm.engine.repository.Deployment;
import org.camunda.bpm.engine.repository.ProcessApplicationDeployment;
import org.camunda.bpm.engine.repository.ProcessDefinition;
import org.camunda.bpm.engine.test.history.useroperationlog.AbstractUserOperationLogTest;
import org.camunda.bpm.model.bpmn.Bpmn;
import org.camunda.bpm.model.bpmn.BpmnModelInstance;
import org.camunda.bpm.model.bpmn.builder.ServiceTaskBuilder;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;

public class UserOperationLogDeploymentTest
extends AbstractUserOperationLogTest {
    protected static final String DEPLOYMENT_NAME = "my-deployment";
    protected static final String RESOURCE_NAME = "path/to/my/process.bpmn";
    protected static final String PROCESS_KEY = "process";

    @After
    public void tearDown() throws Exception {
        List deployments = this.repositoryService.createDeploymentQuery().list();
        for (Deployment deployment : deployments) {
            this.repositoryService.deleteDeployment(deployment.getId(), true, true);
        }
    }

    @Test
    public void testCreateDeployment() {
        Deployment deployment = this.repositoryService.createDeployment().name(DEPLOYMENT_NAME).addModelInstance(RESOURCE_NAME, this.createProcessWithServiceTask(PROCESS_KEY)).deploy();
        UserOperationLogEntry userOperationLogEntry = (UserOperationLogEntry)this.historyService.createUserOperationLogQuery().singleResult();
        Assert.assertNotNull((Object)userOperationLogEntry);
        Assert.assertEquals((Object)"Deployment", (Object)userOperationLogEntry.getEntityType());
        Assert.assertEquals((Object)deployment.getId(), (Object)userOperationLogEntry.getDeploymentId());
        Assert.assertEquals((Object)"Create", (Object)userOperationLogEntry.getOperationType());
        Assert.assertEquals((Object)"duplicateFilterEnabled", (Object)userOperationLogEntry.getProperty());
        Assert.assertNull((Object)userOperationLogEntry.getOrgValue());
        Assert.assertFalse((boolean)Boolean.valueOf(userOperationLogEntry.getNewValue()));
        Assert.assertEquals((Object)"demo", (Object)userOperationLogEntry.getUserId());
        Assert.assertEquals((Object)"Operator", (Object)userOperationLogEntry.getCategory());
        Assert.assertNull((Object)userOperationLogEntry.getJobDefinitionId());
        Assert.assertNull((Object)userOperationLogEntry.getProcessInstanceId());
        Assert.assertNull((Object)userOperationLogEntry.getProcessDefinitionId());
        Assert.assertNull((Object)userOperationLogEntry.getProcessDefinitionKey());
        Assert.assertNull((Object)userOperationLogEntry.getCaseInstanceId());
        Assert.assertNull((Object)userOperationLogEntry.getCaseDefinitionId());
    }

    @Test
    public void testCreateDeploymentPa() {
        EmbeddedProcessApplication application = new EmbeddedProcessApplication();
        ProcessApplicationDeployment deployment = this.repositoryService.createDeployment(application.getReference()).name(DEPLOYMENT_NAME).addModelInstance(RESOURCE_NAME, this.createProcessWithServiceTask(PROCESS_KEY)).deploy();
        UserOperationLogEntry userOperationLogEntry = (UserOperationLogEntry)this.historyService.createUserOperationLogQuery().singleResult();
        Assert.assertNotNull((Object)userOperationLogEntry);
        Assert.assertEquals((Object)"Deployment", (Object)userOperationLogEntry.getEntityType());
        Assert.assertEquals((Object)deployment.getId(), (Object)userOperationLogEntry.getDeploymentId());
        Assert.assertEquals((Object)"Create", (Object)userOperationLogEntry.getOperationType());
        Assert.assertEquals((Object)"duplicateFilterEnabled", (Object)userOperationLogEntry.getProperty());
        Assert.assertNull((Object)userOperationLogEntry.getOrgValue());
        Assert.assertFalse((boolean)Boolean.valueOf(userOperationLogEntry.getNewValue()));
        Assert.assertEquals((Object)"demo", (Object)userOperationLogEntry.getUserId());
        Assert.assertEquals((Object)"Operator", (Object)userOperationLogEntry.getCategory());
        Assert.assertNull((Object)userOperationLogEntry.getJobDefinitionId());
        Assert.assertNull((Object)userOperationLogEntry.getProcessInstanceId());
        Assert.assertNull((Object)userOperationLogEntry.getProcessDefinitionId());
        Assert.assertNull((Object)userOperationLogEntry.getProcessDefinitionKey());
        Assert.assertNull((Object)userOperationLogEntry.getCaseInstanceId());
        Assert.assertNull((Object)userOperationLogEntry.getCaseDefinitionId());
    }

    @Test
    public void testPropertyDuplicateFiltering() {
        BpmnModelInstance model = this.createProcessWithServiceTask(PROCESS_KEY);
        Deployment deployment = this.repositoryService.createDeployment().name(DEPLOYMENT_NAME).addModelInstance(RESOURCE_NAME, model).enableDuplicateFiltering(false).deploy();
        UserOperationLogQuery query = this.historyService.createUserOperationLogQuery();
        Assert.assertEquals((long)2L, (long)query.count());
        UserOperationLogEntry logDuplicateFilterEnabledProperty = (UserOperationLogEntry)query.property("duplicateFilterEnabled").singleResult();
        Assert.assertNotNull((Object)logDuplicateFilterEnabledProperty);
        Assert.assertEquals((Object)"Deployment", (Object)logDuplicateFilterEnabledProperty.getEntityType());
        Assert.assertEquals((Object)deployment.getId(), (Object)logDuplicateFilterEnabledProperty.getDeploymentId());
        Assert.assertEquals((Object)"Create", (Object)logDuplicateFilterEnabledProperty.getOperationType());
        Assert.assertEquals((Object)"demo", (Object)logDuplicateFilterEnabledProperty.getUserId());
        Assert.assertEquals((Object)"Operator", (Object)logDuplicateFilterEnabledProperty.getCategory());
        Assert.assertEquals((Object)"duplicateFilterEnabled", (Object)logDuplicateFilterEnabledProperty.getProperty());
        Assert.assertNull((Object)logDuplicateFilterEnabledProperty.getOrgValue());
        Assert.assertTrue((boolean)Boolean.valueOf(logDuplicateFilterEnabledProperty.getNewValue()));
        UserOperationLogEntry logDeployChangedOnlyProperty = (UserOperationLogEntry)query.property("deployChangedOnly").singleResult();
        Assert.assertNotNull((Object)logDeployChangedOnlyProperty);
        Assert.assertEquals((Object)"Deployment", (Object)logDeployChangedOnlyProperty.getEntityType());
        Assert.assertEquals((Object)deployment.getId(), (Object)logDeployChangedOnlyProperty.getDeploymentId());
        Assert.assertEquals((Object)"Create", (Object)logDeployChangedOnlyProperty.getOperationType());
        Assert.assertEquals((Object)"demo", (Object)logDeployChangedOnlyProperty.getUserId());
        Assert.assertEquals((Object)"Operator", (Object)logDeployChangedOnlyProperty.getCategory());
        Assert.assertEquals((Object)"deployChangedOnly", (Object)logDeployChangedOnlyProperty.getProperty());
        Assert.assertNull((Object)logDeployChangedOnlyProperty.getOrgValue());
        Assert.assertFalse((boolean)Boolean.valueOf(logDeployChangedOnlyProperty.getNewValue()));
        Assert.assertEquals((Object)logDuplicateFilterEnabledProperty.getOperationId(), (Object)logDeployChangedOnlyProperty.getOperationId());
    }

    @Test
    public void testPropertiesDuplicateFilteringAndDeployChangedOnly() {
        BpmnModelInstance model = this.createProcessWithServiceTask(PROCESS_KEY);
        Deployment deployment = this.repositoryService.createDeployment().name(DEPLOYMENT_NAME).addModelInstance(RESOURCE_NAME, model).enableDuplicateFiltering(true).deploy();
        UserOperationLogQuery query = this.historyService.createUserOperationLogQuery();
        Assert.assertEquals((long)2L, (long)query.count());
        UserOperationLogEntry logDuplicateFilterEnabledProperty = (UserOperationLogEntry)query.property("duplicateFilterEnabled").singleResult();
        Assert.assertNotNull((Object)logDuplicateFilterEnabledProperty);
        Assert.assertEquals((Object)"Deployment", (Object)logDuplicateFilterEnabledProperty.getEntityType());
        Assert.assertEquals((Object)deployment.getId(), (Object)logDuplicateFilterEnabledProperty.getDeploymentId());
        Assert.assertEquals((Object)"Create", (Object)logDuplicateFilterEnabledProperty.getOperationType());
        Assert.assertEquals((Object)"demo", (Object)logDuplicateFilterEnabledProperty.getUserId());
        Assert.assertEquals((Object)"Operator", (Object)logDuplicateFilterEnabledProperty.getCategory());
        Assert.assertEquals((Object)"duplicateFilterEnabled", (Object)logDuplicateFilterEnabledProperty.getProperty());
        Assert.assertNull((Object)logDuplicateFilterEnabledProperty.getOrgValue());
        Assert.assertTrue((boolean)Boolean.valueOf(logDuplicateFilterEnabledProperty.getNewValue()));
        UserOperationLogEntry logDeployChangedOnlyProperty = (UserOperationLogEntry)query.property("deployChangedOnly").singleResult();
        Assert.assertNotNull((Object)logDeployChangedOnlyProperty);
        Assert.assertEquals((Object)"Deployment", (Object)logDeployChangedOnlyProperty.getEntityType());
        Assert.assertEquals((Object)deployment.getId(), (Object)logDeployChangedOnlyProperty.getDeploymentId());
        Assert.assertEquals((Object)"Create", (Object)logDeployChangedOnlyProperty.getOperationType());
        Assert.assertEquals((Object)"demo", (Object)logDeployChangedOnlyProperty.getUserId());
        Assert.assertEquals((Object)"Operator", (Object)logDeployChangedOnlyProperty.getCategory());
        Assert.assertEquals((Object)"deployChangedOnly", (Object)logDeployChangedOnlyProperty.getProperty());
        Assert.assertNull((Object)logDeployChangedOnlyProperty.getOrgValue());
        Assert.assertTrue((boolean)Boolean.valueOf(logDeployChangedOnlyProperty.getNewValue()));
        Assert.assertEquals((Object)logDuplicateFilterEnabledProperty.getOperationId(), (Object)logDeployChangedOnlyProperty.getOperationId());
    }

    @Test
    public void testDeleteDeploymentCascadingShouldKeepCreateUserOperationLog() {
        Deployment deployment = this.repositoryService.createDeployment().name(DEPLOYMENT_NAME).addModelInstance(RESOURCE_NAME, this.createProcessWithServiceTask(PROCESS_KEY)).deploy();
        UserOperationLogQuery query = this.historyService.createUserOperationLogQuery().operationType("Create");
        Assert.assertEquals((long)1L, (long)query.count());
        this.repositoryService.deleteDeployment(deployment.getId(), true);
        Assert.assertEquals((long)1L, (long)query.count());
    }

    @Test
    public void testDeleteDeploymentWithoutCascadingShouldKeepCreateUserOperationLog() {
        Deployment deployment = this.repositoryService.createDeployment().name(DEPLOYMENT_NAME).addModelInstance(RESOURCE_NAME, this.createProcessWithServiceTask(PROCESS_KEY)).deploy();
        UserOperationLogQuery query = this.historyService.createUserOperationLogQuery().operationType("Create");
        Assert.assertEquals((long)1L, (long)query.count());
        this.repositoryService.deleteDeployment(deployment.getId(), false);
        Assert.assertEquals((long)1L, (long)query.count());
    }

    @Test
    public void testDeleteDeployment() {
        Deployment deployment = this.repositoryService.createDeployment().name(DEPLOYMENT_NAME).addModelInstance(RESOURCE_NAME, this.createProcessWithServiceTask(PROCESS_KEY)).deploy();
        UserOperationLogQuery query = this.historyService.createUserOperationLogQuery().operationType("Delete");
        this.repositoryService.deleteDeployment(deployment.getId(), false);
        Assert.assertEquals((long)1L, (long)query.count());
        UserOperationLogEntry log = (UserOperationLogEntry)query.singleResult();
        Assert.assertNotNull((Object)log);
        Assert.assertEquals((Object)"Deployment", (Object)log.getEntityType());
        Assert.assertEquals((Object)deployment.getId(), (Object)log.getDeploymentId());
        Assert.assertEquals((Object)"Delete", (Object)log.getOperationType());
        Assert.assertEquals((Object)"cascade", (Object)log.getProperty());
        Assert.assertNull((Object)log.getOrgValue());
        Assert.assertFalse((boolean)Boolean.valueOf(log.getNewValue()));
        Assert.assertEquals((Object)"demo", (Object)log.getUserId());
        Assert.assertEquals((Object)"Operator", (Object)log.getCategory());
        Assert.assertNull((Object)log.getJobDefinitionId());
        Assert.assertNull((Object)log.getProcessInstanceId());
        Assert.assertNull((Object)log.getProcessDefinitionId());
        Assert.assertNull((Object)log.getProcessDefinitionKey());
        Assert.assertNull((Object)log.getCaseInstanceId());
        Assert.assertNull((Object)log.getCaseDefinitionId());
    }

    @Test
    public void testDeleteDeploymentCascading() {
        Deployment deployment = this.repositoryService.createDeployment().name(DEPLOYMENT_NAME).addModelInstance(RESOURCE_NAME, this.createProcessWithServiceTask(PROCESS_KEY)).deploy();
        UserOperationLogQuery query = this.historyService.createUserOperationLogQuery().operationType("Delete");
        this.repositoryService.deleteDeployment(deployment.getId(), true);
        Assert.assertEquals((long)1L, (long)query.count());
        UserOperationLogEntry log = (UserOperationLogEntry)query.singleResult();
        Assert.assertNotNull((Object)log);
        Assert.assertEquals((Object)"Deployment", (Object)log.getEntityType());
        Assert.assertEquals((Object)deployment.getId(), (Object)log.getDeploymentId());
        Assert.assertEquals((Object)"Delete", (Object)log.getOperationType());
        Assert.assertEquals((Object)"cascade", (Object)log.getProperty());
        Assert.assertNull((Object)log.getOrgValue());
        Assert.assertTrue((boolean)Boolean.valueOf(log.getNewValue()));
        Assert.assertEquals((Object)"demo", (Object)log.getUserId());
        Assert.assertEquals((Object)"Operator", (Object)log.getCategory());
        Assert.assertNull((Object)log.getJobDefinitionId());
        Assert.assertNull((Object)log.getProcessInstanceId());
        Assert.assertNull((Object)log.getProcessDefinitionId());
        Assert.assertNull((Object)log.getProcessDefinitionKey());
        Assert.assertNull((Object)log.getCaseInstanceId());
        Assert.assertNull((Object)log.getCaseDefinitionId());
    }

    @Test
    public void testDeleteProcessDefinitionCascadingShouldKeepCreateUserOperationLog() {
        Deployment deployment = this.repositoryService.createDeployment().name(DEPLOYMENT_NAME).addModelInstance(RESOURCE_NAME, this.createProcessWithServiceTask(PROCESS_KEY)).deploy();
        ProcessDefinition procDef = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().deploymentId(deployment.getId()).singleResult();
        UserOperationLogQuery query = this.historyService.createUserOperationLogQuery().operationType("Create");
        Assert.assertEquals((long)1L, (long)query.count());
        this.repositoryService.deleteProcessDefinition(procDef.getId(), true);
        Assert.assertEquals((long)1L, (long)query.count());
    }

    @Test
    public void testDeleteProcessDefinitiontWithoutCascadingShouldKeepCreateUserOperationLog() {
        Deployment deployment = this.repositoryService.createDeployment().name(DEPLOYMENT_NAME).addModelInstance(RESOURCE_NAME, this.createProcessWithServiceTask(PROCESS_KEY)).deploy();
        ProcessDefinition procDef = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().deploymentId(deployment.getId()).singleResult();
        UserOperationLogQuery query = this.historyService.createUserOperationLogQuery().operationType("Create");
        Assert.assertEquals((long)1L, (long)query.count());
        this.repositoryService.deleteProcessDefinition(procDef.getId());
        Assert.assertEquals((long)1L, (long)query.count());
    }

    @Test
    public void testDeleteProcessDefinition() {
        Deployment deployment = this.repositoryService.createDeployment().name(DEPLOYMENT_NAME).addModelInstance(RESOURCE_NAME, this.createProcessWithServiceTask(PROCESS_KEY)).deploy();
        ProcessDefinition procDef = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().deploymentId(deployment.getId()).singleResult();
        UserOperationLogQuery query = this.historyService.createUserOperationLogQuery().operationType("Delete");
        this.repositoryService.deleteProcessDefinition(procDef.getId(), false);
        Assert.assertEquals((long)1L, (long)query.count());
        UserOperationLogEntry log = (UserOperationLogEntry)query.singleResult();
        Assert.assertNotNull((Object)log);
        Assert.assertEquals((Object)"ProcessDefinition", (Object)log.getEntityType());
        Assert.assertEquals((Object)procDef.getId(), (Object)log.getProcessDefinitionId());
        Assert.assertEquals((Object)procDef.getKey(), (Object)log.getProcessDefinitionKey());
        Assert.assertEquals((Object)deployment.getId(), (Object)log.getDeploymentId());
        Assert.assertEquals((Object)"Delete", (Object)log.getOperationType());
        Assert.assertEquals((Object)"cascade", (Object)log.getProperty());
        Assert.assertFalse((boolean)Boolean.valueOf(log.getOrgValue()));
        Assert.assertFalse((boolean)Boolean.valueOf(log.getNewValue()));
        Assert.assertEquals((Object)"demo", (Object)log.getUserId());
        Assert.assertEquals((Object)"Operator", (Object)log.getCategory());
        Assert.assertNull((Object)log.getJobDefinitionId());
        Assert.assertNull((Object)log.getProcessInstanceId());
        Assert.assertNull((Object)log.getCaseInstanceId());
        Assert.assertNull((Object)log.getCaseDefinitionId());
    }

    @Test
    public void testDeleteProcessDefinitionCascading() {
        Deployment deployment = this.repositoryService.createDeployment().name(DEPLOYMENT_NAME).addModelInstance(RESOURCE_NAME, this.createProcessWithServiceTask(PROCESS_KEY)).deploy();
        ProcessDefinition procDef = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().deploymentId(deployment.getId()).singleResult();
        UserOperationLogQuery query = this.historyService.createUserOperationLogQuery().operationType("Delete");
        this.repositoryService.deleteProcessDefinition(procDef.getId(), true);
        Assert.assertEquals((long)1L, (long)query.count());
        UserOperationLogEntry log = (UserOperationLogEntry)query.singleResult();
        Assert.assertNotNull((Object)log);
        Assert.assertEquals((Object)"ProcessDefinition", (Object)log.getEntityType());
        Assert.assertEquals((Object)procDef.getId(), (Object)log.getProcessDefinitionId());
        Assert.assertEquals((Object)procDef.getKey(), (Object)log.getProcessDefinitionKey());
        Assert.assertEquals((Object)deployment.getId(), (Object)log.getDeploymentId());
        Assert.assertEquals((Object)"Delete", (Object)log.getOperationType());
        Assert.assertEquals((Object)"cascade", (Object)log.getProperty());
        Assert.assertFalse((boolean)Boolean.valueOf(log.getOrgValue()));
        Assert.assertTrue((boolean)Boolean.valueOf(log.getNewValue()));
        Assert.assertEquals((Object)"demo", (Object)log.getUserId());
        Assert.assertEquals((Object)"Operator", (Object)log.getCategory());
        Assert.assertNull((Object)log.getJobDefinitionId());
        Assert.assertNull((Object)log.getProcessInstanceId());
        Assert.assertNull((Object)log.getCaseInstanceId());
        Assert.assertNull((Object)log.getCaseDefinitionId());
    }

    protected BpmnModelInstance createProcessWithServiceTask(String key) {
        return ((ServiceTaskBuilder)Bpmn.createExecutableProcess((String)key).startEvent().serviceTask().camundaExpression("${true}")).endEvent().done();
    }
}

