/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.jobexecutor;

import java.util.List;
import org.camunda.bpm.engine.impl.persistence.entity.AcquirableJobEntity;
import org.camunda.bpm.engine.impl.util.ClockUtil;
import org.camunda.bpm.engine.runtime.Job;
import org.camunda.bpm.engine.runtime.ProcessInstance;
import org.camunda.bpm.engine.test.Deployment;
import org.camunda.bpm.engine.test.jobexecutor.AbstractJobExecutorAcquireJobsTest;
import org.camunda.bpm.engine.test.util.ClockTestUtil;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class JobExecutorAcquireJobsByTypeAndDueDateTest
extends AbstractJobExecutorAcquireJobsTest {
    @Before
    public void prepareProcessEngineConfiguration() {
        this.configuration.setJobExecutorPreferTimerJobs(true);
        this.configuration.setJobExecutorAcquireByDueDate(true);
    }

    @Test
    public void testProcessEngineConfiguration() {
        Assert.assertTrue((boolean)this.configuration.isJobExecutorPreferTimerJobs());
        Assert.assertTrue((boolean)this.configuration.isJobExecutorAcquireByDueDate());
        Assert.assertFalse((boolean)this.configuration.isJobExecutorAcquireByPriority());
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/jobexecutor/simpleAsyncProcess.bpmn20.xml"})
    public void testMessageJobHasDueDateSet() {
        this.runtimeService.startProcessInstanceByKey("simpleAsyncProcess");
        Job job = (Job)this.managementService.createJobQuery().singleResult();
        Assert.assertNotNull((Object)job.getDuedate());
        Assert.assertEquals((Object)ClockUtil.getCurrentTime(), (Object)job.getDuedate());
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/jobexecutor/simpleAsyncProcess.bpmn20.xml", "org/camunda/bpm/engine/test/jobexecutor/processWithTimerCatch.bpmn20.xml"})
    public void testTimerAndOldJobsArePreferred() {
        ProcessInstance timerProcess1 = this.runtimeService.startProcessInstanceByKey("testProcess");
        ClockTestUtil.incrementClock(1L);
        ProcessInstance asyncProcess1 = this.runtimeService.startProcessInstanceByKey("simpleAsyncProcess");
        ClockTestUtil.incrementClock(1L);
        ProcessInstance timerProcess2 = this.runtimeService.startProcessInstanceByKey("testProcess");
        ClockTestUtil.incrementClock(61L);
        ProcessInstance asyncProcess2 = this.runtimeService.startProcessInstanceByKey("simpleAsyncProcess");
        Job timerJob1 = (Job)this.managementService.createJobQuery().processInstanceId(timerProcess1.getId()).singleResult();
        Job timerJob2 = (Job)this.managementService.createJobQuery().processInstanceId(timerProcess2.getId()).singleResult();
        Job messageJob1 = (Job)this.managementService.createJobQuery().processInstanceId(asyncProcess1.getId()).singleResult();
        Job messageJob2 = (Job)this.managementService.createJobQuery().processInstanceId(asyncProcess2.getId()).singleResult();
        Assert.assertNotNull((Object)timerJob1.getDuedate());
        Assert.assertNotNull((Object)timerJob2.getDuedate());
        Assert.assertNotNull((Object)messageJob1.getDuedate());
        Assert.assertNotNull((Object)messageJob2.getDuedate());
        Assert.assertTrue((boolean)messageJob1.getDuedate().before(timerJob1.getDuedate()));
        Assert.assertTrue((boolean)timerJob1.getDuedate().before(timerJob2.getDuedate()));
        Assert.assertTrue((boolean)timerJob2.getDuedate().before(messageJob2.getDuedate()));
        List<AcquirableJobEntity> acquirableJobs = this.findAcquirableJobs();
        Assert.assertEquals((long)4L, (long)acquirableJobs.size());
        Assert.assertEquals((Object)timerJob1.getId(), (Object)acquirableJobs.get(0).getId());
        Assert.assertEquals((Object)timerJob2.getId(), (Object)acquirableJobs.get(1).getId());
        Assert.assertEquals((Object)messageJob1.getId(), (Object)acquirableJobs.get(2).getId());
        Assert.assertEquals((Object)messageJob2.getId(), (Object)acquirableJobs.get(3).getId());
    }
}

