/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.standalone.history;

import java.util.Arrays;
import java.util.Collections;
import java.util.UUID;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.impl.ProcessEngineImpl;
import org.camunda.bpm.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.camunda.bpm.engine.impl.cfg.StandaloneInMemProcessEngineConfiguration;
import org.camunda.bpm.engine.impl.cmd.DetermineHistoryLevelCmd;
import org.camunda.bpm.engine.impl.history.HistoryLevel;
import org.camunda.bpm.engine.impl.history.event.HistoryEventType;
import org.camunda.bpm.engine.impl.interceptor.Command;
import org.junit.After;
import org.junit.Test;

public class DetermineHistoryLevelCmdTest {
    private ProcessEngineImpl processEngineImpl;

    private static ProcessEngineConfigurationImpl config(String historyLevel) {
        return DetermineHistoryLevelCmdTest.config("false", historyLevel);
    }

    private static ProcessEngineConfigurationImpl config(String schemaUpdate, String historyLevel) {
        StandaloneInMemProcessEngineConfiguration engineConfiguration = new StandaloneInMemProcessEngineConfiguration();
        engineConfiguration.setProcessEngineName(UUID.randomUUID().toString());
        engineConfiguration.setDatabaseSchemaUpdate(schemaUpdate);
        engineConfiguration.setHistory(historyLevel);
        engineConfiguration.setDbMetricsReporterActivate(false);
        engineConfiguration.setJdbcUrl("jdbc:h2:mem:DatabaseHistoryPropertyAutoTest");
        return engineConfiguration;
    }

    @Test
    public void readLevelFullfromDB() throws Exception {
        ProcessEngineConfigurationImpl config = DetermineHistoryLevelCmdTest.config("true", "full");
        this.processEngineImpl = (ProcessEngineImpl)config.buildProcessEngine();
        HistoryLevel historyLevel = (HistoryLevel)config.getCommandExecutorSchemaOperations().execute((Command)new DetermineHistoryLevelCmd(config.getHistoryLevels()));
        Assertions.assertThat((Object)historyLevel).isEqualTo((Object)HistoryLevel.HISTORY_LEVEL_FULL);
    }

    @Test
    public void useDefaultLevelAudit() throws Exception {
        ProcessEngineConfigurationImpl config = DetermineHistoryLevelCmdTest.config("true", "auto");
        this.processEngineImpl = (ProcessEngineImpl)config.buildProcessEngine();
        Assertions.assertThat((Object)config.getHistoryLevel()).isEqualTo((Object)HistoryLevel.HISTORY_LEVEL_AUDIT);
        HistoryLevel databaseLevel = (HistoryLevel)config.getCommandExecutorSchemaOperations().execute((Command)new DetermineHistoryLevelCmd(config.getHistoryLevels()));
        Assertions.assertThat((Object)databaseLevel).isEqualTo((Object)HistoryLevel.HISTORY_LEVEL_AUDIT);
    }

    @Test
    public void failWhenExistingHistoryLevelIsNotRegistered() {
        HistoryLevel customLevel = new HistoryLevel(){

            public int getId() {
                return 99;
            }

            public String getName() {
                return "custom";
            }

            public boolean isHistoryEventProduced(HistoryEventType eventType, Object entity) {
                return false;
            }
        };
        ProcessEngineConfigurationImpl config = DetermineHistoryLevelCmdTest.config("true", "custom");
        config.setCustomHistoryLevels(Arrays.asList(customLevel));
        this.processEngineImpl = (ProcessEngineImpl)config.buildProcessEngine();
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> {
            HistoryLevel cfr_ignored_0 = (HistoryLevel)config.getCommandExecutorSchemaOperations().execute((Command)new DetermineHistoryLevelCmd(Collections.emptyList()));
        }).isInstanceOf(ProcessEngineException.class)).hasMessageContaining("The configured history level with id='99' is not registered in this config.");
    }

    @After
    public void after() {
        this.processEngineImpl.close();
        this.processEngineImpl = null;
    }
}

