/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.cmd;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.camunda.bpm.engine.AuthorizationException;
import org.camunda.bpm.engine.impl.ProcessEngineLogger;
import org.camunda.bpm.engine.impl.bpmn.behavior.CallActivityBehavior;
import org.camunda.bpm.engine.impl.cfg.CommandChecker;
import org.camunda.bpm.engine.impl.cmd.GetDeployedProcessDefinitionCmd;
import org.camunda.bpm.engine.impl.core.model.CallableElement;
import org.camunda.bpm.engine.impl.interceptor.Command;
import org.camunda.bpm.engine.impl.interceptor.CommandContext;
import org.camunda.bpm.engine.impl.persistence.entity.ProcessDefinitionEntity;
import org.camunda.bpm.engine.impl.pvm.process.ActivityImpl;
import org.camunda.bpm.engine.impl.repository.CalledProcessDefinitionImpl;
import org.camunda.bpm.engine.impl.util.CallableElementUtil;
import org.camunda.bpm.engine.repository.CalledProcessDefinition;
import org.camunda.bpm.engine.repository.ProcessDefinition;

public class GetStaticCalledProcessDefinitionCmd
implements Command<Collection<CalledProcessDefinition>> {
    protected String processDefinitionId;

    public GetStaticCalledProcessDefinitionCmd(String processDefinitionId) {
        this.processDefinitionId = processDefinitionId;
    }

    @Override
    public Collection<CalledProcessDefinition> execute(CommandContext commandContext) {
        ProcessDefinitionEntity processDefinition = new GetDeployedProcessDefinitionCmd(this.processDefinitionId, true).execute(commandContext);
        List<ActivityImpl> activities = processDefinition.getActivities();
        List callActivities = activities.stream().filter(act -> act.getActivityBehavior() instanceof CallActivityBehavior).collect(Collectors.toList());
        HashMap<String, CalledProcessDefinitionImpl> calledProcessDefinitionsById = new HashMap<String, CalledProcessDefinitionImpl>();
        for (ActivityImpl activity : callActivities) {
            String tenantId;
            CallActivityBehavior behavior = (CallActivityBehavior)activity.getActivityBehavior();
            CallableElement callableElement = behavior.getCallableElement();
            String activityId = activity.getActivityId();
            ProcessDefinition calledProcess = CallableElementUtil.getStaticallyBoundProcessDefinition(this.processDefinitionId, activityId, callableElement, tenantId = processDefinition.getTenantId());
            if (calledProcess == null) continue;
            if (!calledProcessDefinitionsById.containsKey(calledProcess.getId())) {
                try {
                    for (CommandChecker checker : commandContext.getProcessEngineConfiguration().getCommandCheckers()) {
                        checker.checkReadProcessDefinition(calledProcess);
                    }
                    CalledProcessDefinitionImpl result = new CalledProcessDefinitionImpl(calledProcess, this.processDefinitionId);
                    result.addCallingCallActivity(activityId);
                    calledProcessDefinitionsById.put(calledProcess.getId(), result);
                }
                catch (AuthorizationException e) {
                    ProcessEngineLogger.CMD_LOGGER.debugNotAllowedToResolveCalledProcess(calledProcess.getId(), this.processDefinitionId, activityId, e);
                }
                continue;
            }
            ((CalledProcessDefinitionImpl)calledProcessDefinitionsById.get(calledProcess.getId())).addCallingCallActivity(activityId);
        }
        return new ArrayList<CalledProcessDefinition>(calledProcessDefinitionsById.values());
    }
}

