/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.persistence.entity;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.camunda.bpm.engine.ProcessEngine;
import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.ProcessEngineServices;
import org.camunda.bpm.engine.delegate.BpmnError;
import org.camunda.bpm.engine.delegate.DelegateTask;
import org.camunda.bpm.engine.delegate.Expression;
import org.camunda.bpm.engine.delegate.TaskListener;
import org.camunda.bpm.engine.exception.NotFoundException;
import org.camunda.bpm.engine.exception.NullValueException;
import org.camunda.bpm.engine.impl.ProcessEngineLogger;
import org.camunda.bpm.engine.impl.bpmn.helper.BpmnExceptionHandler;
import org.camunda.bpm.engine.impl.bpmn.helper.ErrorPropagationException;
import org.camunda.bpm.engine.impl.bpmn.helper.EscalationHandler;
import org.camunda.bpm.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.camunda.bpm.engine.impl.cfg.auth.ResourceAuthorizationProvider;
import org.camunda.bpm.engine.impl.cmmn.entity.repository.CaseDefinitionEntity;
import org.camunda.bpm.engine.impl.cmmn.entity.runtime.CaseExecutionEntity;
import org.camunda.bpm.engine.impl.context.Context;
import org.camunda.bpm.engine.impl.core.instance.CoreExecution;
import org.camunda.bpm.engine.impl.core.variable.CoreVariableInstance;
import org.camunda.bpm.engine.impl.core.variable.event.VariableEvent;
import org.camunda.bpm.engine.impl.core.variable.scope.AbstractVariableScope;
import org.camunda.bpm.engine.impl.core.variable.scope.VariableInstanceFactory;
import org.camunda.bpm.engine.impl.core.variable.scope.VariableInstanceLifecycleListener;
import org.camunda.bpm.engine.impl.core.variable.scope.VariableStore;
import org.camunda.bpm.engine.impl.db.DbEntity;
import org.camunda.bpm.engine.impl.db.EnginePersistenceLogger;
import org.camunda.bpm.engine.impl.db.HasDbReferences;
import org.camunda.bpm.engine.impl.db.HasDbRevision;
import org.camunda.bpm.engine.impl.db.entitymanager.DbEntityManager;
import org.camunda.bpm.engine.impl.history.event.HistoryEventTypes;
import org.camunda.bpm.engine.impl.interceptor.CommandContext;
import org.camunda.bpm.engine.impl.interceptor.CommandContextListener;
import org.camunda.bpm.engine.impl.interceptor.CommandInvocationContext;
import org.camunda.bpm.engine.impl.persistence.entity.AuthorizationEntity;
import org.camunda.bpm.engine.impl.persistence.entity.ExecutionEntity;
import org.camunda.bpm.engine.impl.persistence.entity.IdentityLinkEntity;
import org.camunda.bpm.engine.impl.persistence.entity.ProcessDefinitionEntity;
import org.camunda.bpm.engine.impl.persistence.entity.PropertyChange;
import org.camunda.bpm.engine.impl.persistence.entity.SuspensionState;
import org.camunda.bpm.engine.impl.persistence.entity.TaskEntityReferencer;
import org.camunda.bpm.engine.impl.persistence.entity.TaskManager;
import org.camunda.bpm.engine.impl.persistence.entity.TaskMeterLogEntity;
import org.camunda.bpm.engine.impl.persistence.entity.VariableInstanceEntity;
import org.camunda.bpm.engine.impl.persistence.entity.VariableInstanceEntityFactory;
import org.camunda.bpm.engine.impl.persistence.entity.VariableInstanceEntityPersistenceListener;
import org.camunda.bpm.engine.impl.persistence.entity.VariableInstanceHistoryListener;
import org.camunda.bpm.engine.impl.persistence.entity.VariableInstanceSequenceCounterListener;
import org.camunda.bpm.engine.impl.pvm.delegate.ActivityExecution;
import org.camunda.bpm.engine.impl.pvm.runtime.PvmExecutionImpl;
import org.camunda.bpm.engine.impl.task.TaskDefinition;
import org.camunda.bpm.engine.impl.task.delegate.TaskListenerInvocation;
import org.camunda.bpm.engine.impl.util.ClockUtil;
import org.camunda.bpm.engine.impl.util.EnsureUtil;
import org.camunda.bpm.engine.task.DelegationState;
import org.camunda.bpm.engine.task.IdentityLink;
import org.camunda.bpm.engine.task.Task;
import org.camunda.bpm.model.bpmn.BpmnModelInstance;
import org.camunda.bpm.model.bpmn.instance.UserTask;
import org.camunda.bpm.model.xml.instance.ModelElementInstance;
import org.camunda.bpm.model.xml.type.ModelElementType;

public class TaskEntity
extends AbstractVariableScope
implements Task,
DelegateTask,
Serializable,
DbEntity,
HasDbRevision,
HasDbReferences,
CommandContextListener,
VariableStore.VariablesProvider<VariableInstanceEntity> {
    protected static final List<VariableInstanceLifecycleListener<CoreVariableInstance>> DEFAULT_VARIABLE_LIFECYCLE_LISTENERS = Arrays.asList(VariableInstanceEntityPersistenceListener.INSTANCE, VariableInstanceSequenceCounterListener.INSTANCE, VariableInstanceHistoryListener.INSTANCE);
    protected static final EnginePersistenceLogger LOG = ProcessEngineLogger.PERSISTENCE_LOGGER;
    public static final String DELETE_REASON_COMPLETED = "completed";
    public static final String DELETE_REASON_DELETED = "deleted";
    private static final long serialVersionUID = 1L;
    protected String id;
    protected int revision;
    protected String owner;
    protected String assignee;
    protected DelegationState delegationState;
    protected String parentTaskId;
    protected transient TaskEntity parentTask;
    protected String name;
    protected String description;
    protected int priority = 50;
    protected Date createTime;
    protected Date dueDate;
    protected Date followUpDate;
    protected int suspensionState = SuspensionState.ACTIVE.getStateCode();
    protected TaskState lifecycleState = TaskState.STATE_INIT;
    protected String tenantId;
    protected boolean isIdentityLinksInitialized = false;
    protected transient List<IdentityLinkEntity> taskIdentityLinkEntities = new ArrayList<IdentityLinkEntity>();
    protected String executionId;
    protected transient ExecutionEntity execution;
    protected String processInstanceId;
    protected transient ExecutionEntity processInstance;
    protected String processDefinitionId;
    protected String caseExecutionId;
    protected transient CaseExecutionEntity caseExecution;
    protected String caseInstanceId;
    protected String caseDefinitionId;
    protected transient TaskDefinition taskDefinition;
    protected String taskDefinitionKey;
    protected boolean isDeleted;
    protected String deleteReason;
    protected String eventName;
    protected boolean isFormKeyInitialized = false;
    protected String formKey;
    protected transient VariableStore<VariableInstanceEntity> variableStore = new VariableStore<VariableInstanceEntity>(this, new TaskEntityReferencer(this));
    protected transient boolean skipCustomListeners = false;
    protected transient Map<String, PropertyChange> propertyChanges = new HashMap<String, PropertyChange>();
    protected transient List<PropertyChange> identityLinkChanges = new ArrayList<PropertyChange>();
    protected List<VariableInstanceLifecycleListener<VariableInstanceEntity>> customLifecycleListeners;
    public static final String ASSIGNEE = "assignee";
    public static final String DELEGATION = "delegation";
    public static final String DELETE = "delete";
    public static final String DESCRIPTION = "description";
    public static final String DUE_DATE = "dueDate";
    public static final String FOLLOW_UP_DATE = "followUpDate";
    public static final String NAME = "name";
    public static final String OWNER = "owner";
    public static final String PARENT_TASK = "parentTask";
    public static final String PRIORITY = "priority";
    public static final String CASE_INSTANCE_ID = "caseInstanceId";

    public TaskEntity() {
        this.lifecycleState = TaskState.STATE_CREATED;
    }

    public TaskEntity(String id) {
        this(TaskState.STATE_INIT);
        this.id = id;
    }

    protected TaskEntity(TaskState initialState) {
        this.isIdentityLinksInitialized = true;
        this.setCreateTime(ClockUtil.getCurrentTime());
        this.lifecycleState = initialState;
    }

    public TaskEntity(ExecutionEntity execution) {
        this(TaskState.STATE_INIT);
        this.setExecution(execution);
        this.skipCustomListeners = execution.isSkipCustomListeners();
        this.setTenantId(execution.getTenantId());
        execution.addTask(this);
    }

    public TaskEntity(CaseExecutionEntity caseExecution) {
        this(TaskState.STATE_INIT);
        this.setCaseExecution(caseExecution);
    }

    public void insert() {
        CommandContext commandContext = Context.getCommandContext();
        TaskManager taskManager = commandContext.getTaskManager();
        taskManager.insertTask(this);
    }

    protected void propagateExecutionTenantId(ExecutionEntity execution) {
        if (execution != null) {
            this.setTenantId(execution.getTenantId());
        }
    }

    public void propagateParentTaskTenantId() {
        if (this.parentTaskId != null) {
            TaskEntity parentTask = Context.getCommandContext().getTaskManager().findTaskById(this.parentTaskId);
            if (this.tenantId != null && !this.tenantIdIsSame(parentTask)) {
                throw LOG.cannotSetDifferentTenantIdOnSubtask(this.parentTaskId, parentTask.getTenantId(), this.tenantId);
            }
            this.setTenantId(parentTask.getTenantId());
        }
    }

    public void update() {
        this.ensureTenantIdNotChanged();
        this.registerCommandContextCloseListener();
        CommandContext commandContext = Context.getCommandContext();
        DbEntityManager dbEntityManger = commandContext.getDbEntityManager();
        dbEntityManger.merge(this);
    }

    protected void ensureTenantIdNotChanged() {
        TaskEntity persistentTask = Context.getCommandContext().getTaskManager().findTaskById(this.id);
        if (persistentTask != null) {
            boolean changed;
            boolean bl = changed = !this.tenantIdIsSame(persistentTask);
            if (changed) {
                throw LOG.cannotChangeTenantIdOfTask(this.id, persistentTask.tenantId, this.tenantId);
            }
        }
    }

    protected boolean tenantIdIsSame(TaskEntity otherTask) {
        String otherTenantId = otherTask.getTenantId();
        if (otherTenantId == null) {
            return this.tenantId == null;
        }
        return otherTenantId.equals(this.tenantId);
    }

    @Override
    public void complete() {
        if (TaskState.STATE_COMPLETED.equals((Object)this.lifecycleState) || "complete".equals(this.eventName) || DELETE.equals(this.eventName)) {
            throw LOG.invokeTaskListenerException(new IllegalStateException("invalid task state"));
        }
        if (this.caseExecutionId != null) {
            this.getCaseExecution().manualComplete();
            return;
        }
        this.ensureTaskActive();
        boolean shouldDeleteTask = this.transitionTo(TaskState.STATE_COMPLETED);
        if (shouldDeleteTask) {
            Context.getCommandContext().getTaskManager().deleteTask(this, DELETE_REASON_COMPLETED, false, this.skipCustomListeners);
            if (this.executionId != null) {
                ExecutionEntity execution = this.getExecution();
                execution.removeTask(this);
                execution.signal(null, null);
            }
        }
    }

    public void caseExecutionCompleted() {
        this.ensureTaskActive();
        this.transitionTo(TaskState.STATE_COMPLETED);
        Context.getCommandContext().getTaskManager().deleteTask(this, DELETE_REASON_COMPLETED, false, false);
    }

    public void delete(String deleteReason, boolean cascade) {
        this.deleteReason = deleteReason;
        if (!DELETE_REASON_COMPLETED.equals(deleteReason) && !TaskState.STATE_DELETED.equals((Object)this.lifecycleState)) {
            this.transitionTo(TaskState.STATE_DELETED);
        }
        Context.getCommandContext().getTaskManager().deleteTask(this, deleteReason, cascade, this.skipCustomListeners);
        if (this.executionId != null) {
            ExecutionEntity execution = this.getExecution();
            execution.removeTask(this);
        }
    }

    public void delete(String deleteReason, boolean cascade, boolean skipCustomListeners) {
        this.skipCustomListeners = skipCustomListeners;
        this.delete(deleteReason, cascade);
    }

    @Override
    public void delegate(String userId) {
        this.setDelegationState(DelegationState.PENDING);
        if (this.getOwner() == null) {
            this.setOwner(this.getAssignee());
        }
        this.setAssignee(userId);
    }

    public void resolve() {
        this.setDelegationState(DelegationState.RESOLVED);
        this.setAssignee(this.owner);
    }

    @Override
    public Object getPersistentState() {
        HashMap<String, Object> persistentState = new HashMap<String, Object>();
        persistentState.put(ASSIGNEE, this.assignee);
        persistentState.put(OWNER, this.owner);
        persistentState.put(NAME, this.name);
        persistentState.put(PRIORITY, this.priority);
        if (this.executionId != null) {
            persistentState.put("executionId", this.executionId);
        }
        if (this.processDefinitionId != null) {
            persistentState.put("processDefinitionId", this.processDefinitionId);
        }
        if (this.caseExecutionId != null) {
            persistentState.put("caseExecutionId", this.caseExecutionId);
        }
        if (this.caseInstanceId != null) {
            persistentState.put(CASE_INSTANCE_ID, this.caseInstanceId);
        }
        if (this.caseDefinitionId != null) {
            persistentState.put("caseDefinitionId", this.caseDefinitionId);
        }
        if (this.createTime != null) {
            persistentState.put("createTime", this.createTime);
        }
        if (this.description != null) {
            persistentState.put(DESCRIPTION, this.description);
        }
        if (this.dueDate != null) {
            persistentState.put(DUE_DATE, this.dueDate);
        }
        if (this.followUpDate != null) {
            persistentState.put(FOLLOW_UP_DATE, this.followUpDate);
        }
        if (this.parentTaskId != null) {
            persistentState.put("parentTaskId", this.parentTaskId);
        }
        if (this.delegationState != null) {
            persistentState.put("delegationState", (Object)this.delegationState);
        }
        if (this.tenantId != null) {
            persistentState.put("tenantId", this.tenantId);
        }
        persistentState.put("suspensionState", this.suspensionState);
        return persistentState;
    }

    @Override
    public int getRevisionNext() {
        return this.revision + 1;
    }

    public void ensureParentTaskActive() {
        if (this.parentTaskId != null) {
            TaskEntity parentTask = Context.getCommandContext().getTaskManager().findTaskById(this.parentTaskId);
            EnsureUtil.ensureNotNull(NullValueException.class, "Parent task with id '" + this.parentTaskId + "' does not exist", PARENT_TASK, (Object)parentTask);
            if (parentTask.suspensionState == SuspensionState.SUSPENDED.getStateCode()) {
                throw LOG.suspendedEntityException("parent task", this.id);
            }
        }
    }

    protected void ensureTaskActive() {
        if (this.suspensionState == SuspensionState.SUSPENDED.getStateCode()) {
            throw LOG.suspendedEntityException("task", this.id);
        }
    }

    @Override
    public UserTask getBpmnModelElementInstance() {
        BpmnModelInstance bpmnModelInstance = this.getBpmnModelInstance();
        if (bpmnModelInstance != null) {
            ModelElementInstance modelElementInstance = bpmnModelInstance.getModelElementById(this.taskDefinitionKey);
            try {
                return (UserTask)modelElementInstance;
            }
            catch (ClassCastException e) {
                ModelElementType elementType = modelElementInstance.getElementType();
                throw LOG.castModelInstanceException(modelElementInstance, "UserTask", elementType.getTypeName(), elementType.getTypeNamespace(), e);
            }
        }
        return null;
    }

    @Override
    public BpmnModelInstance getBpmnModelInstance() {
        if (this.processDefinitionId != null) {
            return Context.getProcessEngineConfiguration().getDeploymentCache().findBpmnModelInstanceForProcessDefinition(this.processDefinitionId);
        }
        return null;
    }

    @Override
    protected VariableStore<CoreVariableInstance> getVariableStore() {
        return this.variableStore;
    }

    @Override
    protected VariableInstanceFactory<CoreVariableInstance> getVariableInstanceFactory() {
        return VariableInstanceEntityFactory.INSTANCE;
    }

    @Override
    protected List<VariableInstanceLifecycleListener<CoreVariableInstance>> getVariableInstanceLifecycleListeners() {
        if (this.customLifecycleListeners == null || this.customLifecycleListeners.isEmpty()) {
            return DEFAULT_VARIABLE_LIFECYCLE_LISTENERS;
        }
        ArrayList<VariableInstanceLifecycleListener<CoreVariableInstance>> listeners = new ArrayList<VariableInstanceLifecycleListener<CoreVariableInstance>>();
        listeners.addAll(DEFAULT_VARIABLE_LIFECYCLE_LISTENERS);
        listeners.addAll(this.customLifecycleListeners);
        return listeners;
    }

    public void addCustomLifecycleListener(VariableInstanceLifecycleListener<VariableInstanceEntity> customLifecycleListener) {
        if (this.customLifecycleListeners == null) {
            this.customLifecycleListeners = new ArrayList<VariableInstanceLifecycleListener<VariableInstanceEntity>>();
        }
        this.customLifecycleListeners.add(customLifecycleListener);
    }

    public VariableInstanceLifecycleListener<VariableInstanceEntity> removeCustomLifecycleListener(VariableInstanceLifecycleListener<VariableInstanceEntity> customLifecycleListener) {
        if (this.customLifecycleListeners != null) {
            this.customLifecycleListeners.remove(customLifecycleListener);
        }
        return customLifecycleListener;
    }

    @Override
    public void dispatchEvent(VariableEvent variableEvent) {
        if (this.execution != null && variableEvent.getVariableInstance().getTaskId() == null) {
            this.execution.handleConditionalEventOnVariableChange(variableEvent);
        }
    }

    @Override
    public Collection<VariableInstanceEntity> provideVariables() {
        return Context.getCommandContext().getVariableInstanceManager().findVariableInstancesByTaskId(this.id);
    }

    @Override
    public Collection<VariableInstanceEntity> provideVariables(Collection<String> variableNames) {
        return Context.getCommandContext().getVariableInstanceManager().findVariableInstancesByTaskIdAndVariableNames(this.id, variableNames);
    }

    @Override
    public AbstractVariableScope getParentVariableScope() {
        if (this.getExecution() != null) {
            return this.execution;
        }
        if (this.getCaseExecution() != null) {
            return this.caseExecution;
        }
        if (this.getParentTask() != null) {
            return this.parentTask;
        }
        return null;
    }

    @Override
    public String getVariableScopeKey() {
        return "task";
    }

    public TaskEntity getParentTask() {
        if (this.parentTask == null && this.parentTaskId != null) {
            this.parentTask = Context.getCommandContext().getTaskManager().findTaskById(this.parentTaskId);
        }
        return this.parentTask;
    }

    @Override
    public ExecutionEntity getExecution() {
        if (this.execution == null && this.executionId != null) {
            this.execution = Context.getCommandContext().getExecutionManager().findExecutionById(this.executionId);
        }
        return this.execution;
    }

    public void setExecution(PvmExecutionImpl execution) {
        if (execution != null) {
            this.execution = (ExecutionEntity)execution;
            this.executionId = this.execution.getId();
            this.processInstanceId = this.execution.getProcessInstanceId();
            this.processDefinitionId = this.execution.getProcessDefinitionId();
            ExecutionEntity instance = this.execution.getProcessInstance();
            if (instance != null) {
                this.caseInstanceId = instance.getCaseInstanceId();
            }
        } else {
            this.execution = null;
            this.executionId = null;
            this.processInstanceId = null;
            this.processDefinitionId = null;
            this.caseInstanceId = null;
        }
    }

    @Override
    public CaseExecutionEntity getCaseExecution() {
        this.ensureCaseExecutionInitialized();
        return this.caseExecution;
    }

    protected void ensureCaseExecutionInitialized() {
        if (this.caseExecution == null && this.caseExecutionId != null) {
            this.caseExecution = Context.getCommandContext().getCaseExecutionManager().findCaseExecutionById(this.caseExecutionId);
        }
    }

    public void setCaseExecution(CaseExecutionEntity caseExecution) {
        if (caseExecution != null) {
            this.caseExecution = caseExecution;
            this.caseExecutionId = this.caseExecution.getId();
            this.caseInstanceId = this.caseExecution.getCaseInstanceId();
            this.caseDefinitionId = this.caseExecution.getCaseDefinitionId();
            this.tenantId = this.caseExecution.getTenantId();
        } else {
            this.caseExecution = null;
            this.caseExecutionId = null;
            this.caseInstanceId = null;
            this.caseDefinitionId = null;
            this.tenantId = null;
        }
    }

    @Override
    public String getCaseExecutionId() {
        return this.caseExecutionId;
    }

    public void setCaseExecutionId(String caseExecutionId) {
        this.caseExecutionId = caseExecutionId;
    }

    @Override
    public String getCaseInstanceId() {
        return this.caseInstanceId;
    }

    @Override
    public void setCaseInstanceId(String caseInstanceId) {
        this.registerCommandContextCloseListener();
        this.propertyChanged(CASE_INSTANCE_ID, this.caseInstanceId, caseInstanceId);
        this.caseInstanceId = caseInstanceId;
    }

    public CaseDefinitionEntity getCaseDefinition() {
        if (this.caseDefinitionId != null) {
            return Context.getProcessEngineConfiguration().getDeploymentCache().findDeployedCaseDefinitionById(this.caseDefinitionId);
        }
        return null;
    }

    @Override
    public String getCaseDefinitionId() {
        return this.caseDefinitionId;
    }

    public void setCaseDefinitionId(String caseDefinitionId) {
        this.caseDefinitionId = caseDefinitionId;
    }

    public IdentityLinkEntity addIdentityLink(String userId, String groupId, String type) {
        this.ensureTaskActive();
        IdentityLinkEntity identityLink = this.newIdentityLink(userId, groupId, type);
        identityLink.insert();
        this.getIdentityLinks().add(identityLink);
        this.fireAddIdentityLinkAuthorizationProvider(type, userId, groupId);
        return identityLink;
    }

    public void fireIdentityLinkHistoryEvents(String userId, String groupId, String type, HistoryEventTypes historyEventType) {
        IdentityLinkEntity identityLinkEntity = this.newIdentityLink(userId, groupId, type);
        identityLinkEntity.fireHistoricIdentityLinkEvent(historyEventType);
    }

    public IdentityLinkEntity newIdentityLink(String userId, String groupId, String type) {
        IdentityLinkEntity identityLinkEntity = new IdentityLinkEntity();
        identityLinkEntity.setTask(this);
        identityLinkEntity.setUserId(userId);
        identityLinkEntity.setGroupId(groupId);
        identityLinkEntity.setType(type);
        identityLinkEntity.setTenantId(this.getTenantId());
        return identityLinkEntity;
    }

    public void deleteIdentityLink(String userId, String groupId, String type) {
        this.ensureTaskActive();
        List<IdentityLinkEntity> identityLinks = Context.getCommandContext().getIdentityLinkManager().findIdentityLinkByTaskUserGroupAndType(this.id, userId, groupId, type);
        for (IdentityLinkEntity identityLink : identityLinks) {
            this.fireDeleteIdentityLinkAuthorizationProvider(type, userId, groupId);
            identityLink.delete();
        }
    }

    public void deleteIdentityLinks() {
        List<IdentityLinkEntity> identityLinkEntities = this.getIdentityLinks();
        for (IdentityLinkEntity identityLinkEntity : identityLinkEntities) {
            this.fireDeleteIdentityLinkAuthorizationProvider(identityLinkEntity.getType(), identityLinkEntity.getUserId(), identityLinkEntity.getGroupId());
            identityLinkEntity.delete(false);
        }
        this.isIdentityLinksInitialized = false;
    }

    @Override
    public Set<IdentityLink> getCandidates() {
        HashSet<IdentityLink> potentialOwners = new HashSet<IdentityLink>();
        for (IdentityLinkEntity identityLinkEntity : this.getIdentityLinks()) {
            if (!"candidate".equals(identityLinkEntity.getType())) continue;
            potentialOwners.add(identityLinkEntity);
        }
        return potentialOwners;
    }

    @Override
    public void addCandidateUser(String userId) {
        this.addIdentityLink(userId, null, "candidate");
    }

    @Override
    public void addCandidateUsers(Collection<String> candidateUsers) {
        for (String candidateUser : candidateUsers) {
            this.addCandidateUser(candidateUser);
        }
    }

    @Override
    public void addCandidateGroup(String groupId) {
        this.addIdentityLink(null, groupId, "candidate");
    }

    @Override
    public void addCandidateGroups(Collection<String> candidateGroups) {
        for (String candidateGroup : candidateGroups) {
            this.addCandidateGroup(candidateGroup);
        }
    }

    @Override
    public void addGroupIdentityLink(String groupId, String identityLinkType) {
        this.addIdentityLink(null, groupId, identityLinkType);
    }

    @Override
    public void addUserIdentityLink(String userId, String identityLinkType) {
        this.addIdentityLink(userId, null, identityLinkType);
    }

    @Override
    public void deleteCandidateGroup(String groupId) {
        this.deleteGroupIdentityLink(groupId, "candidate");
    }

    @Override
    public void deleteCandidateUser(String userId) {
        this.deleteUserIdentityLink(userId, "candidate");
    }

    @Override
    public void deleteGroupIdentityLink(String groupId, String identityLinkType) {
        if (groupId != null) {
            this.deleteIdentityLink(null, groupId, identityLinkType);
        }
    }

    @Override
    public void deleteUserIdentityLink(String userId, String identityLinkType) {
        if (userId != null) {
            this.deleteIdentityLink(userId, null, identityLinkType);
        }
    }

    public List<IdentityLinkEntity> getIdentityLinks() {
        if (!this.isIdentityLinksInitialized) {
            this.taskIdentityLinkEntities = Context.getCommandContext().getIdentityLinkManager().findIdentityLinksByTaskId(this.id);
            this.isIdentityLinksInitialized = true;
        }
        return this.taskIdentityLinkEntities;
    }

    public Map<String, Object> getActivityInstanceVariables() {
        if (this.execution != null) {
            return this.execution.getVariables();
        }
        return Collections.EMPTY_MAP;
    }

    public void setExecutionVariables(Map<String, Object> parameters) {
        AbstractVariableScope scope = this.getParentVariableScope();
        if (scope != null) {
            scope.setVariables(parameters);
        }
    }

    public String toString() {
        return "Task[" + this.id + "]";
    }

    @Override
    public void setName(String taskName) {
        this.registerCommandContextCloseListener();
        this.propertyChanged(NAME, this.name, taskName);
        this.name = taskName;
    }

    @Override
    public void setDescription(String description) {
        this.registerCommandContextCloseListener();
        this.propertyChanged(DESCRIPTION, this.description, description);
        this.description = description;
    }

    @Override
    public void setAssignee(String assignee) {
        Date timestamp = ClockUtil.getCurrentTime();
        this.ensureTaskActive();
        this.registerCommandContextCloseListener();
        String oldAssignee = this.assignee;
        if (assignee == null && oldAssignee == null) {
            return;
        }
        this.addIdentityLinkChanges(ASSIGNEE, oldAssignee, assignee);
        this.propertyChanged(ASSIGNEE, oldAssignee, assignee);
        this.assignee = assignee;
        CommandContext commandContext = Context.getCommandContext();
        if (commandContext != null) {
            if (commandContext.getDbEntityManager().contains(this)) {
                this.fireAssigneeAuthorizationProvider(oldAssignee, assignee);
                this.fireHistoricIdentityLinks();
            }
            if (commandContext.getProcessEngineConfiguration().isTaskMetricsEnabled() && assignee != null && !assignee.equals(oldAssignee)) {
                commandContext.getMeterLogManager().insert(new TaskMeterLogEntity(assignee, timestamp));
            }
        }
    }

    @Override
    public void setOwner(String owner) {
        this.ensureTaskActive();
        this.registerCommandContextCloseListener();
        String oldOwner = this.owner;
        if (owner == null && oldOwner == null) {
            return;
        }
        this.addIdentityLinkChanges(OWNER, oldOwner, owner);
        this.propertyChanged(OWNER, oldOwner, owner);
        this.owner = owner;
        CommandContext commandContext = Context.getCommandContext();
        if (commandContext != null && commandContext.getDbEntityManager().contains(this)) {
            this.fireOwnerAuthorizationProvider(oldOwner, owner);
            this.fireHistoricIdentityLinks();
        }
    }

    @Override
    public void setDueDate(Date dueDate) {
        this.registerCommandContextCloseListener();
        this.propertyChanged(DUE_DATE, this.dueDate, dueDate);
        this.dueDate = dueDate;
    }

    @Override
    public void setPriority(int priority) {
        this.registerCommandContextCloseListener();
        this.propertyChanged(PRIORITY, this.priority, priority);
        this.priority = priority;
    }

    @Override
    public void setParentTaskId(String parentTaskId) {
        this.registerCommandContextCloseListener();
        this.propertyChanged(PARENT_TASK, this.parentTaskId, parentTaskId);
        this.parentTaskId = parentTaskId;
    }

    public void setNameWithoutCascade(String taskName) {
        this.name = taskName;
    }

    public void setDescriptionWithoutCascade(String description) {
        this.description = description;
    }

    public void setAssigneeWithoutCascade(String assignee) {
        this.assignee = assignee;
    }

    public void setOwnerWithoutCascade(String owner) {
        this.owner = owner;
    }

    public void setDueDateWithoutCascade(Date dueDate) {
        this.dueDate = dueDate;
    }

    public void setPriorityWithoutCascade(int priority) {
        this.priority = priority;
    }

    public void setCaseInstanceIdWithoutCascade(String caseInstanceId) {
        this.caseInstanceId = caseInstanceId;
    }

    public void setParentTaskIdWithoutCascade(String parentTaskId) {
        this.parentTaskId = parentTaskId;
    }

    public void setTaskDefinitionKeyWithoutCascade(String taskDefinitionKey) {
        this.taskDefinitionKey = taskDefinitionKey;
    }

    public void setDelegationStateWithoutCascade(DelegationState delegationState) {
        this.delegationState = delegationState;
    }

    public void setDelegationStateString(String delegationState) {
        if (delegationState == null) {
            this.setDelegationStateWithoutCascade(null);
        } else {
            this.setDelegationStateWithoutCascade(DelegationState.valueOf(delegationState));
        }
    }

    public void setFollowUpDateWithoutCascade(Date followUpDate) {
        this.followUpDate = followUpDate;
    }

    public boolean fireEvent(String taskEventName) {
        List<TaskListener> taskEventListeners = this.getListenersForEvent(taskEventName);
        if (taskEventListeners != null) {
            for (TaskListener taskListener : taskEventListeners) {
                if (this.invokeListener(taskEventName, taskListener)) continue;
                return false;
            }
        }
        return true;
    }

    protected List<TaskListener> getListenersForEvent(String event) {
        TaskDefinition resolvedTaskDefinition = this.getTaskDefinition();
        if (resolvedTaskDefinition != null) {
            if (this.skipCustomListeners) {
                return resolvedTaskDefinition.getBuiltinTaskListeners(event);
            }
            return resolvedTaskDefinition.getTaskListeners(event);
        }
        return null;
    }

    protected TaskListener getTimeoutListener(String timeoutId) {
        TaskDefinition resolvedTaskDefinition = this.getTaskDefinition();
        if (resolvedTaskDefinition == null) {
            return null;
        }
        return resolvedTaskDefinition.getTimeoutTaskListener(timeoutId);
    }

    protected boolean invokeListener(String taskEventName, TaskListener taskListener) {
        boolean popProcessDataContext = false;
        CommandInvocationContext commandInvocationContext = Context.getCommandInvocationContext();
        CoreExecution execution = this.getExecution();
        if (execution == null) {
            execution = this.getCaseExecution();
        } else if (commandInvocationContext != null) {
            popProcessDataContext = commandInvocationContext.getProcessDataContext().pushSection((ExecutionEntity)execution);
        }
        if (execution != null) {
            this.setEventName(taskEventName);
        }
        try {
            boolean result = this.invokeListener(execution, taskEventName, taskListener);
            if (popProcessDataContext) {
                commandInvocationContext.getProcessDataContext().popSection();
            }
            return result;
        }
        catch (Exception e) {
            throw LOG.invokeTaskListenerException(e);
        }
    }

    protected boolean invokeListener(CoreExecution currentExecution, String eventName, TaskListener taskListener) throws Exception {
        boolean isBpmnTask = currentExecution instanceof ActivityExecution && currentExecution != null;
        TaskListenerInvocation listenerInvocation = new TaskListenerInvocation(taskListener, this, currentExecution);
        try {
            Context.getProcessEngineConfiguration().getDelegateInterceptor().handleInvocation(listenerInvocation);
        }
        catch (Exception ex) {
            if (isBpmnTask && !eventName.equals(DELETE)) {
                try {
                    BpmnExceptionHandler.propagateException((ActivityExecution)((Object)currentExecution), ex);
                    return false;
                }
                catch (ErrorPropagationException e) {
                    throw ex;
                }
            }
            throw ex;
        }
        return true;
    }

    protected void propertyChanged(String propertyName, Object orgValue, Object newValue) {
        if (this.propertyChanges.containsKey(propertyName)) {
            Object oldOrgValue = this.propertyChanges.get(propertyName).getOrgValue();
            if (oldOrgValue == null && newValue == null || oldOrgValue != null && oldOrgValue.equals(newValue)) {
                this.propertyChanges.remove(propertyName);
            } else {
                this.propertyChanges.get(propertyName).setNewValue(newValue);
            }
        } else if (orgValue == null && newValue != null || orgValue != null && newValue == null || orgValue != null && !orgValue.equals(newValue)) {
            this.propertyChanges.put(propertyName, new PropertyChange(propertyName, orgValue, newValue));
        }
    }

    public void fireAuthorizationProvider() {
        PropertyChange ownerPropertyChange;
        PropertyChange assigneePropertyChange = this.propertyChanges.get(ASSIGNEE);
        if (assigneePropertyChange != null) {
            String oldAssignee = assigneePropertyChange.getOrgValueString();
            String newAssignee = assigneePropertyChange.getNewValueString();
            this.fireAssigneeAuthorizationProvider(oldAssignee, newAssignee);
        }
        if ((ownerPropertyChange = this.propertyChanges.get(OWNER)) != null) {
            String oldOwner = ownerPropertyChange.getOrgValueString();
            String newOwner = ownerPropertyChange.getNewValueString();
            this.fireOwnerAuthorizationProvider(oldOwner, newOwner);
        }
    }

    public boolean transitionTo(TaskState state) {
        this.lifecycleState = state;
        switch (state) {
            case STATE_CREATED: {
                CommandContext commandContext = Context.getCommandContext();
                if (commandContext != null) {
                    commandContext.getHistoricTaskInstanceManager().createHistoricTask(this);
                }
                return this.fireEvent("create") && this.fireAssignmentEvent();
            }
            case STATE_COMPLETED: {
                return this.fireEvent("complete") && TaskState.STATE_COMPLETED.equals((Object)this.lifecycleState);
            }
            case STATE_DELETED: {
                return this.fireEvent(DELETE);
            }
        }
        throw new ProcessEngineException(String.format("Task %s cannot transition into state %s.", new Object[]{this.id, state}));
    }

    public boolean triggerUpdateEvent() {
        if (this.lifecycleState == TaskState.STATE_CREATED) {
            return this.fireEvent("update") && this.fireAssignmentEvent();
        }
        return true;
    }

    public boolean triggerTimeoutEvent(String timeoutId) {
        TaskListener taskListener = this.getTimeoutListener(timeoutId);
        if (taskListener == null) {
            throw LOG.invokeTaskListenerException(new NotFoundException("Cannot find timeout taskListener with id '" + timeoutId + "' for task " + this.id));
        }
        return this.invokeListener("timeout", taskListener);
    }

    protected boolean fireAssignmentEvent() {
        PropertyChange assigneePropertyChange = this.propertyChanges.get(ASSIGNEE);
        if (assigneePropertyChange != null) {
            return this.fireEvent("assignment");
        }
        return true;
    }

    protected void fireAssigneeAuthorizationProvider(String oldAssignee, String newAssignee) {
        this.fireAuthorizationProvider(ASSIGNEE, oldAssignee, newAssignee);
    }

    protected void fireOwnerAuthorizationProvider(String oldOwner, String newOwner) {
        this.fireAuthorizationProvider(OWNER, oldOwner, newOwner);
    }

    protected void fireAuthorizationProvider(String property, String oldValue, String newValue) {
        if (this.isAuthorizationEnabled() && this.caseExecutionId == null) {
            ResourceAuthorizationProvider provider = this.getResourceAuthorizationProvider();
            AuthorizationEntity[] authorizations = null;
            if (ASSIGNEE.equals(property)) {
                authorizations = provider.newTaskAssignee(this, oldValue, newValue);
            } else if (OWNER.equals(property)) {
                authorizations = provider.newTaskOwner(this, oldValue, newValue);
            }
            this.saveAuthorizations(authorizations);
        }
    }

    protected void fireAddIdentityLinkAuthorizationProvider(String type, String userId, String groupId) {
        if (this.isAuthorizationEnabled() && this.caseExecutionId == null) {
            ResourceAuthorizationProvider provider = this.getResourceAuthorizationProvider();
            AuthorizationEntity[] authorizations = null;
            if (userId != null) {
                authorizations = provider.newTaskUserIdentityLink(this, userId, type);
            } else if (groupId != null) {
                authorizations = provider.newTaskGroupIdentityLink(this, groupId, type);
            }
            this.saveAuthorizations(authorizations);
        }
    }

    protected void fireDeleteIdentityLinkAuthorizationProvider(String type, String userId, String groupId) {
        if (this.isAuthorizationEnabled() && this.caseExecutionId == null) {
            ResourceAuthorizationProvider provider = this.getResourceAuthorizationProvider();
            AuthorizationEntity[] authorizations = null;
            if (userId != null) {
                authorizations = provider.deleteTaskUserIdentityLink(this, userId, type);
            } else if (groupId != null) {
                authorizations = provider.deleteTaskGroupIdentityLink(this, groupId, type);
            }
            this.deleteAuthorizations(authorizations);
        }
    }

    protected ResourceAuthorizationProvider getResourceAuthorizationProvider() {
        ProcessEngineConfigurationImpl processEngineConfiguration = Context.getProcessEngineConfiguration();
        return processEngineConfiguration.getResourceAuthorizationProvider();
    }

    protected void saveAuthorizations(AuthorizationEntity[] authorizations) {
        CommandContext commandContext = Context.getCommandContext();
        TaskManager taskManager = commandContext.getTaskManager();
        taskManager.saveDefaultAuthorizations(authorizations);
    }

    protected void deleteAuthorizations(AuthorizationEntity[] authorizations) {
        CommandContext commandContext = Context.getCommandContext();
        TaskManager taskManager = commandContext.getTaskManager();
        taskManager.deleteDefaultAuthorizations(authorizations);
    }

    protected boolean isAuthorizationEnabled() {
        return Context.getProcessEngineConfiguration().isAuthorizationEnabled();
    }

    public void setTaskDefinition(TaskDefinition taskDefinition) {
        this.taskDefinition = taskDefinition;
        this.taskDefinitionKey = taskDefinition.getKey();
    }

    public TaskDefinition getTaskDefinition() {
        if (this.taskDefinition == null && this.taskDefinitionKey != null) {
            Map<String, TaskDefinition> taskDefinitions = null;
            if (this.processDefinitionId != null) {
                ProcessDefinitionEntity processDefinition = Context.getProcessEngineConfiguration().getDeploymentCache().findDeployedProcessDefinitionById(this.processDefinitionId);
                taskDefinitions = processDefinition.getTaskDefinitions();
            } else {
                CaseDefinitionEntity caseDefinition = Context.getProcessEngineConfiguration().getDeploymentCache().findDeployedCaseDefinitionById(this.caseDefinitionId);
                taskDefinitions = caseDefinition.getTaskDefinitions();
            }
            this.taskDefinition = taskDefinitions.get(this.taskDefinitionKey);
        }
        return this.taskDefinition;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public void setId(String id) {
        this.id = id;
    }

    @Override
    public int getRevision() {
        return this.revision;
    }

    @Override
    public void setRevision(int revision) {
        this.revision = revision;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public Date getDueDate() {
        return this.dueDate;
    }

    @Override
    public int getPriority() {
        return this.priority;
    }

    @Override
    public Date getCreateTime() {
        return this.createTime;
    }

    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    @Override
    public String getExecutionId() {
        return this.executionId;
    }

    @Override
    public String getProcessInstanceId() {
        return this.processInstanceId;
    }

    public boolean isStandaloneTask() {
        return this.executionId == null && this.caseExecutionId == null;
    }

    public ProcessDefinitionEntity getProcessDefinition() {
        if (this.processDefinitionId != null) {
            return Context.getProcessEngineConfiguration().getDeploymentCache().findDeployedProcessDefinitionById(this.processDefinitionId);
        }
        return null;
    }

    @Override
    public String getProcessDefinitionId() {
        return this.processDefinitionId;
    }

    public void initializeFormKey() {
        Expression formKey;
        TaskDefinition taskDefinition;
        this.isFormKeyInitialized = true;
        if (this.taskDefinitionKey != null && (taskDefinition = this.getTaskDefinition()) != null && (formKey = taskDefinition.getFormKey()) != null) {
            this.formKey = (String)formKey.getValue(this);
        }
    }

    @Override
    public String getFormKey() {
        if (!this.isFormKeyInitialized) {
            throw LOG.uninitializedFormKeyException();
        }
        return this.formKey;
    }

    public void setProcessDefinitionId(String processDefinitionId) {
        this.processDefinitionId = processDefinitionId;
    }

    @Override
    public String getAssignee() {
        return this.assignee;
    }

    @Override
    public String getTaskDefinitionKey() {
        return this.taskDefinitionKey;
    }

    public void setTaskDefinitionKey(String taskDefinitionKey) {
        if (taskDefinitionKey == null && this.taskDefinitionKey != null || taskDefinitionKey != null && !taskDefinitionKey.equals(this.taskDefinitionKey)) {
            this.taskDefinition = null;
            this.formKey = null;
            this.isFormKeyInitialized = false;
        }
        this.taskDefinitionKey = taskDefinitionKey;
    }

    @Override
    public String getEventName() {
        return this.eventName;
    }

    public void setEventName(String eventName) {
        this.eventName = eventName;
    }

    public void setExecutionId(String executionId) {
        this.executionId = executionId;
    }

    public ExecutionEntity getProcessInstance() {
        if (this.processInstance == null && this.processInstanceId != null) {
            this.processInstance = Context.getCommandContext().getExecutionManager().findExecutionById(this.processInstanceId);
        }
        return this.processInstance;
    }

    public void setProcessInstance(ExecutionEntity processInstance) {
        this.processInstance = processInstance;
    }

    public void setProcessInstanceId(String processInstanceId) {
        this.processInstanceId = processInstanceId;
    }

    @Override
    public String getOwner() {
        return this.owner;
    }

    @Override
    public DelegationState getDelegationState() {
        return this.delegationState;
    }

    @Override
    public void setDelegationState(DelegationState delegationState) {
        this.propertyChanged(DELEGATION, (Object)this.delegationState, (Object)delegationState);
        this.delegationState = delegationState;
    }

    public String getDelegationStateString() {
        return this.delegationState != null ? this.delegationState.toString() : null;
    }

    public boolean isDeleted() {
        return this.isDeleted;
    }

    @Override
    public String getDeleteReason() {
        return this.deleteReason;
    }

    public void setDeleted(boolean isDeleted) {
        this.isDeleted = isDeleted;
    }

    @Override
    public String getParentTaskId() {
        return this.parentTaskId;
    }

    public int getSuspensionState() {
        return this.suspensionState;
    }

    public void setSuspensionState(int suspensionState) {
        this.suspensionState = suspensionState;
    }

    @Override
    public boolean isSuspended() {
        return this.suspensionState == SuspensionState.SUSPENDED.getStateCode();
    }

    @Override
    public Date getFollowUpDate() {
        return this.followUpDate;
    }

    @Override
    public String getTenantId() {
        return this.tenantId;
    }

    @Override
    public void setTenantId(String tenantId) {
        this.tenantId = tenantId;
    }

    @Override
    public void setFollowUpDate(Date followUpDate) {
        this.registerCommandContextCloseListener();
        this.propertyChanged(FOLLOW_UP_DATE, this.followUpDate, followUpDate);
        this.followUpDate = followUpDate;
    }

    public Collection<VariableInstanceEntity> getVariablesInternal() {
        return this.variableStore.getVariables();
    }

    @Override
    public void onCommandContextClose(CommandContext commandContext) {
        if (commandContext.getDbEntityManager().isDirty(this)) {
            commandContext.getHistoricTaskInstanceManager().updateHistoricTaskInstance(this);
        }
    }

    @Override
    public void onCommandFailed(CommandContext commandContext, Throwable t) {
    }

    protected void registerCommandContextCloseListener() {
        CommandContext commandContext = Context.getCommandContext();
        if (commandContext != null) {
            commandContext.registerCommandContextListener(this);
        }
    }

    public Map<String, PropertyChange> getPropertyChanges() {
        return this.propertyChanges;
    }

    public void logUserOperation(String operation) {
        CommandContext commandContext;
        if ("Complete".equals(operation) || "Delete".equals(operation)) {
            this.propertyChanged(DELETE, false, true);
        }
        if ((commandContext = Context.getCommandContext()) != null) {
            ArrayList<PropertyChange> values = new ArrayList<PropertyChange>(this.propertyChanges.values());
            commandContext.getOperationLogManager().logTaskOperations(operation, this, values);
            this.fireHistoricIdentityLinks();
            this.propertyChanges.clear();
        }
    }

    public void fireHistoricIdentityLinks() {
        for (PropertyChange propertyChange : this.identityLinkChanges) {
            String newValue;
            String oldValue = propertyChange.getOrgValueString();
            String propertyName = propertyChange.getPropertyName();
            if (oldValue != null) {
                this.fireIdentityLinkHistoryEvents(oldValue, null, propertyName, HistoryEventTypes.IDENTITY_LINK_DELETE);
            }
            if ((newValue = propertyChange.getNewValueString()) == null) continue;
            this.fireIdentityLinkHistoryEvents(newValue, null, propertyName, HistoryEventTypes.IDENTITY_LINK_ADD);
        }
        this.identityLinkChanges.clear();
    }

    @Override
    public ProcessEngineServices getProcessEngineServices() {
        return Context.getProcessEngineConfiguration().getProcessEngine();
    }

    @Override
    public ProcessEngine getProcessEngine() {
        return Context.getProcessEngineConfiguration().getProcessEngine();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TaskEntity other = (TaskEntity)obj;
        return !(this.id == null ? other.id != null : !this.id.equals(other.id));
    }

    public void executeMetrics(String metricsName, CommandContext commandContext) {
        ProcessEngineConfigurationImpl processEngineConfiguration = Context.getProcessEngineConfiguration();
        if ("activity-instance-start".equals(metricsName) && processEngineConfiguration.isMetricsEnabled()) {
            processEngineConfiguration.getMetricsRegistry().markOccurrence("activity-instance-start");
        }
        if ("unique-task-workers".equals(metricsName) && processEngineConfiguration.isTaskMetricsEnabled() && this.assignee != null && this.propertyChanges.containsKey(ASSIGNEE)) {
            commandContext.getMeterLogManager().insert(new TaskMeterLogEntity(this.assignee, ClockUtil.getCurrentTime()));
        }
    }

    public void addIdentityLinkChanges(String type, String oldProperty, String newProperty) {
        this.identityLinkChanges.add(new PropertyChange(type, oldProperty, newProperty));
    }

    @Override
    public void setVariablesLocal(Map<String, ?> variables, boolean skipJavaSerializationFormatCheck) {
        super.setVariablesLocal(variables, skipJavaSerializationFormatCheck);
        Context.getCommandContext().getDbEntityManager().forceUpdate(this);
    }

    @Override
    public Set<String> getReferencedEntityIds() {
        HashSet<String> referencedEntityIds = new HashSet<String>();
        return referencedEntityIds;
    }

    @Override
    public Map<String, Class> getReferencedEntitiesIdAndClass() {
        HashMap<String, Class> referenceIdAndClass = new HashMap<String, Class>();
        if (this.processDefinitionId != null) {
            referenceIdAndClass.put(this.processDefinitionId, ProcessDefinitionEntity.class);
        }
        if (this.processInstanceId != null) {
            referenceIdAndClass.put(this.processInstanceId, ExecutionEntity.class);
        }
        if (this.executionId != null) {
            referenceIdAndClass.put(this.executionId, ExecutionEntity.class);
        }
        if (this.caseDefinitionId != null) {
            referenceIdAndClass.put(this.caseDefinitionId, CaseDefinitionEntity.class);
        }
        if (this.caseExecutionId != null) {
            referenceIdAndClass.put(this.caseExecutionId, CaseExecutionEntity.class);
        }
        return referenceIdAndClass;
    }

    public void bpmnError(String errorCode, String errorMessage, Map<String, Object> variables) {
        this.ensureTaskActive();
        ExecutionEntity activityExecution = this.getExecution();
        BpmnError bpmnError = null;
        bpmnError = errorMessage != null ? new BpmnError(errorCode, errorMessage) : new BpmnError(errorCode);
        try {
            if (variables != null && !variables.isEmpty()) {
                activityExecution.setVariables((Map<String, ? extends Object>)variables);
            }
            BpmnExceptionHandler.propagateBpmnError(bpmnError, activityExecution);
        }
        catch (Exception ex) {
            throw ProcessEngineLogger.CMD_LOGGER.exceptionBpmnErrorPropagationFailed(errorCode, ex);
        }
    }

    public void escalation(String escalationCode, Map<String, Object> variables) {
        this.ensureTaskActive();
        ExecutionEntity activityExecution = this.getExecution();
        if (variables != null && !variables.isEmpty()) {
            activityExecution.setVariables((Map<String, ? extends Object>)variables);
        }
        EscalationHandler.propagateEscalation(activityExecution, escalationCode);
    }

    public static enum TaskState {
        STATE_INIT,
        STATE_CREATED,
        STATE_COMPLETED,
        STATE_DELETED;

    }
}

