/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.authorization;

import java.io.InputStream;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.camunda.bpm.application.ProcessApplicationReference;
import org.camunda.bpm.application.ProcessApplicationRegistration;
import org.camunda.bpm.application.impl.EmbeddedProcessApplication;
import org.camunda.bpm.engine.AuthorizationException;
import org.camunda.bpm.engine.authorization.Authorization;
import org.camunda.bpm.engine.authorization.AuthorizationQuery;
import org.camunda.bpm.engine.authorization.Permission;
import org.camunda.bpm.engine.authorization.Permissions;
import org.camunda.bpm.engine.authorization.Resources;
import org.camunda.bpm.engine.impl.AbstractQuery;
import org.camunda.bpm.engine.query.Query;
import org.camunda.bpm.engine.repository.Deployment;
import org.camunda.bpm.engine.repository.DeploymentQuery;
import org.camunda.bpm.engine.repository.Resource;
import org.camunda.bpm.engine.test.api.authorization.AuthorizationTest;
import org.junit.Assert;
import org.junit.Test;

public class DeploymentAuthorizationTest
extends AuthorizationTest {
    private static final String REQUIRED_ADMIN_AUTH_EXCEPTION = "ENGINE-03029 Required admin authenticated group or user.";
    protected static final String FIRST_RESOURCE = "org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml";
    protected static final String SECOND_RESOURCE = "org/camunda/bpm/engine/test/api/authorization/messageBoundaryEventProcess.bpmn20.xml";

    @Test
    public void testSimpleDeploymentQueryWithoutAuthorization() {
        String deploymentId = this.createDeployment(null);
        DeploymentQuery query = this.repositoryService.createDeploymentQuery();
        this.verifyQueryResults(query, 0);
        this.deleteDeployment(deploymentId);
    }

    @Test
    public void testSimpleDeploymentQueryWithReadPermissionOnDeployment() {
        String deploymentId = this.createDeployment(null);
        this.createGrantAuthorization((org.camunda.bpm.engine.authorization.Resource)Resources.DEPLOYMENT, deploymentId, this.userId, new Permission[]{Permissions.READ});
        DeploymentQuery query = this.repositoryService.createDeploymentQuery();
        this.verifyQueryResults(query, 1);
        this.deleteDeployment(deploymentId);
    }

    @Test
    public void testSimpleDeploymentQueryWithReadPermissionOnAnyDeployment() {
        String deploymentId = this.createDeployment(null);
        this.createGrantAuthorization((org.camunda.bpm.engine.authorization.Resource)Resources.DEPLOYMENT, "*", this.userId, new Permission[]{Permissions.READ});
        DeploymentQuery query = this.repositoryService.createDeploymentQuery();
        this.verifyQueryResults(query, 1);
        this.deleteDeployment(deploymentId);
    }

    @Test
    public void testSimpleDeploymentQueryWithMultiple() {
        String deploymentId = this.createDeployment(null);
        this.createGrantAuthorization((org.camunda.bpm.engine.authorization.Resource)Resources.DEPLOYMENT, deploymentId, this.userId, new Permission[]{Permissions.READ});
        this.createGrantAuthorization((org.camunda.bpm.engine.authorization.Resource)Resources.DEPLOYMENT, "*", this.userId, new Permission[]{Permissions.READ});
        DeploymentQuery query = this.repositoryService.createDeploymentQuery();
        this.verifyQueryResults(query, 1);
        this.deleteDeployment(deploymentId);
    }

    @Test
    public void testDeploymentQueryWithoutAuthorization() {
        String deploymentId1 = this.createDeployment("first");
        String deploymentId2 = this.createDeployment("second");
        DeploymentQuery query = this.repositoryService.createDeploymentQuery();
        this.verifyQueryResults(query, 0);
        this.deleteDeployment(deploymentId1);
        this.deleteDeployment(deploymentId2);
    }

    @Test
    public void testDeploymentQueryWithReadPermissionOnDeployment() {
        String deploymentId1 = this.createDeployment("first");
        String deploymentId2 = this.createDeployment("second");
        this.createGrantAuthorization((org.camunda.bpm.engine.authorization.Resource)Resources.DEPLOYMENT, deploymentId1, this.userId, new Permission[]{Permissions.READ});
        DeploymentQuery query = this.repositoryService.createDeploymentQuery();
        this.verifyQueryResults(query, 1);
        this.deleteDeployment(deploymentId1);
        this.deleteDeployment(deploymentId2);
    }

    @Test
    public void testDeploymentQueryWithReadPermissionOnAnyDeployment() {
        String deploymentId1 = this.createDeployment("first");
        String deploymentId2 = this.createDeployment("second");
        this.createGrantAuthorization((org.camunda.bpm.engine.authorization.Resource)Resources.DEPLOYMENT, "*", this.userId, new Permission[]{Permissions.READ});
        DeploymentQuery query = this.repositoryService.createDeploymentQuery();
        this.verifyQueryResults(query, 2);
        this.deleteDeployment(deploymentId1);
        this.deleteDeployment(deploymentId2);
    }

    @Test
    public void testCreateDeploymentWithoutAuthoriatzion() {
        try {
            this.repositoryService.createDeployment().addClasspathResource(FIRST_RESOURCE).deploy();
            Assert.fail((String)"Exception expected: It should not be possible to create a new deployment");
        }
        catch (AuthorizationException e) {
            String message = e.getMessage();
            this.testRule.assertTextPresent(this.userId, message);
            this.testRule.assertTextPresent(Permissions.CREATE.getName(), message);
            this.testRule.assertTextPresent(Resources.DEPLOYMENT.resourceName(), message);
        }
    }

    @Test
    public void testCreateDeployment() {
        this.createGrantAuthorization((org.camunda.bpm.engine.authorization.Resource)Resources.DEPLOYMENT, "*", this.userId, new Permission[]{Permissions.CREATE});
        Deployment deployment = this.repositoryService.createDeployment().addClasspathResource(FIRST_RESOURCE).deploy();
        this.disableAuthorization();
        DeploymentQuery query = this.repositoryService.createDeploymentQuery();
        this.verifyQueryResults(query, 1);
        this.enableAuthorization();
        this.deleteDeployment(deployment.getId());
    }

    @Test
    public void testDeleteDeploymentWithoutAuthorization() {
        String deploymentId = this.createDeployment(null);
        try {
            this.repositoryService.deleteDeployment(deploymentId);
            Assert.fail((String)"Exception expected: it should not be possible to delete a deployment");
        }
        catch (AuthorizationException e) {
            String message = e.getMessage();
            this.testRule.assertTextPresent(this.userId, message);
            this.testRule.assertTextPresent(Permissions.DELETE.getName(), message);
            this.testRule.assertTextPresent(Resources.DEPLOYMENT.resourceName(), message);
        }
        this.deleteDeployment(deploymentId);
    }

    @Test
    public void testDeleteDeploymentWithDeletePermissionOnDeployment() {
        String deploymentId = this.createDeployment(null);
        this.createGrantAuthorization((org.camunda.bpm.engine.authorization.Resource)Resources.DEPLOYMENT, deploymentId, this.userId, new Permission[]{Permissions.DELETE});
        this.repositoryService.deleteDeployment(deploymentId);
        this.disableAuthorization();
        DeploymentQuery query = this.repositoryService.createDeploymentQuery();
        this.verifyQueryResults(query, 0);
        this.enableAuthorization();
        this.deleteDeployment(deploymentId);
    }

    @Test
    public void testDeleteDeploymentWithDeletePermissionOnAnyDeployment() {
        String deploymentId = this.createDeployment(null);
        this.createGrantAuthorization((org.camunda.bpm.engine.authorization.Resource)Resources.DEPLOYMENT, "*", this.userId, new Permission[]{Permissions.DELETE});
        this.repositoryService.deleteDeployment(deploymentId);
        this.disableAuthorization();
        DeploymentQuery query = this.repositoryService.createDeploymentQuery();
        this.verifyQueryResults(query, 0);
        this.enableAuthorization();
        this.deleteDeployment(deploymentId);
    }

    @Test
    public void testGetDeploymentResourceNamesWithoutAuthorization() {
        String deploymentId = this.createDeployment(null);
        try {
            this.repositoryService.getDeploymentResourceNames(deploymentId);
            Assert.fail((String)"Exception expected: it should not be possible to retrieve deployment resource names");
        }
        catch (AuthorizationException e) {
            String message = e.getMessage();
            this.testRule.assertTextPresent(this.userId, message);
            this.testRule.assertTextPresent(Permissions.READ.getName(), message);
            this.testRule.assertTextPresent(Resources.DEPLOYMENT.resourceName(), message);
        }
        this.deleteDeployment(deploymentId);
    }

    @Test
    public void testGetDeploymentResourceNamesWithReadPermissionOnDeployment() {
        String deploymentId = this.createDeployment(null);
        this.createGrantAuthorization((org.camunda.bpm.engine.authorization.Resource)Resources.DEPLOYMENT, deploymentId, this.userId, new Permission[]{Permissions.READ});
        List names = this.repositoryService.getDeploymentResourceNames(deploymentId);
        Assert.assertFalse((boolean)names.isEmpty());
        Assert.assertEquals((long)2L, (long)names.size());
        Assert.assertTrue((boolean)names.contains(FIRST_RESOURCE));
        Assert.assertTrue((boolean)names.contains(SECOND_RESOURCE));
        this.deleteDeployment(deploymentId);
    }

    @Test
    public void testGetDeploymentResourceNamesWithReadPermissionOnAnyDeployment() {
        String deploymentId = this.createDeployment(null);
        this.createGrantAuthorization((org.camunda.bpm.engine.authorization.Resource)Resources.DEPLOYMENT, "*", this.userId, new Permission[]{Permissions.READ});
        List names = this.repositoryService.getDeploymentResourceNames(deploymentId);
        Assert.assertFalse((boolean)names.isEmpty());
        Assert.assertEquals((long)2L, (long)names.size());
        Assert.assertTrue((boolean)names.contains(FIRST_RESOURCE));
        Assert.assertTrue((boolean)names.contains(SECOND_RESOURCE));
        this.deleteDeployment(deploymentId);
    }

    @Test
    public void testGetDeploymentResourcesWithoutAuthorization() {
        String deploymentId = this.createDeployment(null);
        try {
            this.repositoryService.getDeploymentResources(deploymentId);
            Assert.fail((String)"Exception expected: it should not be possible to retrieve deployment resources");
        }
        catch (AuthorizationException e) {
            String message = e.getMessage();
            this.testRule.assertTextPresent(this.userId, message);
            this.testRule.assertTextPresent(Permissions.READ.getName(), message);
            this.testRule.assertTextPresent(Resources.DEPLOYMENT.resourceName(), message);
        }
        this.deleteDeployment(deploymentId);
    }

    @Test
    public void testGetDeploymentResourcesWithReadPermissionOnDeployment() {
        String deploymentId = this.createDeployment(null);
        this.createGrantAuthorization((org.camunda.bpm.engine.authorization.Resource)Resources.DEPLOYMENT, deploymentId, this.userId, new Permission[]{Permissions.READ});
        List resources = this.repositoryService.getDeploymentResources(deploymentId);
        Assert.assertFalse((boolean)resources.isEmpty());
        Assert.assertEquals((long)2L, (long)resources.size());
        this.deleteDeployment(deploymentId);
    }

    @Test
    public void testGetDeploymentResourcesWithReadPermissionOnAnyDeployment() {
        String deploymentId = this.createDeployment(null);
        this.createGrantAuthorization((org.camunda.bpm.engine.authorization.Resource)Resources.DEPLOYMENT, "*", this.userId, new Permission[]{Permissions.READ});
        List resources = this.repositoryService.getDeploymentResources(deploymentId);
        Assert.assertFalse((boolean)resources.isEmpty());
        Assert.assertEquals((long)2L, (long)resources.size());
        this.deleteDeployment(deploymentId);
    }

    @Test
    public void testGetResourceAsStreamWithoutAuthorization() {
        String deploymentId = this.createDeployment(null);
        try {
            this.repositoryService.getResourceAsStream(deploymentId, FIRST_RESOURCE);
            Assert.fail((String)"Exception expected: it should not be possible to retrieve a resource as stream");
        }
        catch (AuthorizationException e) {
            String message = e.getMessage();
            this.testRule.assertTextPresent(this.userId, message);
            this.testRule.assertTextPresent(Permissions.READ.getName(), message);
            this.testRule.assertTextPresent(Resources.DEPLOYMENT.resourceName(), message);
        }
        this.deleteDeployment(deploymentId);
    }

    @Test
    public void testGetResourceAsStreamWithReadPermissionOnDeployment() {
        String deploymentId = this.createDeployment(null);
        this.createGrantAuthorization((org.camunda.bpm.engine.authorization.Resource)Resources.DEPLOYMENT, deploymentId, this.userId, new Permission[]{Permissions.READ});
        InputStream stream = this.repositoryService.getResourceAsStream(deploymentId, FIRST_RESOURCE);
        Assert.assertNotNull((Object)stream);
        this.deleteDeployment(deploymentId);
    }

    @Test
    public void testGetResourceAsStreamWithReadPermissionOnAnyDeployment() {
        String deploymentId = this.createDeployment(null);
        this.createGrantAuthorization((org.camunda.bpm.engine.authorization.Resource)Resources.DEPLOYMENT, "*", this.userId, new Permission[]{Permissions.READ});
        InputStream stream = this.repositoryService.getResourceAsStream(deploymentId, FIRST_RESOURCE);
        Assert.assertNotNull((Object)stream);
        this.deleteDeployment(deploymentId);
    }

    @Test
    public void testGetResourceAsStreamByIdWithoutAuthorization() {
        String deploymentId = this.createDeployment(null);
        this.disableAuthorization();
        List resources = this.repositoryService.getDeploymentResources(deploymentId);
        this.enableAuthorization();
        String resourceId = ((Resource)resources.get(0)).getId();
        try {
            this.repositoryService.getResourceAsStreamById(deploymentId, resourceId);
            Assert.fail((String)"Exception expected: it should not be possible to retrieve a resource as stream");
        }
        catch (AuthorizationException e) {
            String message = e.getMessage();
            this.testRule.assertTextPresent(this.userId, message);
            this.testRule.assertTextPresent(Permissions.READ.getName(), message);
            this.testRule.assertTextPresent(Resources.DEPLOYMENT.resourceName(), message);
        }
        this.deleteDeployment(deploymentId);
    }

    @Test
    public void testGetResourceAsStreamByIdWithReadPermissionOnDeployment() {
        String deploymentId = this.createDeployment(null);
        this.createGrantAuthorization((org.camunda.bpm.engine.authorization.Resource)Resources.DEPLOYMENT, deploymentId, this.userId, new Permission[]{Permissions.READ});
        this.disableAuthorization();
        List resources = this.repositoryService.getDeploymentResources(deploymentId);
        this.enableAuthorization();
        String resourceId = ((Resource)resources.get(0)).getId();
        InputStream stream = this.repositoryService.getResourceAsStreamById(deploymentId, resourceId);
        Assert.assertNotNull((Object)stream);
        this.deleteDeployment(deploymentId);
    }

    @Test
    public void testGetResourceAsStreamByIdWithReadPermissionOnAnyDeployment() {
        String deploymentId = this.createDeployment(null);
        this.createGrantAuthorization((org.camunda.bpm.engine.authorization.Resource)Resources.DEPLOYMENT, "*", this.userId, new Permission[]{Permissions.READ});
        this.disableAuthorization();
        List resources = this.repositoryService.getDeploymentResources(deploymentId);
        this.enableAuthorization();
        String resourceId = ((Resource)resources.get(0)).getId();
        InputStream stream = this.repositoryService.getResourceAsStreamById(deploymentId, resourceId);
        Assert.assertNotNull((Object)stream);
        this.deleteDeployment(deploymentId);
    }

    @Test
    public void testCreateAuthorizationOnDeploy() {
        this.createGrantAuthorization((org.camunda.bpm.engine.authorization.Resource)Resources.DEPLOYMENT, "*", this.userId, new Permission[]{Permissions.CREATE});
        Deployment deployment = this.repositoryService.createDeployment().addClasspathResource(FIRST_RESOURCE).deploy();
        Authorization authorization = (Authorization)this.authorizationService.createAuthorizationQuery().userIdIn(new String[]{this.userId}).resourceId(deployment.getId()).singleResult();
        Assert.assertNotNull((Object)authorization);
        Assert.assertTrue((boolean)authorization.isPermissionGranted((Permission)Permissions.READ));
        Assert.assertTrue((boolean)authorization.isPermissionGranted((Permission)Permissions.DELETE));
        Assert.assertFalse((boolean)authorization.isPermissionGranted((Permission)Permissions.UPDATE));
        this.deleteDeployment(deployment.getId());
    }

    @Test
    public void testClearAuthorizationOnDeleteDeployment() {
        this.createGrantAuthorization((org.camunda.bpm.engine.authorization.Resource)Resources.DEPLOYMENT, "*", this.userId, new Permission[]{Permissions.CREATE});
        Deployment deployment = this.repositoryService.createDeployment().addClasspathResource(FIRST_RESOURCE).deploy();
        String deploymentId = deployment.getId();
        AuthorizationQuery query = this.authorizationService.createAuthorizationQuery().userIdIn(new String[]{this.userId}).resourceId(deploymentId);
        Authorization authorization = (Authorization)query.singleResult();
        Assert.assertNotNull((Object)authorization);
        this.repositoryService.deleteDeployment(deploymentId);
        authorization = (Authorization)query.singleResult();
        Assert.assertNull((Object)authorization);
        this.deleteDeployment(deploymentId);
    }

    @Test
    public void testRegisterProcessApplicationWithoutAuthorization() {
        EmbeddedProcessApplication processApplication = new EmbeddedProcessApplication();
        ProcessApplicationReference reference = processApplication.getReference();
        String deploymentId = this.createDeployment(null, FIRST_RESOURCE).getId();
        try {
            this.managementService.registerProcessApplication(deploymentId, reference);
            Assert.fail((String)"Exception expected: It should not be possible to register a process application");
        }
        catch (AuthorizationException e) {
            String message = e.getMessage();
            this.testRule.assertTextPresent(REQUIRED_ADMIN_AUTH_EXCEPTION, message);
        }
        this.deleteDeployment(deploymentId);
    }

    @Test
    public void testRegisterProcessApplicationAsCamundaAdmin() {
        this.identityService.setAuthentication(this.userId, Collections.singletonList("camunda-admin"));
        EmbeddedProcessApplication processApplication = new EmbeddedProcessApplication();
        ProcessApplicationReference reference = processApplication.getReference();
        String deploymentId = this.createDeployment(null, FIRST_RESOURCE).getId();
        ProcessApplicationRegistration registration = this.managementService.registerProcessApplication(deploymentId, reference);
        Assert.assertNotNull((Object)registration);
        Assert.assertNotNull((Object)this.getProcessApplicationForDeployment(deploymentId));
        this.deleteDeployment(deploymentId);
    }

    @Test
    public void testUnregisterProcessApplicationWithoutAuthorization() {
        EmbeddedProcessApplication processApplication = new EmbeddedProcessApplication();
        String deploymentId = this.createDeployment(null, FIRST_RESOURCE).getId();
        ProcessApplicationReference reference = processApplication.getReference();
        this.registerProcessApplication(deploymentId, reference);
        try {
            this.managementService.unregisterProcessApplication(deploymentId, true);
            Assert.fail((String)"Exception expected: It should not be possible to unregister a process application");
        }
        catch (AuthorizationException e) {
            String message = e.getMessage();
            this.testRule.assertTextPresent(REQUIRED_ADMIN_AUTH_EXCEPTION, message);
        }
        this.deleteDeployment(deploymentId);
    }

    @Test
    public void testUnregisterProcessApplicationAsCamundaAdmin() {
        this.identityService.setAuthentication(this.userId, Collections.singletonList("camunda-admin"));
        EmbeddedProcessApplication processApplication = new EmbeddedProcessApplication();
        String deploymentId = this.createDeployment(null, FIRST_RESOURCE).getId();
        ProcessApplicationReference reference = processApplication.getReference();
        this.registerProcessApplication(deploymentId, reference);
        this.managementService.unregisterProcessApplication(deploymentId, true);
        Assert.assertNull((Object)this.getProcessApplicationForDeployment(deploymentId));
        this.deleteDeployment(deploymentId);
    }

    @Test
    public void testGetProcessApplicationForDeploymentWithoutAuthorization() {
        EmbeddedProcessApplication processApplication = new EmbeddedProcessApplication();
        String deploymentId = this.createDeployment(null, FIRST_RESOURCE).getId();
        ProcessApplicationReference reference = processApplication.getReference();
        this.registerProcessApplication(deploymentId, reference);
        try {
            this.managementService.getProcessApplicationForDeployment(deploymentId);
            Assert.fail((String)"Exception expected: It should not be possible to get the process application");
        }
        catch (AuthorizationException e) {
            String message = e.getMessage();
            this.testRule.assertTextPresent(REQUIRED_ADMIN_AUTH_EXCEPTION, message);
        }
        this.deleteDeployment(deploymentId);
    }

    @Test
    public void testGetProcessApplicationForDeploymentAsCamundaAdmin() {
        this.identityService.setAuthentication(this.userId, Collections.singletonList("camunda-admin"));
        EmbeddedProcessApplication processApplication = new EmbeddedProcessApplication();
        String deploymentId = this.createDeployment(null, FIRST_RESOURCE).getId();
        ProcessApplicationReference reference = processApplication.getReference();
        this.registerProcessApplication(deploymentId, reference);
        String application = this.managementService.getProcessApplicationForDeployment(deploymentId);
        Assert.assertNotNull((Object)application);
        this.deleteDeployment(deploymentId);
    }

    @Test
    public void testGetRegisteredDeploymentsWithoutAuthorization() {
        String deploymentId = this.createDeployment(null, FIRST_RESOURCE).getId();
        try {
            this.managementService.getRegisteredDeployments();
            Assert.fail((String)"Exception expected: It should not be possible to get the registered deployments");
        }
        catch (AuthorizationException e) {
            String message = e.getMessage();
            this.testRule.assertTextPresent(REQUIRED_ADMIN_AUTH_EXCEPTION, message);
        }
        this.deleteDeployment(deploymentId);
    }

    @Test
    public void testGetRegisteredDeploymentsAsCamundaAdmin() {
        this.identityService.setAuthentication(this.userId, Collections.singletonList("camunda-admin"));
        String deploymentId = this.createDeployment(null, FIRST_RESOURCE).getId();
        Set deployments = this.managementService.getRegisteredDeployments();
        Assert.assertTrue((boolean)deployments.contains(deploymentId));
        this.deleteDeployment(deploymentId);
    }

    @Test
    public void testRegisterDeploymentForJobExecutorWithoutAuthorization() {
        String deploymentId = this.createDeployment(null, FIRST_RESOURCE).getId();
        try {
            this.managementService.registerDeploymentForJobExecutor(deploymentId);
            Assert.fail((String)"Exception expected: It should not be possible to register the deployment");
        }
        catch (AuthorizationException e) {
            String message = e.getMessage();
            this.testRule.assertTextPresent(REQUIRED_ADMIN_AUTH_EXCEPTION, message);
        }
        this.deleteDeployment(deploymentId);
    }

    @Test
    public void testRegisterDeploymentForJobExecutorAsCamundaAdmin() {
        this.identityService.setAuthentication(this.userId, Collections.singletonList("camunda-admin"));
        String deploymentId = this.createDeployment(null, FIRST_RESOURCE).getId();
        this.managementService.registerDeploymentForJobExecutor(deploymentId);
        Assert.assertTrue((boolean)this.getRegisteredDeployments().contains(deploymentId));
        this.deleteDeployment(deploymentId);
    }

    @Test
    public void testUnregisterDeploymentForJobExecutorWithoutAuthorization() {
        String deploymentId = this.createDeployment(null, FIRST_RESOURCE).getId();
        try {
            this.managementService.unregisterDeploymentForJobExecutor(deploymentId);
            Assert.fail((String)"Exception expected: It should not be possible to unregister the deployment");
        }
        catch (AuthorizationException e) {
            String message = e.getMessage();
            this.testRule.assertTextPresent(REQUIRED_ADMIN_AUTH_EXCEPTION, message);
        }
        this.deleteDeployment(deploymentId);
    }

    @Test
    public void testUnregisterDeploymentForJobExecutorAsCamundaAdmin() {
        this.identityService.setAuthentication(this.userId, Collections.singletonList("camunda-admin"));
        String deploymentId = this.createDeployment(null, FIRST_RESOURCE).getId();
        this.managementService.unregisterDeploymentForJobExecutor(deploymentId);
        Assert.assertFalse((boolean)this.getRegisteredDeployments().contains(deploymentId));
        this.deleteDeployment(deploymentId);
    }

    protected void verifyQueryResults(DeploymentQuery query, int countExpected) {
        this.verifyQueryResults((Query<?, ?>)((AbstractQuery)query), countExpected);
    }

    protected String createDeployment(String name) {
        return this.createDeployment(name, FIRST_RESOURCE, SECOND_RESOURCE).getId();
    }

    protected void registerProcessApplication(String deploymentId, ProcessApplicationReference reference) {
        this.disableAuthorization();
        this.managementService.registerProcessApplication(deploymentId, reference);
        this.enableAuthorization();
    }

    protected String getProcessApplicationForDeployment(String deploymentId) {
        this.disableAuthorization();
        String applications = this.managementService.getProcessApplicationForDeployment(deploymentId);
        this.enableAuthorization();
        return applications;
    }

    protected Set<String> getRegisteredDeployments() {
        this.disableAuthorization();
        Set deployments = this.managementService.getRegisteredDeployments();
        this.enableAuthorization();
        return deployments;
    }
}

