/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.authorization.dmn;

import java.io.InputStream;
import org.camunda.bpm.engine.AuthorizationException;
import org.camunda.bpm.engine.authorization.Permission;
import org.camunda.bpm.engine.authorization.Permissions;
import org.camunda.bpm.engine.authorization.Resource;
import org.camunda.bpm.engine.authorization.Resources;
import org.camunda.bpm.engine.query.Query;
import org.camunda.bpm.engine.repository.DecisionDefinition;
import org.camunda.bpm.engine.repository.DecisionDefinitionQuery;
import org.camunda.bpm.engine.test.api.authorization.AuthorizationTest;
import org.camunda.bpm.model.dmn.DmnModelInstance;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class DecisionDefinitionAuthorizationTest
extends AuthorizationTest {
    protected static final String PROCESS_KEY = "testProcess";
    protected static final String DECISION_DEFINITION_KEY = "sampleDecision";

    @Override
    @Before
    public void setUp() throws Exception {
        this.testRule.deploy("org/camunda/bpm/engine/test/api/authorization/singleDecision.dmn11.xml", "org/camunda/bpm/engine/test/api/authorization/anotherDecision.dmn11.xml");
        super.setUp();
    }

    @Test
    public void testQueryWithoutAuthorization() {
        DecisionDefinitionQuery query = this.repositoryService.createDecisionDefinitionQuery();
        this.verifyQueryResults((Query<?, ?>)query, 0);
    }

    @Test
    public void testQueryWithReadPermissionOnAnyDecisionDefinition() {
        this.createGrantAuthorization((Resource)Resources.DECISION_DEFINITION, "*", this.userId, new Permission[]{Permissions.READ});
        DecisionDefinitionQuery query = this.repositoryService.createDecisionDefinitionQuery();
        this.verifyQueryResults((Query<?, ?>)query, 2);
    }

    @Test
    public void testQueryWithReadPermissionOnOneDecisionDefinition() {
        this.createGrantAuthorization((Resource)Resources.DECISION_DEFINITION, DECISION_DEFINITION_KEY, this.userId, new Permission[]{Permissions.READ});
        DecisionDefinitionQuery query = this.repositoryService.createDecisionDefinitionQuery();
        this.verifyQueryResults((Query<?, ?>)query, 1);
        DecisionDefinition definition = (DecisionDefinition)query.singleResult();
        Assert.assertNotNull((Object)definition);
        Assert.assertEquals((Object)DECISION_DEFINITION_KEY, (Object)definition.getKey());
    }

    @Test
    public void testQueryWithMultiple() {
        this.createGrantAuthorization((Resource)Resources.DECISION_DEFINITION, DECISION_DEFINITION_KEY, this.userId, new Permission[]{Permissions.READ});
        this.createGrantAuthorization((Resource)Resources.DECISION_DEFINITION, "*", this.userId, new Permission[]{Permissions.READ});
        DecisionDefinitionQuery query = this.repositoryService.createDecisionDefinitionQuery();
        this.verifyQueryResults((Query<?, ?>)query, 2);
    }

    @Test
    public void testGetDecisionDefinitionWithoutAuthorizations() {
        String decisionDefinitionId = this.selectDecisionDefinitionByKey(DECISION_DEFINITION_KEY).getId();
        try {
            this.repositoryService.getDecisionDefinition(decisionDefinitionId);
            Assert.fail((String)"Exception expected");
        }
        catch (AuthorizationException e) {
            String message = e.getMessage();
            this.testRule.assertTextPresent(this.userId, message);
            this.testRule.assertTextPresent(Permissions.READ.getName(), message);
            this.testRule.assertTextPresent(DECISION_DEFINITION_KEY, message);
            this.testRule.assertTextPresent(Resources.DECISION_DEFINITION.resourceName(), message);
        }
    }

    @Test
    public void testGetDecisionDefinition() {
        String decisionDefinitionId = this.selectDecisionDefinitionByKey(DECISION_DEFINITION_KEY).getId();
        this.createGrantAuthorization((Resource)Resources.DECISION_DEFINITION, DECISION_DEFINITION_KEY, this.userId, new Permission[]{Permissions.READ});
        DecisionDefinition decisionDefinition = this.repositoryService.getDecisionDefinition(decisionDefinitionId);
        Assert.assertNotNull((Object)decisionDefinition);
    }

    @Test
    public void testGetDecisionDiagramWithoutAuthorizations() {
        String decisionDefinitionId = this.selectDecisionDefinitionByKey(DECISION_DEFINITION_KEY).getId();
        try {
            this.repositoryService.getDecisionDiagram(decisionDefinitionId);
            Assert.fail((String)"Exception expected");
        }
        catch (AuthorizationException e) {
            String message = e.getMessage();
            this.testRule.assertTextPresent(this.userId, message);
            this.testRule.assertTextPresent(Permissions.READ.getName(), message);
            this.testRule.assertTextPresent(DECISION_DEFINITION_KEY, message);
            this.testRule.assertTextPresent(Resources.DECISION_DEFINITION.resourceName(), message);
        }
    }

    @Test
    public void testGetDecisionDiagram() {
        String decisionDefinitionId = this.selectDecisionDefinitionByKey(DECISION_DEFINITION_KEY).getId();
        this.createGrantAuthorization((Resource)Resources.DECISION_DEFINITION, DECISION_DEFINITION_KEY, this.userId, new Permission[]{Permissions.READ});
        InputStream stream = this.repositoryService.getDecisionDiagram(decisionDefinitionId);
        Assert.assertNull((Object)stream);
    }

    @Test
    public void testGetDecisionModelWithoutAuthorizations() {
        String decisionDefinitionId = this.selectDecisionDefinitionByKey(DECISION_DEFINITION_KEY).getId();
        try {
            this.repositoryService.getDecisionModel(decisionDefinitionId);
            Assert.fail((String)"Exception expected");
        }
        catch (AuthorizationException e) {
            String message = e.getMessage();
            this.testRule.assertTextPresent(this.userId, message);
            this.testRule.assertTextPresent(Permissions.READ.getName(), message);
            this.testRule.assertTextPresent(DECISION_DEFINITION_KEY, message);
            this.testRule.assertTextPresent(Resources.DECISION_DEFINITION.resourceName(), message);
        }
    }

    @Test
    public void testGetDecisionModel() {
        String decisionDefinitionId = this.selectDecisionDefinitionByKey(DECISION_DEFINITION_KEY).getId();
        this.createGrantAuthorization((Resource)Resources.DECISION_DEFINITION, DECISION_DEFINITION_KEY, this.userId, new Permission[]{Permissions.READ});
        InputStream stream = this.repositoryService.getDecisionModel(decisionDefinitionId);
        Assert.assertNotNull((Object)stream);
    }

    @Test
    public void testGetDmnModelInstanceWithoutAuthorizations() {
        String decisionDefinitionId = this.selectDecisionDefinitionByKey(DECISION_DEFINITION_KEY).getId();
        try {
            this.repositoryService.getDmnModelInstance(decisionDefinitionId);
            Assert.fail((String)"Exception expected");
        }
        catch (AuthorizationException e) {
            String message = e.getMessage();
            this.testRule.assertTextPresent(this.userId, message);
            this.testRule.assertTextPresent(Permissions.READ.getName(), message);
            this.testRule.assertTextPresent(DECISION_DEFINITION_KEY, message);
            this.testRule.assertTextPresent(Resources.DECISION_DEFINITION.resourceName(), message);
        }
    }

    @Test
    public void testGetDmnModelInstance() {
        String decisionDefinitionId = this.selectDecisionDefinitionByKey(DECISION_DEFINITION_KEY).getId();
        this.createGrantAuthorization((Resource)Resources.DECISION_DEFINITION, DECISION_DEFINITION_KEY, this.userId, new Permission[]{Permissions.READ});
        DmnModelInstance modelInstance = this.repositoryService.getDmnModelInstance(decisionDefinitionId);
        Assert.assertNotNull((Object)modelInstance);
    }

    @Test
    public void testDecisionDefinitionUpdateTimeToLive() {
        String decisionDefinitionId = this.selectDecisionDefinitionByKey(DECISION_DEFINITION_KEY).getId();
        this.createGrantAuthorization((Resource)Resources.DECISION_DEFINITION, DECISION_DEFINITION_KEY, this.userId, new Permission[]{Permissions.UPDATE});
        this.repositoryService.updateDecisionDefinitionHistoryTimeToLive(decisionDefinitionId, Integer.valueOf(6));
        Assert.assertEquals((long)6L, (long)this.selectDecisionDefinitionByKey(DECISION_DEFINITION_KEY).getHistoryTimeToLive().intValue());
    }

    @Test
    public void testDecisionDefinitionUpdateTimeToLiveWithoutAuthorizations() {
        String decisionDefinitionId = this.selectDecisionDefinitionByKey(DECISION_DEFINITION_KEY).getId();
        try {
            this.repositoryService.updateDecisionDefinitionHistoryTimeToLive(decisionDefinitionId, Integer.valueOf(6));
            Assert.fail((String)"Exception expected");
        }
        catch (AuthorizationException e) {
            String message = e.getMessage();
            this.testRule.assertTextPresent(this.userId, message);
            this.testRule.assertTextPresent(Permissions.UPDATE.getName(), message);
            this.testRule.assertTextPresent(DECISION_DEFINITION_KEY, message);
            this.testRule.assertTextPresent(Resources.DECISION_DEFINITION.resourceName(), message);
        }
    }
}

