/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.history;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.camunda.bpm.engine.HistoryService;
import org.camunda.bpm.engine.ManagementService;
import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.RepositoryService;
import org.camunda.bpm.engine.RuntimeService;
import org.camunda.bpm.engine.history.HistoricProcessInstanceQuery;
import org.camunda.bpm.engine.runtime.Job;
import org.camunda.bpm.engine.runtime.ProcessInstance;
import org.camunda.bpm.engine.test.Deployment;
import org.camunda.bpm.engine.test.ProcessEngineRule;
import org.camunda.bpm.engine.test.RequiredHistoryLevel;
import org.camunda.bpm.engine.test.util.ProvidedProcessEngineRule;
import org.camunda.bpm.model.bpmn.Bpmn;
import org.camunda.bpm.model.bpmn.BpmnModelInstance;
import org.camunda.bpm.model.bpmn.builder.ProcessBuilder;
import org.camunda.bpm.model.bpmn.builder.StartEventBuilder;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;

@RequiredHistoryLevel(value="audit")
public class HistoricProcessInstanceQueryOrTest {
    @Rule
    public ProcessEngineRule processEngineRule = new ProvidedProcessEngineRule();
    protected HistoryService historyService;
    protected RuntimeService runtimeService;
    protected RepositoryService repositoryService;
    protected ManagementService managementService;
    protected List<String> deploymentIds = new ArrayList<String>();

    @Before
    public void init() {
        this.historyService = this.processEngineRule.getHistoryService();
        this.runtimeService = this.processEngineRule.getRuntimeService();
        this.repositoryService = this.processEngineRule.getRepositoryService();
        this.managementService = this.processEngineRule.getManagementService();
    }

    @After
    public void deleteDeployments() {
        for (String deploymentId : this.deploymentIds) {
            this.repositoryService.deleteDeployment(deploymentId, true);
        }
    }

    @Test
    public void shouldThrowExceptionByMissingStartOr() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.historyService.createHistoricProcessInstanceQuery().or().endOr().endOr()).isInstanceOf(ProcessEngineException.class)).hasMessageContaining("Invalid query usage: cannot set endOr() before or()");
    }

    @Test
    public void shouldThrowExceptionByNesting() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.historyService.createHistoricProcessInstanceQuery().or().or().endOr().endOr().or().endOr()).isInstanceOf(ProcessEngineException.class)).hasMessageContaining("Invalid query usage: cannot set or() within 'or' query");
    }

    @Test
    public void shouldThrowExceptionOnOrderByProcessInstanceId() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.historyService.createHistoricProcessInstanceQuery().or().orderByProcessInstanceId().endOr()).isInstanceOf(ProcessEngineException.class)).hasMessageContaining("Invalid query usage: cannot set orderByProcessInstanceId() within 'or' query");
    }

    @Test
    public void shouldThrowExceptionOnOrderByProcessDefinitionId() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.historyService.createHistoricProcessInstanceQuery().or().orderByProcessDefinitionId().endOr()).isInstanceOf(ProcessEngineException.class)).hasMessageContaining("Invalid query usage: cannot set orderByProcessDefinitionId() within 'or' query");
    }

    @Test
    public void shouldThrowExceptionOnOrderByProcessDefinitionKey() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.historyService.createHistoricProcessInstanceQuery().or().orderByProcessDefinitionKey().endOr()).isInstanceOf(ProcessEngineException.class)).hasMessageContaining("Invalid query usage: cannot set orderByProcessDefinitionKey() within 'or' query");
    }

    @Test
    public void shouldThrowExceptionOnOrderByTenantId() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.historyService.createHistoricProcessInstanceQuery().or().orderByTenantId().endOr()).isInstanceOf(ProcessEngineException.class)).hasMessageContaining("Invalid query usage: cannot set orderByTenantId() within 'or' query");
    }

    @Test
    public void shouldThrowExceptionOnOrderByProcessInstanceDuration() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.historyService.createHistoricProcessInstanceQuery().or().orderByProcessInstanceDuration().endOr()).isInstanceOf(ProcessEngineException.class)).hasMessageContaining("Invalid query usage: cannot set orderByProcessInstanceDuration() within 'or' query");
    }

    @Test
    public void shouldThrowExceptionOnOrderByProcessInstanceStartTime() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.historyService.createHistoricProcessInstanceQuery().or().orderByProcessInstanceStartTime().endOr()).isInstanceOf(ProcessEngineException.class)).hasMessageContaining("Invalid query usage: cannot set orderByProcessInstanceStartTime() within 'or' query");
    }

    @Test
    public void shouldThrowExceptionOnOrderByProcessInstanceEndTime() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.historyService.createHistoricProcessInstanceQuery().or().orderByProcessInstanceEndTime().endOr()).isInstanceOf(ProcessEngineException.class)).hasMessageContaining("Invalid query usage: cannot set orderByProcessInstanceEndTime() within 'or' query");
    }

    @Test
    public void shouldThrowExceptionOnOrderByProcessInstanceBusinessKey() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.historyService.createHistoricProcessInstanceQuery().or().orderByProcessInstanceBusinessKey().endOr()).isInstanceOf(ProcessEngineException.class)).hasMessageContaining("Invalid query usage: cannot set orderByProcessInstanceBusinessKey() within 'or' query");
    }

    @Test
    public void shouldThrowExceptionOnOrderByProcessDefinitionName() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.historyService.createHistoricProcessInstanceQuery().or().orderByProcessDefinitionName().endOr()).isInstanceOf(ProcessEngineException.class)).hasMessageContaining("Invalid query usage: cannot set orderByProcessDefinitionName() within 'or' query");
    }

    @Test
    public void shouldThrowExceptionOnOrderByProcessDefinitionVersion() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.historyService.createHistoricProcessInstanceQuery().or().orderByProcessDefinitionVersion().endOr()).isInstanceOf(ProcessEngineException.class)).hasMessageContaining("Invalid query usage: cannot set orderByProcessDefinitionVersion() within 'or' query");
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    public void shouldReturnHistoricProcInstWithEmptyOrQuery() {
        ProcessInstance processInstance1 = this.runtimeService.startProcessInstanceByKey("oneTaskProcess");
        ProcessInstance processInstance2 = this.runtimeService.startProcessInstanceByKey("oneTaskProcess");
        this.runtimeService.deleteProcessInstance(processInstance1.getId(), "test");
        this.runtimeService.deleteProcessInstance(processInstance2.getId(), "test");
        List processInstances = this.historyService.createHistoricProcessInstanceQuery().or().endOr().list();
        Assert.assertEquals((long)2L, (long)processInstances.size());
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    public void shouldReturnHistoricProcInstWithVarValue1OrVarValue2() {
        HashMap<String, String> vars = new HashMap<String, String>();
        vars.put("stringVar", "abcdef");
        this.runtimeService.startProcessInstanceByKey("oneTaskProcess", vars);
        vars = new HashMap();
        vars.put("stringVar", "ghijkl");
        this.runtimeService.startProcessInstanceByKey("oneTaskProcess", vars);
        List processInstances = this.historyService.createHistoricProcessInstanceQuery().or().variableValueEquals("stringVar", (Object)"abcdef").variableValueEquals("stringVar", (Object)"ghijkl").endOr().list();
        Assert.assertEquals((long)2L, (long)processInstances.size());
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    public void shouldReturnHistoricProcInstWithMultipleOrCriteria() {
        ProcessInstance processInstance1 = this.runtimeService.startProcessInstanceByKey("oneTaskProcess");
        HashMap<String, String> vars = new HashMap<String, String>();
        vars.put("stringVar", "abcdef");
        ProcessInstance processInstance2 = this.runtimeService.startProcessInstanceByKey("oneTaskProcess", vars);
        this.runtimeService.setVariable(processInstance2.getProcessInstanceId(), "aVarName", (Object)"varValue");
        vars = new HashMap();
        vars.put("stringVar2", "aaabbbaaa");
        ProcessInstance processInstance3 = this.runtimeService.startProcessInstanceByKey("oneTaskProcess", vars);
        this.runtimeService.setVariable(processInstance3.getProcessInstanceId(), "bVarName", (Object)"bTestb");
        vars = new HashMap();
        vars.put("stringVar2", "cccbbbccc");
        ProcessInstance processInstance4 = this.runtimeService.startProcessInstanceByKey("oneTaskProcess", vars);
        this.runtimeService.setVariable(processInstance4.getProcessInstanceId(), "bVarName", (Object)"aTesta");
        List processInstances = this.historyService.createHistoricProcessInstanceQuery().or().variableValueEquals("stringVar", (Object)"abcdef").variableValueLike("stringVar2", "%bbb%").processInstanceId(processInstance1.getId()).endOr().list();
        Assert.assertEquals((long)4L, (long)processInstances.size());
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    public void shouldReturnHistoricProcInstFilteredByMultipleOrAndCriteria() {
        HashMap<String, Object> vars = new HashMap<String, Object>();
        vars.put("stringVar", "abcdef");
        vars.put("longVar", 12345L);
        ProcessInstance processInstance1 = this.runtimeService.startProcessInstanceByKey("oneTaskProcess", vars);
        vars = new HashMap();
        vars.put("stringVar", "ghijkl");
        vars.put("longVar", 56789L);
        this.runtimeService.startProcessInstanceByKey("oneTaskProcess", vars);
        vars = new HashMap();
        vars.put("stringVar", "abcdef");
        vars.put("longVar", 56789L);
        this.runtimeService.startProcessInstanceByKey("oneTaskProcess", vars);
        vars = new HashMap();
        vars.put("stringVar", "ghijkl");
        vars.put("longVar", 12345L);
        this.runtimeService.startProcessInstanceByKey("oneTaskProcess", vars);
        List processInstances = this.historyService.createHistoricProcessInstanceQuery().or().variableValueEquals("longVar", (Object)56789L).processInstanceId(processInstance1.getId()).endOr().variableValueEquals("stringVar", (Object)"abcdef").list();
        Assert.assertEquals((long)2L, (long)processInstances.size());
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    public void shouldReturnHistoricProcInstFilteredByMultipleOrQueries() {
        HashMap<String, Object> vars = new HashMap<String, Object>();
        vars.put("stringVar", "abcdef");
        vars.put("longVar", 12345L);
        vars.put("boolVar", true);
        this.runtimeService.startProcessInstanceByKey("oneTaskProcess", vars);
        vars = new HashMap();
        vars.put("stringVar", "ghijkl");
        vars.put("longVar", 56789L);
        vars.put("boolVar", true);
        this.runtimeService.startProcessInstanceByKey("oneTaskProcess", vars);
        vars = new HashMap();
        vars.put("stringVar", "abcdef");
        vars.put("longVar", 56789L);
        vars.put("boolVar", true);
        this.runtimeService.startProcessInstanceByKey("oneTaskProcess", vars);
        vars = new HashMap();
        vars.put("stringVar", "ghijkl");
        vars.put("longVar", 12345L);
        vars.put("boolVar", true);
        this.runtimeService.startProcessInstanceByKey("oneTaskProcess", vars);
        vars = new HashMap();
        vars.put("stringVar", "ghijkl");
        vars.put("longVar", 56789L);
        vars.put("boolVar", false);
        this.runtimeService.startProcessInstanceByKey("oneTaskProcess", vars);
        vars = new HashMap();
        vars.put("stringVar", "abcdef");
        vars.put("longVar", 12345L);
        vars.put("boolVar", false);
        this.runtimeService.startProcessInstanceByKey("oneTaskProcess", vars);
        List processInstances = this.historyService.createHistoricProcessInstanceQuery().or().variableValueEquals("stringVar", (Object)"abcdef").variableValueEquals("longVar", (Object)12345L).endOr().or().variableValueEquals("boolVar", (Object)true).variableValueEquals("longVar", (Object)12345L).endOr().or().variableValueEquals("stringVar", (Object)"ghijkl").variableValueEquals("longVar", (Object)56789L).endOr().or().variableValueEquals("stringVar", (Object)"ghijkl").variableValueEquals("boolVar", (Object)false).variableValueEquals("longVar", (Object)56789L).endOr().list();
        Assert.assertEquals((long)2L, (long)processInstances.size());
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    public void shouldReturnHistoricProcInstWhereSameCriterionWasAppliedThreeTimesInOneQuery() {
        ProcessInstance processInstance1 = this.runtimeService.startProcessInstanceByKey("oneTaskProcess");
        ProcessInstance processInstance2 = this.runtimeService.startProcessInstanceByKey("oneTaskProcess");
        ProcessInstance processInstance3 = this.runtimeService.startProcessInstanceByKey("oneTaskProcess");
        List processInstances = this.historyService.createHistoricProcessInstanceQuery().or().processInstanceId(processInstance1.getId()).processInstanceId(processInstance2.getId()).processInstanceId(processInstance3.getId()).endOr().list();
        Assert.assertEquals((long)1L, (long)processInstances.size());
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    public void shouldReturnHistoricProcInstWithVariableValueEqualsOrVariableValueGreaterThan() {
        HashMap<String, Long> vars = new HashMap<String, Long>();
        vars.put("longVar", 12345L);
        this.runtimeService.startProcessInstanceByKey("oneTaskProcess", vars);
        vars = new HashMap();
        vars.put("longerVar", 56789L);
        this.runtimeService.startProcessInstanceByKey("oneTaskProcess", vars);
        vars = new HashMap();
        vars.put("longerVar", 56789L);
        this.runtimeService.startProcessInstanceByKey("oneTaskProcess", vars);
        HistoricProcessInstanceQuery query = this.historyService.createHistoricProcessInstanceQuery().or().variableValueEquals("longVar", (Object)12345L).variableValueGreaterThan("longerVar", (Object)20000L).endOr();
        Assert.assertEquals((long)3L, (long)query.count());
    }

    @Test
    public void shouldReturnHistoricProcInstWithProcessDefinitionNameOrProcessDefinitionKey() {
        BpmnModelInstance aProcessDefinition = ((ProcessBuilder)Bpmn.createExecutableProcess((String)"aProcessDefinition").name("process1")).startEvent().userTask().endEvent().done();
        String deploymentId = this.repositoryService.createDeployment().addModelInstance("foo.bpmn", aProcessDefinition).deploy().getId();
        this.deploymentIds.add(deploymentId);
        ProcessInstance processInstance1 = this.runtimeService.startProcessInstanceByKey("aProcessDefinition");
        BpmnModelInstance anotherProcessDefinition = Bpmn.createExecutableProcess((String)"anotherProcessDefinition").startEvent().userTask().endEvent().done();
        deploymentId = this.repositoryService.createDeployment().addModelInstance("foo.bpmn", anotherProcessDefinition).deploy().getId();
        this.deploymentIds.add(deploymentId);
        this.runtimeService.startProcessInstanceByKey("anotherProcessDefinition");
        List processInstances = this.historyService.createHistoricProcessInstanceQuery().or().processDefinitionId(processInstance1.getProcessDefinitionId()).processDefinitionKey("anotherProcessDefinition").endOr().list();
        Assert.assertEquals((long)2L, (long)processInstances.size());
    }

    @Test
    public void shouldReturnHistoricProcInstWithBusinessKeyOrBusinessKeyLike() {
        BpmnModelInstance aProcessDefinition = Bpmn.createExecutableProcess((String)"aProcessDefinition").startEvent().userTask().endEvent().done();
        String deploymentId = this.repositoryService.createDeployment().addModelInstance("foo.bpmn", aProcessDefinition).deploy().getId();
        this.deploymentIds.add(deploymentId);
        this.runtimeService.startProcessInstanceByKey("aProcessDefinition", "aBusinessKey");
        BpmnModelInstance anotherProcessDefinition = Bpmn.createExecutableProcess((String)"anotherProcessDefinition").startEvent().userTask().endEvent().done();
        deploymentId = this.repositoryService.createDeployment().addModelInstance("foo.bpmn", anotherProcessDefinition).deploy().getId();
        this.deploymentIds.add(deploymentId);
        this.runtimeService.startProcessInstanceByKey("anotherProcessDefinition", "anotherBusinessKey");
        List processInstances = this.historyService.createHistoricProcessInstanceQuery().or().processInstanceBusinessKey("aBusinessKey").processInstanceBusinessKeyLike("anotherBusinessKey").endOr().list();
        Assert.assertEquals((long)2L, (long)processInstances.size());
    }

    @Test
    public void shouldReturnHistoricProcInstWithActivityIdInOrProcInstId() {
        BpmnModelInstance aProcessDefinition = Bpmn.createExecutableProcess((String)"aProcessDefinition").startEvent().userTask().endEvent().done();
        String deploymentId = this.repositoryService.createDeployment().addModelInstance("foo.bpmn", aProcessDefinition).deploy().getId();
        this.deploymentIds.add(deploymentId);
        ProcessInstance processInstance1 = this.runtimeService.startProcessInstanceByKey("aProcessDefinition");
        String activityInstanceId = this.runtimeService.getActivityInstance(processInstance1.getId()).getChildActivityInstances()[0].getActivityId();
        ProcessInstance processInstance2 = this.runtimeService.startProcessInstanceByKey("aProcessDefinition");
        List tasks = this.historyService.createHistoricProcessInstanceQuery().or().activeActivityIdIn(new String[]{activityInstanceId}).processInstanceId(processInstance2.getId()).endOr().list();
        Assert.assertEquals((long)2L, (long)tasks.size());
    }

    @Test
    public void shouldReturnHistoricProcInstByVariableAndActiveProcesses() {
        BpmnModelInstance aProcessDefinition = Bpmn.createExecutableProcess((String)"oneTaskProcess").startEvent().userTask("testQuerySuspensionStateTask").endEvent().done();
        String deploymentId = this.repositoryService.createDeployment().addModelInstance("foo.bpmn", aProcessDefinition).deploy().getId();
        this.deploymentIds.add(deploymentId);
        this.runtimeService.startProcessInstanceByKey("oneTaskProcess");
        this.runtimeService.startProcessInstanceByKey("oneTaskProcess");
        HashMap<String, Integer> variables = new HashMap<String, Integer>();
        variables.put("foo", 0);
        ProcessInstance suspendedProcessInstance = this.runtimeService.startProcessInstanceByKey("oneTaskProcess", variables);
        this.runtimeService.suspendProcessInstanceById(suspendedProcessInstance.getProcessInstanceId());
        Assert.assertEquals((long)2L, (long)this.historyService.createHistoricProcessInstanceQuery().processDefinitionKey("oneTaskProcess").active().count());
        Assert.assertEquals((long)1L, (long)this.historyService.createHistoricProcessInstanceQuery().processDefinitionKey("oneTaskProcess").suspended().count());
        Assert.assertEquals((long)3L, (long)this.historyService.createHistoricProcessInstanceQuery().or().active().variableValueEquals("foo", (Object)0).endOr().list().size());
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    public void shouldReturnByProcessDefinitionKeyOrActivityId() {
        this.runtimeService.startProcessInstanceByKey("oneTaskProcess");
        BpmnModelInstance aProcessDefinition = Bpmn.createExecutableProcess((String)"process").startEvent().userTask("aUserTask").endEvent().done();
        String deploymentId = this.repositoryService.createDeployment().addModelInstance("foo.bpmn", aProcessDefinition).deploy().getId();
        this.deploymentIds.add(deploymentId);
        this.runtimeService.startProcessInstanceByKey("process");
        List processInstances = this.historyService.createHistoricProcessInstanceQuery().or().activeActivityIdIn(new String[]{"theTask"}).processDefinitionKey("process").endOr().list();
        Assertions.assertThat((int)processInstances.size()).isEqualTo(2);
    }

    @Test
    @RequiredHistoryLevel(value="full")
    @Deployment(resources={"org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    public void shouldReturnByProcessDefinitionIdOrIncidentType() {
        String processDefinitionId = this.runtimeService.startProcessInstanceByKey("oneTaskProcess").getProcessDefinitionId();
        BpmnModelInstance aProcessDefinition = ((StartEventBuilder)Bpmn.createExecutableProcess((String)"process").startEvent().camundaAsyncBefore()).userTask("aUserTask").endEvent().done();
        String deploymentId = this.repositoryService.createDeployment().addModelInstance("foo.bpmn", aProcessDefinition).deploy().getId();
        this.deploymentIds.add(deploymentId);
        this.runtimeService.startProcessInstanceByKey("process");
        String jobId = ((Job)this.managementService.createJobQuery().singleResult()).getId();
        this.managementService.setJobRetries(jobId, 0);
        List processInstances = this.historyService.createHistoricProcessInstanceQuery().or().incidentType("failedJob").processDefinitionId(processDefinitionId).endOr().list();
        Assertions.assertThat((int)processInstances.size()).isEqualTo(2);
    }
}

