/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.jobexecutor;

import java.util.List;
import org.assertj.core.api.Assertions;
import org.camunda.bpm.engine.batch.Batch;
import org.camunda.bpm.engine.impl.Page;
import org.camunda.bpm.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.camunda.bpm.engine.impl.interceptor.Command;
import org.camunda.bpm.engine.impl.interceptor.CommandContext;
import org.camunda.bpm.engine.impl.persistence.entity.AcquirableJobEntity;
import org.camunda.bpm.engine.runtime.Job;
import org.camunda.bpm.engine.test.ProcessEngineRule;
import org.camunda.bpm.engine.test.api.runtime.migration.MigrationTestRule;
import org.camunda.bpm.engine.test.api.runtime.migration.batch.BatchMigrationHelper;
import org.camunda.bpm.engine.test.util.ProvidedProcessEngineRule;
import org.junit.After;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;

public class BatchJobPriorityRangeTest {
    protected ProcessEngineRule rule = new ProvidedProcessEngineRule();
    protected MigrationTestRule migrationRule = new MigrationTestRule(this.rule);
    protected BatchMigrationHelper helper = new BatchMigrationHelper(this.rule, this.migrationRule);
    @Rule
    public RuleChain ruleChain = RuleChain.outerRule((TestRule)this.rule).around((TestRule)this.migrationRule);
    ProcessEngineConfigurationImpl configuration;
    protected long defaultBatchJobPriority;
    protected int defaultBatchJobsPerSeed;
    protected Long defaultJobExecutorPriorityRangeMin;
    protected Long defaultJobExecutorPriorityRangeMax;

    @Before
    public void setup() {
        this.configuration = this.rule.getProcessEngineConfiguration();
        this.defaultBatchJobPriority = this.configuration.getHistoryCleanupJobPriority();
        this.defaultBatchJobsPerSeed = this.configuration.getBatchJobsPerSeed();
        this.defaultBatchJobPriority = this.configuration.getBatchJobPriority();
        this.defaultJobExecutorPriorityRangeMin = this.configuration.getJobExecutorPriorityRangeMin();
        this.defaultJobExecutorPriorityRangeMax = this.configuration.getJobExecutorPriorityRangeMax();
    }

    @After
    public void tearDown() {
        this.configuration.setBatchJobPriority(this.defaultBatchJobPriority);
        this.configuration.setBatchJobsPerSeed(this.defaultBatchJobsPerSeed);
        this.configuration.setJobExecutorPriorityRangeMin(this.defaultJobExecutorPriorityRangeMin);
        this.configuration.setJobExecutorPriorityRangeMax(this.defaultJobExecutorPriorityRangeMax);
        this.helper.removeAllRunningAndHistoricBatches();
    }

    @Test
    public void shouldSetConfiguredPriorityOnBatchCleanupJob() {
        this.configuration.setBatchJobPriority(10L);
        Batch batch = this.helper.migrateProcessInstancesAsync(1);
        Job seedJob = this.helper.getSeedJob(batch);
        this.helper.completeSeedJobs(batch);
        Job monitorJob = this.helper.getMonitorJob(batch);
        Job executionJob = this.helper.getExecutionJobs(batch).get(0);
        Assertions.assertThat((long)seedJob.getPriority()).isEqualTo(10L);
        Assertions.assertThat((long)monitorJob.getPriority()).isEqualTo(10L);
        Assertions.assertThat((long)executionJob.getPriority()).isEqualTo(10L);
    }

    @Test
    public void shouldAcquireBatchJobInPriorityRange() {
        this.configuration.setJobExecutorPriorityRangeMin(Long.valueOf(5L));
        this.configuration.setJobExecutorPriorityRangeMax(Long.valueOf(15L));
        this.configuration.setBatchJobPriority(10L);
        Batch batch = this.helper.migrateProcessInstancesAsync(1);
        this.checkAndCompleteSeedJob(batch, 10L);
        this.checkAndCompleteMonitorAndExecutionJobs(batch, 10L);
    }

    @Test
    public void shouldNotAcquireBatchJobOutsidePriorityRange() {
        this.configuration.setJobExecutorPriorityRangeMin(Long.valueOf(5L));
        this.configuration.setJobExecutorPriorityRangeMax(Long.valueOf(15L));
        this.configuration.setBatchJobPriority(20L);
        Batch batch = this.helper.migrateProcessInstancesAsync(1);
        List<AcquirableJobEntity> acquirableJobs = this.findAcquirableJobs();
        Assertions.assertThat(acquirableJobs).hasSize(0);
        Job seedJob = this.helper.getSeedJob(batch);
        Assertions.assertThat((long)seedJob.getPriority()).isEqualTo(20L);
        this.helper.completeSeedJobs(batch);
        List<Job> executionJobs = this.helper.getExecutionJobs(batch);
        Assertions.assertThat(executionJobs).hasSize(1);
        Assertions.assertThat((long)executionJobs.get(0).getPriority()).isEqualTo(20L);
        this.helper.completeExecutionJobs(batch);
        Job monitorJob = this.helper.getMonitorJob(batch);
        Assertions.assertThat((long)monitorJob.getPriority()).isEqualTo(20L);
        this.helper.completeMonitorJobs(batch);
    }

    private void checkAndCompleteSeedJob(Batch batch, Long priority) {
        List<AcquirableJobEntity> jobs = this.findAcquirableJobs();
        Job seedJob = this.helper.getSeedJob(batch);
        Assertions.assertThat(jobs).hasSize(1);
        Assertions.assertThat((String)jobs.get(0).getId()).isEqualTo((Object)seedJob.getId());
        Assertions.assertThat((long)seedJob.getPriority()).isEqualTo((Object)priority);
        this.helper.completeSeedJobs(batch);
    }

    private void checkAndCompleteMonitorAndExecutionJobs(Batch batch, Long priority) {
        List<AcquirableJobEntity> jobs = this.findAcquirableJobs();
        Job monitorJob = this.helper.getMonitorJob(batch);
        List<Job> executionJobs = this.helper.getExecutionJobs(batch);
        Assertions.assertThat(jobs).hasSize(2);
        Assertions.assertThat(executionJobs).hasSize(1);
        Assertions.assertThat(jobs).extracting("id").containsExactlyInAnyOrder(new Object[]{monitorJob.getId(), executionJobs.get(0).getId()});
        Assertions.assertThat((long)monitorJob.getPriority()).isEqualTo((Object)priority);
        Assertions.assertThat((long)executionJobs.get(0).getPriority()).isEqualTo((Object)priority);
        this.helper.completeExecutionJobs(batch);
        this.helper.completeMonitorJobs(batch);
    }

    private List<AcquirableJobEntity> findAcquirableJobs() {
        return (List)this.configuration.getCommandExecutorTxRequired().execute((Command)new Command<List<AcquirableJobEntity>>(){

            public List<AcquirableJobEntity> execute(CommandContext commandContext) {
                return commandContext.getJobManager().findNextJobsToExecute(new Page(0, 100));
            }
        });
    }
}

