/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.jobexecutor;

import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.camunda.bpm.engine.ProcessEngineConfiguration;
import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public class JobExecutorPriorityRangeConfigurationTest {
    ProcessEngineConfigurationImpl config;
    protected Long defaultJobExecutorPriorityRangeMin;
    protected Long defaultJobExecutorPriorityRangeMax;

    @Before
    public void setup() {
        this.config = (ProcessEngineConfigurationImpl)ProcessEngineConfiguration.createProcessEngineConfigurationFromResource((String)"camunda.cfg.xml");
        this.defaultJobExecutorPriorityRangeMin = this.config.getJobExecutorPriorityRangeMin();
        this.defaultJobExecutorPriorityRangeMax = this.config.getJobExecutorPriorityRangeMax();
    }

    @After
    public void tearDown() {
        this.config.setJobExecutorPriorityRangeMin(this.defaultJobExecutorPriorityRangeMin);
        this.config.setJobExecutorPriorityRangeMax(this.defaultJobExecutorPriorityRangeMax);
    }

    @Test
    public void shouldAcceptValidPriorityRangeConfiguration() {
        this.config.setJobExecutorPriorityRangeMin(Long.valueOf(10L));
        this.config.setJobExecutorPriorityRangeMax(Long.valueOf(10L));
        this.config.buildProcessEngine();
        Assertions.assertThat((Long)this.config.getJobExecutorPriorityRangeMin()).isEqualTo(10L);
        Assertions.assertThat((Long)this.config.getJobExecutorPriorityRangeMax()).isEqualTo(10L);
    }

    @Test
    public void shouldThrowExceptionOnNegativeMinPriorityRangeConfiguration() {
        this.config.setJobExecutorPriorityRangeMin(Long.valueOf(-10L));
        this.config.setJobExecutorPriorityRangeMax(Long.valueOf(0L));
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.config.buildProcessEngine()).isInstanceOf(ProcessEngineException.class)).hasMessage("ENGINE-14031 Invalid configuration for job executor priority range. Reason: job executor priority range can not be negative");
    }

    @Test
    public void shouldThrowExceptionOnNegativeMaxPriorityRangeConfiguration() {
        this.config.setJobExecutorPriorityRangeMin(null);
        this.config.setJobExecutorPriorityRangeMax(Long.valueOf(-10L));
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.config.buildProcessEngine()).isInstanceOf(ProcessEngineException.class)).hasMessage("ENGINE-14031 Invalid configuration for job executor priority range. Reason: jobExecutorPriorityRangeMin can not be greater than jobExecutorPriorityRangeMax");
    }

    @Test
    public void shouldThrowExceptionJobExecutorPriorityMinLargerThanMax() {
        this.config.setJobExecutorPriorityRangeMin(Long.valueOf(10L));
        this.config.setJobExecutorPriorityRangeMax(Long.valueOf(5L));
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.config.buildProcessEngine()).isInstanceOf(ProcessEngineException.class)).hasMessage("ENGINE-14031 Invalid configuration for job executor priority range. Reason: jobExecutorPriorityRangeMin can not be greater than jobExecutorPriorityRangeMax");
    }
}

