/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.standalone.entity;

import java.util.List;
import org.camunda.bpm.engine.impl.incident.IncidentContext;
import org.camunda.bpm.engine.impl.interceptor.Command;
import org.camunda.bpm.engine.impl.interceptor.CommandContext;
import org.camunda.bpm.engine.impl.persistence.entity.ExecutionEntity;
import org.camunda.bpm.engine.impl.persistence.entity.IncidentEntity;
import org.camunda.bpm.engine.impl.util.BitMaskUtil;
import org.camunda.bpm.engine.runtime.Execution;
import org.camunda.bpm.engine.test.Deployment;
import org.camunda.bpm.engine.test.util.PluggableProcessEngineTest;
import org.junit.Assert;
import org.junit.Test;

public class ExecutionCachedEntityStateTest
extends PluggableProcessEngineTest {
    @Deployment
    @Test
    public void testProcessInstanceTasks() {
        this.runtimeService.startProcessInstanceByKey("testProcess");
        ExecutionEntity processInstance = (ExecutionEntity)this.runtimeService.createProcessInstanceQuery().singleResult();
        Assert.assertEquals((long)BitMaskUtil.getMaskForBit((int)2), (long)processInstance.getCachedEntityStateRaw());
    }

    @Deployment
    @Test
    public void testExecutionTasksScope() {
        this.runtimeService.startProcessInstanceByKey("testProcess");
        ExecutionEntity processInstance = (ExecutionEntity)this.runtimeService.createProcessInstanceQuery().singleResult();
        Assert.assertEquals((long)0L, (long)processInstance.getCachedEntityStateRaw());
        ExecutionEntity execution = (ExecutionEntity)this.runtimeService.createExecutionQuery().activityId("userTask").singleResult();
        Assert.assertEquals((long)BitMaskUtil.getMaskForBit((int)2), (long)execution.getCachedEntityStateRaw());
    }

    @Deployment
    @Test
    public void testExecutionTasksParallel() {
        this.runtimeService.startProcessInstanceByKey("testProcess");
        ExecutionEntity processInstance = (ExecutionEntity)this.runtimeService.createProcessInstanceQuery().singleResult();
        Assert.assertEquals((long)0L, (long)processInstance.getCachedEntityStateRaw());
        ExecutionEntity execution = (ExecutionEntity)this.runtimeService.createExecutionQuery().activityId("userTask").singleResult();
        Assert.assertEquals((long)BitMaskUtil.getMaskForBit((int)2), (long)execution.getCachedEntityStateRaw());
    }

    @Deployment
    @Test
    public void testExecutionTasksMi() {
        this.runtimeService.startProcessInstanceByKey("testProcess");
        ExecutionEntity processInstance = (ExecutionEntity)this.runtimeService.createProcessInstanceQuery().singleResult();
        Assert.assertEquals((long)0L, (long)processInstance.getCachedEntityStateRaw());
        List executions = this.runtimeService.createExecutionQuery().activityId("userTask").list();
        for (Execution execution : executions) {
            int cachedEntityStateRaw = ((ExecutionEntity)execution).getCachedEntityStateRaw();
            if (!((ExecutionEntity)execution).isScope()) {
                Assert.assertEquals((long)(BitMaskUtil.getMaskForBit((int)2) | BitMaskUtil.getMaskForBit((int)5)), (long)cachedEntityStateRaw);
                continue;
            }
            Assert.assertEquals((long)BitMaskUtil.getMaskForBit((int)5), (long)cachedEntityStateRaw);
        }
    }

    @Deployment
    @Test
    public void testProcessInstanceEventSubscriptions() {
        this.runtimeService.startProcessInstanceByKey("testProcess");
        ExecutionEntity processInstance = (ExecutionEntity)this.runtimeService.createProcessInstanceQuery().singleResult();
        Assert.assertEquals((long)BitMaskUtil.getMaskForBit((int)1), (long)processInstance.getCachedEntityStateRaw());
    }

    @Deployment
    @Test
    public void testExecutionEventSubscriptionsScope() {
        this.runtimeService.startProcessInstanceByKey("testProcess");
        ExecutionEntity processInstance = (ExecutionEntity)this.runtimeService.createProcessInstanceQuery().singleResult();
        Assert.assertEquals((long)0L, (long)processInstance.getCachedEntityStateRaw());
        ExecutionEntity execution = (ExecutionEntity)this.runtimeService.createExecutionQuery().activityId("IntermediateCatchEvent_1").singleResult();
        Assert.assertEquals((long)BitMaskUtil.getMaskForBit((int)1), (long)execution.getCachedEntityStateRaw());
    }

    @Deployment
    @Test
    public void testExecutionEventSubscriptionsMi() {
        this.runtimeService.startProcessInstanceByKey("testProcess");
        ExecutionEntity processInstance = (ExecutionEntity)this.runtimeService.createProcessInstanceQuery().singleResult();
        Assert.assertEquals((long)0L, (long)processInstance.getCachedEntityStateRaw());
        List executions = this.runtimeService.createExecutionQuery().activityId("ReceiveTask_1").list();
        for (Execution execution : executions) {
            int cachedEntityStateRaw = ((ExecutionEntity)execution).getCachedEntityStateRaw();
            if (!((ExecutionEntity)execution).isScope()) {
                Assert.assertEquals((long)BitMaskUtil.getMaskForBit((int)5), (long)cachedEntityStateRaw);
                continue;
            }
            Assert.assertEquals((long)BitMaskUtil.getMaskForBit((int)1), (long)cachedEntityStateRaw);
        }
    }

    @Deployment
    @Test
    public void testProcessInstanceJobs() {
        this.runtimeService.startProcessInstanceByKey("testProcess");
        ExecutionEntity processInstance = (ExecutionEntity)this.runtimeService.createProcessInstanceQuery().singleResult();
        Assert.assertEquals((long)BitMaskUtil.getMaskForBit((int)3), (long)processInstance.getCachedEntityStateRaw());
    }

    @Deployment
    @Test
    public void testExecutionJobsScope() {
        this.runtimeService.startProcessInstanceByKey("testProcess");
        ExecutionEntity processInstance = (ExecutionEntity)this.runtimeService.createProcessInstanceQuery().singleResult();
        Assert.assertEquals((long)0L, (long)processInstance.getCachedEntityStateRaw());
        ExecutionEntity execution = (ExecutionEntity)this.runtimeService.createExecutionQuery().activityId("userTask").singleResult();
        Assert.assertEquals((long)BitMaskUtil.getMaskForBit((int)3), (long)execution.getCachedEntityStateRaw());
    }

    @Deployment
    @Test
    public void testExecutionJobsParallel() {
        this.runtimeService.startProcessInstanceByKey("testProcess");
        ExecutionEntity processInstance = (ExecutionEntity)this.runtimeService.createProcessInstanceQuery().singleResult();
        Assert.assertEquals((long)0L, (long)processInstance.getCachedEntityStateRaw());
        ExecutionEntity execution = (ExecutionEntity)this.runtimeService.createExecutionQuery().activityId("userTask").singleResult();
        Assert.assertEquals((long)BitMaskUtil.getMaskForBit((int)3), (long)execution.getCachedEntityStateRaw());
    }

    @Deployment
    @Test
    public void testProcessInstanceIncident() {
        this.runtimeService.startProcessInstanceByKey("testProcess");
        ExecutionEntity processInstance = (ExecutionEntity)this.runtimeService.createProcessInstanceQuery().singleResult();
        Assert.assertEquals((long)0L, (long)processInstance.getCachedEntityStateRaw());
        final ExecutionEntity execution = (ExecutionEntity)this.runtimeService.createExecutionQuery().activityId("task").singleResult();
        Assert.assertEquals((long)0L, (long)execution.getCachedEntityStateRaw());
        this.processEngineConfiguration.getCommandExecutorTxRequired().execute((Command)new Command<Void>(){

            public Void execute(CommandContext commandContext) {
                IncidentContext incidentContext = new IncidentContext();
                incidentContext.setExecutionId(execution.getId());
                IncidentEntity.createAndInsertIncident((String)"foo", (IncidentContext)incidentContext, null);
                return null;
            }
        });
        ExecutionEntity execution2 = (ExecutionEntity)this.runtimeService.createExecutionQuery().activityId("task").singleResult();
        Assert.assertEquals((long)BitMaskUtil.getMaskForBit((int)4), (long)execution2.getCachedEntityStateRaw());
    }

    @Deployment
    @Test
    public void testExecutionIncidentParallel() {
        this.runtimeService.startProcessInstanceByKey("testProcess");
        ExecutionEntity processInstance = (ExecutionEntity)this.runtimeService.createProcessInstanceQuery().singleResult();
        Assert.assertEquals((long)0L, (long)processInstance.getCachedEntityStateRaw());
        final ExecutionEntity execution = (ExecutionEntity)this.runtimeService.createExecutionQuery().activityId("task").singleResult();
        Assert.assertEquals((long)0L, (long)execution.getCachedEntityStateRaw());
        this.processEngineConfiguration.getCommandExecutorTxRequired().execute((Command)new Command<Void>(){

            public Void execute(CommandContext commandContext) {
                IncidentContext incidentContext = new IncidentContext();
                incidentContext.setExecutionId(execution.getId());
                IncidentEntity.createAndInsertIncident((String)"foo", (IncidentContext)incidentContext, null);
                return null;
            }
        });
        ExecutionEntity execution2 = (ExecutionEntity)this.runtimeService.createExecutionQuery().activityId("task").singleResult();
        Assert.assertEquals((long)BitMaskUtil.getMaskForBit((int)4), (long)execution2.getCachedEntityStateRaw());
    }

    @Deployment
    @Test
    public void testExecutionExternalTask() {
        this.runtimeService.startProcessInstanceByKey("oneExternalTaskProcess");
        ExecutionEntity execution = (ExecutionEntity)this.runtimeService.createExecutionQuery().activityId("externalTask").singleResult();
        Assert.assertEquals((long)BitMaskUtil.getMaskForBit((int)8), (long)execution.getCachedEntityStateRaw());
    }
}

