/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.authorization;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.camunda.bpm.engine.AuthorizationException;
import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.authorization.Authorization;
import org.camunda.bpm.engine.authorization.Permission;
import org.camunda.bpm.engine.authorization.Permissions;
import org.camunda.bpm.engine.authorization.ProcessDefinitionPermissions;
import org.camunda.bpm.engine.authorization.Resource;
import org.camunda.bpm.engine.authorization.Resources;
import org.camunda.bpm.engine.authorization.TaskPermissions;
import org.camunda.bpm.engine.history.HistoricVariableInstance;
import org.camunda.bpm.engine.impl.AbstractQuery;
import org.camunda.bpm.engine.impl.TaskServiceImpl;
import org.camunda.bpm.engine.impl.cfg.auth.DefaultAuthorizationProvider;
import org.camunda.bpm.engine.impl.cfg.auth.ResourceAuthorizationProvider;
import org.camunda.bpm.engine.impl.db.DbEntity;
import org.camunda.bpm.engine.impl.history.HistoryLevel;
import org.camunda.bpm.engine.impl.interceptor.Command;
import org.camunda.bpm.engine.impl.interceptor.CommandContext;
import org.camunda.bpm.engine.impl.persistence.entity.HistoricVariableInstanceEntity;
import org.camunda.bpm.engine.impl.persistence.entity.TaskEntity;
import org.camunda.bpm.engine.query.Query;
import org.camunda.bpm.engine.runtime.VariableInstanceQuery;
import org.camunda.bpm.engine.task.IdentityLink;
import org.camunda.bpm.engine.task.Task;
import org.camunda.bpm.engine.task.TaskQuery;
import org.camunda.bpm.engine.test.Deployment;
import org.camunda.bpm.engine.test.api.authorization.AuthorizationTest;
import org.camunda.bpm.engine.test.api.authorization.MyExtendedPermissionDefaultAuthorizationProvider;
import org.camunda.bpm.engine.variable.VariableMap;
import org.camunda.bpm.engine.variable.value.TypedValue;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TaskAuthorizationTest
extends AuthorizationTest {
    protected static final String PROCESS_KEY = "oneTaskProcess";
    protected static final String CASE_KEY = "oneTaskCase";
    protected static final String DEMO_ASSIGNEE_PROCESS_KEY = "demoAssigneeProcess";
    protected static final String CANDIDATE_USERS_PROCESS_KEY = "candidateUsersProcess";
    protected static final String CANDIDATE_GROUPS_PROCESS_KEY = "candidateGroupsProcess";
    protected static final String INVALID_PERMISSION = "invalidPermission";

    @Override
    @Before
    public void setUp() throws Exception {
        this.testRule.deploy("org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml", "org/camunda/bpm/engine/test/api/authorization/oneTaskCase.cmmn", "org/camunda/bpm/engine/test/api/authorization/oneTaskProcess.bpmn20.xml", "org/camunda/bpm/engine/test/api/authorization/candidateUsersProcess.bpmn20.xml", "org/camunda/bpm/engine/test/api/authorization/candidateGroupsProcess.bpmn20.xml");
        super.setUp();
    }

    @Override
    @After
    public void tearDown() {
        super.tearDown();
        this.processEngineConfiguration.getCommandExecutorTxRequired().execute((Command)new Command<Void>(){

            public Void execute(CommandContext commandContext) {
                List variables = TaskAuthorizationTest.this.historyService.createHistoricVariableInstanceQuery().includeDeleted().list();
                for (HistoricVariableInstance variable : variables) {
                    commandContext.getDbEntityManager().delete((DbEntity)((HistoricVariableInstanceEntity)variable));
                }
                return null;
            }
        });
    }

    @Test
    public void testSimpleQueryWithTaskInsideProcessWithoutAuthorization() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        TaskQuery query = this.taskService.createTaskQuery();
        this.verifyQueryResults(query, 0);
    }

    @Test
    public void testSimpleQueryWithTaskInsideProcessWithReadPermissionOnTask() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        this.createGrantAuthorization((Resource)Resources.TASK, taskId, this.userId, new Permission[]{Permissions.READ});
        TaskQuery query = this.taskService.createTaskQuery();
        this.verifyQueryResults(query, 1);
    }

    @Test
    public void testSimpleQueryWithTaskInsideProcessWithReadPermissionOnAnyTask() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        this.createGrantAuthorization((Resource)Resources.TASK, "*", this.userId, new Permission[]{Permissions.READ});
        TaskQuery query = this.taskService.createTaskQuery();
        this.verifyQueryResults(query, 1);
    }

    @Test
    public void testSimpleQueryWithTaskInsideProcessWithReadPermissionOnOneTaskProcess() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, PROCESS_KEY, this.userId, new Permission[]{Permissions.READ_TASK});
        TaskQuery query = this.taskService.createTaskQuery();
        this.verifyQueryResults(query, 1);
    }

    @Test
    public void testSimpleQueryWithTaskInsideProcessWithReadPermissionOnAnyProcessDefinition() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, "*", this.userId, new Permission[]{Permissions.READ_TASK});
        TaskQuery query = this.taskService.createTaskQuery();
        this.verifyQueryResults(query, 1);
    }

    @Test
    public void testSimpleQueryWithMultiple() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, "*", this.userId, new Permission[]{Permissions.READ_TASK});
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, PROCESS_KEY, this.userId, new Permission[]{Permissions.READ_TASK});
        this.createGrantAuthorization((Resource)Resources.TASK, "*", this.userId, new Permission[]{Permissions.READ});
        this.createGrantAuthorization((Resource)Resources.TASK, taskId, this.userId, new Permission[]{Permissions.READ});
        TaskQuery query = this.taskService.createTaskQuery();
        this.verifyQueryResults(query, 1);
    }

    @Test
    public void testQueryWithTaskInsideProcessWithoutAuthorization() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        this.startProcessInstanceByKey(PROCESS_KEY);
        this.startProcessInstanceByKey(PROCESS_KEY);
        this.startProcessInstanceByKey(DEMO_ASSIGNEE_PROCESS_KEY);
        this.startProcessInstanceByKey(DEMO_ASSIGNEE_PROCESS_KEY);
        this.startProcessInstanceByKey(DEMO_ASSIGNEE_PROCESS_KEY);
        this.startProcessInstanceByKey(DEMO_ASSIGNEE_PROCESS_KEY);
        TaskQuery query = this.taskService.createTaskQuery();
        this.verifyQueryResults(query, 0);
    }

    @Test
    public void testQueryWithTaskInsideProcessWithReadPermissionOnTask() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        this.startProcessInstanceByKey(PROCESS_KEY);
        this.startProcessInstanceByKey(PROCESS_KEY);
        this.startProcessInstanceByKey(DEMO_ASSIGNEE_PROCESS_KEY);
        this.startProcessInstanceByKey(DEMO_ASSIGNEE_PROCESS_KEY);
        this.startProcessInstanceByKey(DEMO_ASSIGNEE_PROCESS_KEY);
        this.startProcessInstanceByKey(DEMO_ASSIGNEE_PROCESS_KEY);
        this.disableAuthorization();
        String taskId = ((Task)this.taskService.createTaskQuery().processDefinitionKey(PROCESS_KEY).listPage(0, 1).get(0)).getId();
        this.enableAuthorization();
        this.createGrantAuthorization((Resource)Resources.TASK, taskId, this.userId, new Permission[]{Permissions.READ});
        TaskQuery query = this.taskService.createTaskQuery();
        this.verifyQueryResults(query, 1);
    }

    @Test
    public void testQueryWithTaskInsideProcessWithReadPermissionOnAnyTask() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        this.startProcessInstanceByKey(PROCESS_KEY);
        this.startProcessInstanceByKey(PROCESS_KEY);
        this.startProcessInstanceByKey(DEMO_ASSIGNEE_PROCESS_KEY);
        this.startProcessInstanceByKey(DEMO_ASSIGNEE_PROCESS_KEY);
        this.startProcessInstanceByKey(DEMO_ASSIGNEE_PROCESS_KEY);
        this.startProcessInstanceByKey(DEMO_ASSIGNEE_PROCESS_KEY);
        this.createGrantAuthorization((Resource)Resources.TASK, "*", this.userId, new Permission[]{Permissions.READ});
        TaskQuery query = this.taskService.createTaskQuery();
        this.verifyQueryResults(query, 7);
    }

    @Test
    public void testQueryWithTaskInsideProcessWithReadPermissionOnOneTaskProcess() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        this.startProcessInstanceByKey(PROCESS_KEY);
        this.startProcessInstanceByKey(PROCESS_KEY);
        this.startProcessInstanceByKey(DEMO_ASSIGNEE_PROCESS_KEY);
        this.startProcessInstanceByKey(DEMO_ASSIGNEE_PROCESS_KEY);
        this.startProcessInstanceByKey(DEMO_ASSIGNEE_PROCESS_KEY);
        this.startProcessInstanceByKey(DEMO_ASSIGNEE_PROCESS_KEY);
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, PROCESS_KEY, this.userId, new Permission[]{Permissions.READ_TASK});
        TaskQuery query = this.taskService.createTaskQuery();
        this.verifyQueryResults(query, 3);
    }

    @Test
    public void testQueryWithTaskInsideProcessWithReadPermissionOnAnyProcessDefinition() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        this.startProcessInstanceByKey(PROCESS_KEY);
        this.startProcessInstanceByKey(PROCESS_KEY);
        this.startProcessInstanceByKey(DEMO_ASSIGNEE_PROCESS_KEY);
        this.startProcessInstanceByKey(DEMO_ASSIGNEE_PROCESS_KEY);
        this.startProcessInstanceByKey(DEMO_ASSIGNEE_PROCESS_KEY);
        this.startProcessInstanceByKey(DEMO_ASSIGNEE_PROCESS_KEY);
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, "*", this.userId, new Permission[]{Permissions.READ_TASK});
        TaskQuery query = this.taskService.createTaskQuery();
        this.verifyQueryResults(query, 7);
    }

    @Test
    public void testQueryWithTaskInsideCaseWithoutAuthorization() {
        this.testRule.createCaseInstanceByKey(CASE_KEY);
        TaskQuery query = this.taskService.createTaskQuery();
        this.verifyQueryResults(query, 1);
    }

    @Test
    public void testQueryWithStandaloneTaskWithoutAuthorization() {
        String taskId = "newTask";
        this.createTask(taskId);
        TaskQuery query = this.taskService.createTaskQuery();
        this.verifyQueryResults(query, 0);
        this.deleteTask(taskId, true);
    }

    @Test
    public void testQueryWithStandaloneTaskWithReadPermissionOnTask() {
        String taskId = "newTask";
        this.createTask(taskId);
        this.createGrantAuthorization((Resource)Resources.TASK, taskId, this.userId, new Permission[]{Permissions.READ});
        TaskQuery query = this.taskService.createTaskQuery();
        this.verifyQueryResults(query, 1);
        this.deleteTask(taskId, true);
    }

    @Test
    public void testQueryWithProcessDefinitionFilter() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        this.createGrantAuthorization((Resource)Resources.TASK, taskId, this.userId, new Permission[]{Permissions.READ});
        this.startProcessInstanceByKey(PROCESS_KEY);
        TaskQuery query = this.taskService.createTaskQuery().processDefinitionKey(PROCESS_KEY);
        this.verifyQueryResults(query, 1);
    }

    @Test
    public void testNewTaskWithoutAuthorization() {
        try {
            this.taskService.newTask();
            Assert.fail((String)"Exception expected: It should not be possible to create a new task.");
        }
        catch (AuthorizationException e) {
            this.testRule.assertTextPresent("The user with id 'test' does not have 'CREATE' permission on resource 'Task'", e.getMessage());
        }
    }

    @Test
    public void testNewTask() {
        this.createGrantAuthorization((Resource)Resources.TASK, "*", this.userId, new Permission[]{Permissions.CREATE});
        Task task = this.taskService.newTask();
        Assert.assertNotNull((Object)task);
    }

    @Test
    public void testSaveTaskInsertWithoutAuthorization() {
        TaskEntity task = new TaskEntity();
        try {
            this.taskService.saveTask((Task)task);
            Assert.fail((String)"Exception expected: It should not be possible to save a task.");
        }
        catch (AuthorizationException e) {
            this.testRule.assertTextPresent("The user with id 'test' does not have 'CREATE' permission on resource 'Task'", e.getMessage());
        }
    }

    @Test
    public void testSaveTaskInsert() {
        TaskEntity task = new TaskEntity();
        task.setAssignee("demo");
        this.createGrantAuthorization((Resource)Resources.TASK, "*", this.userId, new Permission[]{Permissions.CREATE});
        this.taskService.saveTask((Task)task);
        task = (TaskEntity)this.selectSingleTask();
        Assert.assertNotNull((Object)task);
        Assert.assertEquals((Object)"demo", (Object)task.getAssignee());
        String taskId = task.getId();
        this.deleteTask(taskId, true);
    }

    @Test
    public void testSaveAndUpdateTaskWithTaskAssignPermission() {
        TaskEntity task = new TaskEntity();
        task.setAssignee("demo");
        this.createGrantAuthorization((Resource)Resources.TASK, "*", this.userId, new Permission[]{Permissions.CREATE, Permissions.TASK_ASSIGN});
        this.taskService.saveTask((Task)task);
        task.delegate("demoNew");
        this.taskService.saveTask((Task)task);
        task = (TaskEntity)this.selectSingleTask();
        Assert.assertNotNull((Object)task);
        Assert.assertEquals((Object)"demoNew", (Object)task.getAssignee());
        String taskId = task.getId();
        this.deleteTask(taskId, true);
    }

    @Test
    public void testSaveStandaloneTaskUpdateWithoutAuthorization() {
        String taskId = "myTask";
        this.createTask(taskId);
        Task task = this.selectSingleTask();
        try {
            this.taskService.saveTask(task);
            Assert.fail((String)"Exception expected: It should not be possible to save a task.");
        }
        catch (AuthorizationException e) {
            this.testRule.assertTextPresent("The user with id 'test' does not have one of the following permissions: 'TASK_ASSIGN'", e.getMessage());
        }
        this.deleteTask(taskId, true);
    }

    @Test
    public void testSaveStandaloneTaskUpdate() {
        String taskId = "myTask";
        this.createTask(taskId);
        Task task = this.selectSingleTask();
        task.setAssignee("demo");
        this.createGrantAuthorization((Resource)Resources.TASK, taskId, this.userId, new Permission[]{Permissions.UPDATE});
        this.taskService.saveTask(task);
        task = this.selectSingleTask();
        Assert.assertNotNull((Object)task);
        Assert.assertEquals((Object)"demo", (Object)task.getAssignee());
        this.deleteTask(taskId, true);
    }

    @Test
    public void testSaveProcessTaskUpdateWithoutAuthorization() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        Task task = this.selectSingleTask();
        try {
            this.taskService.saveTask(task);
            Assert.fail((String)"Exception expected: It should not be possible to save a task.");
        }
        catch (AuthorizationException e) {
            String message = e.getMessage();
            this.testRule.assertTextPresent(this.userId, message);
            this.testRule.assertTextPresent(Permissions.UPDATE.getName(), message);
            this.testRule.assertTextPresent(task.getId(), message);
            this.testRule.assertTextPresent(Resources.TASK.resourceName(), message);
            this.testRule.assertTextPresent(Permissions.UPDATE_TASK.getName(), message);
            this.testRule.assertTextPresent(Resources.PROCESS_DEFINITION.resourceName(), message);
        }
    }

    @Test
    public void testSaveProcessTaskUpdateWithUpdatePermissionOnTask() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        Task task = this.selectSingleTask();
        task.setAssignee("demo");
        this.createGrantAuthorization((Resource)Resources.TASK, task.getId(), this.userId, new Permission[]{Permissions.UPDATE});
        this.taskService.saveTask(task);
        task = this.selectSingleTask();
        Assert.assertNotNull((Object)task);
        Assert.assertEquals((Object)"demo", (Object)task.getAssignee());
    }

    @Test
    public void testSaveProcessTaskUpdateWithTaskAssignPermissionOnTask() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        Task task = this.selectSingleTask();
        task.setAssignee("demo");
        this.createGrantAuthorization((Resource)Resources.TASK, task.getId(), this.userId, new Permission[]{Permissions.TASK_ASSIGN});
        this.taskService.saveTask(task);
        task = this.selectSingleTask();
        Assert.assertNotNull((Object)task);
        Assert.assertEquals((Object)"demo", (Object)task.getAssignee());
    }

    @Test
    public void testSaveProcessTaskUpdateWithUpdatePermissionOnAnyTask() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        Task task = this.selectSingleTask();
        task.setAssignee("demo");
        this.createGrantAuthorization((Resource)Resources.TASK, "*", this.userId, new Permission[]{Permissions.UPDATE});
        this.taskService.saveTask(task);
        task = this.selectSingleTask();
        Assert.assertNotNull((Object)task);
        Assert.assertEquals((Object)"demo", (Object)task.getAssignee());
    }

    @Test
    public void testSaveProcessTaskUpdateWithTaskAssignPermissionOnAnyTask() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        Task task = this.selectSingleTask();
        task.setAssignee("demo");
        this.createGrantAuthorization((Resource)Resources.TASK, "*", this.userId, new Permission[]{Permissions.TASK_ASSIGN});
        this.taskService.saveTask(task);
        task = this.selectSingleTask();
        Assert.assertNotNull((Object)task);
        Assert.assertEquals((Object)"demo", (Object)task.getAssignee());
    }

    @Test
    public void testSaveProcessTaskUpdateWithUpdateTasksPermissionOnProcessDefinition() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        Task task = this.selectSingleTask();
        task.setAssignee("demo");
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, PROCESS_KEY, this.userId, new Permission[]{Permissions.UPDATE_TASK});
        this.taskService.saveTask(task);
        task = this.selectSingleTask();
        Assert.assertNotNull((Object)task);
        Assert.assertEquals((Object)"demo", (Object)task.getAssignee());
    }

    @Test
    public void testSaveProcessTaskUpdateWithTaskAssignPermissionOnProcessDefinition() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        Task task = this.selectSingleTask();
        task.setAssignee("demo");
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, PROCESS_KEY, this.userId, new Permission[]{Permissions.TASK_ASSIGN});
        this.taskService.saveTask(task);
        task = this.selectSingleTask();
        Assert.assertNotNull((Object)task);
        Assert.assertEquals((Object)"demo", (Object)task.getAssignee());
    }

    @Test
    public void testSaveCaseTaskUpdate() {
        this.testRule.createCaseInstanceByKey(CASE_KEY);
        Task task = this.selectSingleTask();
        task.setAssignee("demo");
        this.taskService.saveTask(task);
        task = this.selectSingleTask();
        Assert.assertNotNull((Object)task);
        Assert.assertEquals((Object)"demo", (Object)task.getAssignee());
    }

    @Test
    public void testDeleteTaskWithoutAuthorization() {
        String taskId = "myTask";
        this.createTask(taskId);
        try {
            this.taskService.deleteTask(taskId);
            Assert.fail((String)"Exception expected: It should not be possible to delete a task.");
        }
        catch (AuthorizationException e) {
            this.testRule.assertTextPresent("The user with id 'test' does not have 'DELETE' permission on resource 'myTask' of type 'Task'", e.getMessage());
        }
        this.deleteTask(taskId, true);
    }

    @Test
    public void testDeleteTask() {
        String taskId = "myTask";
        this.createTask(taskId);
        this.createGrantAuthorization((Resource)Resources.TASK, taskId, this.userId, new Permission[]{Permissions.DELETE});
        this.taskService.deleteTask(taskId);
        Task task = this.selectSingleTask();
        Assert.assertNull((Object)task);
        this.deleteTask(taskId, true);
    }

    @Test
    public void testDeleteTasksWithoutAuthorization() {
        String firstTaskId = "myTask1";
        this.createTask(firstTaskId);
        String secondTaskId = "myTask2";
        this.createTask(secondTaskId);
        try {
            this.taskService.deleteTasks(Arrays.asList(firstTaskId, secondTaskId));
            Assert.fail((String)"Exception expected: It should not be possible to delete tasks.");
        }
        catch (AuthorizationException e) {
            this.testRule.assertTextPresent("The user with id 'test' does not have 'DELETE' permission on resource 'myTask1' of type 'Task'", e.getMessage());
        }
        this.deleteTask(firstTaskId, true);
        this.deleteTask(secondTaskId, true);
    }

    @Test
    public void testDeleteTasksWithDeletePermissionOnFirstTask() {
        String firstTaskId = "myTask1";
        this.createTask(firstTaskId);
        this.createGrantAuthorization((Resource)Resources.TASK, firstTaskId, this.userId, new Permission[]{Permissions.DELETE});
        String secondTaskId = "myTask2";
        this.createTask(secondTaskId);
        try {
            this.taskService.deleteTasks(Arrays.asList(firstTaskId, secondTaskId));
            Assert.fail((String)"Exception expected: It should not be possible to delete tasks.");
        }
        catch (AuthorizationException e) {
            this.testRule.assertTextPresent("The user with id 'test' does not have 'DELETE' permission on resource 'myTask2' of type 'Task'", e.getMessage());
        }
        this.deleteTask(firstTaskId, true);
        this.deleteTask(secondTaskId, true);
    }

    @Test
    public void testDeleteTasks() {
        String firstTaskId = "myTask1";
        this.createTask(firstTaskId);
        String secondTaskId = "myTask2";
        this.createTask(secondTaskId);
        this.createGrantAuthorization((Resource)Resources.TASK, "*", this.userId, new Permission[]{Permissions.DELETE});
        this.taskService.deleteTasks(Arrays.asList(firstTaskId, secondTaskId));
        Task task = this.selectSingleTask();
        Assert.assertNull((Object)task);
        this.deleteTask(firstTaskId, true);
        this.deleteTask(secondTaskId, true);
    }

    @Test
    public void testStandaloneTaskSetAssigneeWithoutAuthorization() {
        String taskId = "myTask";
        this.createTask(taskId);
        try {
            this.taskService.setAssignee(taskId, "demo");
            Assert.fail((String)"Exception expected: It should not be possible to set an assignee");
        }
        catch (AuthorizationException e) {
            this.testRule.assertTextPresent("The user with id 'test' does not have one of the following permissions: 'TASK_ASSIGN", e.getMessage());
        }
        this.deleteTask(taskId, true);
    }

    @Test
    public void testStandaloneTaskSetAssignee() {
        String taskId = "myTask";
        this.createTask(taskId);
        this.createGrantAuthorization((Resource)Resources.TASK, taskId, this.userId, new Permission[]{Permissions.UPDATE});
        this.taskService.setAssignee(taskId, "demo");
        Task task = this.selectSingleTask();
        Assert.assertNotNull((Object)task);
        Assert.assertEquals((Object)"demo", (Object)task.getAssignee());
        this.deleteTask(taskId, true);
    }

    @Test
    public void testStandaloneTaskSetAssigneeWithTaskAssignPermission() {
        String taskId = "myTask";
        this.createTask(taskId);
        this.createGrantAuthorization((Resource)Resources.TASK, taskId, this.userId, new Permission[]{Permissions.TASK_ASSIGN});
        this.taskService.setAssignee(taskId, "demo");
        Task task = this.selectSingleTask();
        Assert.assertNotNull((Object)task);
        Assert.assertEquals((Object)"demo", (Object)task.getAssignee());
        this.deleteTask(taskId, true);
    }

    @Test
    public void testProcessTaskSetAssigneeWithoutAuthorization() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        try {
            this.taskService.setAssignee(taskId, "demo");
            Assert.fail((String)"Exception expected: It should not be possible to set an assignee");
        }
        catch (AuthorizationException e) {
            String message = e.getMessage();
            this.testRule.assertTextPresent(this.userId, message);
            this.testRule.assertTextPresent(Permissions.UPDATE.getName(), message);
            this.testRule.assertTextPresent(taskId, message);
            this.testRule.assertTextPresent(Resources.TASK.resourceName(), message);
            this.testRule.assertTextPresent(Permissions.UPDATE_TASK.getName(), message);
            this.testRule.assertTextPresent(Resources.PROCESS_DEFINITION.resourceName(), message);
        }
    }

    @Test
    public void testProcessTaskSetAssigneeWithUpdatePersmissionOnTask() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        this.createGrantAuthorization((Resource)Resources.TASK, taskId, this.userId, new Permission[]{Permissions.UPDATE});
        this.taskService.setAssignee(taskId, "demo");
        Task task = this.selectSingleTask();
        Assert.assertNotNull((Object)task);
        Assert.assertEquals((Object)"demo", (Object)task.getAssignee());
    }

    @Test
    public void testProcessTaskSetAssigneeWithTaskAssignPermissionOnTask() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        this.createGrantAuthorization((Resource)Resources.TASK, taskId, this.userId, new Permission[]{Permissions.TASK_ASSIGN});
        this.taskService.setAssignee(taskId, "demo");
        Task task = this.selectSingleTask();
        Assert.assertNotNull((Object)task);
        Assert.assertEquals((Object)"demo", (Object)task.getAssignee());
    }

    @Test
    public void testProcessTaskSetAssigneeWithUpdatePersmissionOnAnyTask() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        this.createGrantAuthorization((Resource)Resources.TASK, "*", this.userId, new Permission[]{Permissions.UPDATE});
        this.taskService.setAssignee(taskId, "demo");
        Task task = this.selectSingleTask();
        Assert.assertNotNull((Object)task);
        Assert.assertEquals((Object)"demo", (Object)task.getAssignee());
    }

    @Test
    public void testProcessTaskSetAssigneeWithTaskAssignPermissionOnAnyTask() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        this.createGrantAuthorization((Resource)Resources.TASK, "*", this.userId, new Permission[]{Permissions.TASK_ASSIGN});
        this.taskService.setAssignee(taskId, "demo");
        Task task = this.selectSingleTask();
        Assert.assertNotNull((Object)task);
        Assert.assertEquals((Object)"demo", (Object)task.getAssignee());
    }

    @Test
    public void testProcessTaskSetAssigneeWithUpdateTasksPersmissionOnProcessDefinition() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, PROCESS_KEY, this.userId, new Permission[]{Permissions.UPDATE_TASK});
        this.taskService.setAssignee(taskId, "demo");
        Task task = this.selectSingleTask();
        Assert.assertNotNull((Object)task);
        Assert.assertEquals((Object)"demo", (Object)task.getAssignee());
    }

    @Test
    public void testProcessTaskSetAssigneeWithTaskAssignPermissionOnProcessDefinition() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, PROCESS_KEY, this.userId, new Permission[]{Permissions.TASK_ASSIGN});
        this.taskService.setAssignee(taskId, "demo");
        Task task = this.selectSingleTask();
        Assert.assertNotNull((Object)task);
        Assert.assertEquals((Object)"demo", (Object)task.getAssignee());
    }

    @Test
    public void testProcessTaskSetAssignee() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        this.createGrantAuthorization((Resource)Resources.TASK, taskId, this.userId, new Permission[]{Permissions.UPDATE});
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, PROCESS_KEY, this.userId, new Permission[]{Permissions.UPDATE_TASK});
        this.taskService.setAssignee(taskId, "demo");
        Task task = this.selectSingleTask();
        Assert.assertNotNull((Object)task);
        Assert.assertEquals((Object)"demo", (Object)task.getAssignee());
    }

    @Test
    public void testCaseTaskSetAssignee() {
        this.testRule.createCaseInstanceByKey(CASE_KEY);
        String taskId = this.selectSingleTask().getId();
        this.taskService.setAssignee(taskId, "demo");
        Task task = this.selectSingleTask();
        Assert.assertNotNull((Object)task);
        Assert.assertEquals((Object)"demo", (Object)task.getAssignee());
    }

    @Test
    public void testStandaloneTaskSetOwnerWithoutAuthorization() {
        String taskId = "myTask";
        this.createTask(taskId);
        try {
            this.taskService.setOwner(taskId, "demo");
            Assert.fail((String)"Exception expected: It should not be possible to set an owner");
        }
        catch (AuthorizationException e) {
            this.testRule.assertTextPresent("The user with id 'test' does not have one of the following permissions: 'TASK_ASSIGN", e.getMessage());
        }
        this.deleteTask(taskId, true);
    }

    @Test
    public void testStandaloneTaskSetOwner() {
        String taskId = "myTask";
        this.createTask(taskId);
        this.createGrantAuthorization((Resource)Resources.TASK, taskId, this.userId, new Permission[]{Permissions.UPDATE});
        this.taskService.setOwner(taskId, "demo");
        Task task = this.selectSingleTask();
        Assert.assertNotNull((Object)task);
        Assert.assertEquals((Object)"demo", (Object)task.getOwner());
        this.deleteTask(taskId, true);
    }

    @Test
    public void testStandaloneTaskSetOwnerWithTaskAssignPermission() {
        String taskId = "myTask";
        this.createTask(taskId);
        this.createGrantAuthorization((Resource)Resources.TASK, taskId, this.userId, new Permission[]{Permissions.TASK_ASSIGN});
        this.taskService.setOwner(taskId, "demo");
        Task task = this.selectSingleTask();
        Assert.assertNotNull((Object)task);
        Assert.assertEquals((Object)"demo", (Object)task.getOwner());
        this.deleteTask(taskId, true);
    }

    @Test
    public void testProcessTaskSetOwnerWithoutAuthorization() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        try {
            this.taskService.setOwner(taskId, "demo");
            Assert.fail((String)"Exception expected: It should not be possible to set an owner");
        }
        catch (AuthorizationException e) {
            String message = e.getMessage();
            this.testRule.assertTextPresent(this.userId, message);
            this.testRule.assertTextPresent(Permissions.UPDATE.getName(), message);
            this.testRule.assertTextPresent(taskId, message);
            this.testRule.assertTextPresent(Resources.TASK.resourceName(), message);
            this.testRule.assertTextPresent(Permissions.UPDATE_TASK.getName(), message);
            this.testRule.assertTextPresent(Resources.PROCESS_DEFINITION.resourceName(), message);
        }
    }

    @Test
    public void testProcessTaskSetOwnerWithUpdatePersmissionOnTask() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        this.createGrantAuthorization((Resource)Resources.TASK, taskId, this.userId, new Permission[]{Permissions.UPDATE});
        this.taskService.setOwner(taskId, "demo");
        Task task = this.selectSingleTask();
        Assert.assertNotNull((Object)task);
        Assert.assertEquals((Object)"demo", (Object)task.getOwner());
    }

    @Test
    public void testProcessTaskSetOwnerWithTaskAssignPermissionOnTask() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        this.createGrantAuthorization((Resource)Resources.TASK, taskId, this.userId, new Permission[]{Permissions.TASK_ASSIGN});
        this.taskService.setOwner(taskId, "demo");
        Task task = this.selectSingleTask();
        Assert.assertNotNull((Object)task);
        Assert.assertEquals((Object)"demo", (Object)task.getOwner());
    }

    @Test
    public void testProcessTaskSetOwnerWithUpdatePersmissionOnAnyTask() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        this.createGrantAuthorization((Resource)Resources.TASK, "*", this.userId, new Permission[]{Permissions.UPDATE});
        this.taskService.setOwner(taskId, "demo");
        Task task = this.selectSingleTask();
        Assert.assertNotNull((Object)task);
        Assert.assertEquals((Object)"demo", (Object)task.getOwner());
    }

    @Test
    public void testProcessTaskSetOwnerWithTaskAssignPermissionOnAnyTask() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        this.createGrantAuthorization((Resource)Resources.TASK, "*", this.userId, new Permission[]{Permissions.TASK_ASSIGN});
        this.taskService.setOwner(taskId, "demo");
        Task task = this.selectSingleTask();
        Assert.assertNotNull((Object)task);
        Assert.assertEquals((Object)"demo", (Object)task.getOwner());
    }

    @Test
    public void testProcessTaskSetOwnerWithUpdateTasksPersmissionOnProcessDefinition() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, PROCESS_KEY, this.userId, new Permission[]{Permissions.UPDATE_TASK});
        this.taskService.setOwner(taskId, "demo");
        Task task = this.selectSingleTask();
        Assert.assertNotNull((Object)task);
        Assert.assertEquals((Object)"demo", (Object)task.getOwner());
    }

    @Test
    public void testProcessTaskSetOwnerWithTaskAssignPermissionOnProcessDefinition() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, PROCESS_KEY, this.userId, new Permission[]{Permissions.TASK_ASSIGN});
        this.taskService.setOwner(taskId, "demo");
        Task task = this.selectSingleTask();
        Assert.assertNotNull((Object)task);
        Assert.assertEquals((Object)"demo", (Object)task.getOwner());
    }

    @Test
    public void testProcessTaskSetOwner() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        this.createGrantAuthorization((Resource)Resources.TASK, taskId, this.userId, new Permission[]{Permissions.UPDATE});
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, PROCESS_KEY, this.userId, new Permission[]{Permissions.UPDATE_TASK});
        this.taskService.setOwner(taskId, "demo");
        Task task = this.selectSingleTask();
        Assert.assertNotNull((Object)task);
        Assert.assertEquals((Object)"demo", (Object)task.getOwner());
    }

    @Test
    public void testProcessTaskSetOwnerWithTaskAssignPermission() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        this.createGrantAuthorization((Resource)Resources.TASK, taskId, this.userId, new Permission[]{Permissions.TASK_ASSIGN});
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, PROCESS_KEY, this.userId, new Permission[]{Permissions.TASK_ASSIGN});
        this.taskService.setOwner(taskId, "demo");
        Task task = this.selectSingleTask();
        Assert.assertNotNull((Object)task);
        Assert.assertEquals((Object)"demo", (Object)task.getOwner());
    }

    @Test
    public void testCaseTaskSetOwner() {
        this.testRule.createCaseInstanceByKey(CASE_KEY);
        String taskId = this.selectSingleTask().getId();
        this.taskService.setOwner(taskId, "demo");
        Task task = this.selectSingleTask();
        Assert.assertNotNull((Object)task);
        Assert.assertEquals((Object)"demo", (Object)task.getOwner());
    }

    @Test
    public void testStandaloneTaskAddCandidateUserWithoutAuthorization() {
        String taskId = "myTask";
        this.createTask(taskId);
        try {
            this.taskService.addCandidateUser(taskId, "demo");
            Assert.fail((String)"Exception expected: It should not be possible to add a candidate user");
        }
        catch (AuthorizationException e) {
            this.testRule.assertTextPresent("The user with id 'test' does not have one of the following permissions: 'TASK_ASSIGN", e.getMessage());
        }
        this.deleteTask(taskId, true);
    }

    @Test
    public void testStandaloneTaskAddCandidateUser() {
        String taskId = "myTask";
        this.createTask(taskId);
        this.createGrantAuthorization((Resource)Resources.TASK, taskId, this.userId, new Permission[]{Permissions.UPDATE});
        this.taskService.addCandidateUser(taskId, "demo");
        this.disableAuthorization();
        List linksForTask = this.taskService.getIdentityLinksForTask(taskId);
        this.enableAuthorization();
        Assert.assertNotNull((Object)linksForTask);
        Assert.assertEquals((long)1L, (long)linksForTask.size());
        IdentityLink identityLink = (IdentityLink)linksForTask.get(0);
        Assert.assertNotNull((Object)identityLink);
        Assert.assertEquals((Object)"demo", (Object)identityLink.getUserId());
        Assert.assertEquals((Object)"candidate", (Object)identityLink.getType());
        this.deleteTask(taskId, true);
    }

    @Test
    public void testProcessTaskAddCandidateUserWithoutAuthorization() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        try {
            this.taskService.addCandidateUser(taskId, "demo");
            Assert.fail((String)"Exception expected: It should not be possible to add a candidate user");
        }
        catch (AuthorizationException e) {
            String message = e.getMessage();
            this.testRule.assertTextPresent(this.userId, message);
            this.testRule.assertTextPresent(Permissions.UPDATE.getName(), message);
            this.testRule.assertTextPresent(taskId, message);
            this.testRule.assertTextPresent(Resources.TASK.resourceName(), message);
            this.testRule.assertTextPresent(Permissions.UPDATE_TASK.getName(), message);
            this.testRule.assertTextPresent(Resources.PROCESS_DEFINITION.resourceName(), message);
        }
    }

    @Test
    public void testProcessTaskAddCandidateUserWithUpdatePersmissionOnTask() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        this.createGrantAuthorization((Resource)Resources.TASK, taskId, this.userId, new Permission[]{Permissions.UPDATE});
        this.taskService.addCandidateUser(taskId, "demo");
        this.disableAuthorization();
        List linksForTask = this.taskService.getIdentityLinksForTask(taskId);
        this.enableAuthorization();
        Assert.assertNotNull((Object)linksForTask);
        Assert.assertEquals((long)1L, (long)linksForTask.size());
        IdentityLink identityLink = (IdentityLink)linksForTask.get(0);
        Assert.assertNotNull((Object)identityLink);
        Assert.assertEquals((Object)"demo", (Object)identityLink.getUserId());
        Assert.assertEquals((Object)"candidate", (Object)identityLink.getType());
    }

    @Test
    public void testProcessTaskAddCandidateUserWithTaskAssignPermissionRevokeOnTask() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        this.createRevokeAuthorization((Resource)Resources.TASK, taskId, this.userId, new Permission[]{Permissions.TASK_ASSIGN});
        this.createGrantAuthorization((Resource)Resources.TASK, taskId, this.userId, new Permission[]{Permissions.UPDATE});
        try {
            this.taskService.addCandidateUser(taskId, "demo");
            Assert.fail((String)"Exception expected: It should not be possible to add an user identity link");
        }
        catch (AuthorizationException e) {
            this.testRule.assertTextPresent("The user with id 'test' does not have one of the following permissions: 'TASK_ASSIGN", e.getMessage());
        }
    }

    @Test
    public void testProcessTaskAddCandidateUserWithTaskAssignPermissionOnTask() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        this.createGrantAuthorization((Resource)Resources.TASK, taskId, this.userId, new Permission[]{Permissions.TASK_ASSIGN});
        this.taskService.addCandidateUser(taskId, "demo");
        this.disableAuthorization();
        List linksForTask = this.taskService.getIdentityLinksForTask(taskId);
        this.enableAuthorization();
        Assert.assertNotNull((Object)linksForTask);
        Assert.assertEquals((long)1L, (long)linksForTask.size());
        IdentityLink identityLink = (IdentityLink)linksForTask.get(0);
        Assert.assertNotNull((Object)identityLink);
        Assert.assertEquals((Object)"demo", (Object)identityLink.getUserId());
        Assert.assertEquals((Object)"candidate", (Object)identityLink.getType());
    }

    @Test
    public void testProcessTaskAddCandidateUserWithGrantTaskAssignAndRevokeUpdatePermissionOnTask() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        this.createGrantAuthorization((Resource)Resources.TASK, taskId, this.userId, new Permission[]{Permissions.TASK_ASSIGN});
        this.createRevokeAuthorization((Resource)Resources.TASK, taskId, this.userId, new Permission[]{Permissions.UPDATE});
        this.taskService.addCandidateUser(taskId, "demo");
        this.disableAuthorization();
        List linksForTask = this.taskService.getIdentityLinksForTask(taskId);
        this.enableAuthorization();
        Assert.assertNotNull((Object)linksForTask);
        Assert.assertEquals((long)1L, (long)linksForTask.size());
        IdentityLink identityLink = (IdentityLink)linksForTask.get(0);
        Assert.assertNotNull((Object)identityLink);
        Assert.assertEquals((Object)"demo", (Object)identityLink.getUserId());
        Assert.assertEquals((Object)"candidate", (Object)identityLink.getType());
    }

    @Test
    public void testProcessTaskAddCandidateUserWithUpdatePersmissionOnAnyTask() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        this.createGrantAuthorization((Resource)Resources.TASK, "*", this.userId, new Permission[]{Permissions.UPDATE});
        this.taskService.addCandidateUser(taskId, "demo");
        this.disableAuthorization();
        List linksForTask = this.taskService.getIdentityLinksForTask(taskId);
        this.enableAuthorization();
        Assert.assertNotNull((Object)linksForTask);
        Assert.assertEquals((long)1L, (long)linksForTask.size());
        IdentityLink identityLink = (IdentityLink)linksForTask.get(0);
        Assert.assertNotNull((Object)identityLink);
        Assert.assertEquals((Object)"demo", (Object)identityLink.getUserId());
        Assert.assertEquals((Object)"candidate", (Object)identityLink.getType());
    }

    @Test
    public void testProcessTaskAddCandidateUserWithTaskAssignPersmissionOnAnyTask() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        this.createGrantAuthorization((Resource)Resources.TASK, "*", this.userId, new Permission[]{Permissions.TASK_ASSIGN});
        this.taskService.addCandidateUser(taskId, "demo");
        this.disableAuthorization();
        List linksForTask = this.taskService.getIdentityLinksForTask(taskId);
        this.enableAuthorization();
        Assert.assertNotNull((Object)linksForTask);
        Assert.assertEquals((long)1L, (long)linksForTask.size());
        IdentityLink identityLink = (IdentityLink)linksForTask.get(0);
        Assert.assertNotNull((Object)identityLink);
        Assert.assertEquals((Object)"demo", (Object)identityLink.getUserId());
        Assert.assertEquals((Object)"candidate", (Object)identityLink.getType());
    }

    @Test
    public void testProcessTaskAddCandidateUserWithUpdateTasksPersmissionOnProcessDefinition() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, PROCESS_KEY, this.userId, new Permission[]{Permissions.UPDATE_TASK});
        this.taskService.addCandidateUser(taskId, "demo");
        this.disableAuthorization();
        List linksForTask = this.taskService.getIdentityLinksForTask(taskId);
        this.enableAuthorization();
        Assert.assertNotNull((Object)linksForTask);
        Assert.assertEquals((long)1L, (long)linksForTask.size());
        IdentityLink identityLink = (IdentityLink)linksForTask.get(0);
        Assert.assertNotNull((Object)identityLink);
        Assert.assertEquals((Object)"demo", (Object)identityLink.getUserId());
        Assert.assertEquals((Object)"candidate", (Object)identityLink.getType());
    }

    @Test
    public void testProcessTaskAddCandidateUserWithTaskAssignPermissionOnProcessDefinition() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, PROCESS_KEY, this.userId, new Permission[]{Permissions.TASK_ASSIGN});
        this.taskService.addCandidateUser(taskId, "demo");
        this.disableAuthorization();
        List linksForTask = this.taskService.getIdentityLinksForTask(taskId);
        this.enableAuthorization();
        Assert.assertNotNull((Object)linksForTask);
        Assert.assertEquals((long)1L, (long)linksForTask.size());
        IdentityLink identityLink = (IdentityLink)linksForTask.get(0);
        Assert.assertNotNull((Object)identityLink);
        Assert.assertEquals((Object)"demo", (Object)identityLink.getUserId());
        Assert.assertEquals((Object)"candidate", (Object)identityLink.getType());
    }

    @Test
    public void testProcessTaskAddCandidateUser() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        this.createGrantAuthorization((Resource)Resources.TASK, taskId, this.userId, new Permission[]{Permissions.UPDATE});
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, PROCESS_KEY, this.userId, new Permission[]{Permissions.UPDATE_TASK});
        this.taskService.addCandidateUser(taskId, "demo");
        this.disableAuthorization();
        List linksForTask = this.taskService.getIdentityLinksForTask(taskId);
        this.enableAuthorization();
        Assert.assertNotNull((Object)linksForTask);
        Assert.assertEquals((long)1L, (long)linksForTask.size());
        IdentityLink identityLink = (IdentityLink)linksForTask.get(0);
        Assert.assertNotNull((Object)identityLink);
        Assert.assertEquals((Object)"demo", (Object)identityLink.getUserId());
        Assert.assertEquals((Object)"candidate", (Object)identityLink.getType());
    }

    @Test
    public void testCaseTaskAddCandidateUser() {
        this.testRule.createCaseInstanceByKey(CASE_KEY);
        String taskId = this.selectSingleTask().getId();
        this.taskService.addCandidateUser(taskId, "demo");
        this.disableAuthorization();
        List linksForTask = this.taskService.getIdentityLinksForTask(taskId);
        this.enableAuthorization();
        Assert.assertNotNull((Object)linksForTask);
        Assert.assertEquals((long)1L, (long)linksForTask.size());
        IdentityLink identityLink = (IdentityLink)linksForTask.get(0);
        Assert.assertNotNull((Object)identityLink);
        Assert.assertEquals((Object)"demo", (Object)identityLink.getUserId());
        Assert.assertEquals((Object)"candidate", (Object)identityLink.getType());
    }

    @Test
    public void testStandaloneTaskAddCandidateGroupWithoutAuthorization() {
        String taskId = "myTask";
        this.createTask(taskId);
        try {
            this.taskService.addCandidateGroup(taskId, "accounting");
            Assert.fail((String)"Exception expected: It should not be possible to add a candidate group");
        }
        catch (AuthorizationException e) {
            this.testRule.assertTextPresent("The user with id 'test' does not have one of the following permissions: 'TASK_ASSIGN", e.getMessage());
        }
        this.deleteTask(taskId, true);
    }

    @Test
    public void testStandaloneTaskAddCandidateGroup() {
        String taskId = "myTask";
        this.createTask(taskId);
        this.createGrantAuthorization((Resource)Resources.TASK, taskId, this.userId, new Permission[]{Permissions.UPDATE});
        this.taskService.addCandidateGroup(taskId, "accounting");
        this.disableAuthorization();
        List linksForTask = this.taskService.getIdentityLinksForTask(taskId);
        this.enableAuthorization();
        Assert.assertNotNull((Object)linksForTask);
        Assert.assertEquals((long)1L, (long)linksForTask.size());
        IdentityLink identityLink = (IdentityLink)linksForTask.get(0);
        Assert.assertNotNull((Object)identityLink);
        Assert.assertEquals((Object)"accounting", (Object)identityLink.getGroupId());
        Assert.assertEquals((Object)"candidate", (Object)identityLink.getType());
        this.deleteTask(taskId, true);
    }

    @Test
    public void testStandaloneTaskAddCandidateGroupWithTaskAssignPermission() {
        String taskId = "myTask";
        this.createTask(taskId);
        this.createGrantAuthorization((Resource)Resources.TASK, taskId, this.userId, new Permission[]{Permissions.TASK_ASSIGN});
        this.taskService.addCandidateGroup(taskId, "accounting");
        this.disableAuthorization();
        List linksForTask = this.taskService.getIdentityLinksForTask(taskId);
        this.enableAuthorization();
        Assert.assertNotNull((Object)linksForTask);
        Assert.assertEquals((long)1L, (long)linksForTask.size());
        IdentityLink identityLink = (IdentityLink)linksForTask.get(0);
        Assert.assertNotNull((Object)identityLink);
        Assert.assertEquals((Object)"accounting", (Object)identityLink.getGroupId());
        Assert.assertEquals((Object)"candidate", (Object)identityLink.getType());
        this.deleteTask(taskId, true);
    }

    @Test
    public void testProcessTaskAddCandidateGroupWithoutAuthorization() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        try {
            this.taskService.addCandidateGroup(taskId, "accounting");
            Assert.fail((String)"Exception expected: It should not be possible to add a candidate group");
        }
        catch (AuthorizationException e) {
            String message = e.getMessage();
            this.testRule.assertTextPresent(this.userId, message);
            this.testRule.assertTextPresent(Permissions.UPDATE.getName(), message);
            this.testRule.assertTextPresent(taskId, message);
            this.testRule.assertTextPresent(Resources.TASK.resourceName(), message);
            this.testRule.assertTextPresent(Permissions.UPDATE_TASK.getName(), message);
            this.testRule.assertTextPresent(Resources.PROCESS_DEFINITION.resourceName(), message);
        }
    }

    @Test
    public void testProcessTaskAddCandidateGroupWithUpdatePersmissionOnTask() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        this.createGrantAuthorization((Resource)Resources.TASK, taskId, this.userId, new Permission[]{Permissions.UPDATE});
        this.taskService.addCandidateGroup(taskId, "accounting");
        this.disableAuthorization();
        List linksForTask = this.taskService.getIdentityLinksForTask(taskId);
        this.enableAuthorization();
        Assert.assertNotNull((Object)linksForTask);
        Assert.assertEquals((long)1L, (long)linksForTask.size());
        IdentityLink identityLink = (IdentityLink)linksForTask.get(0);
        Assert.assertNotNull((Object)identityLink);
        Assert.assertEquals((Object)"accounting", (Object)identityLink.getGroupId());
        Assert.assertEquals((Object)"candidate", (Object)identityLink.getType());
    }

    @Test
    public void testProcessTaskAddCandidateGroupWithTaskAssignPermissionOnTask() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        this.createGrantAuthorization((Resource)Resources.TASK, taskId, this.userId, new Permission[]{Permissions.TASK_ASSIGN});
        this.taskService.addCandidateGroup(taskId, "accounting");
        this.disableAuthorization();
        List linksForTask = this.taskService.getIdentityLinksForTask(taskId);
        this.enableAuthorization();
        Assert.assertNotNull((Object)linksForTask);
        Assert.assertEquals((long)1L, (long)linksForTask.size());
        IdentityLink identityLink = (IdentityLink)linksForTask.get(0);
        Assert.assertNotNull((Object)identityLink);
        Assert.assertEquals((Object)"accounting", (Object)identityLink.getGroupId());
        Assert.assertEquals((Object)"candidate", (Object)identityLink.getType());
    }

    @Test
    public void testProcessTaskAddCandidateGroupWithUpdatePersmissionOnAnyTask() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        this.createGrantAuthorization((Resource)Resources.TASK, "*", this.userId, new Permission[]{Permissions.UPDATE});
        this.taskService.addCandidateGroup(taskId, "accounting");
        this.disableAuthorization();
        List linksForTask = this.taskService.getIdentityLinksForTask(taskId);
        this.enableAuthorization();
        Assert.assertNotNull((Object)linksForTask);
        Assert.assertEquals((long)1L, (long)linksForTask.size());
        IdentityLink identityLink = (IdentityLink)linksForTask.get(0);
        Assert.assertNotNull((Object)identityLink);
        Assert.assertEquals((Object)"accounting", (Object)identityLink.getGroupId());
        Assert.assertEquals((Object)"candidate", (Object)identityLink.getType());
    }

    @Test
    public void testProcessTaskAddCandidateGroupWithTaskAssignPermissionOnAnyTask() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        this.createGrantAuthorization((Resource)Resources.TASK, "*", this.userId, new Permission[]{Permissions.TASK_ASSIGN});
        this.taskService.addCandidateGroup(taskId, "accounting");
        this.disableAuthorization();
        List linksForTask = this.taskService.getIdentityLinksForTask(taskId);
        this.enableAuthorization();
        Assert.assertNotNull((Object)linksForTask);
        Assert.assertEquals((long)1L, (long)linksForTask.size());
        IdentityLink identityLink = (IdentityLink)linksForTask.get(0);
        Assert.assertNotNull((Object)identityLink);
        Assert.assertEquals((Object)"accounting", (Object)identityLink.getGroupId());
        Assert.assertEquals((Object)"candidate", (Object)identityLink.getType());
    }

    @Test
    public void testProcessTaskAddCandidateGroupWithUpdateTasksPersmissionOnProcessDefinition() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, PROCESS_KEY, this.userId, new Permission[]{Permissions.UPDATE_TASK});
        this.taskService.addCandidateGroup(taskId, "accounting");
        this.disableAuthorization();
        List linksForTask = this.taskService.getIdentityLinksForTask(taskId);
        this.enableAuthorization();
        Assert.assertNotNull((Object)linksForTask);
        Assert.assertEquals((long)1L, (long)linksForTask.size());
        IdentityLink identityLink = (IdentityLink)linksForTask.get(0);
        Assert.assertNotNull((Object)identityLink);
        Assert.assertEquals((Object)"accounting", (Object)identityLink.getGroupId());
        Assert.assertEquals((Object)"candidate", (Object)identityLink.getType());
    }

    @Test
    public void testProcessTaskAddCandidateGroupWithTaskAssignPersmissionOnProcessDefinition() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, PROCESS_KEY, this.userId, new Permission[]{Permissions.TASK_ASSIGN});
        this.taskService.addCandidateGroup(taskId, "accounting");
        this.disableAuthorization();
        List linksForTask = this.taskService.getIdentityLinksForTask(taskId);
        this.enableAuthorization();
        Assert.assertNotNull((Object)linksForTask);
        Assert.assertEquals((long)1L, (long)linksForTask.size());
        IdentityLink identityLink = (IdentityLink)linksForTask.get(0);
        Assert.assertNotNull((Object)identityLink);
        Assert.assertEquals((Object)"accounting", (Object)identityLink.getGroupId());
        Assert.assertEquals((Object)"candidate", (Object)identityLink.getType());
    }

    @Test
    public void testProcessTaskAddCandidateGroup() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        this.createGrantAuthorization((Resource)Resources.TASK, taskId, this.userId, new Permission[]{Permissions.UPDATE});
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, PROCESS_KEY, this.userId, new Permission[]{Permissions.UPDATE_TASK});
        this.taskService.addCandidateGroup(taskId, "accounting");
        this.disableAuthorization();
        List linksForTask = this.taskService.getIdentityLinksForTask(taskId);
        this.enableAuthorization();
        Assert.assertNotNull((Object)linksForTask);
        Assert.assertEquals((long)1L, (long)linksForTask.size());
        IdentityLink identityLink = (IdentityLink)linksForTask.get(0);
        Assert.assertNotNull((Object)identityLink);
        Assert.assertEquals((Object)"accounting", (Object)identityLink.getGroupId());
        Assert.assertEquals((Object)"candidate", (Object)identityLink.getType());
    }

    @Test
    public void testProcessTaskAddCandidateGroupWithTaskAssignPermission() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        this.createGrantAuthorization((Resource)Resources.TASK, taskId, this.userId, new Permission[]{Permissions.TASK_ASSIGN});
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, PROCESS_KEY, this.userId, new Permission[]{Permissions.TASK_ASSIGN});
        this.taskService.addCandidateGroup(taskId, "accounting");
        this.disableAuthorization();
        List linksForTask = this.taskService.getIdentityLinksForTask(taskId);
        this.enableAuthorization();
        Assert.assertNotNull((Object)linksForTask);
        Assert.assertEquals((long)1L, (long)linksForTask.size());
        IdentityLink identityLink = (IdentityLink)linksForTask.get(0);
        Assert.assertNotNull((Object)identityLink);
        Assert.assertEquals((Object)"accounting", (Object)identityLink.getGroupId());
        Assert.assertEquals((Object)"candidate", (Object)identityLink.getType());
    }

    @Test
    public void testProcessTaskAddCandidateGroupWithTaskAssignPermissionRevoked() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        this.createRevokeAuthorization((Resource)Resources.PROCESS_DEFINITION, PROCESS_KEY, this.userId, new Permission[]{Permissions.TASK_ASSIGN});
        this.createGrantAuthorization((Resource)Resources.TASK, taskId, this.userId, new Permission[]{Permissions.TASK_ASSIGN});
        this.taskService.addCandidateGroup(taskId, "accounting");
        this.disableAuthorization();
        List linksForTask = this.taskService.getIdentityLinksForTask(taskId);
        this.enableAuthorization();
        Assert.assertNotNull((Object)linksForTask);
        Assert.assertEquals((long)1L, (long)linksForTask.size());
        IdentityLink identityLink = (IdentityLink)linksForTask.get(0);
        Assert.assertNotNull((Object)identityLink);
        Assert.assertEquals((Object)"accounting", (Object)identityLink.getGroupId());
        Assert.assertEquals((Object)"candidate", (Object)identityLink.getType());
    }

    @Test
    public void testCaseTaskAddCandidateGroup() {
        this.testRule.createCaseInstanceByKey(CASE_KEY);
        String taskId = this.selectSingleTask().getId();
        this.taskService.addCandidateGroup(taskId, "accounting");
        this.disableAuthorization();
        List linksForTask = this.taskService.getIdentityLinksForTask(taskId);
        this.enableAuthorization();
        Assert.assertNotNull((Object)linksForTask);
        Assert.assertEquals((long)1L, (long)linksForTask.size());
        IdentityLink identityLink = (IdentityLink)linksForTask.get(0);
        Assert.assertNotNull((Object)identityLink);
        Assert.assertEquals((Object)"accounting", (Object)identityLink.getGroupId());
        Assert.assertEquals((Object)"candidate", (Object)identityLink.getType());
    }

    @Test
    public void testStandaloneTaskAddUserIdentityLinkWithoutAuthorization() {
        String taskId = "myTask";
        this.createTask(taskId);
        try {
            this.taskService.addUserIdentityLink(taskId, "demo", "candidate");
            Assert.fail((String)"Exception expected: It should not be possible to add an user identity link");
        }
        catch (AuthorizationException e) {
            this.testRule.assertTextPresent("The user with id 'test' does not have one of the following permissions: 'TASK_ASSIGN", e.getMessage());
        }
        this.deleteTask(taskId, true);
    }

    @Test
    public void testStandaloneTaskAddUserIdentityLink() {
        String taskId = "myTask";
        this.createTask(taskId);
        this.createGrantAuthorization((Resource)Resources.TASK, taskId, this.userId, new Permission[]{Permissions.UPDATE});
        this.taskService.addUserIdentityLink(taskId, "demo", "candidate");
        this.disableAuthorization();
        List linksForTask = this.taskService.getIdentityLinksForTask(taskId);
        this.enableAuthorization();
        Assert.assertNotNull((Object)linksForTask);
        Assert.assertEquals((long)1L, (long)linksForTask.size());
        IdentityLink identityLink = (IdentityLink)linksForTask.get(0);
        Assert.assertNotNull((Object)identityLink);
        Assert.assertEquals((Object)"demo", (Object)identityLink.getUserId());
        Assert.assertEquals((Object)"candidate", (Object)identityLink.getType());
        this.deleteTask(taskId, true);
    }

    @Test
    public void testStandaloneTaskAddUserIdentityLinkWithTaskAssignPermission() {
        String taskId = "myTask";
        this.createTask(taskId);
        this.createGrantAuthorization((Resource)Resources.TASK, taskId, this.userId, new Permission[]{Permissions.TASK_ASSIGN});
        this.taskService.addUserIdentityLink(taskId, "demo", "candidate");
        this.disableAuthorization();
        List linksForTask = this.taskService.getIdentityLinksForTask(taskId);
        Assert.assertNotNull((Object)linksForTask);
        Assert.assertEquals((long)1L, (long)linksForTask.size());
        IdentityLink identityLink = (IdentityLink)linksForTask.get(0);
        Assert.assertNotNull((Object)identityLink);
        Assert.assertEquals((Object)"demo", (Object)identityLink.getUserId());
        Assert.assertEquals((Object)"candidate", (Object)identityLink.getType());
        this.deleteTask(taskId, true);
    }

    @Test
    public void testProcessTaskAddUserIdentityLinkWithoutAuthorization() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        try {
            this.taskService.addUserIdentityLink(taskId, "demo", "candidate");
            Assert.fail((String)"Exception expected: It should not be possible to add an user identity link");
        }
        catch (AuthorizationException e) {
            String message = e.getMessage();
            this.testRule.assertTextPresent(this.userId, message);
            this.testRule.assertTextPresent(Permissions.UPDATE.getName(), message);
            this.testRule.assertTextPresent(taskId, message);
            this.testRule.assertTextPresent(Resources.TASK.resourceName(), message);
            this.testRule.assertTextPresent(Permissions.UPDATE_TASK.getName(), message);
            this.testRule.assertTextPresent(Resources.PROCESS_DEFINITION.resourceName(), message);
        }
    }

    @Test
    public void testProcessTaskAddUserIdentityLinkWithUpdatePersmissionOnTask() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        this.createGrantAuthorization((Resource)Resources.TASK, taskId, this.userId, new Permission[]{Permissions.UPDATE});
        this.taskService.addUserIdentityLink(taskId, "demo", "candidate");
        this.disableAuthorization();
        List linksForTask = this.taskService.getIdentityLinksForTask(taskId);
        this.enableAuthorization();
        Assert.assertNotNull((Object)linksForTask);
        Assert.assertEquals((long)1L, (long)linksForTask.size());
        IdentityLink identityLink = (IdentityLink)linksForTask.get(0);
        Assert.assertNotNull((Object)identityLink);
        Assert.assertEquals((Object)"demo", (Object)identityLink.getUserId());
        Assert.assertEquals((Object)"candidate", (Object)identityLink.getType());
    }

    @Test
    public void testProcessTaskAddUserIdentityLinkWithTaskAssignPermissionOnTask() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        this.createGrantAuthorization((Resource)Resources.TASK, taskId, this.userId, new Permission[]{Permissions.TASK_ASSIGN});
        this.taskService.addUserIdentityLink(taskId, "demo", "candidate");
        this.disableAuthorization();
        List linksForTask = this.taskService.getIdentityLinksForTask(taskId);
        this.enableAuthorization();
        Assert.assertNotNull((Object)linksForTask);
        Assert.assertEquals((long)1L, (long)linksForTask.size());
        IdentityLink identityLink = (IdentityLink)linksForTask.get(0);
        Assert.assertNotNull((Object)identityLink);
        Assert.assertEquals((Object)"demo", (Object)identityLink.getUserId());
        Assert.assertEquals((Object)"candidate", (Object)identityLink.getType());
    }

    @Test
    public void testProcessTaskAddUserIdentityLinkWithUpdatePersmissionOnAnyTask() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        this.createGrantAuthorization((Resource)Resources.TASK, "*", this.userId, new Permission[]{Permissions.UPDATE});
        this.taskService.addUserIdentityLink(taskId, "demo", "candidate");
        this.disableAuthorization();
        List linksForTask = this.taskService.getIdentityLinksForTask(taskId);
        this.enableAuthorization();
        Assert.assertNotNull((Object)linksForTask);
        Assert.assertEquals((long)1L, (long)linksForTask.size());
        IdentityLink identityLink = (IdentityLink)linksForTask.get(0);
        Assert.assertNotNull((Object)identityLink);
        Assert.assertEquals((Object)"demo", (Object)identityLink.getUserId());
        Assert.assertEquals((Object)"candidate", (Object)identityLink.getType());
    }

    @Test
    public void testProcessTaskAddUserIdentityLinkWithTaskAssignPersmissionOnAnyTask() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        this.createGrantAuthorization((Resource)Resources.TASK, "*", this.userId, new Permission[]{Permissions.TASK_ASSIGN});
        this.taskService.addUserIdentityLink(taskId, "demo", "candidate");
        this.disableAuthorization();
        List linksForTask = this.taskService.getIdentityLinksForTask(taskId);
        this.enableAuthorization();
        Assert.assertNotNull((Object)linksForTask);
        Assert.assertEquals((long)1L, (long)linksForTask.size());
        IdentityLink identityLink = (IdentityLink)linksForTask.get(0);
        Assert.assertNotNull((Object)identityLink);
        Assert.assertEquals((Object)"demo", (Object)identityLink.getUserId());
        Assert.assertEquals((Object)"candidate", (Object)identityLink.getType());
    }

    @Test
    public void testProcessTaskAddUserIdentityLinkWithUpdateTasksPersmissionOnProcessDefinition() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, PROCESS_KEY, this.userId, new Permission[]{Permissions.UPDATE_TASK});
        this.taskService.addUserIdentityLink(taskId, "demo", "candidate");
        this.disableAuthorization();
        List linksForTask = this.taskService.getIdentityLinksForTask(taskId);
        this.enableAuthorization();
        Assert.assertNotNull((Object)linksForTask);
        Assert.assertEquals((long)1L, (long)linksForTask.size());
        IdentityLink identityLink = (IdentityLink)linksForTask.get(0);
        Assert.assertNotNull((Object)identityLink);
        Assert.assertEquals((Object)"demo", (Object)identityLink.getUserId());
        Assert.assertEquals((Object)"candidate", (Object)identityLink.getType());
    }

    @Test
    public void testProcessTaskAddUserIdentityLinkWithTaskAssignPermissionOnProcessDefinition() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, PROCESS_KEY, this.userId, new Permission[]{Permissions.TASK_ASSIGN});
        this.taskService.addUserIdentityLink(taskId, "demo", "candidate");
        this.disableAuthorization();
        List linksForTask = this.taskService.getIdentityLinksForTask(taskId);
        this.enableAuthorization();
        Assert.assertNotNull((Object)linksForTask);
        Assert.assertEquals((long)1L, (long)linksForTask.size());
        IdentityLink identityLink = (IdentityLink)linksForTask.get(0);
        Assert.assertNotNull((Object)identityLink);
        Assert.assertEquals((Object)"demo", (Object)identityLink.getUserId());
        Assert.assertEquals((Object)"candidate", (Object)identityLink.getType());
    }

    @Test
    public void testProcessTaskAddUserIdentityLink() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        this.createGrantAuthorization((Resource)Resources.TASK, taskId, this.userId, new Permission[]{Permissions.UPDATE});
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, PROCESS_KEY, this.userId, new Permission[]{Permissions.UPDATE_TASK});
        this.taskService.addUserIdentityLink(taskId, "demo", "candidate");
        this.disableAuthorization();
        List linksForTask = this.taskService.getIdentityLinksForTask(taskId);
        this.enableAuthorization();
        Assert.assertNotNull((Object)linksForTask);
        Assert.assertEquals((long)1L, (long)linksForTask.size());
        IdentityLink identityLink = (IdentityLink)linksForTask.get(0);
        Assert.assertNotNull((Object)identityLink);
        Assert.assertEquals((Object)"demo", (Object)identityLink.getUserId());
        Assert.assertEquals((Object)"candidate", (Object)identityLink.getType());
    }

    @Test
    public void testCaseTaskAddUserIdentityLink() {
        this.testRule.createCaseInstanceByKey(CASE_KEY);
        String taskId = this.selectSingleTask().getId();
        this.taskService.addUserIdentityLink(taskId, "demo", "candidate");
        this.disableAuthorization();
        List linksForTask = this.taskService.getIdentityLinksForTask(taskId);
        this.enableAuthorization();
        Assert.assertNotNull((Object)linksForTask);
        Assert.assertEquals((long)1L, (long)linksForTask.size());
        IdentityLink identityLink = (IdentityLink)linksForTask.get(0);
        Assert.assertNotNull((Object)identityLink);
        Assert.assertEquals((Object)"demo", (Object)identityLink.getUserId());
        Assert.assertEquals((Object)"candidate", (Object)identityLink.getType());
    }

    @Test
    public void testStandaloneTaskAddGroupIdentityLinkWithoutAuthorization() {
        String taskId = "myTask";
        this.createTask(taskId);
        try {
            this.taskService.addGroupIdentityLink(taskId, "accounting", "candidate");
            Assert.fail((String)"Exception expected: It should not be possible to add a group identity link");
        }
        catch (AuthorizationException e) {
            this.testRule.assertTextPresent("The user with id 'test' does not have one of the following permissions: 'TASK_ASSIGN", e.getMessage());
        }
        this.deleteTask(taskId, true);
    }

    @Test
    public void testStandaloneTaskAddGroupIdentityLink() {
        String taskId = "myTask";
        this.createTask(taskId);
        this.createGrantAuthorization((Resource)Resources.TASK, taskId, this.userId, new Permission[]{Permissions.UPDATE});
        this.taskService.addGroupIdentityLink(taskId, "accounting", "candidate");
        this.disableAuthorization();
        List linksForTask = this.taskService.getIdentityLinksForTask(taskId);
        this.enableAuthorization();
        Assert.assertNotNull((Object)linksForTask);
        Assert.assertEquals((long)1L, (long)linksForTask.size());
        IdentityLink identityLink = (IdentityLink)linksForTask.get(0);
        Assert.assertNotNull((Object)identityLink);
        Assert.assertEquals((Object)"accounting", (Object)identityLink.getGroupId());
        Assert.assertEquals((Object)"candidate", (Object)identityLink.getType());
        this.deleteTask(taskId, true);
    }

    @Test
    public void testProcessTaskAddGroupIdentityLinkWithoutAuthorization() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        try {
            this.taskService.addGroupIdentityLink(taskId, "accounting", "candidate");
            Assert.fail((String)"Exception expected: It should not be possible to add a group identity link");
        }
        catch (AuthorizationException e) {
            String message = e.getMessage();
            this.testRule.assertTextPresent(this.userId, message);
            this.testRule.assertTextPresent(Permissions.UPDATE.getName(), message);
            this.testRule.assertTextPresent(taskId, message);
            this.testRule.assertTextPresent(Resources.TASK.resourceName(), message);
            this.testRule.assertTextPresent(Permissions.UPDATE_TASK.getName(), message);
            this.testRule.assertTextPresent(Resources.PROCESS_DEFINITION.resourceName(), message);
        }
    }

    @Test
    public void testProcessTaskAddGroupIdentityLinkWithUpdatePersmissionOnTask() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        this.createGrantAuthorization((Resource)Resources.TASK, taskId, this.userId, new Permission[]{Permissions.UPDATE});
        this.taskService.addGroupIdentityLink(taskId, "accounting", "candidate");
        this.disableAuthorization();
        List linksForTask = this.taskService.getIdentityLinksForTask(taskId);
        this.enableAuthorization();
        Assert.assertNotNull((Object)linksForTask);
        Assert.assertEquals((long)1L, (long)linksForTask.size());
        IdentityLink identityLink = (IdentityLink)linksForTask.get(0);
        Assert.assertNotNull((Object)identityLink);
        Assert.assertEquals((Object)"accounting", (Object)identityLink.getGroupId());
        Assert.assertEquals((Object)"candidate", (Object)identityLink.getType());
    }

    @Test
    public void testProcessTaskAddGroupIdentityLinkWithUpdatePersmissionOnAnyTask() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        this.createGrantAuthorization((Resource)Resources.TASK, "*", this.userId, new Permission[]{Permissions.UPDATE});
        this.taskService.addGroupIdentityLink(taskId, "accounting", "candidate");
        this.disableAuthorization();
        List linksForTask = this.taskService.getIdentityLinksForTask(taskId);
        this.enableAuthorization();
        Assert.assertNotNull((Object)linksForTask);
        Assert.assertEquals((long)1L, (long)linksForTask.size());
        IdentityLink identityLink = (IdentityLink)linksForTask.get(0);
        Assert.assertNotNull((Object)identityLink);
        Assert.assertEquals((Object)"accounting", (Object)identityLink.getGroupId());
        Assert.assertEquals((Object)"candidate", (Object)identityLink.getType());
    }

    @Test
    public void testProcessTaskAddGroupIdentityLinkWithUpdateTasksPersmissionOnProcessDefinition() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, PROCESS_KEY, this.userId, new Permission[]{Permissions.UPDATE_TASK});
        this.taskService.addGroupIdentityLink(taskId, "accounting", "candidate");
        this.disableAuthorization();
        List linksForTask = this.taskService.getIdentityLinksForTask(taskId);
        this.enableAuthorization();
        Assert.assertNotNull((Object)linksForTask);
        Assert.assertEquals((long)1L, (long)linksForTask.size());
        IdentityLink identityLink = (IdentityLink)linksForTask.get(0);
        Assert.assertNotNull((Object)identityLink);
        Assert.assertEquals((Object)"accounting", (Object)identityLink.getGroupId());
        Assert.assertEquals((Object)"candidate", (Object)identityLink.getType());
    }

    @Test
    public void testProcessTaskAddGroupIdentityLink() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        this.createGrantAuthorization((Resource)Resources.TASK, taskId, this.userId, new Permission[]{Permissions.UPDATE});
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, PROCESS_KEY, this.userId, new Permission[]{Permissions.UPDATE_TASK});
        this.taskService.addGroupIdentityLink(taskId, "accounting", "candidate");
        this.disableAuthorization();
        List linksForTask = this.taskService.getIdentityLinksForTask(taskId);
        this.enableAuthorization();
        Assert.assertNotNull((Object)linksForTask);
        Assert.assertEquals((long)1L, (long)linksForTask.size());
        IdentityLink identityLink = (IdentityLink)linksForTask.get(0);
        Assert.assertNotNull((Object)identityLink);
        Assert.assertEquals((Object)"accounting", (Object)identityLink.getGroupId());
        Assert.assertEquals((Object)"candidate", (Object)identityLink.getType());
    }

    @Test
    public void testCaseTaskAddGroupIdentityLink() {
        this.testRule.createCaseInstanceByKey(CASE_KEY);
        String taskId = this.selectSingleTask().getId();
        this.taskService.addGroupIdentityLink(taskId, "accounting", "candidate");
        this.disableAuthorization();
        List linksForTask = this.taskService.getIdentityLinksForTask(taskId);
        this.enableAuthorization();
        Assert.assertNotNull((Object)linksForTask);
        Assert.assertEquals((long)1L, (long)linksForTask.size());
        IdentityLink identityLink = (IdentityLink)linksForTask.get(0);
        Assert.assertNotNull((Object)identityLink);
        Assert.assertEquals((Object)"accounting", (Object)identityLink.getGroupId());
        Assert.assertEquals((Object)"candidate", (Object)identityLink.getType());
    }

    @Test
    public void testStandaloneTaskDeleteCandidateUserWithoutAuthorization() {
        String taskId = "myTask";
        this.createTask(taskId);
        this.addCandidateUser(taskId, "demo");
        try {
            this.taskService.deleteCandidateUser(taskId, "demo");
            Assert.fail((String)"Exception expected: It should not be possible to delete a candidate user");
        }
        catch (AuthorizationException e) {
            this.testRule.assertTextPresent("The user with id 'test' does not have one of the following permissions: 'TASK_ASSIGN", e.getMessage());
        }
        this.deleteTask(taskId, true);
    }

    @Test
    public void testStandaloneTaskDeleteCandidateUser() {
        String taskId = "myTask";
        this.createTask(taskId);
        this.addCandidateUser(taskId, "demo");
        this.createGrantAuthorization((Resource)Resources.TASK, taskId, this.userId, new Permission[]{Permissions.UPDATE});
        this.taskService.deleteCandidateUser(taskId, "demo");
        this.disableAuthorization();
        List linksForTask = this.taskService.getIdentityLinksForTask(taskId);
        this.enableAuthorization();
        Assert.assertNotNull((Object)linksForTask);
        Assert.assertTrue((boolean)linksForTask.isEmpty());
        this.deleteTask(taskId, true);
    }

    @Test
    public void testStandaloneTaskDeleteCandidateUserWithTaskAssignPermission() {
        String taskId = "myTask";
        this.createTask(taskId);
        this.addCandidateUser(taskId, "demo");
        this.createGrantAuthorization((Resource)Resources.TASK, taskId, this.userId, new Permission[]{Permissions.TASK_ASSIGN});
        this.taskService.deleteCandidateUser(taskId, "demo");
        this.disableAuthorization();
        List linksForTask = this.taskService.getIdentityLinksForTask(taskId);
        this.enableAuthorization();
        Assert.assertNotNull((Object)linksForTask);
        Assert.assertTrue((boolean)linksForTask.isEmpty());
        this.deleteTask(taskId, true);
    }

    @Test
    public void testProcessTaskDeleteCandidateUserWithoutAuthorization() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        this.addCandidateUser(taskId, "demo");
        try {
            this.taskService.deleteCandidateUser(taskId, "demo");
            Assert.fail((String)"Exception expected: It should not be possible to delete a candidate user");
        }
        catch (AuthorizationException e) {
            String message = e.getMessage();
            this.testRule.assertTextPresent(this.userId, message);
            this.testRule.assertTextPresent(Permissions.UPDATE.getName(), message);
            this.testRule.assertTextPresent(taskId, message);
            this.testRule.assertTextPresent(Resources.TASK.resourceName(), message);
            this.testRule.assertTextPresent(Permissions.UPDATE_TASK.getName(), message);
            this.testRule.assertTextPresent(Resources.PROCESS_DEFINITION.resourceName(), message);
        }
    }

    @Test
    public void testProcessTaskDeleteCandidateUserWithUpdatePersmissionOnTask() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        this.addCandidateUser(taskId, "demo");
        this.createGrantAuthorization((Resource)Resources.TASK, taskId, this.userId, new Permission[]{Permissions.UPDATE});
        this.taskService.deleteCandidateUser(taskId, "demo");
        this.disableAuthorization();
        List linksForTask = this.taskService.getIdentityLinksForTask(taskId);
        this.enableAuthorization();
        Assert.assertNotNull((Object)linksForTask);
        Assert.assertTrue((boolean)linksForTask.isEmpty());
    }

    @Test
    public void testProcessTaskDeleteCandidateUserWithTaskAssignPermissionOnTask() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        this.addCandidateUser(taskId, "demo");
        this.createGrantAuthorization((Resource)Resources.TASK, taskId, this.userId, new Permission[]{Permissions.TASK_ASSIGN});
        this.taskService.deleteCandidateUser(taskId, "demo");
        this.disableAuthorization();
        List linksForTask = this.taskService.getIdentityLinksForTask(taskId);
        this.enableAuthorization();
        Assert.assertNotNull((Object)linksForTask);
        Assert.assertTrue((boolean)linksForTask.isEmpty());
    }

    @Test
    public void testProcessTaskDeleteCandidateUserWithUpdatePersmissionOnAnyTask() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        this.addCandidateUser(taskId, "demo");
        this.createGrantAuthorization((Resource)Resources.TASK, "*", this.userId, new Permission[]{Permissions.UPDATE});
        this.taskService.deleteCandidateUser(taskId, "demo");
        this.disableAuthorization();
        List linksForTask = this.taskService.getIdentityLinksForTask(taskId);
        this.enableAuthorization();
        Assert.assertNotNull((Object)linksForTask);
        Assert.assertTrue((boolean)linksForTask.isEmpty());
    }

    @Test
    public void testProcessTaskDeleteCandidateUserWithTaskAssignPermissionOnAnyTask() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        this.addCandidateUser(taskId, "demo");
        this.createGrantAuthorization((Resource)Resources.TASK, "*", this.userId, new Permission[]{Permissions.TASK_ASSIGN});
        this.taskService.deleteCandidateUser(taskId, "demo");
        this.disableAuthorization();
        List linksForTask = this.taskService.getIdentityLinksForTask(taskId);
        this.enableAuthorization();
        Assert.assertNotNull((Object)linksForTask);
        Assert.assertTrue((boolean)linksForTask.isEmpty());
    }

    @Test
    public void testProcessTaskDeleteCandidateUserWithUpdateTasksPersmissionOnProcessDefinition() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        this.addCandidateUser(taskId, "demo");
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, PROCESS_KEY, this.userId, new Permission[]{Permissions.UPDATE_TASK});
        this.taskService.deleteCandidateUser(taskId, "demo");
        this.disableAuthorization();
        List linksForTask = this.taskService.getIdentityLinksForTask(taskId);
        this.enableAuthorization();
        Assert.assertNotNull((Object)linksForTask);
        Assert.assertTrue((boolean)linksForTask.isEmpty());
    }

    @Test
    public void testProcessTaskDeleteCandidateUserWithTaskAssignPersmissionOnProcessDefinition() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        this.addCandidateUser(taskId, "demo");
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, PROCESS_KEY, this.userId, new Permission[]{Permissions.TASK_ASSIGN});
        this.taskService.deleteCandidateUser(taskId, "demo");
        this.disableAuthorization();
        List linksForTask = this.taskService.getIdentityLinksForTask(taskId);
        this.enableAuthorization();
        Assert.assertNotNull((Object)linksForTask);
        Assert.assertTrue((boolean)linksForTask.isEmpty());
    }

    @Test
    public void testProcessTaskDeleteCandidateUser() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        this.addCandidateUser(taskId, "demo");
        this.createGrantAuthorization((Resource)Resources.TASK, taskId, this.userId, new Permission[]{Permissions.UPDATE});
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, PROCESS_KEY, this.userId, new Permission[]{Permissions.UPDATE_TASK});
        this.taskService.deleteCandidateUser(taskId, "demo");
        this.disableAuthorization();
        List linksForTask = this.taskService.getIdentityLinksForTask(taskId);
        this.enableAuthorization();
        Assert.assertNotNull((Object)linksForTask);
        Assert.assertTrue((boolean)linksForTask.isEmpty());
    }

    @Test
    public void testCaseTaskDeleteCandidateUser() {
        this.testRule.createCaseInstanceByKey(CASE_KEY);
        String taskId = this.selectSingleTask().getId();
        this.addCandidateUser(taskId, "demo");
        this.taskService.deleteCandidateUser(taskId, "demo");
        this.disableAuthorization();
        List linksForTask = this.taskService.getIdentityLinksForTask(taskId);
        this.enableAuthorization();
        Assert.assertNotNull((Object)linksForTask);
        Assert.assertTrue((boolean)linksForTask.isEmpty());
    }

    @Test
    public void testStandaloneTaskDeleteCandidateGroupWithoutAuthorization() {
        String taskId = "myTask";
        this.createTask(taskId);
        this.addCandidateGroup(taskId, "accounting");
        try {
            this.taskService.deleteCandidateGroup(taskId, "accounting");
            Assert.fail((String)"Exception expected: It should not be possible to delete a candidate group");
        }
        catch (AuthorizationException e) {
            this.testRule.assertTextPresent("The user with id 'test' does not have one of the following permissions: 'TASK_ASSIGN", e.getMessage());
        }
        this.deleteTask(taskId, true);
    }

    @Test
    public void testStandaloneTaskDeleteCandidateGroup() {
        String taskId = "myTask";
        this.createTask(taskId);
        this.addCandidateGroup(taskId, "accounting");
        this.createGrantAuthorization((Resource)Resources.TASK, taskId, this.userId, new Permission[]{Permissions.UPDATE});
        this.taskService.deleteCandidateGroup(taskId, "accounting");
        this.disableAuthorization();
        List linksForTask = this.taskService.getIdentityLinksForTask(taskId);
        this.enableAuthorization();
        Assert.assertNotNull((Object)linksForTask);
        Assert.assertTrue((boolean)linksForTask.isEmpty());
        this.deleteTask(taskId, true);
    }

    @Test
    public void testStandaloneTaskDeleteCandidateGroupWithTaskAssignPermission() {
        String taskId = "myTask";
        this.createTask(taskId);
        this.addCandidateGroup(taskId, "accounting");
        this.createGrantAuthorization((Resource)Resources.TASK, taskId, this.userId, new Permission[]{Permissions.TASK_ASSIGN});
        this.taskService.deleteCandidateGroup(taskId, "accounting");
        this.disableAuthorization();
        List linksForTask = this.taskService.getIdentityLinksForTask(taskId);
        this.enableAuthorization();
        Assert.assertNotNull((Object)linksForTask);
        Assert.assertTrue((boolean)linksForTask.isEmpty());
        this.deleteTask(taskId, true);
    }

    @Test
    public void testProcessTaskDeleteCandidateGroupWithoutAuthorization() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        this.addCandidateGroup(taskId, "accounting");
        try {
            this.taskService.deleteCandidateGroup(taskId, "accounting");
            Assert.fail((String)"Exception expected: It should not be possible to delete a candidate group");
        }
        catch (AuthorizationException e) {
            String message = e.getMessage();
            this.testRule.assertTextPresent(this.userId, message);
            this.testRule.assertTextPresent(Permissions.UPDATE.getName(), message);
            this.testRule.assertTextPresent(taskId, message);
            this.testRule.assertTextPresent(Resources.TASK.resourceName(), message);
            this.testRule.assertTextPresent(Permissions.UPDATE_TASK.getName(), message);
            this.testRule.assertTextPresent(Resources.PROCESS_DEFINITION.resourceName(), message);
        }
    }

    @Test
    public void testProcessTaskDeleteCandidateGroupWithUpdatePersmissionOnTask() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        this.addCandidateGroup(taskId, "accounting");
        this.createGrantAuthorization((Resource)Resources.TASK, taskId, this.userId, new Permission[]{Permissions.UPDATE});
        this.taskService.deleteCandidateGroup(taskId, "accounting");
        this.disableAuthorization();
        List linksForTask = this.taskService.getIdentityLinksForTask(taskId);
        this.enableAuthorization();
        Assert.assertNotNull((Object)linksForTask);
        Assert.assertTrue((boolean)linksForTask.isEmpty());
    }

    @Test
    public void testProcessTaskDeleteCandidateGroupWithTaskAssignPermissionOnTask() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        this.addCandidateGroup(taskId, "accounting");
        this.createGrantAuthorization((Resource)Resources.TASK, taskId, this.userId, new Permission[]{Permissions.TASK_ASSIGN});
        this.taskService.deleteCandidateGroup(taskId, "accounting");
        this.disableAuthorization();
        List linksForTask = this.taskService.getIdentityLinksForTask(taskId);
        this.enableAuthorization();
        Assert.assertNotNull((Object)linksForTask);
        Assert.assertTrue((boolean)linksForTask.isEmpty());
    }

    @Test
    public void testProcessTaskDeleteCandidateGroupWithUpdatePersmissionOnAnyTask() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        this.addCandidateGroup(taskId, "accounting");
        this.createGrantAuthorization((Resource)Resources.TASK, "*", this.userId, new Permission[]{Permissions.UPDATE});
        this.taskService.deleteCandidateGroup(taskId, "accounting");
        this.disableAuthorization();
        List linksForTask = this.taskService.getIdentityLinksForTask(taskId);
        this.enableAuthorization();
        Assert.assertNotNull((Object)linksForTask);
        Assert.assertTrue((boolean)linksForTask.isEmpty());
    }

    @Test
    public void testProcessTaskDeleteCandidateGroupWithTaskAssignPersmissionOnAnyTask() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        this.addCandidateGroup(taskId, "accounting");
        this.createGrantAuthorization((Resource)Resources.TASK, "*", this.userId, new Permission[]{Permissions.TASK_ASSIGN});
        this.taskService.deleteCandidateGroup(taskId, "accounting");
        this.disableAuthorization();
        List linksForTask = this.taskService.getIdentityLinksForTask(taskId);
        this.enableAuthorization();
        Assert.assertNotNull((Object)linksForTask);
        Assert.assertTrue((boolean)linksForTask.isEmpty());
    }

    @Test
    public void testProcessTaskDeleteCandidateGroupWithUpdateTasksPersmissionOnProcessDefinition() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        this.addCandidateGroup(taskId, "accounting");
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, PROCESS_KEY, this.userId, new Permission[]{Permissions.UPDATE_TASK});
        this.taskService.deleteCandidateGroup(taskId, "accounting");
        this.disableAuthorization();
        List linksForTask = this.taskService.getIdentityLinksForTask(taskId);
        this.enableAuthorization();
        Assert.assertNotNull((Object)linksForTask);
        Assert.assertTrue((boolean)linksForTask.isEmpty());
    }

    @Test
    public void testProcessTaskDeleteCandidateGroupWithTaskAssignPermissionOnProcessDefinition() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        this.addCandidateGroup(taskId, "accounting");
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, PROCESS_KEY, this.userId, new Permission[]{Permissions.TASK_ASSIGN});
        this.taskService.deleteCandidateGroup(taskId, "accounting");
        this.disableAuthorization();
        List linksForTask = this.taskService.getIdentityLinksForTask(taskId);
        this.enableAuthorization();
        Assert.assertNotNull((Object)linksForTask);
        Assert.assertTrue((boolean)linksForTask.isEmpty());
    }

    @Test
    public void testProcessTaskDeleteCandidateGroup() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        this.addCandidateGroup(taskId, "accounting");
        this.createGrantAuthorization((Resource)Resources.TASK, taskId, this.userId, new Permission[]{Permissions.UPDATE});
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, PROCESS_KEY, this.userId, new Permission[]{Permissions.UPDATE_TASK});
        this.taskService.deleteCandidateGroup(taskId, "accounting");
        this.disableAuthorization();
        List linksForTask = this.taskService.getIdentityLinksForTask(taskId);
        this.enableAuthorization();
        Assert.assertNotNull((Object)linksForTask);
        Assert.assertTrue((boolean)linksForTask.isEmpty());
    }

    @Test
    public void testCaseTaskDeleteCandidateGroup() {
        this.testRule.createCaseInstanceByKey(CASE_KEY);
        String taskId = this.selectSingleTask().getId();
        this.addCandidateGroup(taskId, "accounting");
        this.taskService.deleteCandidateGroup(taskId, "accounting");
        this.disableAuthorization();
        List linksForTask = this.taskService.getIdentityLinksForTask(taskId);
        this.enableAuthorization();
        Assert.assertNotNull((Object)linksForTask);
        Assert.assertTrue((boolean)linksForTask.isEmpty());
    }

    @Test
    public void testStandaloneTaskDeleteUserIdentityLinkWithoutAuthorization() {
        String taskId = "myTask";
        this.createTask(taskId);
        this.addCandidateUser(taskId, "demo");
        try {
            this.taskService.deleteUserIdentityLink(taskId, "demo", "candidate");
            Assert.fail((String)"Exception expected: It should not be possible to delete an user identity link");
        }
        catch (AuthorizationException e) {
            this.testRule.assertTextPresent("The user with id 'test' does not have one of the following permissions: 'TASK_ASSIGN", e.getMessage());
        }
        this.deleteTask(taskId, true);
    }

    @Test
    public void testStandaloneTaskDeleteUserIdentityLink() {
        String taskId = "myTask";
        this.createTask(taskId);
        this.addCandidateUser(taskId, "demo");
        this.createGrantAuthorization((Resource)Resources.TASK, taskId, this.userId, new Permission[]{Permissions.UPDATE});
        this.taskService.deleteUserIdentityLink(taskId, "demo", "candidate");
        this.disableAuthorization();
        List linksForTask = this.taskService.getIdentityLinksForTask(taskId);
        this.enableAuthorization();
        Assert.assertNotNull((Object)linksForTask);
        Assert.assertTrue((boolean)linksForTask.isEmpty());
        this.deleteTask(taskId, true);
    }

    @Test
    public void testStandaloneTaskDeleteUserIdentityLinkWithTaskAssignPermission() {
        String taskId = "myTask";
        this.createTask(taskId);
        this.addCandidateUser(taskId, "demo");
        this.createGrantAuthorization((Resource)Resources.TASK, taskId, this.userId, new Permission[]{Permissions.TASK_ASSIGN});
        this.taskService.deleteUserIdentityLink(taskId, "demo", "candidate");
        this.disableAuthorization();
        List linksForTask = this.taskService.getIdentityLinksForTask(taskId);
        this.enableAuthorization();
        Assert.assertNotNull((Object)linksForTask);
        Assert.assertTrue((boolean)linksForTask.isEmpty());
        this.deleteTask(taskId, true);
    }

    @Test
    public void testProcessTaskDeleteUserIdentityLinkWithoutAuthorization() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        this.addCandidateUser(taskId, "demo");
        try {
            this.taskService.deleteUserIdentityLink(taskId, "demo", "candidate");
            Assert.fail((String)"Exception expected: It should not be possible to delete an user identity link");
        }
        catch (AuthorizationException e) {
            String message = e.getMessage();
            this.testRule.assertTextPresent(this.userId, message);
            this.testRule.assertTextPresent(Permissions.UPDATE.getName(), message);
            this.testRule.assertTextPresent(taskId, message);
            this.testRule.assertTextPresent(Resources.TASK.resourceName(), message);
            this.testRule.assertTextPresent(Permissions.UPDATE_TASK.getName(), message);
            this.testRule.assertTextPresent(Resources.PROCESS_DEFINITION.resourceName(), message);
        }
    }

    @Test
    public void testProcessTaskDeleteUserIdentityLinkWithUpdatePersmissionOnTask() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        this.addCandidateUser(taskId, "demo");
        this.createGrantAuthorization((Resource)Resources.TASK, taskId, this.userId, new Permission[]{Permissions.UPDATE});
        this.taskService.deleteUserIdentityLink(taskId, "demo", "candidate");
        this.disableAuthorization();
        List linksForTask = this.taskService.getIdentityLinksForTask(taskId);
        this.enableAuthorization();
        Assert.assertNotNull((Object)linksForTask);
        Assert.assertTrue((boolean)linksForTask.isEmpty());
    }

    @Test
    public void testProcessTaskDeleteUserIdentityLinkWithTaskAssignPersmissionOnTask() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        this.addCandidateUser(taskId, "demo");
        this.createGrantAuthorization((Resource)Resources.TASK, taskId, this.userId, new Permission[]{Permissions.TASK_ASSIGN});
        this.taskService.deleteUserIdentityLink(taskId, "demo", "candidate");
        this.disableAuthorization();
        List linksForTask = this.taskService.getIdentityLinksForTask(taskId);
        this.enableAuthorization();
        Assert.assertNotNull((Object)linksForTask);
        Assert.assertTrue((boolean)linksForTask.isEmpty());
    }

    @Test
    public void testProcessTaskDeleteUserIdentityLinkWithUpdatePersmissionOnAnyTask() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        this.addCandidateUser(taskId, "demo");
        this.createGrantAuthorization((Resource)Resources.TASK, "*", this.userId, new Permission[]{Permissions.UPDATE});
        this.taskService.deleteUserIdentityLink(taskId, "demo", "candidate");
        this.disableAuthorization();
        List linksForTask = this.taskService.getIdentityLinksForTask(taskId);
        this.enableAuthorization();
        Assert.assertNotNull((Object)linksForTask);
        Assert.assertTrue((boolean)linksForTask.isEmpty());
    }

    @Test
    public void testProcessTaskDeleteUserIdentityLinkWithTaskAssignPersmissionOnAnyTask() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        this.addCandidateUser(taskId, "demo");
        this.createGrantAuthorization((Resource)Resources.TASK, "*", this.userId, new Permission[]{Permissions.TASK_ASSIGN});
        this.taskService.deleteUserIdentityLink(taskId, "demo", "candidate");
        this.disableAuthorization();
        List linksForTask = this.taskService.getIdentityLinksForTask(taskId);
        this.enableAuthorization();
        Assert.assertNotNull((Object)linksForTask);
        Assert.assertTrue((boolean)linksForTask.isEmpty());
    }

    @Test
    public void testProcessTaskDeleteUserIdentityLinkWithUpdateTasksPersmissionOnProcessDefinition() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        this.addCandidateUser(taskId, "demo");
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, PROCESS_KEY, this.userId, new Permission[]{Permissions.UPDATE_TASK});
        this.taskService.deleteUserIdentityLink(taskId, "demo", "candidate");
        this.disableAuthorization();
        List linksForTask = this.taskService.getIdentityLinksForTask(taskId);
        this.enableAuthorization();
        Assert.assertNotNull((Object)linksForTask);
        Assert.assertTrue((boolean)linksForTask.isEmpty());
    }

    @Test
    public void testProcessTaskDeleteUserIdentityLinkWithTaskAssignPersmissionOnProcessDefinition() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        this.addCandidateUser(taskId, "demo");
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, PROCESS_KEY, this.userId, new Permission[]{Permissions.TASK_ASSIGN});
        this.taskService.deleteUserIdentityLink(taskId, "demo", "candidate");
        this.disableAuthorization();
        List linksForTask = this.taskService.getIdentityLinksForTask(taskId);
        this.enableAuthorization();
        Assert.assertNotNull((Object)linksForTask);
        Assert.assertTrue((boolean)linksForTask.isEmpty());
    }

    @Test
    public void testProcessTaskDeleteUserIdentityLink() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        this.addCandidateUser(taskId, "demo");
        this.createGrantAuthorization((Resource)Resources.TASK, taskId, this.userId, new Permission[]{Permissions.UPDATE});
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, PROCESS_KEY, this.userId, new Permission[]{Permissions.UPDATE_TASK});
        this.taskService.deleteUserIdentityLink(taskId, "demo", "candidate");
        this.disableAuthorization();
        List linksForTask = this.taskService.getIdentityLinksForTask(taskId);
        this.enableAuthorization();
        Assert.assertNotNull((Object)linksForTask);
        Assert.assertTrue((boolean)linksForTask.isEmpty());
    }

    @Test
    public void testProcessTaskDeleteUserIdentityLinkWithTaskAssignPermission() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        this.addCandidateUser(taskId, "demo");
        this.createGrantAuthorization((Resource)Resources.TASK, taskId, this.userId, new Permission[]{Permissions.TASK_ASSIGN});
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, PROCESS_KEY, this.userId, new Permission[]{Permissions.TASK_ASSIGN});
        this.taskService.deleteUserIdentityLink(taskId, "demo", "candidate");
        this.disableAuthorization();
        List linksForTask = this.taskService.getIdentityLinksForTask(taskId);
        this.enableAuthorization();
        Assert.assertNotNull((Object)linksForTask);
        Assert.assertTrue((boolean)linksForTask.isEmpty());
    }

    @Test
    public void testCaseTaskDeleteUserIdentityLink() {
        this.testRule.createCaseInstanceByKey(CASE_KEY);
        String taskId = this.selectSingleTask().getId();
        this.addCandidateUser(taskId, "demo");
        this.taskService.deleteUserIdentityLink(taskId, "demo", "candidate");
        this.disableAuthorization();
        List linksForTask = this.taskService.getIdentityLinksForTask(taskId);
        this.enableAuthorization();
        Assert.assertNotNull((Object)linksForTask);
        Assert.assertTrue((boolean)linksForTask.isEmpty());
    }

    @Test
    public void testStandaloneTaskDeleteGroupIdentityLinkWithoutAuthorization() {
        String taskId = "myTask";
        this.createTask(taskId);
        this.addCandidateGroup(taskId, "accounting");
        try {
            this.taskService.deleteGroupIdentityLink(taskId, "accounting", "candidate");
            Assert.fail((String)"Exception expected: It should not be possible to delete a group identity link");
        }
        catch (AuthorizationException e) {
            this.testRule.assertTextPresent("The user with id 'test' does not have one of the following permissions: 'TASK_ASSIGN", e.getMessage());
        }
        this.deleteTask(taskId, true);
    }

    @Test
    public void testStandaloneTaskDeleteGroupIdentityLink() {
        String taskId = "myTask";
        this.createTask(taskId);
        this.addCandidateGroup(taskId, "accounting");
        this.createGrantAuthorization((Resource)Resources.TASK, taskId, this.userId, new Permission[]{Permissions.UPDATE});
        this.taskService.deleteGroupIdentityLink(taskId, "accounting", "candidate");
        this.disableAuthorization();
        List linksForTask = this.taskService.getIdentityLinksForTask(taskId);
        this.enableAuthorization();
        Assert.assertNotNull((Object)linksForTask);
        Assert.assertTrue((boolean)linksForTask.isEmpty());
        this.deleteTask(taskId, true);
    }

    @Test
    public void testProcessTaskDeleteGroupIdentityLinkWithoutAuthorization() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        this.addCandidateGroup(taskId, "accounting");
        try {
            this.taskService.deleteGroupIdentityLink(taskId, "accounting", "candidate");
            Assert.fail((String)"Exception expected: It should not be possible to delete a group identity link");
        }
        catch (AuthorizationException e) {
            String message = e.getMessage();
            this.testRule.assertTextPresent(this.userId, message);
            this.testRule.assertTextPresent(Permissions.UPDATE.getName(), message);
            this.testRule.assertTextPresent(taskId, message);
            this.testRule.assertTextPresent(Resources.TASK.resourceName(), message);
            this.testRule.assertTextPresent(Permissions.UPDATE_TASK.getName(), message);
            this.testRule.assertTextPresent(Resources.PROCESS_DEFINITION.resourceName(), message);
        }
    }

    @Test
    public void testProcessTaskDeleteGroupIdentityLinkWithUpdatePersmissionOnTask() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        this.addCandidateGroup(taskId, "accounting");
        this.createGrantAuthorization((Resource)Resources.TASK, taskId, this.userId, new Permission[]{Permissions.UPDATE});
        this.taskService.deleteGroupIdentityLink(taskId, "accounting", "candidate");
        this.disableAuthorization();
        List linksForTask = this.taskService.getIdentityLinksForTask(taskId);
        this.enableAuthorization();
        Assert.assertNotNull((Object)linksForTask);
        Assert.assertTrue((boolean)linksForTask.isEmpty());
    }

    @Test
    public void testProcessTaskDeleteGroupIdentityLinkWithUpdatePersmissionOnAnyTask() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        this.addCandidateGroup(taskId, "accounting");
        this.createGrantAuthorization((Resource)Resources.TASK, "*", this.userId, new Permission[]{Permissions.UPDATE});
        this.taskService.deleteGroupIdentityLink(taskId, "accounting", "candidate");
        this.disableAuthorization();
        List linksForTask = this.taskService.getIdentityLinksForTask(taskId);
        this.enableAuthorization();
        Assert.assertNotNull((Object)linksForTask);
        Assert.assertTrue((boolean)linksForTask.isEmpty());
    }

    @Test
    public void testProcessTaskDeleteGroupIdentityLinkWithUpdateTasksPersmissionOnProcessDefinition() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        this.addCandidateGroup(taskId, "accounting");
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, PROCESS_KEY, this.userId, new Permission[]{Permissions.UPDATE_TASK});
        this.taskService.deleteGroupIdentityLink(taskId, "accounting", "candidate");
        this.disableAuthorization();
        List linksForTask = this.taskService.getIdentityLinksForTask(taskId);
        this.enableAuthorization();
        Assert.assertNotNull((Object)linksForTask);
        Assert.assertTrue((boolean)linksForTask.isEmpty());
    }

    @Test
    public void testProcessTaskDeleteGroupIdentityLink() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        this.addCandidateGroup(taskId, "accounting");
        this.createGrantAuthorization((Resource)Resources.TASK, taskId, this.userId, new Permission[]{Permissions.UPDATE});
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, PROCESS_KEY, this.userId, new Permission[]{Permissions.UPDATE_TASK});
        this.taskService.deleteGroupIdentityLink(taskId, "accounting", "candidate");
        this.disableAuthorization();
        List linksForTask = this.taskService.getIdentityLinksForTask(taskId);
        this.enableAuthorization();
        Assert.assertNotNull((Object)linksForTask);
        Assert.assertTrue((boolean)linksForTask.isEmpty());
    }

    @Test
    public void testCaseTaskDeleteGroupIdentityLink() {
        this.testRule.createCaseInstanceByKey(CASE_KEY);
        String taskId = this.selectSingleTask().getId();
        this.addCandidateGroup(taskId, "accounting");
        this.taskService.deleteGroupIdentityLink(taskId, "accounting", "candidate");
        this.disableAuthorization();
        List linksForTask = this.taskService.getIdentityLinksForTask(taskId);
        this.enableAuthorization();
        Assert.assertNotNull((Object)linksForTask);
        Assert.assertTrue((boolean)linksForTask.isEmpty());
    }

    @Test
    public void testStandaloneTaskGetIdentityLinksWithoutAuthorization() {
        String taskId = "myTask";
        this.createTask(taskId);
        this.addCandidateUser(taskId, "demo");
        try {
            this.taskService.getIdentityLinksForTask(taskId);
            Assert.fail((String)"Exception expected: It should not be possible to get identity links");
        }
        catch (AuthorizationException e) {
            this.testRule.assertTextPresent("The user with id 'test' does not have 'READ' permission on resource 'myTask' of type 'Task'", e.getMessage());
        }
        this.deleteTask(taskId, true);
    }

    @Test
    public void testStandaloneTaskGetIdentityLinks() {
        String taskId = "myTask";
        this.createTask(taskId);
        this.addCandidateUser(taskId, "demo");
        this.createGrantAuthorization((Resource)Resources.TASK, taskId, this.userId, new Permission[]{Permissions.READ});
        List identityLinksForTask = this.taskService.getIdentityLinksForTask(taskId);
        Assert.assertNotNull((Object)identityLinksForTask);
        Assert.assertFalse((boolean)identityLinksForTask.isEmpty());
        this.deleteTask(taskId, true);
    }

    @Test
    public void testProcessTaskGetIdentityLinksWithoutAuthorization() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        this.addCandidateUser(taskId, "demo");
        try {
            this.taskService.getIdentityLinksForTask(taskId);
            Assert.fail((String)"Exception expected: It should not be possible to get the identity links");
        }
        catch (AuthorizationException e) {
            String message = e.getMessage();
            this.testRule.assertTextPresent(this.userId, message);
            this.testRule.assertTextPresent(Permissions.READ.getName(), message);
            this.testRule.assertTextPresent(taskId, message);
            this.testRule.assertTextPresent(Resources.TASK.resourceName(), message);
            this.testRule.assertTextPresent(Permissions.READ_TASK.getName(), message);
            this.testRule.assertTextPresent(Resources.PROCESS_DEFINITION.resourceName(), message);
        }
    }

    @Test
    public void testProcessTaskGetIdentityLinksWithReadPersmissionOnTask() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        this.addCandidateUser(taskId, "demo");
        this.createGrantAuthorization((Resource)Resources.TASK, taskId, this.userId, new Permission[]{Permissions.READ});
        List identityLinksForTask = this.taskService.getIdentityLinksForTask(taskId);
        Assert.assertNotNull((Object)identityLinksForTask);
        Assert.assertFalse((boolean)identityLinksForTask.isEmpty());
    }

    @Test
    public void testProcessTaskGetIdentityLinksWithReadPersmissionOnAnyTask() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        this.addCandidateUser(taskId, "demo");
        this.createGrantAuthorization((Resource)Resources.TASK, "*", this.userId, new Permission[]{Permissions.READ});
        List identityLinksForTask = this.taskService.getIdentityLinksForTask(taskId);
        Assert.assertNotNull((Object)identityLinksForTask);
        Assert.assertFalse((boolean)identityLinksForTask.isEmpty());
    }

    @Test
    public void testProcessTaskGetIdentityLinksWithReadTasksPersmissionOnProcessDefinition() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        this.addCandidateUser(taskId, "demo");
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, PROCESS_KEY, this.userId, new Permission[]{Permissions.READ_TASK});
        List identityLinksForTask = this.taskService.getIdentityLinksForTask(taskId);
        Assert.assertNotNull((Object)identityLinksForTask);
        Assert.assertFalse((boolean)identityLinksForTask.isEmpty());
    }

    @Test
    public void testProcessTaskGetIdentityLinks() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        this.addCandidateUser(taskId, "demo");
        this.createGrantAuthorization((Resource)Resources.TASK, taskId, this.userId, new Permission[]{Permissions.READ});
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, PROCESS_KEY, this.userId, new Permission[]{Permissions.READ_TASK});
        List identityLinksForTask = this.taskService.getIdentityLinksForTask(taskId);
        Assert.assertNotNull((Object)identityLinksForTask);
        Assert.assertFalse((boolean)identityLinksForTask.isEmpty());
    }

    @Test
    public void testCaseTaskGetIdentityLinks() {
        this.testRule.createCaseInstanceByKey(CASE_KEY);
        String taskId = this.selectSingleTask().getId();
        this.addCandidateUser(taskId, "demo");
        List identityLinksForTask = this.taskService.getIdentityLinksForTask(taskId);
        Assert.assertNotNull((Object)identityLinksForTask);
        Assert.assertFalse((boolean)identityLinksForTask.isEmpty());
    }

    @Test
    public void testStandaloneTaskClaimTaskWithoutAuthorization() {
        String taskId = "myTask";
        this.createTask(taskId);
        try {
            this.taskService.claim(taskId, "demo");
            Assert.fail((String)"Exception expected: It should not be possible to claim the task.");
        }
        catch (AuthorizationException e) {
            this.testRule.assertTextPresent("The user with id 'test' does not have one of the following permissions:", e.getMessage());
        }
        this.deleteTask(taskId, true);
    }

    @Test
    public void testStandaloneTaskClaimTask() {
        String taskId = "myTask";
        this.createTask(taskId);
        this.createGrantAuthorization((Resource)Resources.TASK, taskId, this.userId, new Permission[]{Permissions.UPDATE});
        this.taskService.claim(taskId, "demo");
        Task task = this.selectSingleTask();
        Assert.assertNotNull((Object)task);
        Assert.assertEquals((Object)"demo", (Object)task.getAssignee());
        this.deleteTask(taskId, true);
    }

    @Test
    public void testStandaloneTaskClaimTaskWithTaskWorkPermission() {
        String taskId = "myTask";
        this.createTask(taskId);
        this.createGrantAuthorization((Resource)Resources.TASK, taskId, this.userId, new Permission[]{Permissions.TASK_WORK});
        this.taskService.claim(taskId, "demo");
        Task task = this.selectSingleTask();
        Assert.assertNotNull((Object)task);
        Assert.assertEquals((Object)"demo", (Object)task.getAssignee());
        this.deleteTask(taskId, true);
    }

    @Test
    public void testStandaloneTaskClaimTaskWithRevokeTaskWorkPermission() {
        String taskId = "myTask";
        this.createTask(taskId);
        this.createRevokeAuthorization((Resource)Resources.TASK, taskId, this.userId, new Permission[]{Permissions.TASK_WORK});
        this.createGrantAuthorization((Resource)Resources.TASK, taskId, this.userId, new Permission[]{Permissions.UPDATE});
        try {
            this.taskService.claim(taskId, "demo");
            Assert.fail((String)"Exception expected: It should not be possible to complete a task");
        }
        catch (AuthorizationException e) {
            this.testRule.assertTextPresent("The user with id 'test' does not have one of the following permissions: 'TASK_WORK", e.getMessage());
        }
        this.deleteTask(taskId, true);
    }

    @Test
    public void testProcessTaskClaimTaskWithoutAuthorization() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        try {
            this.taskService.claim(taskId, "demo");
            Assert.fail((String)"Exception expected: It should not be possible to claim the task");
        }
        catch (AuthorizationException e) {
            String message = e.getMessage();
            this.testRule.assertTextPresent(this.userId, message);
            this.testRule.assertTextPresent(Permissions.UPDATE.getName(), message);
            this.testRule.assertTextPresent(taskId, message);
            this.testRule.assertTextPresent(Resources.TASK.resourceName(), message);
            this.testRule.assertTextPresent(Permissions.UPDATE_TASK.getName(), message);
            this.testRule.assertTextPresent(Resources.PROCESS_DEFINITION.resourceName(), message);
        }
    }

    @Test
    public void testProcessTaskClaimTaskWithUpdatePermissionOnTask() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        this.createGrantAuthorization((Resource)Resources.TASK, taskId, this.userId, new Permission[]{Permissions.UPDATE});
        this.taskService.claim(taskId, "demo");
        Task task = this.selectSingleTask();
        Assert.assertNotNull((Object)task);
        Assert.assertEquals((Object)"demo", (Object)task.getAssignee());
    }

    @Test
    public void testProcessTaskClaimTaskWithTaskWorkPermissionOnTask() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        this.createGrantAuthorization((Resource)Resources.TASK, taskId, this.userId, new Permission[]{Permissions.TASK_WORK});
        this.taskService.claim(taskId, "demo");
        Task task = this.selectSingleTask();
        Assert.assertNotNull((Object)task);
        Assert.assertEquals((Object)"demo", (Object)task.getAssignee());
    }

    @Test
    public void testProcessTaskClaimTaskWithGrantTaskWorkAndRevokeUpdatePermissionsOnTask() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        this.createGrantAuthorization((Resource)Resources.TASK, taskId, this.userId, new Permission[]{Permissions.TASK_WORK});
        this.createRevokeAuthorization((Resource)Resources.TASK, taskId, this.userId, new Permission[]{Permissions.UPDATE});
        this.taskService.claim(taskId, "demo");
        Task task = this.selectSingleTask();
        Assert.assertNotNull((Object)task);
        Assert.assertEquals((Object)"demo", (Object)task.getAssignee());
    }

    @Test
    public void testProcessTaskClaimTaskWithRevokeTaskWorkPermissionOnTask() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        this.createRevokeAuthorization((Resource)Resources.TASK, taskId, this.userId, new Permission[]{Permissions.TASK_WORK});
        this.createGrantAuthorization((Resource)Resources.TASK, taskId, this.userId, new Permission[]{Permissions.UPDATE});
        try {
            this.taskService.complete(taskId);
            Assert.fail((String)"Exception expected: It should not be possible to complete a task");
        }
        catch (AuthorizationException e) {
            this.testRule.assertTextPresent("The user with id 'test' does not have one of the following permissions: 'TASK_WORK", e.getMessage());
        }
    }

    @Test
    public void testProcessTaskClaimTaskWithUpdatePermissionOnAnyTask() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        this.createGrantAuthorization((Resource)Resources.TASK, "*", this.userId, new Permission[]{Permissions.UPDATE});
        this.taskService.claim(taskId, "demo");
        Task task = this.selectSingleTask();
        Assert.assertNotNull((Object)task);
        Assert.assertEquals((Object)"demo", (Object)task.getAssignee());
    }

    @Test
    public void testProcessTaskClaimTaskWithTaskWorkPermissionOnAnyTask() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        this.createGrantAuthorization((Resource)Resources.TASK, taskId, this.userId, new Permission[]{Permissions.TASK_WORK});
        this.taskService.claim(taskId, "demo");
        Task task = this.selectSingleTask();
        Assert.assertNotNull((Object)task);
        Assert.assertEquals((Object)"demo", (Object)task.getAssignee());
    }

    @Test
    public void testProcessTaskClaimTaskWithUpdateTasksPermissionOnProcessDefinition() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, PROCESS_KEY, this.userId, new Permission[]{Permissions.UPDATE_TASK});
        this.taskService.claim(taskId, "demo");
        Task task = this.selectSingleTask();
        Assert.assertNotNull((Object)task);
        Assert.assertEquals((Object)"demo", (Object)task.getAssignee());
    }

    @Test
    public void testProcessTaskClaimTaskWithTaskWorkPermissionOnProcessDefinition() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, PROCESS_KEY, this.userId, new Permission[]{Permissions.TASK_WORK});
        this.taskService.claim(taskId, "demo");
        Task task = this.selectSingleTask();
        Assert.assertNotNull((Object)task);
        Assert.assertEquals((Object)"demo", (Object)task.getAssignee());
    }

    @Test
    public void testProcessTaskClaimTaskWithRevokeTaskWorkPermissionOnProcessDefinition() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        this.createRevokeAuthorization((Resource)Resources.PROCESS_DEFINITION, PROCESS_KEY, this.userId, new Permission[]{Permissions.TASK_WORK});
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, PROCESS_KEY, this.userId, new Permission[]{Permissions.UPDATE_TASK});
        try {
            this.taskService.complete(taskId);
            Assert.fail((String)"Exception expected: It should not be possible to complete a task");
        }
        catch (AuthorizationException e) {
            this.testRule.assertTextPresent("The user with id 'test' does not have one of the following permissions: 'TASK_WORK", e.getMessage());
        }
    }

    @Test
    public void testProcessTaskClaimTask() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        this.createGrantAuthorization((Resource)Resources.TASK, taskId, this.userId, new Permission[]{Permissions.UPDATE});
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, PROCESS_KEY, this.userId, new Permission[]{Permissions.UPDATE_TASK});
        this.taskService.claim(taskId, "demo");
        Task task = this.selectSingleTask();
        Assert.assertNotNull((Object)task);
        Assert.assertEquals((Object)"demo", (Object)task.getAssignee());
    }

    @Test
    public void testCaseTaskClaimTask() {
        this.testRule.createCaseInstanceByKey(CASE_KEY);
        String taskId = this.selectSingleTask().getId();
        this.taskService.claim(taskId, "demo");
        Task task = this.selectSingleTask();
        Assert.assertNotNull((Object)task);
        Assert.assertEquals((Object)"demo", (Object)task.getAssignee());
    }

    @Test
    public void testStandaloneTaskCompleteTaskWithoutAuthorization() {
        String taskId = "myTask";
        this.createTask(taskId);
        try {
            this.taskService.complete(taskId);
            Assert.fail((String)"Exception expected: It should not be possible to complete a task");
        }
        catch (AuthorizationException e) {
            this.testRule.assertTextPresent("The user with id 'test' does not have one of the following permissions: 'TASK_WORK", e.getMessage());
        }
        this.deleteTask(taskId, true);
    }

    @Test
    public void testStandaloneTaskCompleteTask() {
        String taskId = "myTask";
        this.createTask(taskId);
        this.createGrantAuthorization((Resource)Resources.TASK, taskId, this.userId, new Permission[]{Permissions.UPDATE});
        this.taskService.complete(taskId);
        Task task = this.selectSingleTask();
        Assert.assertNull((Object)task);
        if (!this.processEngineConfiguration.getHistoryLevel().equals(HistoryLevel.HISTORY_LEVEL_NONE)) {
            this.historyService.deleteHistoricTaskInstance(taskId);
        }
    }

    @Test
    public void testStandaloneTaskCompleteWithTaskWorkPermission() {
        String taskId = "myTask";
        this.createTask(taskId);
        this.createGrantAuthorization((Resource)Resources.TASK, taskId, this.userId, new Permission[]{Permissions.TASK_WORK});
        this.taskService.complete(taskId);
        Task task = this.selectSingleTask();
        Assert.assertNull((Object)task);
        if (!this.processEngineConfiguration.getHistoryLevel().equals(HistoryLevel.HISTORY_LEVEL_NONE)) {
            this.historyService.deleteHistoricTaskInstance(taskId);
        }
    }

    @Test
    public void testProcessTaskCompleteTaskWithoutAuthorization() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        try {
            this.taskService.complete(taskId);
            Assert.fail((String)"Exception expected: It should not be possible to complete a task");
        }
        catch (AuthorizationException e) {
            String message = e.getMessage();
            this.testRule.assertTextPresent(this.userId, message);
            this.testRule.assertTextPresent(Permissions.UPDATE.getName(), message);
            this.testRule.assertTextPresent(taskId, message);
            this.testRule.assertTextPresent(Resources.TASK.resourceName(), message);
            this.testRule.assertTextPresent(Permissions.UPDATE_TASK.getName(), message);
            this.testRule.assertTextPresent(Resources.PROCESS_DEFINITION.resourceName(), message);
        }
    }

    @Test
    public void testProcessTaskCompleteTaskWithUpdatePermissionOnTask() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        this.createGrantAuthorization((Resource)Resources.TASK, taskId, this.userId, new Permission[]{Permissions.UPDATE});
        this.taskService.complete(taskId);
        Task task = this.selectSingleTask();
        Assert.assertNull((Object)task);
    }

    @Test
    public void testProcessTaskCompleteTaskWithTaskWorkPermissionOnTask() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        this.createGrantAuthorization((Resource)Resources.TASK, taskId, this.userId, new Permission[]{Permissions.TASK_WORK});
        this.taskService.complete(taskId);
        Task task = this.selectSingleTask();
        Assert.assertNull((Object)task);
    }

    @Test
    public void testProcessTaskCompleteTaskWithUpdatePermissionOnAnyTask() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        this.createGrantAuthorization((Resource)Resources.TASK, "*", this.userId, new Permission[]{Permissions.UPDATE});
        this.taskService.complete(taskId);
        Task task = this.selectSingleTask();
        Assert.assertNull((Object)task);
    }

    @Test
    public void testProcessTaskCompleteTaskWithUpdateTasksPermissionOnProcessDefinition() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, PROCESS_KEY, this.userId, new Permission[]{Permissions.UPDATE_TASK});
        this.taskService.complete(taskId);
        Task task = this.selectSingleTask();
        Assert.assertNull((Object)task);
    }

    @Test
    public void testProcessTaskCompleteTaskWithTaskWorkPermissionOnProcessDefinition() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, PROCESS_KEY, this.userId, new Permission[]{Permissions.TASK_WORK});
        this.taskService.complete(taskId);
        Task task = this.selectSingleTask();
        Assert.assertNull((Object)task);
    }

    @Test
    public void testProcessTaskCompleteTask() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        this.createGrantAuthorization((Resource)Resources.TASK, taskId, this.userId, new Permission[]{Permissions.UPDATE});
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, PROCESS_KEY, this.userId, new Permission[]{Permissions.UPDATE_TASK});
        this.taskService.complete(taskId);
        Task task = this.selectSingleTask();
        Assert.assertNull((Object)task);
    }

    @Test
    public void testCaseTaskCompleteTask() {
        this.testRule.createCaseInstanceByKey(CASE_KEY);
        String taskId = this.selectSingleTask().getId();
        this.taskService.complete(taskId);
        Task task = this.selectSingleTask();
        Assert.assertNull((Object)task);
    }

    @Test
    public void testStandaloneTaskDelegateTaskWithoutAuthorization() {
        String taskId = "myTask";
        this.createTask(taskId);
        try {
            this.taskService.delegateTask(taskId, "demo");
            Assert.fail((String)"Exception expected: It should not be possible to delegate a task");
        }
        catch (AuthorizationException e) {
            this.testRule.assertTextPresent("The user with id 'test' does not have one of the following permissions: 'TASK_ASSIGN", e.getMessage());
        }
        this.deleteTask(taskId, true);
    }

    @Test
    public void testStandaloneTaskDelegateTask() {
        String taskId = "myTask";
        this.createTask(taskId);
        this.createGrantAuthorization((Resource)Resources.TASK, taskId, this.userId, new Permission[]{Permissions.UPDATE});
        this.taskService.delegateTask(taskId, "demo");
        Task task = this.selectSingleTask();
        Assert.assertNotNull((Object)task);
        Assert.assertEquals((Object)"demo", (Object)task.getAssignee());
        this.deleteTask(taskId, true);
    }

    @Test
    public void testStandaloneTaskDelegateTaskWithTaskAssignPermission() {
        String taskId = "myTask";
        this.createTask(taskId);
        this.createGrantAuthorization((Resource)Resources.TASK, taskId, this.userId, new Permission[]{Permissions.TASK_ASSIGN});
        this.taskService.delegateTask(taskId, "demo");
        Task task = this.selectSingleTask();
        Assert.assertNotNull((Object)task);
        Assert.assertEquals((Object)"demo", (Object)task.getAssignee());
        this.deleteTask(taskId, true);
    }

    @Test
    public void testProcessTaskDelegateTaskWithoutAuthorization() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        try {
            this.taskService.delegateTask(taskId, "demo");
            Assert.fail((String)"Exception expected: It should not be possible to delegate a task");
        }
        catch (AuthorizationException e) {
            String message = e.getMessage();
            this.testRule.assertTextPresent(this.userId, message);
            this.testRule.assertTextPresent(Permissions.UPDATE.getName(), message);
            this.testRule.assertTextPresent(taskId, message);
            this.testRule.assertTextPresent(Resources.TASK.resourceName(), message);
            this.testRule.assertTextPresent(Permissions.UPDATE_TASK.getName(), message);
            this.testRule.assertTextPresent(Resources.PROCESS_DEFINITION.resourceName(), message);
        }
    }

    @Test
    public void testProcessTaskDelegateTaskWithUpdatePermissionOnTask() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        this.createGrantAuthorization((Resource)Resources.TASK, taskId, this.userId, new Permission[]{Permissions.UPDATE});
        this.taskService.delegateTask(taskId, "demo");
        Task task = this.selectSingleTask();
        Assert.assertNotNull((Object)task);
        Assert.assertEquals((Object)"demo", (Object)task.getAssignee());
    }

    @Test
    public void testProcessTaskDelegateTaskWithTaskAssignPermissionOnTask() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        this.createGrantAuthorization((Resource)Resources.TASK, taskId, this.userId, new Permission[]{Permissions.TASK_ASSIGN});
        this.taskService.delegateTask(taskId, "demo");
        Task task = this.selectSingleTask();
        Assert.assertNotNull((Object)task);
        Assert.assertEquals((Object)"demo", (Object)task.getAssignee());
    }

    @Test
    public void testProcessTaskDelegateTaskWithUpdatePermissionOnAnyTask() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        this.createGrantAuthorization((Resource)Resources.TASK, "*", this.userId, new Permission[]{Permissions.UPDATE});
        this.taskService.delegateTask(taskId, "demo");
        Task task = this.selectSingleTask();
        Assert.assertNotNull((Object)task);
        Assert.assertEquals((Object)"demo", (Object)task.getAssignee());
    }

    @Test
    public void testProcessTaskDelegateTaskWithTaskAssignPermissionOnAnyTask() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        this.createGrantAuthorization((Resource)Resources.TASK, "*", this.userId, new Permission[]{Permissions.TASK_ASSIGN});
        this.taskService.delegateTask(taskId, "demo");
        Task task = this.selectSingleTask();
        Assert.assertNotNull((Object)task);
        Assert.assertEquals((Object)"demo", (Object)task.getAssignee());
    }

    @Test
    public void testProcessTaskDelegateTaskWithUpdateTasksPermissionOnProcessDefinition() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, PROCESS_KEY, this.userId, new Permission[]{Permissions.UPDATE_TASK});
        this.taskService.delegateTask(taskId, "demo");
        Task task = this.selectSingleTask();
        Assert.assertNotNull((Object)task);
        Assert.assertEquals((Object)"demo", (Object)task.getAssignee());
    }

    @Test
    public void testProcessTaskDelegateTaskWithTaskAssignPermissionOnProcessDefinition() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, PROCESS_KEY, this.userId, new Permission[]{Permissions.TASK_ASSIGN});
        this.taskService.delegateTask(taskId, "demo");
        Task task = this.selectSingleTask();
        Assert.assertNotNull((Object)task);
        Assert.assertEquals((Object)"demo", (Object)task.getAssignee());
    }

    @Test
    public void testProcessTaskDelegateTask() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        this.createGrantAuthorization((Resource)Resources.TASK, taskId, this.userId, new Permission[]{Permissions.UPDATE});
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, PROCESS_KEY, this.userId, new Permission[]{Permissions.UPDATE_TASK});
        this.taskService.delegateTask(taskId, "demo");
        Task task = this.selectSingleTask();
        Assert.assertNotNull((Object)task);
        Assert.assertEquals((Object)"demo", (Object)task.getAssignee());
    }

    @Test
    public void testProcessTaskDelegateTaskWithTaskAssignPermission() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        this.createGrantAuthorization((Resource)Resources.TASK, taskId, this.userId, new Permission[]{Permissions.TASK_ASSIGN});
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, PROCESS_KEY, this.userId, new Permission[]{Permissions.TASK_ASSIGN});
        this.taskService.delegateTask(taskId, "demo");
        Task task = this.selectSingleTask();
        Assert.assertNotNull((Object)task);
        Assert.assertEquals((Object)"demo", (Object)task.getAssignee());
    }

    @Test
    public void testCaseTaskDelegateTask() {
        this.testRule.createCaseInstanceByKey(CASE_KEY);
        String taskId = this.selectSingleTask().getId();
        this.taskService.delegateTask(taskId, "demo");
        Task task = this.selectSingleTask();
        Assert.assertNotNull((Object)task);
        Assert.assertEquals((Object)"demo", (Object)task.getAssignee());
    }

    @Test
    public void testStandaloneTaskResolveTaskWithoutAuthorization() {
        String taskId = "myTask";
        this.createTask(taskId);
        try {
            this.taskService.resolveTask(taskId);
            Assert.fail((String)"Exception expected: It should not be possible to resolve a task");
        }
        catch (AuthorizationException e) {
            this.testRule.assertTextPresent("The user with id 'test' does not have one of the following permissions: 'TASK_WORK", e.getMessage());
        }
        this.deleteTask(taskId, true);
    }

    @Test
    public void testStandaloneTaskResolveTask() {
        String taskId = "myTask";
        this.createTask(taskId);
        this.setAssignee(taskId, this.userId);
        this.delegateTask(taskId, "demo");
        this.createGrantAuthorization((Resource)Resources.TASK, taskId, this.userId, new Permission[]{Permissions.UPDATE});
        this.taskService.resolveTask(taskId);
        Task task = this.selectSingleTask();
        Assert.assertNotNull((Object)task);
        Assert.assertEquals((Object)this.userId, (Object)task.getAssignee());
        this.deleteTask(taskId, true);
    }

    @Test
    public void testProcessTaskResolveTaskWithoutAuthorization() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        try {
            this.taskService.resolveTask(taskId);
            Assert.fail((String)"Exception expected: It should not be possible to resolve a task");
        }
        catch (AuthorizationException e) {
            String message = e.getMessage();
            this.testRule.assertTextPresent(this.userId, message);
            this.testRule.assertTextPresent(Permissions.UPDATE.getName(), message);
            this.testRule.assertTextPresent(taskId, message);
            this.testRule.assertTextPresent(Resources.TASK.resourceName(), message);
            this.testRule.assertTextPresent(Permissions.UPDATE_TASK.getName(), message);
            this.testRule.assertTextPresent(Resources.PROCESS_DEFINITION.resourceName(), message);
        }
    }

    @Test
    public void testProcessTaskResolveTaskWithUpdatePermissionOnTask() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        this.setAssignee(taskId, this.userId);
        this.delegateTask(taskId, "demo");
        this.createGrantAuthorization((Resource)Resources.TASK, taskId, this.userId, new Permission[]{Permissions.UPDATE});
        this.taskService.resolveTask(taskId);
        Task task = this.selectSingleTask();
        Assert.assertNotNull((Object)task);
        Assert.assertEquals((Object)this.userId, (Object)task.getAssignee());
    }

    @Test
    public void testProcessTaskResolveTaskWithUpdatePermissionOnAnyTask() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        this.setAssignee(taskId, this.userId);
        this.delegateTask(taskId, "demo");
        this.createGrantAuthorization((Resource)Resources.TASK, "*", this.userId, new Permission[]{Permissions.UPDATE});
        this.taskService.resolveTask(taskId);
        Task task = this.selectSingleTask();
        Assert.assertNotNull((Object)task);
        Assert.assertEquals((Object)this.userId, (Object)task.getAssignee());
    }

    @Test
    public void testProcessTaskResolveTaskWithUpdateTasksPermissionOnProcessDefinition() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        this.setAssignee(taskId, this.userId);
        this.delegateTask(taskId, "demo");
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, PROCESS_KEY, this.userId, new Permission[]{Permissions.UPDATE_TASK});
        this.taskService.resolveTask(taskId);
        Task task = this.selectSingleTask();
        Assert.assertNotNull((Object)task);
        Assert.assertEquals((Object)this.userId, (Object)task.getAssignee());
    }

    @Test
    public void testProcessTaskResolveTask() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        this.setAssignee(taskId, this.userId);
        this.delegateTask(taskId, "demo");
        this.createGrantAuthorization((Resource)Resources.TASK, taskId, this.userId, new Permission[]{Permissions.UPDATE});
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, PROCESS_KEY, this.userId, new Permission[]{Permissions.UPDATE_TASK});
        this.taskService.resolveTask(taskId);
        Task task = this.selectSingleTask();
        Assert.assertNotNull((Object)task);
        Assert.assertEquals((Object)this.userId, (Object)task.getAssignee());
    }

    @Test
    public void testCaseTaskResolveTask() {
        this.testRule.createCaseInstanceByKey(CASE_KEY);
        String taskId = this.selectSingleTask().getId();
        this.setAssignee(taskId, this.userId);
        this.delegateTask(taskId, "demo");
        this.taskService.resolveTask(taskId);
        Task task = this.selectSingleTask();
        Assert.assertNotNull((Object)task);
        Assert.assertEquals((Object)this.userId, (Object)task.getAssignee());
    }

    @Test
    public void testStandaloneTaskSetPriorityWithoutAuthorization() {
        String taskId = "myTask";
        this.createTask(taskId);
        try {
            this.taskService.setPriority(taskId, 80);
            Assert.fail((String)"Exception expected: It should not be possible to set a priority");
        }
        catch (AuthorizationException e) {
            this.testRule.assertTextPresent("The user with id 'test' does not have one of the following permissions: 'TASK_ASSIGN'", e.getMessage());
        }
        this.deleteTask(taskId, true);
    }

    @Test
    public void testStandaloneTaskSetPriority() {
        String taskId = "myTask";
        this.createTask(taskId);
        this.createGrantAuthorization((Resource)Resources.TASK, taskId, this.userId, new Permission[]{Permissions.UPDATE});
        this.taskService.setPriority(taskId, 80);
        Task task = this.selectSingleTask();
        Assert.assertNotNull((Object)task);
        Assert.assertEquals((long)80L, (long)task.getPriority());
        this.deleteTask(taskId, true);
    }

    @Test
    public void testStandaloneTaskSetPriorityWithTaskAssignPermission() {
        String taskId = "myTask";
        this.createTask(taskId);
        this.createGrantAuthorization((Resource)Resources.TASK, taskId, this.userId, new Permission[]{Permissions.TASK_ASSIGN});
        this.taskService.setPriority(taskId, 80);
        Task task = this.selectSingleTask();
        Assert.assertNotNull((Object)task);
        Assert.assertEquals((long)80L, (long)task.getPriority());
        this.deleteTask(taskId, true);
    }

    @Test
    public void testProcessTaskSetPriorityWithoutAuthorization() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        try {
            this.taskService.setPriority(taskId, 80);
            Assert.fail((String)"Exception expected: It should not be possible to set a priority");
        }
        catch (AuthorizationException e) {
            String message = e.getMessage();
            this.testRule.assertTextPresent(this.userId, message);
            this.testRule.assertTextPresent(Permissions.UPDATE.getName(), message);
            this.testRule.assertTextPresent(taskId, message);
            this.testRule.assertTextPresent(Resources.TASK.resourceName(), message);
            this.testRule.assertTextPresent(Permissions.UPDATE_TASK.getName(), message);
            this.testRule.assertTextPresent(Resources.PROCESS_DEFINITION.resourceName(), message);
        }
    }

    @Test
    public void testProcessTaskSetPriorityWithUpdatePersmissionOnTask() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        this.createGrantAuthorization((Resource)Resources.TASK, taskId, this.userId, new Permission[]{Permissions.UPDATE});
        this.taskService.setPriority(taskId, 80);
        Task task = this.selectSingleTask();
        Assert.assertNotNull((Object)task);
        Assert.assertEquals((long)80L, (long)task.getPriority());
    }

    @Test
    public void testProcessTaskSetPriorityWithTaskAssignPermissionOnTask() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        this.createGrantAuthorization((Resource)Resources.TASK, taskId, this.userId, new Permission[]{Permissions.TASK_ASSIGN});
        this.taskService.setPriority(taskId, 80);
        Task task = this.selectSingleTask();
        Assert.assertNotNull((Object)task);
        Assert.assertEquals((long)80L, (long)task.getPriority());
    }

    @Test
    public void testProcessTaskSetPriorityWithUpdatePersmissionOnAnyTask() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        this.createGrantAuthorization((Resource)Resources.TASK, "*", this.userId, new Permission[]{Permissions.UPDATE});
        this.taskService.setPriority(taskId, 80);
        Task task = this.selectSingleTask();
        Assert.assertNotNull((Object)task);
        Assert.assertEquals((long)80L, (long)task.getPriority());
    }

    @Test
    public void testProcessTaskSetPriorityWithTaskAssignPermissionOnAnyTask() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        this.createGrantAuthorization((Resource)Resources.TASK, "*", this.userId, new Permission[]{Permissions.TASK_ASSIGN});
        this.taskService.setPriority(taskId, 80);
        Task task = this.selectSingleTask();
        Assert.assertNotNull((Object)task);
        Assert.assertEquals((long)80L, (long)task.getPriority());
    }

    @Test
    public void testProcessTaskSetPriorityWithUpdateTasksPersmissionOnProcessDefinition() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, PROCESS_KEY, this.userId, new Permission[]{Permissions.UPDATE_TASK});
        this.taskService.setPriority(taskId, 80);
        Task task = this.selectSingleTask();
        Assert.assertNotNull((Object)task);
        Assert.assertEquals((long)80L, (long)task.getPriority());
    }

    @Test
    public void testProcessTaskSetPriorityWithTaskAssignPermissionOnProcessDefinition() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, PROCESS_KEY, this.userId, new Permission[]{Permissions.TASK_ASSIGN});
        this.taskService.setPriority(taskId, 80);
        Task task = this.selectSingleTask();
        Assert.assertNotNull((Object)task);
        Assert.assertEquals((long)80L, (long)task.getPriority());
    }

    @Test
    public void testProcessTaskSetPriority() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        this.createGrantAuthorization((Resource)Resources.TASK, taskId, this.userId, new Permission[]{Permissions.UPDATE});
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, PROCESS_KEY, this.userId, new Permission[]{Permissions.UPDATE_TASK});
        this.taskService.setPriority(taskId, 80);
        Task task = this.selectSingleTask();
        Assert.assertNotNull((Object)task);
        Assert.assertEquals((long)80L, (long)task.getPriority());
    }

    @Test
    public void testProcessTaskSetPriorityWithTaskAssignPermission() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        this.createGrantAuthorization((Resource)Resources.TASK, taskId, this.userId, new Permission[]{Permissions.TASK_ASSIGN});
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, PROCESS_KEY, this.userId, new Permission[]{Permissions.TASK_ASSIGN});
        this.taskService.setPriority(taskId, 80);
        Task task = this.selectSingleTask();
        Assert.assertNotNull((Object)task);
        Assert.assertEquals((long)80L, (long)task.getPriority());
    }

    @Test
    public void testCaseTaskSetPriority() {
        this.testRule.createCaseInstanceByKey(CASE_KEY);
        String taskId = this.selectSingleTask().getId();
        this.taskService.setPriority(taskId, 80);
        Task task = this.selectSingleTask();
        Assert.assertNotNull((Object)task);
        Assert.assertEquals((long)80L, (long)task.getPriority());
    }

    @Test
    public void testStandaloneTaskGetSubTasksWithoutAuthorization() {
        String parentTaskId = "parentTaskId";
        this.createTask(parentTaskId);
        this.disableAuthorization();
        Task sub1 = this.taskService.newTask("sub1");
        sub1.setParentTaskId(parentTaskId);
        this.taskService.saveTask(sub1);
        Task sub2 = this.taskService.newTask("sub2");
        sub2.setParentTaskId(parentTaskId);
        this.taskService.saveTask(sub2);
        this.enableAuthorization();
        List subTasks = this.taskService.getSubTasks(parentTaskId);
        Assert.assertTrue((boolean)subTasks.isEmpty());
        this.deleteTask(parentTaskId, true);
    }

    @Test
    public void testStandaloneTaskGetSubTasksWithReadPermissionOnSub1() {
        String parentTaskId = "parentTaskId";
        this.createTask(parentTaskId);
        this.disableAuthorization();
        Task sub1 = this.taskService.newTask("sub1");
        sub1.setParentTaskId(parentTaskId);
        this.taskService.saveTask(sub1);
        Task sub2 = this.taskService.newTask("sub2");
        sub2.setParentTaskId(parentTaskId);
        this.taskService.saveTask(sub2);
        this.enableAuthorization();
        this.createGrantAuthorization((Resource)Resources.TASK, "sub1", this.userId, new Permission[]{Permissions.READ});
        List subTasks = this.taskService.getSubTasks(parentTaskId);
        Assert.assertFalse((boolean)subTasks.isEmpty());
        Assert.assertEquals((long)1L, (long)subTasks.size());
        Assert.assertEquals((Object)"sub1", (Object)((Task)subTasks.get(0)).getId());
        this.deleteTask(parentTaskId, true);
    }

    @Test
    public void testStandaloneTaskGetSubTasks() {
        String parentTaskId = "parentTaskId";
        this.createTask(parentTaskId);
        this.disableAuthorization();
        Task sub1 = this.taskService.newTask("sub1");
        sub1.setParentTaskId(parentTaskId);
        this.taskService.saveTask(sub1);
        Task sub2 = this.taskService.newTask("sub2");
        sub2.setParentTaskId(parentTaskId);
        this.taskService.saveTask(sub2);
        this.enableAuthorization();
        this.createGrantAuthorization((Resource)Resources.TASK, "*", this.userId, new Permission[]{Permissions.READ});
        List subTasks = this.taskService.getSubTasks(parentTaskId);
        Assert.assertFalse((boolean)subTasks.isEmpty());
        Assert.assertEquals((long)2L, (long)subTasks.size());
        this.deleteTask(parentTaskId, true);
    }

    @Test
    public void testProcessTaskGetSubTasksWithoutAuthorization() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        String parentTaskId = this.selectSingleTask().getId();
        this.disableAuthorization();
        Task sub1 = this.taskService.newTask("sub1");
        sub1.setParentTaskId(parentTaskId);
        this.taskService.saveTask(sub1);
        Task sub2 = this.taskService.newTask("sub2");
        sub2.setParentTaskId(parentTaskId);
        this.taskService.saveTask(sub2);
        this.enableAuthorization();
        List subTasks = this.taskService.getSubTasks(parentTaskId);
        Assert.assertTrue((boolean)subTasks.isEmpty());
    }

    @Test
    public void testProcessTaskGetSubTasksWithReadPermissionOnSub1() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        String parentTaskId = this.selectSingleTask().getId();
        this.disableAuthorization();
        Task sub1 = this.taskService.newTask("sub1");
        sub1.setParentTaskId(parentTaskId);
        this.taskService.saveTask(sub1);
        Task sub2 = this.taskService.newTask("sub2");
        sub2.setParentTaskId(parentTaskId);
        this.taskService.saveTask(sub2);
        this.enableAuthorization();
        this.createGrantAuthorization((Resource)Resources.TASK, "sub1", this.userId, new Permission[]{Permissions.READ});
        List subTasks = this.taskService.getSubTasks(parentTaskId);
        Assert.assertFalse((boolean)subTasks.isEmpty());
        Assert.assertEquals((long)1L, (long)subTasks.size());
        Assert.assertEquals((Object)"sub1", (Object)((Task)subTasks.get(0)).getId());
    }

    @Test
    public void testProcessTaskGetSubTasks() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        String parentTaskId = this.selectSingleTask().getId();
        this.disableAuthorization();
        Task sub1 = this.taskService.newTask("sub1");
        sub1.setParentTaskId(parentTaskId);
        this.taskService.saveTask(sub1);
        Task sub2 = this.taskService.newTask("sub2");
        sub2.setParentTaskId(parentTaskId);
        this.taskService.saveTask(sub2);
        this.enableAuthorization();
        this.createGrantAuthorization((Resource)Resources.TASK, "*", this.userId, new Permission[]{Permissions.READ});
        List subTasks = this.taskService.getSubTasks(parentTaskId);
        Assert.assertFalse((boolean)subTasks.isEmpty());
        Assert.assertEquals((long)2L, (long)subTasks.size());
    }

    @Test
    public void testCaseTaskGetSubTasksWithoutAuthorization() {
        this.testRule.createCaseInstanceByKey(CASE_KEY);
        String parentTaskId = this.selectSingleTask().getId();
        this.disableAuthorization();
        Task sub1 = this.taskService.newTask("sub1");
        sub1.setParentTaskId(parentTaskId);
        this.taskService.saveTask(sub1);
        Task sub2 = this.taskService.newTask("sub2");
        sub2.setParentTaskId(parentTaskId);
        this.taskService.saveTask(sub2);
        this.enableAuthorization();
        List subTasks = this.taskService.getSubTasks(parentTaskId);
        Assert.assertTrue((boolean)subTasks.isEmpty());
    }

    @Test
    public void testCaseTaskGetSubTasksWithReadPermissionOnSub1() {
        this.testRule.createCaseInstanceByKey(CASE_KEY);
        String parentTaskId = this.selectSingleTask().getId();
        this.disableAuthorization();
        Task sub1 = this.taskService.newTask("sub1");
        sub1.setParentTaskId(parentTaskId);
        this.taskService.saveTask(sub1);
        Task sub2 = this.taskService.newTask("sub2");
        sub2.setParentTaskId(parentTaskId);
        this.taskService.saveTask(sub2);
        this.enableAuthorization();
        this.createGrantAuthorization((Resource)Resources.TASK, "sub1", this.userId, new Permission[]{Permissions.READ});
        List subTasks = this.taskService.getSubTasks(parentTaskId);
        Assert.assertFalse((boolean)subTasks.isEmpty());
        Assert.assertEquals((long)1L, (long)subTasks.size());
        Assert.assertEquals((Object)"sub1", (Object)((Task)subTasks.get(0)).getId());
    }

    @Test
    public void testCaseTaskGetSubTasks() {
        this.testRule.createCaseInstanceByKey(CASE_KEY);
        String parentTaskId = this.selectSingleTask().getId();
        this.disableAuthorization();
        Task sub1 = this.taskService.newTask("sub1");
        sub1.setParentTaskId(parentTaskId);
        this.taskService.saveTask(sub1);
        Task sub2 = this.taskService.newTask("sub2");
        sub2.setParentTaskId(parentTaskId);
        this.taskService.saveTask(sub2);
        this.enableAuthorization();
        this.createGrantAuthorization((Resource)Resources.TASK, "*", this.userId, new Permission[]{Permissions.READ});
        List subTasks = this.taskService.getSubTasks(parentTaskId);
        Assert.assertFalse((boolean)subTasks.isEmpty());
        Assert.assertEquals((long)2L, (long)subTasks.size());
    }

    @Test
    public void testStandaloneTaskClearAuthorization() {
        String taskId = "myTask";
        this.createTask(taskId);
        this.createGrantAuthorization((Resource)Resources.TASK, taskId, this.userId, new Permission[]{Permissions.UPDATE});
        this.disableAuthorization();
        Authorization authorization = (Authorization)this.authorizationService.createAuthorizationQuery().resourceId(taskId).singleResult();
        this.enableAuthorization();
        Assert.assertNotNull((Object)authorization);
        this.taskService.complete(taskId);
        this.disableAuthorization();
        authorization = (Authorization)this.authorizationService.createAuthorizationQuery().resourceId(taskId).singleResult();
        this.enableAuthorization();
        Assert.assertNull((Object)authorization);
        this.deleteTask(taskId, true);
    }

    @Test
    public void testProcessTaskClearAuthorization() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        this.createGrantAuthorization((Resource)Resources.TASK, taskId, this.userId, new Permission[]{Permissions.UPDATE});
        this.disableAuthorization();
        Authorization authorization = (Authorization)this.authorizationService.createAuthorizationQuery().resourceId(taskId).singleResult();
        this.enableAuthorization();
        Assert.assertNotNull((Object)authorization);
        this.taskService.complete(taskId);
        this.disableAuthorization();
        authorization = (Authorization)this.authorizationService.createAuthorizationQuery().resourceId(taskId).singleResult();
        this.enableAuthorization();
        Assert.assertNull((Object)authorization);
    }

    @Test
    public void testStandaloneTaskSetAssigneeCreateNewAuthorization() {
        String taskId = "myTask";
        this.createTask(taskId);
        this.createGrantAuthorization((Resource)Resources.TASK, taskId, this.userId, new Permission[]{Permissions.UPDATE});
        this.taskService.setAssignee(taskId, "demo");
        this.disableAuthorization();
        Authorization authorization = (Authorization)this.authorizationService.createAuthorizationQuery().userIdIn(new String[]{"demo"}).singleResult();
        this.enableAuthorization();
        Assert.assertNotNull((Object)authorization);
        Assert.assertEquals((long)Resources.TASK.resourceType(), (long)authorization.getResourceType());
        Assert.assertEquals((Object)taskId, (Object)authorization.getResourceId());
        Assert.assertTrue((boolean)authorization.isPermissionGranted((Permission)Permissions.READ));
        Assert.assertTrue((boolean)authorization.isPermissionGranted(this.getDefaultTaskPermissionForUser()));
        this.deleteTask(taskId, true);
    }

    @Test
    public void testStandaloneTaskSetAssigneeUpdateAuthorization() {
        String taskId = "myTask";
        this.createTask(taskId);
        this.createGrantAuthorization((Resource)Resources.TASK, taskId, this.userId, new Permission[]{Permissions.UPDATE});
        this.createGrantAuthorization((Resource)Resources.TASK, taskId, "demo", new Permission[]{Permissions.DELETE});
        this.taskService.setAssignee(taskId, "demo");
        this.disableAuthorization();
        Authorization authorization = (Authorization)this.authorizationService.createAuthorizationQuery().userIdIn(new String[]{"demo"}).singleResult();
        this.enableAuthorization();
        Assert.assertNotNull((Object)authorization);
        Assert.assertEquals((long)Resources.TASK.resourceType(), (long)authorization.getResourceType());
        Assert.assertEquals((Object)taskId, (Object)authorization.getResourceId());
        Assert.assertTrue((boolean)authorization.isPermissionGranted((Permission)Permissions.READ));
        Assert.assertTrue((boolean)authorization.isPermissionGranted(this.getDefaultTaskPermissionForUser()));
        this.deleteTask(taskId, true);
    }

    @Test
    public void testStandaloneTaskSetAssigneeToNullAuthorizationStillAvailable() {
        String taskId = "myTask";
        this.createTask(taskId);
        this.createGrantAuthorization((Resource)Resources.TASK, taskId, this.userId, new Permission[]{Permissions.UPDATE});
        this.taskService.setAssignee(taskId, "demo");
        this.taskService.setAssignee(taskId, null);
        this.disableAuthorization();
        Authorization authorization = (Authorization)this.authorizationService.createAuthorizationQuery().userIdIn(new String[]{"demo"}).singleResult();
        this.enableAuthorization();
        Assert.assertNotNull((Object)authorization);
        Assert.assertEquals((long)Resources.TASK.resourceType(), (long)authorization.getResourceType());
        Assert.assertEquals((Object)taskId, (Object)authorization.getResourceId());
        Assert.assertTrue((boolean)authorization.isPermissionGranted((Permission)Permissions.READ));
        Assert.assertTrue((boolean)authorization.isPermissionGranted(this.getDefaultTaskPermissionForUser()));
        this.deleteTask(taskId, true);
    }

    @Test
    public void testQueryStandaloneTaskSetAssignee() {
        String taskId = "myTask";
        this.createTask(taskId);
        this.createGrantAuthorization((Resource)Resources.TASK, taskId, this.userId, new Permission[]{Permissions.UPDATE});
        this.taskService.setAssignee(taskId, "demo");
        this.identityService.clearAuthentication();
        this.identityService.setAuthentication("demo", null);
        Task task = (Task)this.taskService.createTaskQuery().singleResult();
        Assert.assertNotNull((Object)task);
        Assert.assertEquals((Object)taskId, (Object)task.getId());
        this.identityService.clearAuthentication();
        this.identityService.setAuthentication(this.userId, Arrays.asList(this.groupId));
        this.deleteTask(taskId, true);
    }

    @Test
    public void testStandaloneTaskSetAssigneeOutsideCommandContextInsert() {
        String taskId = "myTask";
        this.createGrantAuthorization((Resource)Resources.TASK, "*", this.userId, new Permission[]{Permissions.CREATE});
        this.createGrantAuthorization((Resource)Resources.TASK, taskId, this.userId, new Permission[]{Permissions.UPDATE});
        Task task = this.taskService.newTask(taskId);
        task.setAssignee("demo");
        this.taskService.saveTask(task);
        this.disableAuthorization();
        Authorization authorization = (Authorization)this.authorizationService.createAuthorizationQuery().userIdIn(new String[]{"demo"}).singleResult();
        this.enableAuthorization();
        Assert.assertNotNull((Object)authorization);
        Assert.assertEquals((long)Resources.TASK.resourceType(), (long)authorization.getResourceType());
        Assert.assertEquals((Object)taskId, (Object)authorization.getResourceId());
        Assert.assertTrue((boolean)authorization.isPermissionGranted((Permission)Permissions.READ));
        Assert.assertTrue((boolean)authorization.isPermissionGranted(this.getDefaultTaskPermissionForUser()));
        this.deleteTask(taskId, true);
    }

    @Test
    public void testStandaloneTaskSetAssigneeOutsideCommandContextSave() {
        String taskId = "myTask";
        this.createTask(taskId);
        this.createGrantAuthorization((Resource)Resources.TASK, taskId, this.userId, new Permission[]{Permissions.UPDATE});
        Task task = this.selectSingleTask();
        task.setAssignee("demo");
        this.taskService.saveTask(task);
        this.disableAuthorization();
        Authorization authorization = (Authorization)this.authorizationService.createAuthorizationQuery().userIdIn(new String[]{"demo"}).singleResult();
        this.enableAuthorization();
        Assert.assertNotNull((Object)authorization);
        Assert.assertEquals((long)Resources.TASK.resourceType(), (long)authorization.getResourceType());
        Assert.assertEquals((Object)taskId, (Object)authorization.getResourceId());
        Assert.assertTrue((boolean)authorization.isPermissionGranted((Permission)Permissions.READ));
        Assert.assertTrue((boolean)authorization.isPermissionGranted(this.getDefaultTaskPermissionForUser()));
        this.deleteTask(taskId, true);
    }

    @Test
    public void testProcessTaskSetAssigneeCreateNewAuthorization() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        this.createGrantAuthorization((Resource)Resources.TASK, taskId, this.userId, new Permission[]{Permissions.UPDATE});
        this.taskService.setAssignee(taskId, "demo");
        this.disableAuthorization();
        Authorization authorization = (Authorization)this.authorizationService.createAuthorizationQuery().userIdIn(new String[]{"demo"}).singleResult();
        this.enableAuthorization();
        Assert.assertNotNull((Object)authorization);
        Assert.assertEquals((long)Resources.TASK.resourceType(), (long)authorization.getResourceType());
        Assert.assertEquals((Object)taskId, (Object)authorization.getResourceId());
        Assert.assertTrue((boolean)authorization.isPermissionGranted((Permission)Permissions.READ));
        Assert.assertTrue((boolean)authorization.isPermissionGranted(this.getDefaultTaskPermissionForUser()));
    }

    @Test
    public void testProcessTaskSetAssigneeUpdateAuthorization() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        this.createGrantAuthorization((Resource)Resources.TASK, taskId, this.userId, new Permission[]{Permissions.UPDATE});
        this.createGrantAuthorization((Resource)Resources.TASK, taskId, "demo", new Permission[]{Permissions.DELETE});
        this.taskService.setAssignee(taskId, "demo");
        this.disableAuthorization();
        Authorization authorization = (Authorization)this.authorizationService.createAuthorizationQuery().userIdIn(new String[]{"demo"}).singleResult();
        this.enableAuthorization();
        Assert.assertNotNull((Object)authorization);
        Assert.assertEquals((long)Resources.TASK.resourceType(), (long)authorization.getResourceType());
        Assert.assertEquals((Object)taskId, (Object)authorization.getResourceId());
        Assert.assertTrue((boolean)authorization.isPermissionGranted((Permission)Permissions.READ));
        Assert.assertTrue((boolean)authorization.isPermissionGranted(this.getDefaultTaskPermissionForUser()));
    }

    @Test
    public void testProcessTaskSetAssigneeToNullAuthorizationStillAvailable() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        this.createGrantAuthorization((Resource)Resources.TASK, taskId, this.userId, new Permission[]{Permissions.UPDATE});
        this.taskService.setAssignee(taskId, "demo");
        this.taskService.setAssignee(taskId, null);
        this.disableAuthorization();
        Authorization authorization = (Authorization)this.authorizationService.createAuthorizationQuery().userIdIn(new String[]{"demo"}).singleResult();
        this.enableAuthorization();
        Assert.assertNotNull((Object)authorization);
        Assert.assertEquals((long)Resources.TASK.resourceType(), (long)authorization.getResourceType());
        Assert.assertEquals((Object)taskId, (Object)authorization.getResourceId());
        Assert.assertTrue((boolean)authorization.isPermissionGranted((Permission)Permissions.READ));
        Assert.assertTrue((boolean)authorization.isPermissionGranted(this.getDefaultTaskPermissionForUser()));
    }

    @Test
    public void testQueryProcessTaskSetAssignee() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        this.createGrantAuthorization((Resource)Resources.TASK, taskId, this.userId, new Permission[]{Permissions.UPDATE});
        this.taskService.setAssignee(taskId, "demo");
        this.identityService.clearAuthentication();
        this.identityService.setAuthentication("demo", null);
        Task task = (Task)this.taskService.createTaskQuery().singleResult();
        Assert.assertNotNull((Object)task);
        Assert.assertEquals((Object)taskId, (Object)task.getId());
        this.identityService.clearAuthentication();
        this.identityService.setAuthentication(this.userId, Arrays.asList(this.groupId));
    }

    @Test
    public void testProcessTaskAssignee() {
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, DEMO_ASSIGNEE_PROCESS_KEY, this.userId, new Permission[]{Permissions.CREATE_INSTANCE});
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, "*", this.userId, new Permission[]{Permissions.CREATE});
        this.runtimeService.startProcessInstanceByKey(DEMO_ASSIGNEE_PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        this.disableAuthorization();
        Authorization authorization = (Authorization)this.authorizationService.createAuthorizationQuery().userIdIn(new String[]{"demo"}).singleResult();
        this.enableAuthorization();
        Assert.assertNotNull((Object)authorization);
        Assert.assertEquals((long)Resources.TASK.resourceType(), (long)authorization.getResourceType());
        Assert.assertEquals((Object)taskId, (Object)authorization.getResourceId());
        Assert.assertTrue((boolean)authorization.isPermissionGranted((Permission)Permissions.READ));
        Assert.assertTrue((boolean)authorization.isPermissionGranted(this.getDefaultTaskPermissionForUser()));
        this.identityService.clearAuthentication();
        this.identityService.setAuthentication("demo", null);
        Task task = (Task)this.taskService.createTaskQuery().singleResult();
        Assert.assertNotNull((Object)task);
        Assert.assertEquals((Object)taskId, (Object)task.getId());
        this.identityService.clearAuthentication();
        this.identityService.setAuthentication(this.userId, Arrays.asList(this.groupId));
    }

    @Test
    public void testCaseTaskSetAssigneeNoAuthorization() {
        this.testRule.createCaseInstanceByKey(CASE_KEY);
        String taskId = this.selectSingleTask().getId();
        this.createGrantAuthorization((Resource)Resources.TASK, taskId, this.userId, new Permission[]{Permissions.UPDATE});
        this.taskService.setAssignee(taskId, "demo");
        this.disableAuthorization();
        Authorization authorization = (Authorization)this.authorizationService.createAuthorizationQuery().userIdIn(new String[]{"demo"}).singleResult();
        this.enableAuthorization();
        Assert.assertNull((Object)authorization);
    }

    @Test
    public void testStandaloneTaskSetOwnerCreateNewAuthorization() {
        String taskId = "myTask";
        this.createTask(taskId);
        this.createGrantAuthorization((Resource)Resources.TASK, taskId, this.userId, new Permission[]{Permissions.UPDATE});
        this.taskService.setOwner(taskId, "demo");
        this.disableAuthorization();
        Authorization authorization = (Authorization)this.authorizationService.createAuthorizationQuery().userIdIn(new String[]{"demo"}).singleResult();
        this.enableAuthorization();
        Assert.assertNotNull((Object)authorization);
        Assert.assertEquals((long)Resources.TASK.resourceType(), (long)authorization.getResourceType());
        Assert.assertEquals((Object)taskId, (Object)authorization.getResourceId());
        Assert.assertTrue((boolean)authorization.isPermissionGranted((Permission)Permissions.READ));
        Assert.assertTrue((boolean)authorization.isPermissionGranted(this.getDefaultTaskPermissionForUser()));
        this.deleteTask(taskId, true);
    }

    @Test
    public void testStandaloneTaskSetOwnerUpdateAuthorization() {
        String taskId = "myTask";
        this.createTask(taskId);
        this.createGrantAuthorization((Resource)Resources.TASK, taskId, this.userId, new Permission[]{Permissions.UPDATE});
        this.createGrantAuthorization((Resource)Resources.TASK, taskId, "demo", new Permission[]{Permissions.DELETE});
        this.taskService.setOwner(taskId, "demo");
        this.disableAuthorization();
        Authorization authorization = (Authorization)this.authorizationService.createAuthorizationQuery().userIdIn(new String[]{"demo"}).singleResult();
        this.enableAuthorization();
        Assert.assertNotNull((Object)authorization);
        Assert.assertEquals((long)Resources.TASK.resourceType(), (long)authorization.getResourceType());
        Assert.assertEquals((Object)taskId, (Object)authorization.getResourceId());
        Assert.assertTrue((boolean)authorization.isPermissionGranted((Permission)Permissions.READ));
        Assert.assertTrue((boolean)authorization.isPermissionGranted(this.getDefaultTaskPermissionForUser()));
        this.deleteTask(taskId, true);
    }

    @Test
    public void testQueryStandaloneTaskSetOwner() {
        String taskId = "myTask";
        this.createTask(taskId);
        this.createGrantAuthorization((Resource)Resources.TASK, taskId, this.userId, new Permission[]{Permissions.UPDATE});
        this.taskService.setOwner(taskId, "demo");
        this.identityService.clearAuthentication();
        this.identityService.setAuthentication("demo", null);
        Task task = (Task)this.taskService.createTaskQuery().singleResult();
        Assert.assertNotNull((Object)task);
        Assert.assertEquals((Object)taskId, (Object)task.getId());
        this.identityService.clearAuthentication();
        this.identityService.setAuthentication(this.userId, Arrays.asList(this.groupId));
        this.deleteTask(taskId, true);
    }

    @Test
    public void testStandaloneTaskSetOwnerOutsideCommandContextInsert() {
        String taskId = "myTask";
        this.createGrantAuthorization((Resource)Resources.TASK, "*", this.userId, new Permission[]{Permissions.CREATE});
        this.createGrantAuthorization((Resource)Resources.TASK, taskId, this.userId, new Permission[]{Permissions.UPDATE});
        Task task = this.taskService.newTask(taskId);
        task.setOwner("demo");
        this.taskService.saveTask(task);
        this.disableAuthorization();
        Authorization authorization = (Authorization)this.authorizationService.createAuthorizationQuery().userIdIn(new String[]{"demo"}).singleResult();
        this.enableAuthorization();
        Assert.assertNotNull((Object)authorization);
        Assert.assertEquals((long)Resources.TASK.resourceType(), (long)authorization.getResourceType());
        Assert.assertEquals((Object)taskId, (Object)authorization.getResourceId());
        Assert.assertTrue((boolean)authorization.isPermissionGranted((Permission)Permissions.READ));
        Assert.assertTrue((boolean)authorization.isPermissionGranted(this.getDefaultTaskPermissionForUser()));
        this.deleteTask(taskId, true);
    }

    @Test
    public void testStandaloneTaskSetOwnerOutsideCommandContextSave() {
        String taskId = "myTask";
        this.createTask(taskId);
        this.createGrantAuthorization((Resource)Resources.TASK, taskId, this.userId, new Permission[]{Permissions.UPDATE});
        Task task = this.selectSingleTask();
        task.setOwner("demo");
        this.taskService.saveTask(task);
        this.disableAuthorization();
        Authorization authorization = (Authorization)this.authorizationService.createAuthorizationQuery().userIdIn(new String[]{"demo"}).singleResult();
        this.enableAuthorization();
        Assert.assertNotNull((Object)authorization);
        Assert.assertEquals((long)Resources.TASK.resourceType(), (long)authorization.getResourceType());
        Assert.assertEquals((Object)taskId, (Object)authorization.getResourceId());
        Assert.assertTrue((boolean)authorization.isPermissionGranted((Permission)Permissions.READ));
        Assert.assertTrue((boolean)authorization.isPermissionGranted(this.getDefaultTaskPermissionForUser()));
        this.deleteTask(taskId, true);
    }

    @Test
    public void testProcessTaskSetOwnerCreateNewAuthorization() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        this.createGrantAuthorization((Resource)Resources.TASK, taskId, this.userId, new Permission[]{Permissions.UPDATE});
        this.taskService.setOwner(taskId, "demo");
        this.disableAuthorization();
        Authorization authorization = (Authorization)this.authorizationService.createAuthorizationQuery().userIdIn(new String[]{"demo"}).singleResult();
        this.enableAuthorization();
        Assert.assertNotNull((Object)authorization);
        Assert.assertEquals((long)Resources.TASK.resourceType(), (long)authorization.getResourceType());
        Assert.assertEquals((Object)taskId, (Object)authorization.getResourceId());
        Assert.assertTrue((boolean)authorization.isPermissionGranted((Permission)Permissions.READ));
        Assert.assertTrue((boolean)authorization.isPermissionGranted(this.getDefaultTaskPermissionForUser()));
    }

    @Test
    public void testProcessTaskSetOwnerUpdateAuthorization() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        this.createGrantAuthorization((Resource)Resources.TASK, taskId, this.userId, new Permission[]{Permissions.UPDATE});
        this.createGrantAuthorization((Resource)Resources.TASK, taskId, "demo", new Permission[]{Permissions.DELETE});
        this.taskService.setOwner(taskId, "demo");
        this.disableAuthorization();
        Authorization authorization = (Authorization)this.authorizationService.createAuthorizationQuery().userIdIn(new String[]{"demo"}).singleResult();
        this.enableAuthorization();
        Assert.assertNotNull((Object)authorization);
        Assert.assertEquals((long)Resources.TASK.resourceType(), (long)authorization.getResourceType());
        Assert.assertEquals((Object)taskId, (Object)authorization.getResourceId());
        Assert.assertTrue((boolean)authorization.isPermissionGranted((Permission)Permissions.READ));
        Assert.assertTrue((boolean)authorization.isPermissionGranted(this.getDefaultTaskPermissionForUser()));
    }

    @Test
    public void testQueryProcessTaskSetOwner() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        this.createGrantAuthorization((Resource)Resources.TASK, taskId, this.userId, new Permission[]{Permissions.UPDATE});
        this.taskService.setOwner(taskId, "demo");
        this.identityService.clearAuthentication();
        this.identityService.setAuthentication("demo", null);
        Task task = (Task)this.taskService.createTaskQuery().singleResult();
        Assert.assertNotNull((Object)task);
        Assert.assertEquals((Object)taskId, (Object)task.getId());
        this.identityService.clearAuthentication();
        this.identityService.setAuthentication(this.userId, Arrays.asList(this.groupId));
    }

    @Test
    public void testCaseTaskSetOwnerNoAuthorization() {
        this.testRule.createCaseInstanceByKey(CASE_KEY);
        String taskId = this.selectSingleTask().getId();
        this.createGrantAuthorization((Resource)Resources.TASK, taskId, this.userId, new Permission[]{Permissions.UPDATE});
        this.taskService.setOwner(taskId, "demo");
        this.disableAuthorization();
        Authorization authorization = (Authorization)this.authorizationService.createAuthorizationQuery().userIdIn(new String[]{"demo"}).singleResult();
        this.enableAuthorization();
        Assert.assertNull((Object)authorization);
    }

    @Test
    public void testStandaloneTaskAddCandidateUserCreateNewAuthorization() {
        String taskId = "myTask";
        this.createTask(taskId);
        this.createGrantAuthorization((Resource)Resources.TASK, taskId, this.userId, new Permission[]{Permissions.UPDATE});
        this.taskService.addCandidateUser(taskId, "demo");
        this.disableAuthorization();
        Authorization authorization = (Authorization)this.authorizationService.createAuthorizationQuery().userIdIn(new String[]{"demo"}).singleResult();
        this.enableAuthorization();
        Assert.assertNotNull((Object)authorization);
        Assert.assertEquals((long)Resources.TASK.resourceType(), (long)authorization.getResourceType());
        Assert.assertEquals((Object)taskId, (Object)authorization.getResourceId());
        Assert.assertTrue((boolean)authorization.isPermissionGranted((Permission)Permissions.READ));
        Assert.assertTrue((boolean)authorization.isPermissionGranted(this.getDefaultTaskPermissionForUser()));
        this.deleteTask(taskId, true);
    }

    @Test
    public void testStandaloneTaskAddCandidateUserUpdateAuthorization() {
        String taskId = "myTask";
        this.createTask(taskId);
        this.createGrantAuthorization((Resource)Resources.TASK, taskId, this.userId, new Permission[]{Permissions.UPDATE});
        this.createGrantAuthorization((Resource)Resources.TASK, taskId, "demo", new Permission[]{Permissions.DELETE});
        this.taskService.addCandidateUser(taskId, "demo");
        this.disableAuthorization();
        Authorization authorization = (Authorization)this.authorizationService.createAuthorizationQuery().userIdIn(new String[]{"demo"}).singleResult();
        this.enableAuthorization();
        Assert.assertNotNull((Object)authorization);
        Assert.assertEquals((long)Resources.TASK.resourceType(), (long)authorization.getResourceType());
        Assert.assertEquals((Object)taskId, (Object)authorization.getResourceId());
        Assert.assertTrue((boolean)authorization.isPermissionGranted((Permission)Permissions.READ));
        Assert.assertTrue((boolean)authorization.isPermissionGranted(this.getDefaultTaskPermissionForUser()));
        this.deleteTask(taskId, true);
    }

    @Test
    public void testQueryStandaloneTaskAddCandidateUser() {
        String taskId = "myTask";
        this.createTask(taskId);
        this.createGrantAuthorization((Resource)Resources.TASK, taskId, this.userId, new Permission[]{Permissions.UPDATE});
        this.taskService.addCandidateUser(taskId, "demo");
        this.identityService.clearAuthentication();
        this.identityService.setAuthentication("demo", null);
        Task task = (Task)this.taskService.createTaskQuery().singleResult();
        Assert.assertNotNull((Object)task);
        Assert.assertEquals((Object)taskId, (Object)task.getId());
        this.identityService.clearAuthentication();
        this.identityService.setAuthentication(this.userId, Arrays.asList(this.groupId));
        this.deleteTask(taskId, true);
    }

    @Test
    public void testQueryStandaloneTaskAddCandidateUserWithTaskAssignPermission() {
        String taskId = "myTask";
        this.createTask(taskId);
        this.createGrantAuthorization((Resource)Resources.TASK, taskId, this.userId, new Permission[]{Permissions.TASK_ASSIGN});
        this.taskService.addCandidateUser(taskId, "demo");
        this.identityService.clearAuthentication();
        this.identityService.setAuthentication("demo", null);
        Task task = (Task)this.taskService.createTaskQuery().singleResult();
        Assert.assertNotNull((Object)task);
        Assert.assertEquals((Object)taskId, (Object)task.getId());
        this.identityService.clearAuthentication();
        this.identityService.setAuthentication(this.userId, Arrays.asList(this.groupId));
        this.deleteTask(taskId, true);
    }

    @Test
    public void testProcessTaskAddCandidateUserCreateNewAuthorization() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        this.createGrantAuthorization((Resource)Resources.TASK, taskId, this.userId, new Permission[]{Permissions.UPDATE});
        this.taskService.addCandidateUser(taskId, "demo");
        this.disableAuthorization();
        Authorization authorization = (Authorization)this.authorizationService.createAuthorizationQuery().userIdIn(new String[]{"demo"}).singleResult();
        this.enableAuthorization();
        Assert.assertNotNull((Object)authorization);
        Assert.assertEquals((long)Resources.TASK.resourceType(), (long)authorization.getResourceType());
        Assert.assertEquals((Object)taskId, (Object)authorization.getResourceId());
        Assert.assertTrue((boolean)authorization.isPermissionGranted((Permission)Permissions.READ));
        Assert.assertTrue((boolean)authorization.isPermissionGranted(this.getDefaultTaskPermissionForUser()));
    }

    @Test
    public void testProcessTaskAddCandidateUserUpdateAuthorization() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        this.createGrantAuthorization((Resource)Resources.TASK, taskId, this.userId, new Permission[]{Permissions.UPDATE});
        this.createGrantAuthorization((Resource)Resources.TASK, taskId, "demo", new Permission[]{Permissions.DELETE});
        this.taskService.addCandidateUser(taskId, "demo");
        this.disableAuthorization();
        Authorization authorization = (Authorization)this.authorizationService.createAuthorizationQuery().userIdIn(new String[]{"demo"}).singleResult();
        this.enableAuthorization();
        Assert.assertNotNull((Object)authorization);
        Assert.assertEquals((long)Resources.TASK.resourceType(), (long)authorization.getResourceType());
        Assert.assertEquals((Object)taskId, (Object)authorization.getResourceId());
        Assert.assertTrue((boolean)authorization.isPermissionGranted((Permission)Permissions.READ));
        Assert.assertTrue((boolean)authorization.isPermissionGranted(this.getDefaultTaskPermissionForUser()));
    }

    @Test
    public void testQueryProcessTaskAddCandidateUser() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        this.createGrantAuthorization((Resource)Resources.TASK, taskId, this.userId, new Permission[]{Permissions.UPDATE});
        this.taskService.addCandidateUser(taskId, "demo");
        this.identityService.clearAuthentication();
        this.identityService.setAuthentication("demo", null);
        Task task = (Task)this.taskService.createTaskQuery().singleResult();
        Assert.assertNotNull((Object)task);
        Assert.assertEquals((Object)taskId, (Object)task.getId());
        this.identityService.clearAuthentication();
        this.identityService.setAuthentication(this.userId, Arrays.asList(this.groupId));
    }

    @Test
    public void testProcessTaskCandidateUsers() {
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, CANDIDATE_USERS_PROCESS_KEY, this.userId, new Permission[]{Permissions.CREATE_INSTANCE});
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, "*", this.userId, new Permission[]{Permissions.CREATE});
        this.runtimeService.startProcessInstanceByKey(CANDIDATE_USERS_PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        this.disableAuthorization();
        Authorization authorization = (Authorization)this.authorizationService.createAuthorizationQuery().userIdIn(new String[]{"demo"}).singleResult();
        this.enableAuthorization();
        Assert.assertNotNull((Object)authorization);
        Assert.assertEquals((long)Resources.TASK.resourceType(), (long)authorization.getResourceType());
        Assert.assertEquals((Object)taskId, (Object)authorization.getResourceId());
        Assert.assertTrue((boolean)authorization.isPermissionGranted((Permission)Permissions.READ));
        Assert.assertTrue((boolean)authorization.isPermissionGranted(this.getDefaultTaskPermissionForUser()));
        this.disableAuthorization();
        authorization = (Authorization)this.authorizationService.createAuthorizationQuery().userIdIn(new String[]{"test"}).resourceId(taskId).singleResult();
        this.enableAuthorization();
        Assert.assertNotNull((Object)authorization);
        Assert.assertEquals((long)Resources.TASK.resourceType(), (long)authorization.getResourceType());
        Assert.assertEquals((Object)taskId, (Object)authorization.getResourceId());
        Assert.assertTrue((boolean)authorization.isPermissionGranted((Permission)Permissions.READ));
        Assert.assertTrue((boolean)authorization.isPermissionGranted(this.getDefaultTaskPermissionForUser()));
        this.identityService.clearAuthentication();
        this.identityService.setAuthentication("demo", null);
        Task task = (Task)this.taskService.createTaskQuery().singleResult();
        Assert.assertNotNull((Object)task);
        Assert.assertEquals((Object)taskId, (Object)task.getId());
        this.identityService.clearAuthentication();
        this.identityService.setAuthentication(this.userId, Arrays.asList(this.groupId));
        task = (Task)this.taskService.createTaskQuery().singleResult();
        Assert.assertNotNull((Object)task);
        Assert.assertEquals((Object)taskId, (Object)task.getId());
    }

    @Test
    public void testCaseTaskAddCandidateUserNoAuthorization() {
        this.testRule.createCaseInstanceByKey(CASE_KEY);
        String taskId = this.selectSingleTask().getId();
        this.createGrantAuthorization((Resource)Resources.TASK, taskId, this.userId, new Permission[]{Permissions.UPDATE});
        this.taskService.addCandidateUser(taskId, "demo");
        this.disableAuthorization();
        Authorization authorization = (Authorization)this.authorizationService.createAuthorizationQuery().userIdIn(new String[]{"demo"}).singleResult();
        this.enableAuthorization();
        Assert.assertNull((Object)authorization);
    }

    @Test
    public void testStandaloneTaskAddCandidateGroupCreateNewAuthorization() {
        String taskId = "myTask";
        this.createTask(taskId);
        this.createGrantAuthorization((Resource)Resources.TASK, taskId, this.userId, new Permission[]{Permissions.UPDATE});
        this.taskService.addCandidateGroup(taskId, "management");
        this.disableAuthorization();
        Authorization authorization = (Authorization)this.authorizationService.createAuthorizationQuery().groupIdIn(new String[]{"management"}).singleResult();
        this.enableAuthorization();
        Assert.assertNotNull((Object)authorization);
        Assert.assertEquals((long)Resources.TASK.resourceType(), (long)authorization.getResourceType());
        Assert.assertEquals((Object)taskId, (Object)authorization.getResourceId());
        Assert.assertTrue((boolean)authorization.isPermissionGranted((Permission)Permissions.READ));
        Assert.assertTrue((boolean)authorization.isPermissionGranted(this.getDefaultTaskPermissionForUser()));
        this.deleteTask(taskId, true);
    }

    @Test
    public void testStandaloneTaskAddCandidateGroupUpdateAuthorization() {
        String taskId = "myTask";
        this.createTask(taskId);
        this.createGrantAuthorization((Resource)Resources.TASK, taskId, this.userId, new Permission[]{Permissions.UPDATE});
        this.createGrantAuthorization((Resource)Resources.TASK, taskId, "demo", new Permission[]{Permissions.DELETE});
        this.taskService.addCandidateGroup(taskId, "management");
        this.disableAuthorization();
        Authorization authorization = (Authorization)this.authorizationService.createAuthorizationQuery().groupIdIn(new String[]{"management"}).singleResult();
        this.enableAuthorization();
        Assert.assertNotNull((Object)authorization);
        Assert.assertEquals((long)Resources.TASK.resourceType(), (long)authorization.getResourceType());
        Assert.assertEquals((Object)taskId, (Object)authorization.getResourceId());
        Assert.assertTrue((boolean)authorization.isPermissionGranted((Permission)Permissions.READ));
        Assert.assertTrue((boolean)authorization.isPermissionGranted(this.getDefaultTaskPermissionForUser()));
        this.deleteTask(taskId, true);
    }

    @Test
    public void testQueryStandaloneTaskAddCandidateGroup() {
        String taskId = "myTask";
        this.createTask(taskId);
        this.createGrantAuthorization((Resource)Resources.TASK, taskId, this.userId, new Permission[]{Permissions.UPDATE});
        this.taskService.addCandidateGroup(taskId, "management");
        this.identityService.clearAuthentication();
        this.identityService.setAuthentication("demo", Arrays.asList("management"));
        Task task = (Task)this.taskService.createTaskQuery().singleResult();
        Assert.assertNotNull((Object)task);
        Assert.assertEquals((Object)taskId, (Object)task.getId());
        this.identityService.clearAuthentication();
        this.identityService.setAuthentication(this.userId, Arrays.asList(this.groupId));
        this.deleteTask(taskId, true);
    }

    @Test
    public void testProcessTaskAddCandidateGroupCreateNewAuthorization() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        this.createGrantAuthorization((Resource)Resources.TASK, taskId, this.userId, new Permission[]{Permissions.UPDATE});
        this.taskService.addCandidateGroup(taskId, "management");
        this.disableAuthorization();
        Authorization authorization = (Authorization)this.authorizationService.createAuthorizationQuery().groupIdIn(new String[]{"management"}).singleResult();
        this.enableAuthorization();
        Assert.assertNotNull((Object)authorization);
        Assert.assertEquals((long)Resources.TASK.resourceType(), (long)authorization.getResourceType());
        Assert.assertEquals((Object)taskId, (Object)authorization.getResourceId());
        Assert.assertTrue((boolean)authorization.isPermissionGranted((Permission)Permissions.READ));
        Assert.assertTrue((boolean)authorization.isPermissionGranted(this.getDefaultTaskPermissionForUser()));
    }

    @Test
    public void testProcessTaskAddCandidateGroupUpdateAuthorization() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        this.createGrantAuthorization((Resource)Resources.TASK, taskId, this.userId, new Permission[]{Permissions.UPDATE});
        this.createGrantAuthorization((Resource)Resources.TASK, taskId, "demo", new Permission[]{Permissions.DELETE});
        this.taskService.addCandidateGroup(taskId, "management");
        this.disableAuthorization();
        Authorization authorization = (Authorization)this.authorizationService.createAuthorizationQuery().groupIdIn(new String[]{"management"}).singleResult();
        this.enableAuthorization();
        Assert.assertNotNull((Object)authorization);
        Assert.assertEquals((long)Resources.TASK.resourceType(), (long)authorization.getResourceType());
        Assert.assertEquals((Object)taskId, (Object)authorization.getResourceId());
        Assert.assertTrue((boolean)authorization.isPermissionGranted((Permission)Permissions.READ));
        Assert.assertTrue((boolean)authorization.isPermissionGranted(this.getDefaultTaskPermissionForUser()));
    }

    @Test
    public void testQueryProcessTaskAddCandidateGroup() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        this.createGrantAuthorization((Resource)Resources.TASK, taskId, this.userId, new Permission[]{Permissions.UPDATE});
        this.taskService.addCandidateGroup(taskId, "management");
        this.identityService.clearAuthentication();
        this.identityService.setAuthentication("demo", Arrays.asList("management"));
        Task task = (Task)this.taskService.createTaskQuery().singleResult();
        Assert.assertNotNull((Object)task);
        Assert.assertEquals((Object)taskId, (Object)task.getId());
        this.identityService.clearAuthentication();
        this.identityService.setAuthentication(this.userId, Arrays.asList(this.groupId));
    }

    @Test
    public void testProcessTaskCandidateGroups() {
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, CANDIDATE_GROUPS_PROCESS_KEY, this.userId, new Permission[]{Permissions.CREATE_INSTANCE});
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, "*", this.userId, new Permission[]{Permissions.CREATE});
        this.runtimeService.startProcessInstanceByKey(CANDIDATE_GROUPS_PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        this.disableAuthorization();
        Authorization authorization = (Authorization)this.authorizationService.createAuthorizationQuery().groupIdIn(new String[]{"management"}).singleResult();
        this.enableAuthorization();
        Assert.assertNotNull((Object)authorization);
        Assert.assertEquals((long)Resources.TASK.resourceType(), (long)authorization.getResourceType());
        Assert.assertEquals((Object)taskId, (Object)authorization.getResourceId());
        Assert.assertTrue((boolean)authorization.isPermissionGranted((Permission)Permissions.READ));
        Assert.assertTrue((boolean)authorization.isPermissionGranted(this.getDefaultTaskPermissionForUser()));
        this.disableAuthorization();
        authorization = (Authorization)this.authorizationService.createAuthorizationQuery().groupIdIn(new String[]{"accounting"}).singleResult();
        this.enableAuthorization();
        Assert.assertNotNull((Object)authorization);
        Assert.assertEquals((long)Resources.TASK.resourceType(), (long)authorization.getResourceType());
        Assert.assertEquals((Object)taskId, (Object)authorization.getResourceId());
        Assert.assertTrue((boolean)authorization.isPermissionGranted((Permission)Permissions.READ));
        Assert.assertTrue((boolean)authorization.isPermissionGranted(this.getDefaultTaskPermissionForUser()));
        this.identityService.clearAuthentication();
        this.identityService.setAuthentication("demo", Arrays.asList("management"));
        Task task = (Task)this.taskService.createTaskQuery().singleResult();
        Assert.assertNotNull((Object)task);
        Assert.assertEquals((Object)taskId, (Object)task.getId());
        this.identityService.clearAuthentication();
        this.identityService.setAuthentication(this.userId, Arrays.asList(this.groupId));
        task = (Task)this.taskService.createTaskQuery().singleResult();
        Assert.assertNotNull((Object)task);
        Assert.assertEquals((Object)taskId, (Object)task.getId());
    }

    @Test
    public void testCaseTaskAddCandidateGroupNoAuthorization() {
        this.testRule.createCaseInstanceByKey(CASE_KEY);
        String taskId = this.selectSingleTask().getId();
        this.createGrantAuthorization((Resource)Resources.TASK, taskId, this.userId, new Permission[]{Permissions.UPDATE});
        this.taskService.addCandidateGroup(taskId, "management");
        this.disableAuthorization();
        Authorization authorization = (Authorization)this.authorizationService.createAuthorizationQuery().groupIdIn(new String[]{"management"}).singleResult();
        this.enableAuthorization();
        Assert.assertNull((Object)authorization);
    }

    @Test
    public void testCaseTaskGetVariable() {
        this.testRule.createCaseInstanceByKey(CASE_KEY, this.getVariables());
        String taskId = this.selectSingleTask().getId();
        Object variable = this.taskService.getVariable(taskId, "aVariableName");
        Assert.assertEquals((Object)"aVariableValue", (Object)variable);
    }

    @Test
    public void testCaseTaskGetVariableLocal() {
        this.testRule.createCaseInstanceByKey(CASE_KEY, this.getVariables());
        String taskId = this.selectSingleTask().getId();
        this.disableAuthorization();
        this.taskService.setVariablesLocal(taskId, (Map)this.getVariables());
        this.enableAuthorization();
        Object variable = this.taskService.getVariableLocal(taskId, "aVariableName");
        Assert.assertEquals((Object)"aVariableValue", (Object)variable);
    }

    @Test
    public void testCaseTaskGetVariableTyped() {
        this.testRule.createCaseInstanceByKey(CASE_KEY, this.getVariables());
        String taskId = this.selectSingleTask().getId();
        TypedValue typedValue = this.taskService.getVariableTyped(taskId, "aVariableName");
        Assert.assertNotNull((Object)typedValue);
        Assert.assertEquals((Object)"aVariableValue", (Object)typedValue.getValue());
    }

    @Test
    public void testCaseTaskGetVariableLocalTyped() {
        this.testRule.createCaseInstanceByKey(CASE_KEY, this.getVariables());
        String taskId = this.selectSingleTask().getId();
        this.disableAuthorization();
        this.taskService.setVariablesLocal(taskId, (Map)this.getVariables());
        this.enableAuthorization();
        TypedValue typedValue = this.taskService.getVariableLocalTyped(taskId, "aVariableName");
        Assert.assertNotNull((Object)typedValue);
        Assert.assertEquals((Object)"aVariableValue", (Object)typedValue.getValue());
    }

    @Test
    public void testCaseTaskGetVariables() {
        this.testRule.createCaseInstanceByKey(CASE_KEY, this.getVariables());
        String taskId = this.selectSingleTask().getId();
        Map variables = this.taskService.getVariables(taskId);
        Assert.assertNotNull((Object)variables);
        Assert.assertFalse((boolean)variables.isEmpty());
        Assert.assertEquals((long)1L, (long)variables.size());
        Assert.assertEquals((Object)"aVariableValue", variables.get("aVariableName"));
    }

    @Test
    public void testCaseTaskGetVariablesLocal() {
        this.testRule.createCaseInstanceByKey(CASE_KEY);
        String taskId = this.selectSingleTask().getId();
        this.disableAuthorization();
        this.taskService.setVariablesLocal(taskId, (Map)this.getVariables());
        this.enableAuthorization();
        Map variables = this.taskService.getVariablesLocal(taskId);
        Assert.assertNotNull((Object)variables);
        Assert.assertFalse((boolean)variables.isEmpty());
        Assert.assertEquals((long)1L, (long)variables.size());
        Assert.assertEquals((Object)"aVariableValue", variables.get("aVariableName"));
    }

    @Test
    public void testCaseTaskGetVariablesTyped() {
        this.testRule.createCaseInstanceByKey(CASE_KEY, this.getVariables());
        String taskId = this.selectSingleTask().getId();
        VariableMap variables = this.taskService.getVariablesTyped(taskId);
        Assert.assertNotNull((Object)variables);
        Assert.assertFalse((boolean)variables.isEmpty());
        Assert.assertEquals((long)1L, (long)variables.size());
        Assert.assertEquals((Object)"aVariableValue", (Object)variables.get((Object)"aVariableName"));
    }

    @Test
    public void testCaseTaskGetVariablesLocalTyped() {
        this.testRule.createCaseInstanceByKey(CASE_KEY);
        String taskId = this.selectSingleTask().getId();
        this.disableAuthorization();
        this.taskService.setVariablesLocal(taskId, (Map)this.getVariables());
        this.enableAuthorization();
        VariableMap variables = this.taskService.getVariablesLocalTyped(taskId);
        Assert.assertNotNull((Object)variables);
        Assert.assertFalse((boolean)variables.isEmpty());
        Assert.assertEquals((long)1L, (long)variables.size());
        Assert.assertEquals((Object)"aVariableValue", variables.get("aVariableName"));
    }

    @Test
    public void testCaseTaskGetVariablesByName() {
        this.testRule.createCaseInstanceByKey(CASE_KEY, this.getVariables());
        String taskId = this.selectSingleTask().getId();
        Map variables = this.taskService.getVariables(taskId, Arrays.asList("aVariableName"));
        Assert.assertNotNull((Object)variables);
        Assert.assertFalse((boolean)variables.isEmpty());
        Assert.assertEquals((long)1L, (long)variables.size());
        Assert.assertEquals((Object)"aVariableValue", variables.get("aVariableName"));
    }

    @Test
    public void testCaseTaskGetVariablesLocalByName() {
        this.testRule.createCaseInstanceByKey(CASE_KEY);
        String taskId = this.selectSingleTask().getId();
        this.disableAuthorization();
        this.taskService.setVariablesLocal(taskId, (Map)this.getVariables());
        this.enableAuthorization();
        Map variables = this.taskService.getVariablesLocal(taskId, Arrays.asList("aVariableName"));
        Assert.assertNotNull((Object)variables);
        Assert.assertFalse((boolean)variables.isEmpty());
        Assert.assertEquals((long)1L, (long)variables.size());
        Assert.assertEquals((Object)"aVariableValue", variables.get("aVariableName"));
    }

    @Test
    public void testCaseTaskGetVariablesTypedByName() {
        this.testRule.createCaseInstanceByKey(CASE_KEY, this.getVariables());
        String taskId = this.selectSingleTask().getId();
        VariableMap variables = this.taskService.getVariablesTyped(taskId, Arrays.asList("aVariableName"), false);
        Assert.assertNotNull((Object)variables);
        Assert.assertFalse((boolean)variables.isEmpty());
        Assert.assertEquals((long)1L, (long)variables.size());
        Assert.assertEquals((Object)"aVariableValue", (Object)variables.get((Object)"aVariableName"));
    }

    @Test
    public void testCaseTaskGetVariablesLocalTypedByName() {
        this.testRule.createCaseInstanceByKey(CASE_KEY);
        String taskId = this.selectSingleTask().getId();
        this.disableAuthorization();
        this.taskService.setVariablesLocal(taskId, (Map)this.getVariables());
        this.enableAuthorization();
        VariableMap variables = this.taskService.getVariablesLocalTyped(taskId, Arrays.asList("aVariableName"), false);
        Assert.assertNotNull((Object)variables);
        Assert.assertFalse((boolean)variables.isEmpty());
        Assert.assertEquals((long)1L, (long)variables.size());
        Assert.assertEquals((Object)"aVariableValue", variables.get("aVariableName"));
    }

    @Test
    public void testCaseTaskSetVariable() {
        this.testRule.createCaseInstanceByKey(CASE_KEY);
        String taskId = this.selectSingleTask().getId();
        this.verifySetVariable(taskId);
    }

    @Test
    public void testCaseTaskSetVariableLocal() {
        this.testRule.createCaseInstanceByKey(CASE_KEY);
        String taskId = this.selectSingleTask().getId();
        this.verifySetVariableLocal(taskId);
    }

    @Test
    public void testCaseTaskSetVariables() {
        this.testRule.createCaseInstanceByKey(CASE_KEY);
        String taskId = this.selectSingleTask().getId();
        this.verifySetVariables(taskId);
    }

    @Test
    public void testCaseTaskSetVariablesLocal() {
        this.testRule.createCaseInstanceByKey(CASE_KEY);
        String taskId = this.selectSingleTask().getId();
        this.verifySetVariablesLocal(taskId);
    }

    @Test
    public void testCaseTaskRemoveVariable() {
        this.testRule.createCaseInstanceByKey(CASE_KEY, this.getVariables());
        String taskId = this.selectSingleTask().getId();
        this.verifyRemoveVariable(taskId);
    }

    @Test
    public void testCaseTaskRemoveVariableLocal() {
        this.testRule.createCaseInstanceByKey(CASE_KEY);
        String taskId = this.selectSingleTask().getId();
        this.disableAuthorization();
        this.taskService.setVariableLocal(taskId, "aVariableName", (Object)"aVariableValue");
        this.enableAuthorization();
        this.verifyRemoveVariableLocal(taskId);
    }

    @Test
    public void testCaseTaskRemoveVariables() {
        this.testRule.createCaseInstanceByKey(CASE_KEY, this.getVariables());
        String taskId = this.selectSingleTask().getId();
        this.verifyRemoveVariables(taskId);
    }

    @Test
    public void testCaseTaskRemoveVariablesLocal() {
        this.testRule.createCaseInstanceByKey(CASE_KEY);
        String taskId = this.selectSingleTask().getId();
        this.disableAuthorization();
        this.taskService.setVariableLocal(taskId, "aVariableName", (Object)"aVariableValue");
        this.enableAuthorization();
        this.verifyRemoveVariablesLocal(taskId);
    }

    @Test
    public void testCaseTaskUpdateVariablesLocal() {
        this.testRule.createCaseInstanceByKey(CASE_KEY);
        String taskId = this.selectSingleTask().getId();
        this.verifyUpdateVariablesLocal(taskId);
    }

    @Test
    public void testCaseTaskUpdateVariables() {
        this.testRule.createCaseInstanceByKey(CASE_KEY);
        String taskId = this.selectSingleTask().getId();
        this.verifyUpdateVariables(taskId);
    }

    @Test
    public void testStandaloneTaskSaveWithGenericResourceIdOwner() {
        this.createGrantAuthorization((Resource)Resources.TASK, "*", this.userId, new Permission[]{Permissions.CREATE});
        Task task = this.taskService.newTask();
        task.setOwner("*");
        try {
            this.taskService.saveTask(task);
            Assert.fail((String)"it should not be possible to save a task with the generic resource id *");
        }
        catch (ProcessEngineException e) {
            this.testRule.assertTextPresent("Cannot create default authorization for owner *: id cannot be *. * is a reserved identifier", e.getMessage());
        }
    }

    @Test
    public void testStandaloneTaskSaveWithGenericResourceIdOwnerTaskServiceApi() {
        this.createGrantAuthorization((Resource)Resources.TASK, "*", this.userId, new Permission[]{Permissions.CREATE, Permissions.UPDATE});
        Task task = this.taskService.newTask();
        this.taskService.saveTask(task);
        try {
            this.taskService.setOwner(task.getId(), "*");
            Assert.fail((String)"exception expected");
        }
        catch (ProcessEngineException e) {
            this.testRule.assertTextPresent("Cannot create default authorization for owner *: id cannot be *. * is a reserved identifier", e.getMessage());
        }
        this.deleteTask(task.getId(), true);
    }

    @Test
    public void testStandaloneTaskSaveWithGenericResourceIdAssignee() {
        this.createGrantAuthorization((Resource)Resources.TASK, "*", this.userId, new Permission[]{Permissions.CREATE});
        Task task = this.taskService.newTask();
        task.setAssignee("*");
        try {
            this.taskService.saveTask(task);
            Assert.fail((String)"it should not be possible to save a task with the generic resource id *");
        }
        catch (ProcessEngineException e) {
            this.testRule.assertTextPresent("Cannot create default authorization for assignee *: id cannot be *. * is a reserved identifier", e.getMessage());
        }
    }

    @Test
    public void testStandaloneTaskSaveWithGenericResourceIdAssigneeTaskServiceApi() {
        this.createGrantAuthorization((Resource)Resources.TASK, "*", this.userId, new Permission[]{Permissions.CREATE, Permissions.UPDATE});
        Task task = this.taskService.newTask();
        this.taskService.saveTask(task);
        try {
            this.taskService.setAssignee(task.getId(), "*");
            Assert.fail((String)"exception expected");
        }
        catch (ProcessEngineException e) {
            this.testRule.assertTextPresent("Cannot create default authorization for assignee *: id cannot be *. * is a reserved identifier", e.getMessage());
        }
        this.deleteTask(task.getId(), true);
    }

    @Test
    public void testStandaloneTaskSaveIdentityLinkWithGenericUserId() {
        this.createGrantAuthorization((Resource)Resources.TASK, "*", this.userId, new Permission[]{Permissions.CREATE, Permissions.UPDATE});
        Task task = this.taskService.newTask();
        this.taskService.saveTask(task);
        try {
            this.taskService.addUserIdentityLink(task.getId(), "*", "someLink");
            Assert.fail((String)"exception expected");
        }
        catch (ProcessEngineException e) {
            this.testRule.assertTextPresent("Cannot grant default authorization for identity link to user *: id cannot be *. * is a reserved identifier.", e.getMessage());
        }
        this.deleteTask(task.getId(), true);
    }

    @Test
    public void testStandaloneTaskSaveIdentityLinkWithGenericGroupId() {
        this.createGrantAuthorization((Resource)Resources.TASK, "*", this.userId, new Permission[]{Permissions.CREATE, Permissions.UPDATE});
        Task task = this.taskService.newTask();
        this.taskService.saveTask(task);
        try {
            this.taskService.addGroupIdentityLink(task.getId(), "*", "someLink");
            Assert.fail((String)"exception expected");
        }
        catch (ProcessEngineException e) {
            this.testRule.assertTextPresent("Cannot grant default authorization for identity link to group *: id cannot be *. * is a reserved identifier.", e.getMessage());
        }
        this.deleteTask(task.getId(), true);
    }

    @Test
    public void testStandaloneTaskSaveIdentityLinkWithGenericGroupIdAndTaskAssignPermission() {
        this.createGrantAuthorization((Resource)Resources.TASK, "*", this.userId, new Permission[]{Permissions.CREATE, Permissions.TASK_ASSIGN});
        Task task = this.taskService.newTask();
        this.taskService.saveTask(task);
        try {
            this.taskService.addGroupIdentityLink(task.getId(), "*", "someLink");
            Assert.fail((String)"exception expected");
        }
        catch (ProcessEngineException e) {
            this.testRule.assertTextPresent("Cannot grant default authorization for identity link to group *: id cannot be *. * is a reserved identifier.", e.getMessage());
        }
        this.deleteTask(task.getId(), true);
    }

    @Test
    public void testStandaloneTaskSaveIdentityLinkWithGenericTaskId() {
        this.createGrantAuthorization((Resource)Resources.TASK, "*", this.userId, new Permission[]{Permissions.CREATE, Permissions.UPDATE});
        Task task = this.taskService.newTask();
        this.taskService.saveTask(task);
        try {
            this.taskService.addUserIdentityLink("*", "aUserId", "someLink");
            Assert.fail((String)"exception expected");
        }
        catch (ProcessEngineException e) {
            this.testRule.assertTextPresent("Cannot find task with id *", e.getMessage());
        }
        try {
            this.taskService.addGroupIdentityLink("*", "aGroupId", "someLink");
            Assert.fail((String)"exception expected");
        }
        catch (ProcessEngineException e) {
            this.testRule.assertTextPresent("Cannot find task with id *", e.getMessage());
        }
        this.deleteTask(task.getId(), true);
    }

    @Test
    public void testStandaloneTaskSaveIdentityLinkWithGenericTaskIdAndTaskAssignPermission() {
        this.createGrantAuthorization((Resource)Resources.TASK, "*", this.userId, new Permission[]{Permissions.CREATE, Permissions.TASK_ASSIGN});
        Task task = this.taskService.newTask();
        this.taskService.saveTask(task);
        try {
            this.taskService.addUserIdentityLink("*", "aUserId", "someLink");
            Assert.fail((String)"exception expected");
        }
        catch (ProcessEngineException e) {
            this.testRule.assertTextPresent("Cannot find task with id *", e.getMessage());
        }
        try {
            this.taskService.addGroupIdentityLink("*", "aGroupId", "someLink");
            Assert.fail((String)"exception expected");
        }
        catch (ProcessEngineException e) {
            this.testRule.assertTextPresent("Cannot find task with id *", e.getMessage());
        }
        this.deleteTask(task.getId(), true);
    }

    @Deployment
    @Test
    public void testSetGenericResourceIdAssignee() {
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, "*", this.userId, new Permission[]{Permissions.CREATE_INSTANCE});
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, "*", this.userId, new Permission[]{Permissions.CREATE});
        try {
            this.runtimeService.startProcessInstanceByKey("genericResourceIdAssignmentProcess");
            Assert.fail((String)"exception expected");
        }
        catch (ProcessEngineException e) {
            this.testRule.assertTextPresent("Cannot create default authorization for assignee *: id cannot be *. * is a reserved identifier.", e.getMessage());
        }
    }

    @Test
    public void testAssignSameAssigneeAndOwnerToTask() {
        this.createGrantAuthorization((Resource)Resources.TASK, "*", this.userId, new Permission[]{Permissions.ALL});
        Task newTask = this.taskService.newTask();
        newTask.setAssignee("Horst");
        newTask.setOwner("Horst");
        try {
            this.taskService.saveTask(newTask);
        }
        catch (Exception e) {
            Assert.fail((String)"Setting same assignee and owner to user should not fail!");
        }
        this.taskService.deleteTask(newTask.getId(), true);
    }

    @Test
    public void testPermissionsOnAssignSameAssigneeAndOwnerToTask() {
        try {
            this.createGrantAuthorization((Resource)Resources.TASK, "*", this.userId, new Permission[]{Permissions.CREATE, Permissions.DELETE, Permissions.READ});
            this.processEngineConfiguration.setResourceAuthorizationProvider((ResourceAuthorizationProvider)new MyExtendedPermissionDefaultAuthorizationProvider());
            Task newTask = this.taskService.newTask();
            newTask.setAssignee("Horst");
            newTask.setOwner("Horst");
            this.taskService.saveTask(newTask);
            Authorization auth = (Authorization)this.authorizationService.createAuthorizationQuery().userIdIn(new String[]{"Horst"}).singleResult();
            Assert.assertTrue((boolean)auth.isPermissionGranted((Permission)Permissions.DELETE));
            this.taskService.deleteTask(newTask.getId(), true);
        }
        finally {
            this.processEngineConfiguration.setResourceAuthorizationProvider((ResourceAuthorizationProvider)new DefaultAuthorizationProvider());
        }
    }

    @Deployment
    @Test
    public void testAssignSameAssigneeAndOwnerToProcess() {
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, "*", this.userId, new Permission[]{Permissions.ALL});
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, "*", this.userId, new Permission[]{Permissions.ALL});
        this.runtimeService.startProcessInstanceByKey("process");
        List auths = this.authorizationService.createAuthorizationQuery().userIdIn(new String[]{"horst"}).list();
        Assert.assertTrue((auths.size() == 1 ? 1 : 0) != 0);
    }

    @Deployment
    @Test
    public void testAssignSameUserToProcessTwice() {
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, "*", this.userId, new Permission[]{Permissions.ALL});
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, "*", this.userId, new Permission[]{Permissions.ALL});
        this.runtimeService.startProcessInstanceByKey("process");
        List auths = this.authorizationService.createAuthorizationQuery().userIdIn(new String[]{"hans"}).list();
        Assert.assertTrue((auths.size() == 1 ? 1 : 0) != 0);
    }

    @Deployment
    @Test
    public void testAssignSameGroupToProcessTwice() {
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, "*", this.userId, new Permission[]{Permissions.ALL});
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, "*", this.userId, new Permission[]{Permissions.ALL});
        this.runtimeService.startProcessInstanceByKey("process");
        List auths = this.authorizationService.createAuthorizationQuery().groupIdIn(new String[]{"abc"}).list();
        Assert.assertTrue((auths.size() == 1 ? 1 : 0) != 0);
    }

    protected void verifyQueryResults(TaskQuery query, int countExpected) {
        this.verifyQueryResults((Query<?, ?>)((AbstractQuery)query), countExpected);
    }

    protected void verifyQueryResults(VariableInstanceQuery query, int countExpected) {
        this.verifyQueryResults((Query<?, ?>)((AbstractQuery)query), countExpected);
    }

    protected void verifyMessageIsValid(String taskId, String message) {
        this.testRule.assertTextPresent(this.userId, message);
        this.testRule.assertTextPresent(Permissions.UPDATE.getName(), message);
        this.testRule.assertTextPresent(TaskPermissions.UPDATE_VARIABLE.getName(), message);
        this.testRule.assertTextPresent(taskId, message);
        this.testRule.assertTextPresent(Resources.TASK.resourceName(), message);
        this.testRule.assertTextPresent(Permissions.UPDATE_TASK.getName(), message);
        this.testRule.assertTextPresent(ProcessDefinitionPermissions.UPDATE_TASK_VARIABLE.getName(), message);
        this.testRule.assertTextPresent(PROCESS_KEY, message);
        this.testRule.assertTextPresent(Resources.PROCESS_DEFINITION.resourceName(), message);
    }

    protected void verifyVariableInstanceCountDisabledAuthorization(int count) {
        this.disableAuthorization();
        this.verifyQueryResults(this.runtimeService.createVariableInstanceQuery(), count);
        this.enableAuthorization();
    }

    protected void verifySetVariable(String taskId) {
        this.taskService.setVariable(taskId, "aVariableName", (Object)"aVariableValue");
        this.verifyVariableInstanceCountDisabledAuthorization(1);
    }

    protected void verifySetVariableLocal(String taskId) {
        this.taskService.setVariableLocal(taskId, "aVariableName", (Object)"aVariableValue");
        this.verifyVariableInstanceCountDisabledAuthorization(1);
    }

    protected void verifySetVariables(String taskId) {
        this.taskService.setVariables(taskId, (Map)this.getVariables());
        this.verifyVariableInstanceCountDisabledAuthorization(1);
    }

    protected void verifySetVariablesLocal(String taskId) {
        this.taskService.setVariablesLocal(taskId, (Map)this.getVariables());
        this.verifyVariableInstanceCountDisabledAuthorization(1);
    }

    protected void verifyRemoveVariable(String taskId) {
        this.taskService.removeVariable(taskId, "aVariableName");
        this.verifyVariableInstanceCountDisabledAuthorization(0);
    }

    protected void verifyRemoveVariableLocal(String taskId) {
        this.taskService.removeVariableLocal(taskId, "aVariableName");
        this.verifyVariableInstanceCountDisabledAuthorization(0);
    }

    protected void verifyRemoveVariables(String taskId) {
        this.taskService.removeVariables(taskId, Arrays.asList("aVariableName"));
        this.verifyVariableInstanceCountDisabledAuthorization(0);
    }

    protected void verifyRemoveVariablesLocal(String taskId) {
        this.taskService.removeVariablesLocal(taskId, Arrays.asList("aVariableName"));
        this.verifyVariableInstanceCountDisabledAuthorization(0);
    }

    protected void verifyUpdateVariables(String taskId) {
        ((TaskServiceImpl)this.taskService).updateVariables(taskId, (Map)this.getVariables(), null);
        this.verifyVariableInstanceCountDisabledAuthorization(1);
        ((TaskServiceImpl)this.taskService).updateVariables(taskId, null, Arrays.asList("aVariableName"));
        this.verifyVariableInstanceCountDisabledAuthorization(0);
        ((TaskServiceImpl)this.taskService).updateVariables(taskId, (Map)this.getVariables(), Arrays.asList("aVariableName"));
        this.verifyVariableInstanceCountDisabledAuthorization(0);
    }

    protected void verifyUpdateVariablesLocal(String taskId) {
        ((TaskServiceImpl)this.taskService).updateVariablesLocal(taskId, (Map)this.getVariables(), null);
        this.verifyVariableInstanceCountDisabledAuthorization(1);
        ((TaskServiceImpl)this.taskService).updateVariablesLocal(taskId, null, Arrays.asList("aVariableName"));
        this.verifyVariableInstanceCountDisabledAuthorization(0);
        ((TaskServiceImpl)this.taskService).updateVariablesLocal(taskId, (Map)this.getVariables(), Arrays.asList("aVariableName"));
        this.verifyVariableInstanceCountDisabledAuthorization(0);
    }

    protected void verifyGetVariables(Map<String, Object> variables) {
        Assert.assertNotNull(variables);
        Assert.assertFalse((boolean)variables.isEmpty());
        Assert.assertEquals((long)1L, (long)variables.size());
        Assert.assertEquals((Object)"aVariableValue", (Object)variables.get("aVariableName"));
    }
}

