/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.authorization.batch.creation.removaltime;

import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import org.camunda.bpm.engine.authorization.BatchPermissions;
import org.camunda.bpm.engine.authorization.Permission;
import org.camunda.bpm.engine.authorization.Permissions;
import org.camunda.bpm.engine.authorization.Resource;
import org.camunda.bpm.engine.authorization.Resources;
import org.camunda.bpm.engine.batch.history.HistoricBatchQuery;
import org.camunda.bpm.engine.test.RequiredHistoryLevel;
import org.camunda.bpm.engine.test.api.authorization.batch.creation.BatchCreationAuthorizationTest;
import org.camunda.bpm.engine.test.api.authorization.util.AuthorizationScenario;
import org.camunda.bpm.engine.test.api.authorization.util.AuthorizationSpec;
import org.camunda.bpm.engine.test.api.authorization.util.AuthorizationTestRule;
import org.junit.Test;
import org.junit.runners.Parameterized;

public class SetRemovalTimeForHistoricBatchesBatchAuthorizationTest
extends BatchCreationAuthorizationTest {
    @Parameterized.Parameters(name="Scenario {index}")
    public static Collection<AuthorizationScenario[]> scenarios() {
        return AuthorizationTestRule.asParameters(AuthorizationScenario.scenario().withAuthorizations(AuthorizationSpec.grant((Resource)Resources.BATCH, "batchId", "userId", new Permission[]{Permissions.READ_HISTORY})).failsDueToRequired(AuthorizationSpec.grant((Resource)Resources.BATCH, "batchId", "userId", new Permission[]{Permissions.CREATE}), AuthorizationSpec.grant((Resource)Resources.BATCH, "batchId", "userId", new Permission[]{BatchPermissions.CREATE_BATCH_SET_REMOVAL_TIME})), AuthorizationScenario.scenario().withAuthorizations(AuthorizationSpec.grant((Resource)Resources.BATCH, "batchId", "userId", new Permission[]{Permissions.READ_HISTORY, Permissions.CREATE})), AuthorizationScenario.scenario().withAuthorizations(AuthorizationSpec.grant((Resource)Resources.BATCH, "batchId", "userId", new Permission[]{Permissions.READ_HISTORY, BatchPermissions.CREATE_BATCH_SET_REMOVAL_TIME})).succeeds());
    }

    @Test
    @RequiredHistoryLevel(value="full")
    public void shouldAuthorizeSetRemovalTimeForHistoricBatchesBatch() {
        String batchId = this.engineRule.getHistoryService().deleteHistoricProcessInstancesAsync(Collections.singletonList(this.processInstance.getId()), "aDeleteReason").getId();
        this.authRule.init(this.scenario).withUser("userId").bindResource("batchId", "*").start();
        HistoricBatchQuery query = this.historyService.createHistoricBatchQuery().batchId(batchId);
        this.historyService.setRemovalTimeToHistoricBatches().absoluteRemovalTime(new Date()).byQuery(query).executeAsync();
        this.authRule.assertScenario(this.scenario);
        this.managementService.deleteBatch(batchId, true);
    }
}

