/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.authorization.history;

import java.util.List;
import org.assertj.core.api.Assertions;
import org.camunda.bpm.engine.AuthorizationException;
import org.camunda.bpm.engine.authorization.HistoricProcessInstancePermissions;
import org.camunda.bpm.engine.authorization.Permission;
import org.camunda.bpm.engine.authorization.Permissions;
import org.camunda.bpm.engine.authorization.ProcessDefinitionPermissions;
import org.camunda.bpm.engine.authorization.Resource;
import org.camunda.bpm.engine.authorization.Resources;
import org.camunda.bpm.engine.externaltask.ExternalTask;
import org.camunda.bpm.engine.externaltask.LockedExternalTask;
import org.camunda.bpm.engine.history.HistoricExternalTaskLog;
import org.camunda.bpm.engine.history.HistoricExternalTaskLogQuery;
import org.camunda.bpm.engine.query.Query;
import org.camunda.bpm.engine.runtime.ProcessInstance;
import org.camunda.bpm.engine.test.RequiredHistoryLevel;
import org.camunda.bpm.engine.test.api.authorization.AuthorizationTest;
import org.camunda.bpm.engine.test.api.runtime.migration.models.builder.DefaultExternalTaskModelBuilder;
import org.camunda.bpm.model.bpmn.BpmnModelInstance;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

@RequiredHistoryLevel(value="full")
public class HistoricExternalTaskLogAuthorizationTest
extends AuthorizationTest {
    protected final String WORKER_ID = "aWorkerId";
    protected final long LOCK_DURATION = 300000L;
    protected final String ERROR_DETAILS = "These are the error details!";
    protected final String ANOTHER_PROCESS_KEY = "AnotherProcess";

    @Override
    @Before
    public void setUp() throws Exception {
        BpmnModelInstance defaultModel = DefaultExternalTaskModelBuilder.createDefaultExternalTaskModel().build();
        BpmnModelInstance modifiedModel = DefaultExternalTaskModelBuilder.createDefaultExternalTaskModel().processKey("AnotherProcess").build();
        this.testRule.deploy(defaultModel, modifiedModel);
        super.setUp();
    }

    @Override
    @After
    public void tearDown() {
        super.tearDown();
        this.processEngineConfiguration.setEnableHistoricInstancePermissions(false);
    }

    @Test
    public void testSimpleQueryWithoutAuthorization() {
        this.startProcessInstanceByKey("Process");
        HistoricExternalTaskLogQuery query = this.historyService.createHistoricExternalTaskLogQuery();
        this.verifyQueryResults((Query<?, ?>)query, 0);
    }

    @Test
    public void testSimpleQueryWithHistoryReadPermissionOnProcessDefinition() {
        this.startProcessInstanceByKey("Process");
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, "Process", this.userId, new Permission[]{Permissions.READ_HISTORY});
        HistoricExternalTaskLogQuery query = this.historyService.createHistoricExternalTaskLogQuery();
        this.verifyQueryResults((Query<?, ?>)query, 1);
    }

    @Test
    public void testSimpleQueryWithHistoryReadPermissionOnAnyProcessDefinition() {
        this.startProcessInstanceByKey("Process");
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, "*", this.userId, new Permission[]{Permissions.READ_HISTORY});
        HistoricExternalTaskLogQuery query = this.historyService.createHistoricExternalTaskLogQuery();
        this.verifyQueryResults((Query<?, ?>)query, 1);
    }

    @Test
    public void testSimpleQueryWithMultipleAuthorizations() {
        this.startProcessInstanceByKey("Process");
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, "*", this.userId, new Permission[]{Permissions.READ_HISTORY});
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, "Process", this.userId, new Permission[]{Permissions.READ_HISTORY});
        HistoricExternalTaskLogQuery query = this.historyService.createHistoricExternalTaskLogQuery();
        this.verifyQueryResults((Query<?, ?>)query, 1);
    }

    @Test
    public void testQueryWithoutAuthorization() {
        this.startThreeProcessInstancesDeleteOneAndCompleteTwoWithFailure();
        HistoricExternalTaskLogQuery query = this.historyService.createHistoricExternalTaskLogQuery();
        this.verifyQueryResults((Query<?, ?>)query, 0);
    }

    @Test
    public void testQueryWithHistoryReadPermissionOnOneProcessDefinition() {
        this.startThreeProcessInstancesDeleteOneAndCompleteTwoWithFailure();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, "Process", this.userId, new Permission[]{Permissions.READ_HISTORY});
        HistoricExternalTaskLogQuery query = this.historyService.createHistoricExternalTaskLogQuery();
        this.verifyQueryResults((Query<?, ?>)query, 6);
    }

    @Test
    public void testQueryWithHistoryReadPermissionOnAnyProcessDefinition() {
        this.startThreeProcessInstancesDeleteOneAndCompleteTwoWithFailure();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, "*", this.userId, new Permission[]{Permissions.READ_HISTORY});
        HistoricExternalTaskLogQuery query = this.historyService.createHistoricExternalTaskLogQuery();
        this.verifyQueryResults((Query<?, ?>)query, 8);
    }

    @Test
    public void testGetErrorDetailsWithoutAuthorization() {
        this.startThreeProcessInstancesDeleteOneAndCompleteTwoWithFailure();
        this.disableAuthorization();
        String failedHistoricExternalTaskLogId = ((HistoricExternalTaskLog)this.historyService.createHistoricExternalTaskLogQuery().failureLog().list().get(0)).getId();
        this.enableAuthorization();
        try {
            String stacktrace = this.historyService.getHistoricExternalTaskLogErrorDetails(failedHistoricExternalTaskLogId);
            Assert.fail((String)"Exception expected: It should not be possible to retrieve the error details");
        }
        catch (AuthorizationException e) {
            String exceptionMessage = e.getMessage();
            this.testRule.assertTextPresent(this.userId, exceptionMessage);
            this.testRule.assertTextPresent(Permissions.READ_HISTORY.getName(), exceptionMessage);
            this.testRule.assertTextPresent("Process", exceptionMessage);
            this.testRule.assertTextPresent(Resources.PROCESS_DEFINITION.resourceName(), exceptionMessage);
        }
    }

    @Test
    public void testGetErrorDetailsWithHistoryReadPermissionOnProcessDefinition() {
        this.startThreeProcessInstancesDeleteOneAndCompleteTwoWithFailure();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, "Process", this.userId, new Permission[]{Permissions.READ_HISTORY});
        String failedHistoricExternalTaskLogId = ((HistoricExternalTaskLog)this.historyService.createHistoricExternalTaskLogQuery().failureLog().list().get(0)).getId();
        String stacktrace = this.historyService.getHistoricExternalTaskLogErrorDetails(failedHistoricExternalTaskLogId);
        Assert.assertNotNull((Object)stacktrace);
        Assert.assertEquals((Object)"These are the error details!", (Object)stacktrace);
    }

    @Test
    public void testGetErrorDetailsWithHistoryReadPermissionOnProcessAnyDefinition() {
        this.startThreeProcessInstancesDeleteOneAndCompleteTwoWithFailure();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, "*", this.userId, new Permission[]{Permissions.READ_HISTORY});
        String failedHistoricExternalTaskLogId = ((HistoricExternalTaskLog)this.historyService.createHistoricExternalTaskLogQuery().failureLog().list().get(0)).getId();
        String stacktrace = this.historyService.getHistoricExternalTaskLogErrorDetails(failedHistoricExternalTaskLogId);
        Assert.assertNotNull((Object)stacktrace);
        Assert.assertEquals((Object)"These are the error details!", (Object)stacktrace);
    }

    @Test
    public void testCheckNonePermissionOnHistoricProcessInstance() {
        this.processEngineConfiguration.setEnableHistoricInstancePermissions(true);
        String processInstanceId = this.startProcessAndExecuteJob("Process").getProcessInstanceId();
        this.createGrantAuthorization((Resource)Resources.HISTORIC_PROCESS_INSTANCE, processInstanceId, this.userId, new Permission[]{HistoricProcessInstancePermissions.NONE});
        HistoricExternalTaskLogQuery query = this.historyService.createHistoricExternalTaskLogQuery();
        Assertions.assertThat((List)query.list()).isEmpty();
    }

    @Test
    public void testCheckReadPermissionOnHistoricProcessInstance() {
        this.processEngineConfiguration.setEnableHistoricInstancePermissions(true);
        String processInstanceId = this.startProcessAndExecuteJob("Process").getProcessInstanceId();
        this.createGrantAuthorization((Resource)Resources.HISTORIC_PROCESS_INSTANCE, processInstanceId, this.userId, new Permission[]{HistoricProcessInstancePermissions.READ});
        HistoricExternalTaskLogQuery query = this.historyService.createHistoricExternalTaskLogQuery();
        Assertions.assertThat((List)query.list()).extracting("processInstanceId").containsExactly(new Object[]{processInstanceId});
    }

    @Test
    public void testCheckNoneOnHistoricProcessInstanceAndReadHistoryPermissionOnProcessDefinition() {
        this.processEngineConfiguration.setEnableHistoricInstancePermissions(true);
        String processInstanceId = this.startProcessAndExecuteJob("Process").getProcessInstanceId();
        this.createGrantAuthorization((Resource)Resources.HISTORIC_PROCESS_INSTANCE, processInstanceId, this.userId, new Permission[]{HistoricProcessInstancePermissions.NONE});
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, "Process", this.userId, new Permission[]{ProcessDefinitionPermissions.READ_HISTORY});
        HistoricExternalTaskLogQuery query = this.historyService.createHistoricExternalTaskLogQuery();
        Assertions.assertThat((List)query.list()).extracting("processInstanceId").containsExactly(new Object[]{processInstanceId});
    }

    @Test
    public void testCheckReadOnHistoricProcessInstanceAndNonePermissionOnProcessDefinition() {
        this.processEngineConfiguration.setEnableHistoricInstancePermissions(true);
        String processInstanceId = this.startProcessAndExecuteJob("Process").getProcessInstanceId();
        this.createGrantAuthorization((Resource)Resources.HISTORIC_PROCESS_INSTANCE, processInstanceId, this.userId, new Permission[]{HistoricProcessInstancePermissions.READ});
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, "Process", this.userId, new Permission[]{ProcessDefinitionPermissions.NONE});
        HistoricExternalTaskLogQuery query = this.historyService.createHistoricExternalTaskLogQuery();
        Assertions.assertThat((List)query.list()).extracting("processInstanceId").containsExactly(new Object[]{processInstanceId});
    }

    @Test
    public void testHistoricProcessInstancePermissionsAuthorizationDisabled() {
        this.processEngineConfiguration.setEnableHistoricInstancePermissions(true);
        String processInstanceId = this.startProcessAndExecuteJob("Process").getProcessInstanceId();
        this.disableAuthorization();
        HistoricExternalTaskLogQuery query = this.historyService.createHistoricExternalTaskLogQuery();
        Assertions.assertThat((List)query.list()).extracting("processInstanceId").containsExactly(new Object[]{processInstanceId});
    }

    protected void startThreeProcessInstancesDeleteOneAndCompleteTwoWithFailure() {
        this.disableAuthorization();
        ProcessInstance pi1 = this.startProcessInstanceByKey("Process");
        ProcessInstance pi2 = this.startProcessInstanceByKey("Process");
        ProcessInstance pi3 = this.startProcessInstanceByKey("AnotherProcess");
        this.completeExternalTaskWithFailure(pi1);
        this.completeExternalTaskWithFailure(pi2);
        this.runtimeService.deleteProcessInstance(pi3.getId(), "Dummy reason for deletion!");
        this.enableAuthorization();
    }

    protected void completeExternalTaskWithFailure(ProcessInstance pi) {
        ExternalTask task = (ExternalTask)this.externalTaskService.createExternalTaskQuery().processInstanceId(pi.getId()).singleResult();
        this.completeExternalTaskWithFailure(task.getId());
    }

    protected void completeExternalTaskWithFailure(String externalTaskId) {
        List list = this.externalTaskService.fetchAndLock(5, "aWorkerId", false).topic("foo", 300000L).execute();
        this.externalTaskService.handleFailure(externalTaskId, "aWorkerId", "This is an error!", "These are the error details!", 1, 0L);
        this.externalTaskService.complete(externalTaskId, "aWorkerId");
        for (LockedExternalTask lockedExternalTask : list) {
            if (lockedExternalTask.getId().equals(externalTaskId)) continue;
            this.externalTaskService.unlock(lockedExternalTask.getId());
        }
    }
}

