/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.authorization.task.getvariable;

import java.util.Arrays;
import java.util.Map;
import org.camunda.bpm.engine.RuntimeService;
import org.camunda.bpm.engine.TaskService;
import org.camunda.bpm.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.camunda.bpm.engine.task.Task;
import org.camunda.bpm.engine.test.ProcessEngineRule;
import org.camunda.bpm.engine.test.api.authorization.util.AuthorizationScenario;
import org.camunda.bpm.engine.test.api.authorization.util.AuthorizationTestRule;
import org.camunda.bpm.engine.test.util.ProvidedProcessEngineRule;
import org.camunda.bpm.engine.variable.VariableMap;
import org.camunda.bpm.engine.variable.Variables;
import org.camunda.bpm.engine.variable.value.TypedValue;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;
import org.junit.runners.Parameterized;

public abstract class ProcessTaskAuthorizationTest {
    private static final String ONE_TASK_PROCESS = "org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml";
    protected static final String userId = "userId";
    public static final String VARIABLE_NAME = "aVariableName";
    public static final String VARIABLE_VALUE = "aVariableValue";
    protected static final String PROCESS_KEY = "oneTaskProcess";
    public ProcessEngineRule engineRule = new ProvidedProcessEngineRule();
    public AuthorizationTestRule authRule = new AuthorizationTestRule(this.engineRule);
    @Rule
    public RuleChain chain = RuleChain.outerRule((TestRule)this.engineRule).around((TestRule)this.authRule);
    @Parameterized.Parameter
    public AuthorizationScenario scenario;
    protected ProcessEngineConfigurationImpl processEngineConfiguration;
    protected TaskService taskService;
    protected RuntimeService runtimeService;
    protected boolean ensureSpecificVariablePermission;
    protected String deploumentId;

    @Before
    public void setUp() {
        this.processEngineConfiguration = this.engineRule.getProcessEngineConfiguration();
        this.taskService = this.engineRule.getTaskService();
        this.runtimeService = this.engineRule.getRuntimeService();
        this.authRule.createUserAndGroup(userId, "groupId");
        this.deploumentId = this.engineRule.getRepositoryService().createDeployment().addClasspathResource(ONE_TASK_PROCESS).deployWithResult().getId();
    }

    @After
    public void tearDown() {
        this.authRule.deleteUsersAndGroups();
        this.engineRule.getRepositoryService().deleteDeployment(this.deploumentId, true);
    }

    @Test
    public void testGetVariable() {
        this.runtimeService.startProcessInstanceByKey(PROCESS_KEY, (Map)this.getVariables());
        String taskId = ((Task)this.taskService.createTaskQuery().singleResult()).getId();
        this.authRule.init(this.scenario).withUser(userId).bindResource("taskId", taskId).start();
        Object variable = this.taskService.getVariable(taskId, VARIABLE_NAME);
        if (this.authRule.assertScenario(this.scenario)) {
            Assert.assertEquals((Object)VARIABLE_VALUE, (Object)variable);
        }
    }

    @Test
    public void testGetVariableLocal() {
        this.runtimeService.startProcessInstanceByKey(PROCESS_KEY);
        String taskId = ((Task)this.taskService.createTaskQuery().singleResult()).getId();
        this.taskService.setVariablesLocal(taskId, (Map)this.getVariables());
        this.authRule.init(this.scenario).withUser(userId).bindResource("taskId", taskId).start();
        Object variable = this.taskService.getVariableLocal(taskId, VARIABLE_NAME);
        if (this.authRule.assertScenario(this.scenario)) {
            Assert.assertEquals((Object)VARIABLE_VALUE, (Object)variable);
        }
    }

    @Test
    public void testGetVariableTyped() {
        this.runtimeService.startProcessInstanceByKey(PROCESS_KEY, (Map)this.getVariables());
        String taskId = ((Task)this.taskService.createTaskQuery().singleResult()).getId();
        this.authRule.init(this.scenario).withUser(userId).bindResource("taskId", taskId).start();
        TypedValue typedValue = this.taskService.getVariableTyped(taskId, VARIABLE_NAME);
        if (this.authRule.assertScenario(this.scenario)) {
            Assert.assertNotNull((Object)typedValue);
            Assert.assertEquals((Object)VARIABLE_VALUE, (Object)typedValue.getValue());
        }
    }

    @Test
    public void testGetVariableLocalTyped() {
        this.runtimeService.startProcessInstanceByKey(PROCESS_KEY);
        String taskId = ((Task)this.taskService.createTaskQuery().singleResult()).getId();
        this.taskService.setVariablesLocal(taskId, (Map)this.getVariables());
        this.authRule.init(this.scenario).withUser(userId).bindResource("taskId", taskId).start();
        TypedValue typedValue = this.taskService.getVariableLocalTyped(taskId, VARIABLE_NAME);
        if (this.authRule.assertScenario(this.scenario)) {
            Assert.assertNotNull((Object)typedValue);
            Assert.assertEquals((Object)VARIABLE_VALUE, (Object)typedValue.getValue());
        }
    }

    @Test
    public void testGetVariables() {
        this.runtimeService.startProcessInstanceByKey(PROCESS_KEY, (Map)this.getVariables());
        String taskId = ((Task)this.taskService.createTaskQuery().singleResult()).getId();
        this.authRule.init(this.scenario).withUser(userId).bindResource("taskId", taskId).start();
        Map variables = this.taskService.getVariables(taskId);
        if (this.authRule.assertScenario(this.scenario)) {
            this.verifyGetVariables(variables);
        }
    }

    @Test
    public void testGetVariablesLocal() {
        this.runtimeService.startProcessInstanceByKey(PROCESS_KEY);
        String taskId = ((Task)this.taskService.createTaskQuery().singleResult()).getId();
        this.taskService.setVariablesLocal(taskId, (Map)this.getVariables());
        this.authRule.init(this.scenario).withUser(userId).bindResource("taskId", taskId).start();
        Map variables = this.taskService.getVariablesLocal(taskId);
        if (this.authRule.assertScenario(this.scenario)) {
            this.verifyGetVariables(variables);
        }
    }

    @Test
    public void testGetVariablesTyped() {
        this.runtimeService.startProcessInstanceByKey(PROCESS_KEY, (Map)this.getVariables());
        String taskId = ((Task)this.taskService.createTaskQuery().singleResult()).getId();
        this.authRule.init(this.scenario).withUser(userId).bindResource("taskId", taskId).start();
        VariableMap variables = this.taskService.getVariablesTyped(taskId);
        if (this.authRule.assertScenario(this.scenario)) {
            this.verifyGetVariables((Map<String, Object>)variables);
        }
    }

    @Test
    public void testGetVariablesLocalTyped() {
        this.runtimeService.startProcessInstanceByKey(PROCESS_KEY);
        String taskId = ((Task)this.taskService.createTaskQuery().singleResult()).getId();
        this.taskService.setVariablesLocal(taskId, (Map)this.getVariables());
        this.authRule.init(this.scenario).withUser(userId).bindResource("taskId", taskId).start();
        VariableMap variables = this.taskService.getVariablesLocalTyped(taskId);
        if (this.authRule.assertScenario(this.scenario)) {
            this.verifyGetVariables((Map<String, Object>)variables);
        }
    }

    @Test
    public void testGetVariablesByName() {
        this.runtimeService.startProcessInstanceByKey(PROCESS_KEY, (Map)this.getVariables());
        String taskId = ((Task)this.taskService.createTaskQuery().singleResult()).getId();
        this.authRule.init(this.scenario).withUser(userId).bindResource("taskId", taskId).start();
        Map variables = this.taskService.getVariables(taskId, Arrays.asList(VARIABLE_NAME));
        if (this.authRule.assertScenario(this.scenario)) {
            this.verifyGetVariables(variables);
        }
    }

    @Test
    public void testGetVariablesLocalByName() {
        this.runtimeService.startProcessInstanceByKey(PROCESS_KEY);
        String taskId = ((Task)this.taskService.createTaskQuery().singleResult()).getId();
        this.taskService.setVariablesLocal(taskId, (Map)this.getVariables());
        this.authRule.init(this.scenario).withUser(userId).bindResource("taskId", taskId).start();
        Map variables = this.taskService.getVariablesLocal(taskId, Arrays.asList(VARIABLE_NAME));
        if (this.authRule.assertScenario(this.scenario)) {
            this.verifyGetVariables(variables);
        }
    }

    @Test
    public void testGetVariablesTypedByName() {
        this.runtimeService.startProcessInstanceByKey(PROCESS_KEY, (Map)this.getVariables());
        String taskId = ((Task)this.taskService.createTaskQuery().singleResult()).getId();
        this.authRule.init(this.scenario).withUser(userId).bindResource("taskId", taskId).start();
        VariableMap variables = this.taskService.getVariablesTyped(taskId, Arrays.asList(VARIABLE_NAME), false);
        if (this.authRule.assertScenario(this.scenario)) {
            this.verifyGetVariables((Map<String, Object>)variables);
        }
    }

    @Test
    public void testGetVariablesLocalTypedByName() {
        this.runtimeService.startProcessInstanceByKey(PROCESS_KEY);
        String taskId = ((Task)this.taskService.createTaskQuery().singleResult()).getId();
        this.taskService.setVariablesLocal(taskId, (Map)this.getVariables());
        this.authRule.init(this.scenario).withUser(userId).bindResource("taskId", taskId).start();
        VariableMap variables = this.taskService.getVariablesLocalTyped(taskId, Arrays.asList(VARIABLE_NAME), false);
        if (this.authRule.assertScenario(this.scenario)) {
            this.verifyGetVariables((Map<String, Object>)variables);
        }
    }

    protected void createTask(String taskId) {
        Task task = this.taskService.newTask(taskId);
        this.taskService.saveTask(task);
    }

    protected VariableMap getVariables() {
        return Variables.createVariables().putValue(VARIABLE_NAME, (Object)VARIABLE_VALUE);
    }

    protected void verifyGetVariables(Map<String, Object> variables) {
        Assert.assertNotNull(variables);
        Assert.assertFalse((boolean)variables.isEmpty());
        Assert.assertEquals((long)1L, (long)variables.size());
        Assert.assertEquals((Object)VARIABLE_VALUE, (Object)variables.get(VARIABLE_NAME));
    }
}

