/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.optimize;

import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import junit.framework.TestCase;
import org.camunda.bpm.engine.AuthorizationService;
import org.camunda.bpm.engine.IdentityService;
import org.camunda.bpm.engine.RuntimeService;
import org.camunda.bpm.engine.TaskService;
import org.camunda.bpm.engine.authorization.Authorization;
import org.camunda.bpm.engine.history.HistoricActivityInstance;
import org.camunda.bpm.engine.identity.Group;
import org.camunda.bpm.engine.identity.User;
import org.camunda.bpm.engine.impl.OptimizeService;
import org.camunda.bpm.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.camunda.bpm.engine.impl.history.event.HistoryEvent;
import org.camunda.bpm.engine.impl.util.ClockUtil;
import org.camunda.bpm.engine.task.Task;
import org.camunda.bpm.engine.test.ProcessEngineRule;
import org.camunda.bpm.engine.test.RequiredHistoryLevel;
import org.camunda.bpm.engine.test.api.optimize.ShiftTimeByOneMinuteListener;
import org.camunda.bpm.engine.test.util.ProcessEngineTestRule;
import org.camunda.bpm.engine.test.util.ProvidedProcessEngineRule;
import org.camunda.bpm.model.bpmn.Bpmn;
import org.camunda.bpm.model.bpmn.BpmnModelInstance;
import org.camunda.bpm.model.bpmn.builder.EndEventBuilder;
import org.camunda.bpm.model.bpmn.builder.ServiceTaskBuilder;
import org.camunda.bpm.model.bpmn.builder.StartEventBuilder;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.After;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;

@RequiredHistoryLevel(value="full")
public class GetCompletedHistoricActivityInstancesForOptimizeTest {
    public ProcessEngineRule engineRule = new ProvidedProcessEngineRule();
    protected ProcessEngineTestRule testHelper = new ProcessEngineTestRule(this.engineRule);
    @Rule
    public RuleChain ruleChain = RuleChain.outerRule((TestRule)this.engineRule).around((TestRule)this.testHelper);
    private OptimizeService optimizeService;
    protected String userId = "test";
    protected static final String VARIABLE_NAME = "aVariableName";
    protected static final String VARIABLE_VALUE = "aVariableValue";
    private IdentityService identityService;
    private RuntimeService runtimeService;
    private AuthorizationService authorizationService;
    private TaskService taskService;

    @Before
    public void init() {
        ProcessEngineConfigurationImpl config = this.engineRule.getProcessEngineConfiguration();
        this.optimizeService = config.getOptimizeService();
        this.identityService = this.engineRule.getIdentityService();
        this.runtimeService = this.engineRule.getRuntimeService();
        this.authorizationService = this.engineRule.getAuthorizationService();
        this.taskService = this.engineRule.getTaskService();
        this.createUser(this.userId);
    }

    @After
    public void cleanUp() {
        for (User user : this.identityService.createUserQuery().list()) {
            this.identityService.deleteUser(user.getId());
        }
        for (Group group : this.identityService.createGroupQuery().list()) {
            this.identityService.deleteGroup(group.getId());
        }
        for (Authorization authorization : this.authorizationService.createAuthorizationQuery().list()) {
            this.authorizationService.deleteAuthorization(authorization.getId());
        }
        ClockUtil.reset();
    }

    @Test
    public void getCompletedHistoricActivityInstances() {
        BpmnModelInstance simpleDefinition = ((EndEventBuilder)((StartEventBuilder)Bpmn.createExecutableProcess((String)"process").startEvent("startEvent").name("start")).endEvent("endEvent").name("end")).done();
        this.testHelper.deploy(simpleDefinition);
        this.runtimeService.startProcessInstanceByKey("process");
        List completedHistoricActivityInstances = this.optimizeService.getCompletedHistoricActivityInstances(this.pastDate(), null, 10);
        MatcherAssert.assertThat((Object)completedHistoricActivityInstances.size(), (Matcher)CoreMatchers.is((Object)2));
        this.assertThatActivitiesHaveAllImportantInformation(completedHistoricActivityInstances);
    }

    @Test
    public void fishedAfterParameterWorks() {
        BpmnModelInstance simpleDefinition = Bpmn.createExecutableProcess((String)"process").startEvent().userTask("userTask").endEvent("endEvent").done();
        this.testHelper.deploy(simpleDefinition);
        Date now = new Date();
        Date nowPlus2Seconds = new Date(now.getTime() + 2000L);
        ClockUtil.setCurrentTime((Date)now);
        this.engineRule.getRuntimeService().startProcessInstanceByKey("process");
        ClockUtil.setCurrentTime((Date)nowPlus2Seconds);
        this.completeAllUserTasks();
        List completedHistoricActivityInstances = this.optimizeService.getCompletedHistoricActivityInstances(now, null, 10);
        HashSet<String> allowedActivityIds = new HashSet<String>(Arrays.asList("userTask", "endEvent"));
        MatcherAssert.assertThat((Object)completedHistoricActivityInstances.size(), (Matcher)CoreMatchers.is((Object)2));
        TestCase.assertTrue((boolean)allowedActivityIds.contains(((HistoricActivityInstance)completedHistoricActivityInstances.get(0)).getActivityId()));
        TestCase.assertTrue((boolean)allowedActivityIds.contains(((HistoricActivityInstance)completedHistoricActivityInstances.get(1)).getActivityId()));
    }

    @Test
    public void fishedAtParameterWorks() {
        BpmnModelInstance simpleDefinition = Bpmn.createExecutableProcess((String)"process").startEvent("startEvent").userTask("userTask").endEvent("endEvent").done();
        this.testHelper.deploy(simpleDefinition);
        Date now = new Date();
        Date nowPlus2Seconds = new Date(now.getTime() + 2000L);
        ClockUtil.setCurrentTime((Date)now);
        this.engineRule.getRuntimeService().startProcessInstanceByKey("process");
        ClockUtil.setCurrentTime((Date)nowPlus2Seconds);
        this.completeAllUserTasks();
        List completedHistoricActivityInstances = this.optimizeService.getCompletedHistoricActivityInstances(null, now, 10);
        MatcherAssert.assertThat((Object)completedHistoricActivityInstances.size(), (Matcher)CoreMatchers.is((Object)1));
        MatcherAssert.assertThat((Object)((HistoricActivityInstance)completedHistoricActivityInstances.get(0)).getActivityId(), (Matcher)CoreMatchers.is((Object)"startEvent"));
    }

    @Test
    public void fishedAfterAndFinishedAtParameterWorks() {
        BpmnModelInstance simpleDefinition = Bpmn.createExecutableProcess((String)"process").startEvent("startEvent").userTask("userTask").endEvent("endEvent").done();
        this.testHelper.deploy(simpleDefinition);
        Date now = new Date();
        Date nowPlus2Seconds = new Date(now.getTime() + 2000L);
        ClockUtil.setCurrentTime((Date)now);
        this.engineRule.getRuntimeService().startProcessInstanceByKey("process");
        ClockUtil.setCurrentTime((Date)nowPlus2Seconds);
        this.completeAllUserTasks();
        List completedHistoricActivityInstances = this.optimizeService.getCompletedHistoricActivityInstances(now, now, 10);
        MatcherAssert.assertThat((Object)completedHistoricActivityInstances.size(), (Matcher)CoreMatchers.is((Object)0));
    }

    @Test
    public void maxResultsParameterWorks() {
        BpmnModelInstance simpleDefinition = ((ServiceTaskBuilder)((ServiceTaskBuilder)((ServiceTaskBuilder)((ServiceTaskBuilder)Bpmn.createExecutableProcess((String)"process").startEvent("startEvent").serviceTask().camundaExpression("${true}")).serviceTask().camundaExpression("${true}")).serviceTask().camundaExpression("${true}")).serviceTask().camundaExpression("${true}")).endEvent("endEvent").done();
        this.testHelper.deploy(simpleDefinition);
        this.engineRule.getRuntimeService().startProcessInstanceByKey("process");
        List completedHistoricActivityInstances = this.optimizeService.getCompletedHistoricActivityInstances(this.pastDate(), null, 3);
        MatcherAssert.assertThat((Object)completedHistoricActivityInstances.size(), (Matcher)CoreMatchers.is((Object)3));
    }

    @Test
    public void resultIsSortedByEndTime() {
        BpmnModelInstance simpleDefinition = ((EndEventBuilder)((ServiceTaskBuilder)((ServiceTaskBuilder)((ServiceTaskBuilder)((ServiceTaskBuilder)((ServiceTaskBuilder)((ServiceTaskBuilder)Bpmn.createExecutableProcess((String)"process").startEvent("startEvent").serviceTask("ServiceTask1").camundaExpression("${true}")).camundaExecutionListenerClass("start", ShiftTimeByOneMinuteListener.class.getName())).serviceTask("ServiceTask2").camundaExpression("${true}")).camundaExecutionListenerClass("start", ShiftTimeByOneMinuteListener.class.getName())).serviceTask("ServiceTask3").camundaExpression("${true}")).camundaExecutionListenerClass("start", ShiftTimeByOneMinuteListener.class.getName())).endEvent("endEvent").camundaExecutionListenerClass("start", ShiftTimeByOneMinuteListener.class.getName())).done();
        this.testHelper.deploy(simpleDefinition);
        ClockUtil.setCurrentTime((Date)new Date());
        this.engineRule.getRuntimeService().startProcessInstanceByKey("process");
        ClockUtil.reset();
        List completedHistoricActivityInstances = this.optimizeService.getCompletedHistoricActivityInstances(this.pastDate(), null, 4);
        MatcherAssert.assertThat((Object)completedHistoricActivityInstances.size(), (Matcher)CoreMatchers.is((Object)4));
        MatcherAssert.assertThat((Object)((HistoricActivityInstance)completedHistoricActivityInstances.get(0)).getActivityId(), (Matcher)CoreMatchers.is((Object)"startEvent"));
        MatcherAssert.assertThat((Object)((HistoricActivityInstance)completedHistoricActivityInstances.get(1)).getActivityId(), (Matcher)CoreMatchers.is((Object)"ServiceTask1"));
        MatcherAssert.assertThat((Object)((HistoricActivityInstance)completedHistoricActivityInstances.get(2)).getActivityId(), (Matcher)CoreMatchers.is((Object)"ServiceTask2"));
        MatcherAssert.assertThat((Object)((HistoricActivityInstance)completedHistoricActivityInstances.get(3)).getActivityId(), (Matcher)CoreMatchers.is((Object)"ServiceTask3"));
    }

    @Test
    public void fetchOnlyCompletedActivities() {
        BpmnModelInstance simpleDefinition = Bpmn.createExecutableProcess((String)"process").startEvent("startEvent").userTask().endEvent().done();
        this.testHelper.deploy(simpleDefinition);
        this.engineRule.getRuntimeService().startProcessInstanceByKey("process");
        List completedHistoricActivityInstances = this.optimizeService.getCompletedHistoricActivityInstances(this.pastDate(), null, 10);
        MatcherAssert.assertThat((Object)completedHistoricActivityInstances.size(), (Matcher)CoreMatchers.is((Object)1));
        MatcherAssert.assertThat((Object)((HistoricActivityInstance)completedHistoricActivityInstances.get(0)).getActivityId(), (Matcher)CoreMatchers.is((Object)"startEvent"));
    }

    private Date pastDate() {
        return new Date(2L);
    }

    private void completeAllUserTasks() {
        List list = this.taskService.createTaskQuery().list();
        for (Task task : list) {
            this.taskService.claim(task.getId(), this.userId);
            this.taskService.complete(task.getId());
        }
    }

    protected void createUser(String userId) {
        User user = this.identityService.newUser(userId);
        this.identityService.saveUser(user);
    }

    private void assertThatActivitiesHaveAllImportantInformation(List<HistoricActivityInstance> completedHistoricActivityInstances) {
        HistoricActivityInstance startEvent = null;
        HistoricActivityInstance endEvent = null;
        for (HistoricActivityInstance completedHistoricActivityInstance : completedHistoricActivityInstances) {
            if (completedHistoricActivityInstance.getActivityId().equals("startEvent")) {
                startEvent = completedHistoricActivityInstance;
                continue;
            }
            if (!completedHistoricActivityInstance.getActivityId().equals("endEvent")) continue;
            endEvent = completedHistoricActivityInstance;
        }
        MatcherAssert.assertThat(startEvent, (Matcher)CoreMatchers.notNullValue());
        MatcherAssert.assertThat((Object)startEvent.getActivityName(), (Matcher)CoreMatchers.is((Object)"start"));
        MatcherAssert.assertThat((Object)startEvent.getActivityType(), (Matcher)CoreMatchers.is((Object)"startEvent"));
        MatcherAssert.assertThat((Object)startEvent.getStartTime(), (Matcher)CoreMatchers.notNullValue());
        MatcherAssert.assertThat((Object)startEvent.getEndTime(), (Matcher)CoreMatchers.notNullValue());
        MatcherAssert.assertThat((Object)startEvent.getProcessDefinitionKey(), (Matcher)CoreMatchers.is((Object)"process"));
        MatcherAssert.assertThat((Object)startEvent.getProcessDefinitionId(), (Matcher)CoreMatchers.notNullValue());
        MatcherAssert.assertThat((Object)((HistoryEvent)startEvent).getSequenceCounter(), (Matcher)CoreMatchers.notNullValue());
        MatcherAssert.assertThat((Object)endEvent, (Matcher)CoreMatchers.notNullValue());
        MatcherAssert.assertThat((Object)endEvent.getActivityName(), (Matcher)CoreMatchers.is((Object)"end"));
        MatcherAssert.assertThat((Object)endEvent.getActivityType(), (Matcher)CoreMatchers.is((Object)"noneEndEvent"));
        MatcherAssert.assertThat((Object)endEvent.getStartTime(), (Matcher)CoreMatchers.notNullValue());
        MatcherAssert.assertThat((Object)endEvent.getEndTime(), (Matcher)CoreMatchers.notNullValue());
        MatcherAssert.assertThat((Object)endEvent.getProcessDefinitionKey(), (Matcher)CoreMatchers.is((Object)"process"));
        MatcherAssert.assertThat((Object)endEvent.getProcessDefinitionId(), (Matcher)CoreMatchers.notNullValue());
        MatcherAssert.assertThat((Object)((HistoryEvent)endEvent).getSequenceCounter(), (Matcher)CoreMatchers.notNullValue());
    }
}

