/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.bpmn.usertask;

import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.camunda.bpm.engine.ParseException;
import org.camunda.bpm.engine.RepositoryService;
import org.camunda.bpm.engine.impl.bpmn.behavior.UserTaskActivityBehavior;
import org.camunda.bpm.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.camunda.bpm.engine.impl.form.handler.DefaultTaskFormHandler;
import org.camunda.bpm.engine.impl.form.handler.DelegateFormHandler;
import org.camunda.bpm.engine.impl.persistence.entity.ProcessDefinitionEntity;
import org.camunda.bpm.engine.impl.pvm.process.ActivityImpl;
import org.camunda.bpm.engine.impl.task.TaskDefinition;
import org.camunda.bpm.engine.impl.test.TestHelper;
import org.camunda.bpm.engine.repository.ProcessDefinition;
import org.camunda.bpm.engine.test.Deployment;
import org.camunda.bpm.engine.test.ProcessEngineRule;
import org.camunda.bpm.engine.test.util.ProcessEngineTestRule;
import org.camunda.bpm.engine.test.util.ProvidedProcessEngineRule;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;

public class UserTaskCamundaFormDefinitionParseTest {
    public ProcessEngineRule engineRule = new ProvidedProcessEngineRule();
    public ProcessEngineTestRule testRule = new ProcessEngineTestRule(this.engineRule);
    @Rule
    public RuleChain chain = RuleChain.outerRule((TestRule)this.engineRule).around((TestRule)this.testRule);
    public RepositoryService repositoryService;
    public ProcessEngineConfigurationImpl processEngineConfiguration;

    @Before
    public void setup() {
        this.repositoryService = this.engineRule.getRepositoryService();
        this.processEngineConfiguration = this.engineRule.getProcessEngineConfiguration();
    }

    @After
    public void tearDown() {
        for (org.camunda.bpm.engine.repository.Deployment deployment : this.repositoryService.createDeploymentQuery().list()) {
            this.repositoryService.deleteDeployment(deployment.getId(), true);
        }
    }

    protected ActivityImpl findActivityInDeployedProcessDefinition(String activityId) {
        ProcessDefinition processDefinition = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().singleResult();
        Assert.assertNotNull((Object)processDefinition);
        ProcessDefinitionEntity cachedProcessDefinition = (ProcessDefinitionEntity)this.processEngineConfiguration.getDeploymentCache().getProcessDefinitionCache().get((Object)processDefinition.getId());
        return cachedProcessDefinition.findActivity(activityId);
    }

    protected DefaultTaskFormHandler getTaskFormHandler(TaskDefinition taskDefinition) {
        return (DefaultTaskFormHandler)((DelegateFormHandler)taskDefinition.getTaskFormHandler()).getFormHandler();
    }

    @Test
    @Deployment
    public void shouldParseCamundaFormDefinitionVersionBinding() {
        TaskDefinition taskDefinition = this.findUserTaskDefinition("UserTask");
        DefaultTaskFormHandler taskFormHandler = this.getTaskFormHandler(taskDefinition);
        Assertions.assertThat((String)taskDefinition.getCamundaFormDefinitionKey().getExpressionText()).isEqualTo((Object)"formId");
        Assertions.assertThat((String)taskFormHandler.getCamundaFormDefinitionKey().getExpressionText()).isEqualTo((Object)"formId");
        Assertions.assertThat((String)taskDefinition.getCamundaFormDefinitionBinding()).isEqualTo((Object)"version");
        Assertions.assertThat((String)taskFormHandler.getCamundaFormDefinitionBinding()).isEqualTo((Object)"version");
        Assertions.assertThat((String)taskDefinition.getCamundaFormDefinitionVersion().getExpressionText()).isEqualTo((Object)"1");
        Assertions.assertThat((String)taskFormHandler.getCamundaFormDefinitionVersion().getExpressionText()).isEqualTo((Object)"1");
    }

    @Test
    @Deployment
    public void shouldParseCamundaFormDefinitionLatestBinding() {
        TaskDefinition taskDefinition = this.findUserTaskDefinition("UserTask");
        DefaultTaskFormHandler taskFormHandler = this.getTaskFormHandler(taskDefinition);
        Assertions.assertThat((String)taskDefinition.getCamundaFormDefinitionKey().getExpressionText()).isEqualTo((Object)"formId");
        Assertions.assertThat((String)taskFormHandler.getCamundaFormDefinitionKey().getExpressionText()).isEqualTo((Object)"formId");
        Assertions.assertThat((String)taskDefinition.getCamundaFormDefinitionBinding()).isEqualTo((Object)"latest");
        Assertions.assertThat((String)taskFormHandler.getCamundaFormDefinitionBinding()).isEqualTo((Object)"latest");
    }

    @Test
    @Deployment
    public void shouldParseCamundaFormDefinitionDeploymentBinding() {
        TaskDefinition taskDefinition = this.findUserTaskDefinition("UserTask");
        DefaultTaskFormHandler taskFormHandler = this.getTaskFormHandler(taskDefinition);
        Assertions.assertThat((String)taskDefinition.getCamundaFormDefinitionKey().getExpressionText()).isEqualTo((Object)"formId");
        Assertions.assertThat((String)taskFormHandler.getCamundaFormDefinitionKey().getExpressionText()).isEqualTo((Object)"formId");
        Assertions.assertThat((String)taskDefinition.getCamundaFormDefinitionBinding()).isEqualTo((Object)"deployment");
        Assertions.assertThat((String)taskFormHandler.getCamundaFormDefinitionBinding()).isEqualTo((Object)"deployment");
    }

    @Test
    @Deployment
    public void shouldParseTwoUserTasksWithCamundaFormDefinition() {
        TaskDefinition taskDefinition1 = this.findUserTaskDefinition("UserTask_1");
        DefaultTaskFormHandler taskFormHandler1 = this.getTaskFormHandler(taskDefinition1);
        Assertions.assertThat((String)taskDefinition1.getCamundaFormDefinitionKey().getExpressionText()).isEqualTo((Object)"formId_1");
        Assertions.assertThat((String)taskFormHandler1.getCamundaFormDefinitionKey().getExpressionText()).isEqualTo((Object)"formId_1");
        Assertions.assertThat((String)taskDefinition1.getCamundaFormDefinitionBinding()).isEqualTo((Object)"deployment");
        Assertions.assertThat((String)taskFormHandler1.getCamundaFormDefinitionBinding()).isEqualTo((Object)"deployment");
        TaskDefinition taskDefinition2 = this.findUserTaskDefinition("UserTask_2");
        DefaultTaskFormHandler taskFormHandler2 = this.getTaskFormHandler(taskDefinition2);
        Assertions.assertThat((String)taskDefinition2.getCamundaFormDefinitionKey().getExpressionText()).isEqualTo((Object)"formId_2");
        Assertions.assertThat((String)taskFormHandler2.getCamundaFormDefinitionKey().getExpressionText()).isEqualTo((Object)"formId_2");
        Assertions.assertThat((String)taskDefinition2.getCamundaFormDefinitionBinding()).isEqualTo((Object)"version");
        Assertions.assertThat((String)taskFormHandler2.getCamundaFormDefinitionBinding()).isEqualTo((Object)"version");
        Assertions.assertThat((String)taskDefinition2.getCamundaFormDefinitionVersion().getExpressionText()).isEqualTo((Object)"2");
        Assertions.assertThat((String)taskFormHandler2.getCamundaFormDefinitionVersion().getExpressionText()).isEqualTo((Object)"2");
    }

    @Test
    public void shouldNotParseCamundaFormDefinitionUnsupportedBinding() {
        String resource = TestHelper.getBpmnProcessDefinitionResource(this.getClass(), (String)"shouldNotParseCamundaFormDefinitionUnsupportedBinding");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.repositoryService.createDeployment().name(resource).addClasspathResource(resource).deploy()).isInstanceOf(ParseException.class)).hasMessageContaining("Invalid element definition: value for formRefBinding attribute has to be one of [deployment, latest, version] but was unsupported");
    }

    @Test
    public void shouldNotParseCamundaFormDefinitionAndFormKey() {
        String resource = TestHelper.getBpmnProcessDefinitionResource(this.getClass(), (String)"shouldNotParseCamundaFormDefinitionAndFormKey");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.repositoryService.createDeployment().name(resource).addClasspathResource(resource).deploy()).isInstanceOf(ParseException.class)).hasMessageContaining("Invalid element definition: only one of the attributes formKey and formRef is allowed.");
    }

    private TaskDefinition findUserTaskDefinition(String activityId) {
        ActivityImpl userTask = this.findActivityInDeployedProcessDefinition(activityId);
        Assertions.assertThat((Object)userTask).isNotNull();
        TaskDefinition taskDefinition = ((UserTaskActivityBehavior)userTask.getActivityBehavior()).getTaskDecorator().getTaskDefinition();
        return taskDefinition;
    }
}

