/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.standalone.pvm;

import java.util.ArrayList;
import org.camunda.bpm.engine.impl.pvm.ProcessDefinitionBuilder;
import org.camunda.bpm.engine.impl.pvm.PvmExecution;
import org.camunda.bpm.engine.impl.pvm.PvmProcessDefinition;
import org.camunda.bpm.engine.impl.pvm.PvmProcessInstance;
import org.camunda.bpm.engine.impl.pvm.delegate.ActivityBehavior;
import org.camunda.bpm.engine.impl.pvm.process.ActivityImpl;
import org.camunda.bpm.engine.impl.pvm.process.ProcessDefinitionImpl;
import org.camunda.bpm.engine.test.standalone.pvm.activities.Automatic;
import org.camunda.bpm.engine.test.standalone.pvm.activities.EmbeddedSubProcess;
import org.camunda.bpm.engine.test.standalone.pvm.activities.End;
import org.camunda.bpm.engine.test.standalone.pvm.activities.ParallelGateway;
import org.camunda.bpm.engine.test.standalone.pvm.activities.WaitState;
import org.junit.Assert;
import org.junit.Test;

public class PvmEmbeddedSubProcessTest {
    @Test
    public void testEmbeddedSubProcess() {
        PvmProcessDefinition processDefinition = new ProcessDefinitionBuilder().createActivity("start").initial().behavior((ActivityBehavior)new Automatic()).transition("embeddedsubprocess").endActivity().createActivity("embeddedsubprocess").scope().behavior((ActivityBehavior)new EmbeddedSubProcess()).createActivity("startInside").behavior((ActivityBehavior)new Automatic()).transition("endInside").endActivity().createActivity("endInside").behavior((ActivityBehavior)new End()).endActivity().transition("end").endActivity().createActivity("end").behavior((ActivityBehavior)new WaitState()).endActivity().buildProcessDefinition();
        PvmProcessInstance processInstance = processDefinition.createProcessInstance();
        processInstance.start();
        ArrayList<String> expectedActiveActivityIds = new ArrayList<String>();
        expectedActiveActivityIds.add("end");
        Assert.assertEquals(expectedActiveActivityIds, (Object)processInstance.findActiveActivityIds());
    }

    @Test
    public void testMultipleConcurrentEndsInsideEmbeddedSubProcess() {
        PvmProcessDefinition processDefinition = new ProcessDefinitionBuilder().createActivity("start").initial().behavior((ActivityBehavior)new Automatic()).transition("embeddedsubprocess").endActivity().createActivity("embeddedsubprocess").scope().behavior((ActivityBehavior)new EmbeddedSubProcess()).createActivity("startInside").behavior((ActivityBehavior)new Automatic()).transition("fork").endActivity().createActivity("fork").behavior((ActivityBehavior)new ParallelGateway()).transition("endInside1").transition("endInside2").transition("endInside3").endActivity().createActivity("endInside1").behavior((ActivityBehavior)new End()).endActivity().createActivity("endInside2").behavior((ActivityBehavior)new End()).endActivity().createActivity("endInside3").behavior((ActivityBehavior)new End()).endActivity().transition("end").endActivity().createActivity("end").behavior((ActivityBehavior)new End()).endActivity().buildProcessDefinition();
        PvmProcessInstance processInstance = processDefinition.createProcessInstance();
        processInstance.start();
        Assert.assertTrue((boolean)processInstance.isEnded());
    }

    @Test
    public void testMultipleConcurrentEndsInsideEmbeddedSubProcessWithWaitState() {
        PvmProcessDefinition processDefinition = new ProcessDefinitionBuilder().createActivity("start").initial().behavior((ActivityBehavior)new Automatic()).transition("embeddedsubprocess").endActivity().createActivity("embeddedsubprocess").scope().behavior((ActivityBehavior)new EmbeddedSubProcess()).createActivity("startInside").behavior((ActivityBehavior)new Automatic()).transition("fork").endActivity().createActivity("fork").behavior((ActivityBehavior)new ParallelGateway()).transition("endInside1").transition("wait").transition("endInside3").endActivity().createActivity("endInside1").behavior((ActivityBehavior)new End()).endActivity().createActivity("wait").behavior((ActivityBehavior)new WaitState()).transition("endInside2").endActivity().createActivity("endInside2").behavior((ActivityBehavior)new End()).endActivity().createActivity("endInside3").behavior((ActivityBehavior)new End()).endActivity().transition("end").endActivity().createActivity("end").behavior((ActivityBehavior)new End()).endActivity().buildProcessDefinition();
        PvmProcessInstance processInstance = processDefinition.createProcessInstance();
        processInstance.start();
        Assert.assertFalse((boolean)processInstance.isEnded());
        PvmExecution execution = processInstance.findExecution("wait");
        execution.signal(null, null);
        Assert.assertTrue((boolean)processInstance.isEnded());
    }

    @Test
    public void testNestedSubProcessNoEnd() {
        PvmProcessDefinition processDefinition = new ProcessDefinitionBuilder().createActivity("start").initial().behavior((ActivityBehavior)new Automatic()).transition("embeddedsubprocess").endActivity().createActivity("embeddedsubprocess").scope().behavior((ActivityBehavior)new EmbeddedSubProcess()).createActivity("startInside").behavior((ActivityBehavior)new Automatic()).transition("nestedSubProcess").endActivity().createActivity("nestedSubProcess").scope().behavior((ActivityBehavior)new EmbeddedSubProcess()).createActivity("startNestedInside").behavior((ActivityBehavior)new Automatic()).transition("endInside").endActivity().createActivity("endInside").behavior((ActivityBehavior)new End()).endActivity().endActivity().transition("end").endActivity().createActivity("end").behavior((ActivityBehavior)new WaitState()).endActivity().buildProcessDefinition();
        PvmProcessInstance processInstance = processDefinition.createProcessInstance();
        processInstance.start();
        ArrayList<String> expectedActiveActivityIds = new ArrayList<String>();
        expectedActiveActivityIds.add("end");
        Assert.assertEquals(expectedActiveActivityIds, (Object)processInstance.findActiveActivityIds());
    }

    @Test
    public void testEmbeddedSubProcessWithoutEndEvents() {
        PvmProcessDefinition processDefinition = new ProcessDefinitionBuilder().createActivity("start").initial().behavior((ActivityBehavior)new Automatic()).transition("embeddedsubprocess").endActivity().createActivity("embeddedsubprocess").scope().behavior((ActivityBehavior)new EmbeddedSubProcess()).createActivity("startInside").behavior((ActivityBehavior)new Automatic()).endActivity().endActivity().buildProcessDefinition();
        PvmProcessInstance processInstance = processDefinition.createProcessInstance();
        processInstance.start();
        Assert.assertTrue((boolean)processInstance.isEnded());
    }

    @Test
    public void testNestedSubProcessBothNoEnd() {
        PvmProcessDefinition processDefinition = new ProcessDefinitionBuilder().createActivity("start").initial().behavior((ActivityBehavior)new Automatic()).transition("embeddedsubprocess").endActivity().createActivity("embeddedsubprocess").scope().behavior((ActivityBehavior)new EmbeddedSubProcess()).createActivity("startInside").behavior((ActivityBehavior)new Automatic()).transition("nestedSubProcess").endActivity().createActivity("nestedSubProcess").scope().behavior((ActivityBehavior)new EmbeddedSubProcess()).createActivity("startNestedInside").behavior((ActivityBehavior)new Automatic()).endActivity().endActivity().endActivity().buildProcessDefinition();
        PvmProcessInstance processInstance = processDefinition.createProcessInstance();
        processInstance.start();
        Assert.assertTrue((boolean)processInstance.isEnded());
    }

    @Test
    public void testEmbeddedSubProcessNoEnd() {
        PvmProcessDefinition processDefinition = new ProcessDefinitionBuilder().createActivity("start").initial().behavior((ActivityBehavior)new Automatic()).transition("embeddedsubprocess").endActivity().createActivity("embeddedsubprocess").scope().behavior((ActivityBehavior)new EmbeddedSubProcess()).createActivity("startInside").behavior((ActivityBehavior)new Automatic()).transition("endInside").endActivity().createActivity("endInside").behavior((ActivityBehavior)new End()).endActivity().endActivity().buildProcessDefinition();
        PvmProcessInstance processInstance = processDefinition.createProcessInstance();
        processInstance.start();
        Assert.assertTrue((boolean)processInstance.isEnded());
    }

    @Test
    public void testStartInScope() {
        PvmProcessDefinition processDefinition = new ProcessDefinitionBuilder().createActivity("start").initial().behavior((ActivityBehavior)new Automatic()).transition("embeddedsubprocess").endActivity().createActivity("embeddedsubprocess").scope().behavior((ActivityBehavior)new EmbeddedSubProcess()).createActivity("startInside").behavior((ActivityBehavior)new Automatic()).transition("endInside").endActivity().createActivity("endInside").behavior((ActivityBehavior)new End()).endActivity().transition("end").endActivity().createActivity("end").behavior((ActivityBehavior)new WaitState()).endActivity().buildProcessDefinition();
        PvmProcessInstance processInstance = ((ProcessDefinitionImpl)processDefinition).createProcessInstanceForInitial((ActivityImpl)processDefinition.findActivity("startInside"));
        processInstance.start();
        ArrayList<String> expectedActiveActivityIds = new ArrayList<String>();
        expectedActiveActivityIds.add("end");
        Assert.assertEquals(expectedActiveActivityIds, (Object)processInstance.findActiveActivityIds());
    }
}

