/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.authorization;

import java.util.Collections;
import java.util.Map;
import org.assertj.core.api.Assertions;
import org.camunda.bpm.engine.AuthorizationException;
import org.camunda.bpm.engine.impl.persistence.entity.ProcessDefinitionEntity;
import org.camunda.bpm.engine.management.TableMetaData;
import org.camunda.bpm.engine.management.TablePage;
import org.camunda.bpm.engine.test.api.authorization.AuthorizationTest;
import org.junit.Assert;
import org.junit.Test;

public class ManagementAuthorizationTest
extends AuthorizationTest {
    private static final String REQUIRED_ADMIN_AUTH_EXCEPTION = "ENGINE-03029 Required admin authenticated group or user.";

    @Test
    public void testGetTableCountWithoutAuthorization() {
        try {
            this.managementService.getTableCount();
            Assert.fail((String)"Exception expected: It should not be possible to get the table count");
        }
        catch (AuthorizationException e) {
            String message = e.getMessage();
            this.testRule.assertTextPresent(REQUIRED_ADMIN_AUTH_EXCEPTION, message);
        }
    }

    @Test
    public void testGetTableCountAsCamundaAdmin() {
        this.identityService.setAuthentication(this.userId, Collections.singletonList("camunda-admin"));
        Map tableCount = this.managementService.getTableCount();
        Assert.assertFalse((boolean)tableCount.isEmpty());
    }

    @Test
    public void testGetTableNameWithoutAuthorization() {
        try {
            this.managementService.getTableName(ProcessDefinitionEntity.class);
            Assert.fail((String)"Exception expected: It should not be possible to get the table name");
        }
        catch (AuthorizationException e) {
            String message = e.getMessage();
            this.testRule.assertTextPresent(REQUIRED_ADMIN_AUTH_EXCEPTION, message);
        }
    }

    @Test
    public void testGetTableNameAsCamundaAdmin() {
        this.identityService.setAuthentication(this.userId, Collections.singletonList("camunda-admin"));
        String tablePrefix = this.processEngineConfiguration.getDatabaseTablePrefix();
        String tableName = this.managementService.getTableName(ProcessDefinitionEntity.class);
        Assert.assertEquals((Object)(tablePrefix + "ACT_RE_PROCDEF"), (Object)tableName);
    }

    @Test
    public void testGetTableMetaDataWithoutAuthorization() {
        try {
            this.managementService.getTableMetaData("ACT_RE_PROCDEF");
            Assert.fail((String)"Exception expected: It should not be possible to get the table meta data");
        }
        catch (AuthorizationException e) {
            String message = e.getMessage();
            this.testRule.assertTextPresent(REQUIRED_ADMIN_AUTH_EXCEPTION, message);
        }
    }

    @Test
    public void testGetTableMetaDataAsCamundaAdmin() {
        this.identityService.setAuthentication(this.userId, Collections.singletonList("camunda-admin"));
        TableMetaData tableMetaData = this.managementService.getTableMetaData("ACT_RE_PROCDEF");
        Assert.assertNotNull((Object)tableMetaData);
    }

    @Test
    public void testTablePageQueryWithoutAuthorization() {
        try {
            this.managementService.createTablePageQuery().tableName("ACT_RE_PROCDEF").listPage(0, Integer.MAX_VALUE);
            Assert.fail((String)"Exception expected: It should not be possible to get a table page");
        }
        catch (AuthorizationException e) {
            String message = e.getMessage();
            this.testRule.assertTextPresent(REQUIRED_ADMIN_AUTH_EXCEPTION, message);
        }
    }

    @Test
    public void testTablePageQueryAsCamundaAdmin() {
        this.identityService.setAuthentication(this.userId, Collections.singletonList("camunda-admin"));
        String tablePrefix = this.processEngineConfiguration.getDatabaseTablePrefix();
        TablePage page = this.managementService.createTablePageQuery().tableName(tablePrefix + "ACT_RE_PROCDEF").listPage(0, Integer.MAX_VALUE);
        Assert.assertNotNull((Object)page);
    }

    @Test
    public void testGetHistoryLevelWithoutAuthorization() {
        try {
            this.managementService.getHistoryLevel();
            Assert.fail((String)"Exception expected: It should not be possible to get the history level");
        }
        catch (AuthorizationException e) {
            String message = e.getMessage();
            this.testRule.assertTextPresent(REQUIRED_ADMIN_AUTH_EXCEPTION, message);
        }
    }

    @Test
    public void testGetHistoryLevelAsCamundaAdmin() {
        this.identityService.setAuthentication(this.userId, Collections.singletonList("camunda-admin"));
        int historyLevel = this.managementService.getHistoryLevel();
        Assert.assertEquals((long)this.processEngineConfiguration.getHistoryLevel().getId(), (long)historyLevel);
    }

    @Test
    public void testDataSchemaUpgradeWithoutAuthorization() {
        try {
            this.managementService.databaseSchemaUpgrade(null, null, null);
            Assert.fail((String)"Exception expected: It should not be possible to upgrade the database schema");
        }
        catch (AuthorizationException e) {
            String message = e.getMessage();
            this.testRule.assertTextPresent(REQUIRED_ADMIN_AUTH_EXCEPTION, message);
        }
    }

    @Test
    public void testGetPropertiesWithoutAuthorization() {
        try {
            this.managementService.getProperties();
            Assert.fail((String)"Exception expected: It should not be possible to get properties");
        }
        catch (AuthorizationException e) {
            String message = e.getMessage();
            this.testRule.assertTextPresent(REQUIRED_ADMIN_AUTH_EXCEPTION, message);
        }
    }

    @Test
    public void testSetPropertyWithoutAuthorization() {
        try {
            this.managementService.setProperty("aPropertyKey", "aPropertyValue");
            Assert.fail((String)"Exception expected: It should not be possible to set a property");
        }
        catch (AuthorizationException e) {
            String message = e.getMessage();
            this.testRule.assertTextPresent(REQUIRED_ADMIN_AUTH_EXCEPTION, message);
        }
    }

    @Test
    public void testDeletePropertyWithoutAuthorization() {
        try {
            this.managementService.deleteProperty("aPropertyName");
            Assert.fail((String)"Exception expected: It should not be possible to delete a property");
        }
        catch (AuthorizationException e) {
            String message = e.getMessage();
            this.testRule.assertTextPresent(REQUIRED_ADMIN_AUTH_EXCEPTION, message);
        }
    }

    @Test
    public void testTelemetryEnabledWithoutAutorization() {
        try {
            this.managementService.toggleTelemetry(false);
        }
        catch (AuthorizationException e) {
            String message = e.getMessage();
            this.testRule.assertTextPresent(REQUIRED_ADMIN_AUTH_EXCEPTION, message);
        }
    }

    @Test
    public void testTelemetryEnabledAsCamundaAdmin() {
        this.disableAuthorization();
        this.managementService.toggleTelemetry(true);
        this.enableAuthorization();
        this.identityService.setAuthentication(this.userId, Collections.singletonList("camunda-admin"));
        this.managementService.toggleTelemetry(false);
        Assertions.assertThat((Boolean)this.managementService.isTelemetryEnabled()).isFalse();
    }
}

