/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.mgmt.metrics;

import java.util.Collections;
import java.util.Map;
import org.camunda.bpm.engine.management.MetricsQuery;
import org.camunda.bpm.engine.test.api.mgmt.metrics.AbstractMetricsTest;
import org.camunda.bpm.engine.variable.VariableMap;
import org.camunda.bpm.engine.variable.Variables;
import org.camunda.bpm.model.bpmn.Bpmn;
import org.camunda.bpm.model.bpmn.BpmnModelInstance;
import org.camunda.bpm.model.bpmn.builder.BusinessRuleTaskBuilder;
import org.camunda.bpm.model.bpmn.builder.CallActivityBuilder;
import org.camunda.bpm.model.bpmn.instance.CallActivity;
import org.junit.Assert;
import org.junit.Test;

public class RootProcessInstanceMetricsTest
extends AbstractMetricsTest {
    public static final String DMN_FILE = "org/camunda/bpm/engine/test/api/mgmt/metrics/ExecutedDecisionElementsTest.dmn11.xml";
    public static VariableMap VARIABLES = Variables.createVariables().putValue("status", (Object)"").putValue("sum", (Object)100);
    protected static final String BASE_INSTANCE_KEY = "baseProcess";
    protected static final BpmnModelInstance BASE_INSTANCE = Bpmn.createExecutableProcess((String)"baseProcess").startEvent().endEvent().done();
    protected static final String CALLED_DMN_INSTANCE_KEY = "calledDMNProcess";
    protected static final BpmnModelInstance CALLED_DMN_INSTANCE = ((BusinessRuleTaskBuilder)Bpmn.createExecutableProcess((String)"calledDMNProcess").startEvent().businessRuleTask().camundaDecisionRef("decision")).endEvent().done();
    protected static final String CALLING_INSTANCE_KEY = "callingProcess";

    @Override
    protected void clearMetrics() {
        super.clearMetrics();
        this.processEngineConfiguration.getDmnEngineConfiguration().getEngineMetricCollector().clearExecutedDecisionElements();
    }

    @Test
    public void shouldCountOneRootProcessInstance() {
        this.testRule.deploy(BASE_INSTANCE);
        this.runtimeService.startProcessInstanceByKey(BASE_INSTANCE_KEY);
        MetricsQuery query = this.managementService.createMetricsQuery();
        Assert.assertEquals((long)1L, (long)query.name("root-process-instance-start").sum());
        this.processEngineConfiguration.getDbMetricsReporter().reportNow();
        Assert.assertEquals((long)1L, (long)query.name("root-process-instance-start").sum());
    }

    @Test
    public void shouldCountRootProcessInstanceWithCallActivities() {
        BpmnModelInstance callingInstance = this.getCallingInstance(BASE_INSTANCE_KEY, Collections.EMPTY_MAP);
        this.testRule.deploy(BASE_INSTANCE, callingInstance);
        this.runtimeService.startProcessInstanceByKey(CALLING_INSTANCE_KEY);
        MetricsQuery query = this.managementService.createMetricsQuery();
        Assert.assertEquals((long)1L, (long)query.name("root-process-instance-start").sum());
        this.processEngineConfiguration.getDbMetricsReporter().reportNow();
        Assert.assertEquals((long)1L, (long)query.name("root-process-instance-start").sum());
    }

    @Test
    public void shouldCountRootProcessInstanceAndDecisionInstanceWithBusinessRuleTask() {
        BpmnModelInstance callingInstance = this.getCallingInstance(CALLED_DMN_INSTANCE_KEY, (Map)VARIABLES);
        this.testRule.deploy(this.repositoryService.createDeployment().addClasspathResource(DMN_FILE).addModelInstance("calledProcess.bpmn", CALLED_DMN_INSTANCE).addModelInstance("callingProcess.bpmn", callingInstance));
        this.runtimeService.startProcessInstanceByKey(CALLING_INSTANCE_KEY, (Map)VARIABLES);
        MetricsQuery query = this.managementService.createMetricsQuery();
        Assert.assertEquals((long)1L, (long)query.name("root-process-instance-start").sum());
        Assert.assertEquals((long)1L, (long)query.name("executed-decision-instances").sum());
        this.processEngineConfiguration.getDbMetricsReporter().reportNow();
        Assert.assertEquals((long)1L, (long)query.name("root-process-instance-start").sum());
        Assert.assertEquals((long)1L, (long)query.name("executed-decision-instances").sum());
    }

    protected BpmnModelInstance getCallingInstance(String calledInstanceKey, Map variables) {
        BpmnModelInstance modelInstance = ((CallActivityBuilder)Bpmn.createExecutableProcess((String)CALLING_INSTANCE_KEY).startEvent().callActivity("calledProcess").calledElement(calledInstanceKey)).endEvent().done();
        CallActivity callActivity = (CallActivity)modelInstance.getModelElementById("calledProcess");
        variables.keySet().iterator().forEachRemaining(name -> callActivity.builder().camundaIn((String)name, (String)name));
        return modelInstance;
    }
}

