/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.multitenancy.tenantcheck;

import java.util.Arrays;
import java.util.Map;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.camunda.bpm.engine.CaseService;
import org.camunda.bpm.engine.HistoryService;
import org.camunda.bpm.engine.IdentityService;
import org.camunda.bpm.engine.ProcessEngineConfiguration;
import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.history.HistoricCaseActivityInstance;
import org.camunda.bpm.engine.history.HistoricCaseInstance;
import org.camunda.bpm.engine.runtime.CaseExecution;
import org.camunda.bpm.engine.runtime.CaseInstanceBuilder;
import org.camunda.bpm.engine.test.ProcessEngineRule;
import org.camunda.bpm.engine.test.RequiredHistoryLevel;
import org.camunda.bpm.engine.test.util.ProcessEngineTestRule;
import org.camunda.bpm.engine.test.util.ProvidedProcessEngineRule;
import org.camunda.bpm.engine.variable.VariableMap;
import org.camunda.bpm.engine.variable.Variables;
import org.camunda.bpm.engine.variable.value.StringValue;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;

@RequiredHistoryLevel(value="full")
public class MultiTenancyCaseInstanceCmdsTenantCheckTest {
    protected static final String VARIABLE_NAME = "myVar";
    protected static final String VARIABLE_VALUE = "myValue";
    protected static final String TENANT_ONE = "tenant1";
    protected static final String CMMN_MODEL = "org/camunda/bpm/engine/test/api/cmmn/twoTaskCase.cmmn";
    protected static final String ACTIVITY_ID = "PI_HumanTask_1";
    protected ProcessEngineRule engineRule = new ProvidedProcessEngineRule();
    protected ProcessEngineTestRule testRule = new ProcessEngineTestRule(this.engineRule);
    @Rule
    public RuleChain ruleChain = RuleChain.outerRule((TestRule)this.engineRule).around((TestRule)this.testRule);
    protected IdentityService identityService;
    protected CaseService caseService;
    protected HistoryService historyService;
    protected ProcessEngineConfiguration processEngineConfiguration;
    protected String caseInstanceId;
    protected String caseExecutionId;

    @Before
    public void setUp() {
        this.processEngineConfiguration = this.engineRule.getProcessEngineConfiguration();
        this.identityService = this.engineRule.getIdentityService();
        this.caseService = this.engineRule.getCaseService();
        this.historyService = this.engineRule.getHistoryService();
        this.testRule.deployForTenant(TENANT_ONE, CMMN_MODEL);
        this.caseInstanceId = this.createCaseInstance(null);
        this.caseExecutionId = this.getCaseExecution().getId();
    }

    @Test
    public void manuallyStartCaseExecutionNoAuthenticatedTenants() {
        this.identityService.setAuthentication("user", null, null);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.caseService.manuallyStartCaseExecution(this.caseExecutionId)).isInstanceOf(ProcessEngineException.class)).hasMessageContaining("Cannot update the case execution");
    }

    @Test
    public void manuallyStartCaseExecutionWithAuthenticatedTenant() {
        this.identityService.setAuthentication("user", null, Arrays.asList(TENANT_ONE));
        this.caseService.manuallyStartCaseExecution(this.caseExecutionId);
        this.identityService.clearAuthentication();
        CaseExecution caseExecution = this.getCaseExecution();
        Assertions.assertThat((boolean)caseExecution.isActive()).isTrue();
    }

    @Test
    public void manuallyStartCaseExecutionDisabledTenantCheck() {
        this.identityService.setAuthentication("user", null, null);
        this.processEngineConfiguration.setTenantCheckEnabled(false);
        this.caseService.manuallyStartCaseExecution(this.caseExecutionId);
        this.identityService.clearAuthentication();
        CaseExecution caseExecution = this.getCaseExecution();
        Assertions.assertThat((boolean)caseExecution.isActive()).isTrue();
    }

    @Test
    public void disableCaseExecutionNoAuthenticatedTenants() {
        this.identityService.setAuthentication("user", null, null);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.caseService.disableCaseExecution(this.caseExecutionId)).isInstanceOf(ProcessEngineException.class)).hasMessageContaining("Cannot update the case execution");
    }

    @Test
    public void disableCaseExecutionWithAuthenticatedTenant() {
        this.identityService.setAuthentication("user", null, Arrays.asList(TENANT_ONE));
        this.caseService.disableCaseExecution(this.caseExecutionId);
        this.identityService.clearAuthentication();
        HistoricCaseActivityInstance historicCaseActivityInstance = this.getHistoricCaseActivityInstance();
        Assertions.assertThat((Object)historicCaseActivityInstance).isNotNull();
        Assertions.assertThat((boolean)historicCaseActivityInstance.isDisabled()).isTrue();
    }

    @Test
    public void disableCaseExecutionDisabledTenantCheck() {
        this.identityService.setAuthentication("user", null, null);
        this.processEngineConfiguration.setTenantCheckEnabled(false);
        this.caseService.disableCaseExecution(this.caseExecutionId);
        this.identityService.clearAuthentication();
        HistoricCaseActivityInstance historicCaseActivityInstance = this.getHistoricCaseActivityInstance();
        Assertions.assertThat((Object)historicCaseActivityInstance).isNotNull();
        Assertions.assertThat((boolean)historicCaseActivityInstance.isDisabled()).isTrue();
    }

    @Test
    public void reenableCaseExecutionNoAuthenticatedTenants() {
        this.caseService.disableCaseExecution(this.caseExecutionId);
        this.identityService.setAuthentication("user", null, null);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.caseService.reenableCaseExecution(this.caseExecutionId)).isInstanceOf(ProcessEngineException.class)).hasMessageContaining("Cannot update the case execution");
    }

    @Test
    public void reenableCaseExecutionWithAuthenticatedTenant() {
        this.caseService.disableCaseExecution(this.caseExecutionId);
        this.identityService.setAuthentication("user", null, Arrays.asList(TENANT_ONE));
        this.caseService.reenableCaseExecution(this.caseExecutionId);
        this.identityService.clearAuthentication();
        CaseExecution caseExecution = this.getCaseExecution();
        Assertions.assertThat((boolean)caseExecution.isEnabled()).isTrue();
    }

    @Test
    public void reenableCaseExecutionDisabledTenantCheck() {
        this.caseService.disableCaseExecution(this.caseExecutionId);
        this.identityService.setAuthentication("user", null, null);
        this.processEngineConfiguration.setTenantCheckEnabled(false);
        this.caseService.reenableCaseExecution(this.caseExecutionId);
        this.identityService.clearAuthentication();
        CaseExecution caseExecution = this.getCaseExecution();
        Assertions.assertThat((boolean)caseExecution.isEnabled()).isTrue();
    }

    @Test
    public void completeCaseExecutionNoAuthenticatedTenants() {
        this.caseService.manuallyStartCaseExecution(this.caseExecutionId);
        this.identityService.setAuthentication("user", null, null);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.caseService.completeCaseExecution(this.caseExecutionId)).isInstanceOf(ProcessEngineException.class)).hasMessageContaining("Cannot update the case execution");
    }

    @Test
    public void completeCaseExecutionWithAuthenticatedTenant() {
        this.caseService.manuallyStartCaseExecution(this.caseExecutionId);
        this.identityService.setAuthentication("user", null, Arrays.asList(TENANT_ONE));
        this.caseService.completeCaseExecution(this.caseExecutionId);
        this.identityService.clearAuthentication();
        HistoricCaseActivityInstance historicCaseActivityInstance = this.getHistoricCaseActivityInstance();
        Assertions.assertThat((Object)historicCaseActivityInstance).isNotNull();
        Assertions.assertThat((boolean)historicCaseActivityInstance.isCompleted()).isTrue();
    }

    @Test
    public void completeCaseExecutionDisabledTenantCheck() {
        this.caseService.manuallyStartCaseExecution(this.caseExecutionId);
        this.identityService.setAuthentication("user", null, null);
        this.processEngineConfiguration.setTenantCheckEnabled(false);
        this.caseService.completeCaseExecution(this.caseExecutionId);
        this.identityService.clearAuthentication();
        HistoricCaseActivityInstance historicCaseActivityInstance = this.getHistoricCaseActivityInstance();
        Assertions.assertThat((Object)historicCaseActivityInstance).isNotNull();
        Assertions.assertThat((boolean)historicCaseActivityInstance.isCompleted()).isTrue();
    }

    @Test
    public void closeCaseInstanceNoAuthenticatedTenants() {
        this.caseService.completeCaseExecution(this.caseInstanceId);
        this.identityService.setAuthentication("user", null, null);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.caseService.closeCaseInstance(this.caseInstanceId)).isInstanceOf(ProcessEngineException.class)).hasMessageContaining("Cannot update the case execution");
    }

    @Test
    public void closeCaseInstanceWithAuthenticatedTenant() {
        this.caseService.completeCaseExecution(this.caseInstanceId);
        this.identityService.setAuthentication("user", null, Arrays.asList(TENANT_ONE));
        this.caseService.closeCaseInstance(this.caseInstanceId);
        this.identityService.clearAuthentication();
        HistoricCaseInstance historicCaseInstance = this.getHistoricCaseInstance();
        Assertions.assertThat((Object)historicCaseInstance).isNotNull();
        Assertions.assertThat((boolean)historicCaseInstance.isClosed()).isTrue();
    }

    @Test
    public void closeCaseInstanceDisabledTenantCheck() {
        this.caseService.completeCaseExecution(this.caseInstanceId);
        this.identityService.setAuthentication("user", null, null);
        this.processEngineConfiguration.setTenantCheckEnabled(false);
        this.caseService.closeCaseInstance(this.caseInstanceId);
        this.identityService.clearAuthentication();
        HistoricCaseInstance historicCaseInstance = this.getHistoricCaseInstance();
        Assertions.assertThat((Object)historicCaseInstance).isNotNull();
        Assertions.assertThat((boolean)historicCaseInstance.isClosed()).isTrue();
    }

    @Test
    public void terminateCaseInstanceNoAuthenticatedTenants() {
        this.identityService.setAuthentication("user", null, null);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.caseService.terminateCaseExecution(this.caseInstanceId)).isInstanceOf(ProcessEngineException.class)).hasMessageContaining("Cannot update the case execution");
    }

    @Test
    public void terminateCaseExecutionWithAuthenticatedTenant() {
        this.identityService.setAuthentication("user", null, Arrays.asList(TENANT_ONE));
        this.caseService.terminateCaseExecution(this.caseInstanceId);
        HistoricCaseInstance historicCaseInstance = this.getHistoricCaseInstance();
        Assertions.assertThat((Object)historicCaseInstance).isNotNull();
        Assertions.assertThat((boolean)historicCaseInstance.isTerminated()).isTrue();
    }

    @Test
    public void terminateCaseExecutionDisabledTenantCheck() {
        this.identityService.setAuthentication("user", null, null);
        this.processEngineConfiguration.setTenantCheckEnabled(false);
        this.caseService.terminateCaseExecution(this.caseInstanceId);
        HistoricCaseInstance historicCaseInstance = this.getHistoricCaseInstance();
        Assertions.assertThat((Object)historicCaseInstance).isNotNull();
        Assertions.assertThat((boolean)historicCaseInstance.isTerminated()).isTrue();
    }

    @Test
    public void getVariablesNoAuthenticatedTenants() {
        this.identityService.setAuthentication("user", null, null);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.caseService.getVariables(this.caseExecutionId)).isInstanceOf(ProcessEngineException.class)).hasMessageContaining("Cannot get the case execution");
    }

    @Test
    public void getVariablesWithAuthenticatedTenant() {
        this.identityService.setAuthentication("user", null, Arrays.asList(TENANT_ONE));
        Map variables = this.caseService.getVariables(this.caseExecutionId);
        Assertions.assertThat((Map)variables).isNotNull();
        Assertions.assertThat(variables.keySet()).contains((Object[])new String[]{VARIABLE_NAME});
    }

    @Test
    public void getVariablesDisabledTenantCheck() {
        this.identityService.setAuthentication("user", null, null);
        this.processEngineConfiguration.setTenantCheckEnabled(false);
        Map variables = this.caseService.getVariables(this.caseExecutionId);
        Assertions.assertThat((Map)variables).isNotNull();
        Assertions.assertThat(variables.keySet()).contains((Object[])new String[]{VARIABLE_NAME});
    }

    @Test
    public void getVariableNoAuthenticatedTenants() {
        this.identityService.setAuthentication("user", null, null);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.caseService.getVariable(this.caseExecutionId, VARIABLE_NAME)).isInstanceOf(ProcessEngineException.class)).hasMessageContaining("Cannot get the case execution");
    }

    @Test
    public void getVariableWithAuthenticatedTenant() {
        this.identityService.setAuthentication("user", null, Arrays.asList(TENANT_ONE));
        String variableValue = (String)this.caseService.getVariable(this.caseExecutionId, VARIABLE_NAME);
        Assertions.assertThat((String)variableValue).isEqualTo((Object)VARIABLE_VALUE);
    }

    @Test
    public void getVariableDisabledTenantCheck() {
        this.identityService.setAuthentication("user", null, null);
        this.processEngineConfiguration.setTenantCheckEnabled(false);
        String variableValue = (String)this.caseService.getVariable(this.caseExecutionId, VARIABLE_NAME);
        Assertions.assertThat((String)variableValue).isEqualTo((Object)VARIABLE_VALUE);
    }

    @Test
    public void getVariableTypedNoAuthenticatedTenants() {
        this.identityService.setAuthentication("user", null, null);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.caseService.getVariableTyped(this.caseExecutionId, VARIABLE_NAME)).isInstanceOf(ProcessEngineException.class)).hasMessageContaining("Cannot get the case execution");
    }

    @Test
    public void getVariableTypedWithAuthenticatedTenant() {
        this.identityService.setAuthentication("user", null, Arrays.asList(TENANT_ONE));
        StringValue variable = (StringValue)this.caseService.getVariableTyped(this.caseExecutionId, VARIABLE_NAME);
        Assertions.assertThat((String)((String)variable.getValue())).isEqualTo((Object)VARIABLE_VALUE);
    }

    @Test
    public void getVariableTypedDisabledTenantCheck() {
        this.identityService.setAuthentication("user", null, null);
        this.processEngineConfiguration.setTenantCheckEnabled(false);
        StringValue variable = (StringValue)this.caseService.getVariableTyped(this.caseExecutionId, VARIABLE_NAME);
        Assertions.assertThat((String)((String)variable.getValue())).isEqualTo((Object)VARIABLE_VALUE);
    }

    @Test
    public void removeVariablesNoAuthenticatedTenants() {
        this.identityService.setAuthentication("user", null, null);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.caseService.removeVariable(this.caseExecutionId, VARIABLE_NAME)).isInstanceOf(ProcessEngineException.class)).hasMessageContaining("Cannot update the case execution");
    }

    @Test
    public void removeVariablesWithAuthenticatedTenant() {
        this.identityService.setAuthentication("user", null, Arrays.asList(TENANT_ONE));
        this.caseService.removeVariable(this.caseExecutionId, VARIABLE_NAME);
        this.identityService.clearAuthentication();
        Map variables = this.caseService.getVariables(this.caseExecutionId);
        Assertions.assertThat((boolean)variables.isEmpty()).isTrue();
    }

    @Test
    public void removeVariablesDisabledTenantCheck() {
        this.identityService.setAuthentication("user", null, null);
        this.processEngineConfiguration.setTenantCheckEnabled(false);
        this.caseService.removeVariable(this.caseExecutionId, VARIABLE_NAME);
        this.identityService.clearAuthentication();
        Map variables = this.caseService.getVariables(this.caseExecutionId);
        Assertions.assertThat((boolean)variables.isEmpty()).isTrue();
    }

    @Test
    public void setVariableNoAuthenticatedTenants() {
        this.identityService.setAuthentication("user", null, null);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.caseService.setVariable(this.caseExecutionId, "newVar", (Object)"newValue")).isInstanceOf(ProcessEngineException.class)).hasMessageContaining("Cannot update the case execution");
    }

    @Test
    public void setVariableWithAuthenticatedTenant() {
        this.identityService.setAuthentication("user", null, Arrays.asList(TENANT_ONE));
        this.caseService.setVariable(this.caseExecutionId, "newVar", (Object)"newValue");
        this.identityService.clearAuthentication();
        Map variables = this.caseService.getVariables(this.caseExecutionId);
        Assertions.assertThat((Map)variables).isNotNull();
        Assertions.assertThat(variables.keySet()).contains((Object[])new String[]{VARIABLE_NAME, "newVar"});
    }

    @Test
    public void setVariableDisabledTenantCheck() {
        this.identityService.setAuthentication("user", null, null);
        this.processEngineConfiguration.setTenantCheckEnabled(false);
        this.caseService.setVariable(this.caseExecutionId, "newVar", (Object)"newValue");
        this.identityService.clearAuthentication();
        Map variables = this.caseService.getVariables(this.caseExecutionId);
        Assertions.assertThat((Map)variables).isNotNull();
        Assertions.assertThat(variables.keySet()).contains((Object[])new String[]{VARIABLE_NAME, "newVar"});
    }

    protected String createCaseInstance(String tenantId) {
        VariableMap variables = Variables.putValue((String)VARIABLE_NAME, (Object)VARIABLE_VALUE);
        CaseInstanceBuilder builder = this.caseService.withCaseDefinitionByKey("twoTaskCase").setVariables((Map)variables);
        if (tenantId == null) {
            return builder.create().getId();
        }
        return builder.caseDefinitionTenantId(tenantId).create().getId();
    }

    protected CaseExecution getCaseExecution() {
        return (CaseExecution)this.caseService.createCaseExecutionQuery().activityId(ACTIVITY_ID).singleResult();
    }

    protected HistoricCaseActivityInstance getHistoricCaseActivityInstance() {
        return (HistoricCaseActivityInstance)this.historyService.createHistoricCaseActivityInstanceQuery().caseActivityId(ACTIVITY_ID).singleResult();
    }

    protected HistoricCaseInstance getHistoricCaseInstance() {
        return (HistoricCaseInstance)this.historyService.createHistoricCaseInstanceQuery().caseInstanceId(this.caseInstanceId).singleResult();
    }
}

