/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.bpmn;

import java.util.List;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.RepositoryService;
import org.camunda.bpm.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.camunda.bpm.engine.impl.interceptor.Command;
import org.camunda.bpm.engine.repository.Deployment;
import org.camunda.bpm.engine.repository.Resource;
import org.camunda.bpm.engine.test.ProcessEngineRule;
import org.camunda.bpm.engine.test.form.deployment.FindCamundaFormDefinitionsCmd;
import org.camunda.bpm.engine.test.util.ProcessEngineTestRule;
import org.camunda.bpm.engine.test.util.ProvidedProcessEngineRule;
import org.junit.After;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;

public class CamundaFormDefinitionStrictParseTest {
    private static final String FORM = "org/camunda/bpm/engine/test/bpmn/CamundaFormDefinitionStrictParseTest.anyForm.form";
    public ProcessEngineRule engineRule = new ProvidedProcessEngineRule();
    public ProcessEngineTestRule testRule = new ProcessEngineTestRule(this.engineRule);
    @Rule
    public RuleChain chain = RuleChain.outerRule((TestRule)this.engineRule).around((TestRule)this.testRule);
    protected ProcessEngineConfigurationImpl processEngineConfiguration;
    protected RepositoryService repositoryService;

    @Before
    public void setup() {
        this.repositoryService = this.engineRule.getRepositoryService();
        this.processEngineConfiguration = this.engineRule.getProcessEngineConfiguration();
    }

    @After
    public void reset() {
        this.processEngineConfiguration.setDisableStrictCamundaFormParsing(false);
    }

    @Test
    public void shouldParseAnyFormFile_strictParsingDisabled() {
        this.processEngineConfiguration.setDisableStrictCamundaFormParsing(true);
        this.testRule.deploy(FORM);
        List deployments = this.repositoryService.createDeploymentQuery().list();
        Assertions.assertThat((List)deployments).hasSize(1);
        List resources = this.repositoryService.getDeploymentResources(((Deployment)deployments.get(0)).getId());
        Assertions.assertThat((List)resources).hasSize(1);
        Assertions.assertThat((String)((Resource)resources.get(0)).getName()).isEqualTo((Object)FORM);
        List formDefinitions = (List)this.engineRule.getProcessEngineConfiguration().getCommandExecutorTxRequired().execute((Command)new FindCamundaFormDefinitionsCmd());
        Assertions.assertThat((List)formDefinitions).hasSize(0);
    }

    @Test
    public void shouldNotParseAnyFormFile_strictParsingEnabled() {
        this.processEngineConfiguration.setDisableStrictCamundaFormParsing(false);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.testRule.deploy(FORM)).isInstanceOf(ProcessEngineException.class)).hasMessageContaining("ENGINE-09033 Could not parse Camunda Form resource org/camunda/bpm/engine/test/bpmn/CamundaFormDefinitionStrictParseTest.anyForm.form.");
        Assertions.assertThat((List)this.repositoryService.createDeploymentQuery().list()).hasSize(0);
    }
}

