/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.bpmn.event.start;

import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.camunda.bpm.engine.ParseException;
import org.camunda.bpm.engine.RepositoryService;
import org.camunda.bpm.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.camunda.bpm.engine.impl.form.handler.DefaultStartFormHandler;
import org.camunda.bpm.engine.impl.form.handler.DelegateFormHandler;
import org.camunda.bpm.engine.impl.persistence.entity.ProcessDefinitionEntity;
import org.camunda.bpm.engine.impl.test.TestHelper;
import org.camunda.bpm.engine.repository.ProcessDefinition;
import org.camunda.bpm.engine.test.Deployment;
import org.camunda.bpm.engine.test.ProcessEngineRule;
import org.camunda.bpm.engine.test.util.ProcessEngineTestRule;
import org.camunda.bpm.engine.test.util.ProvidedProcessEngineRule;
import org.junit.After;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;

public class StartEventCamundaFormDefinitionParseTest {
    public ProcessEngineRule engineRule = new ProvidedProcessEngineRule();
    public ProcessEngineTestRule testRule = new ProcessEngineTestRule(this.engineRule);
    @Rule
    public RuleChain chain = RuleChain.outerRule((TestRule)this.engineRule).around((TestRule)this.testRule);
    public RepositoryService repositoryService;
    public ProcessEngineConfigurationImpl processEngineConfiguration;

    @Before
    public void setup() {
        this.repositoryService = this.engineRule.getRepositoryService();
        this.processEngineConfiguration = this.engineRule.getProcessEngineConfiguration();
    }

    @After
    public void tearDown() {
        for (org.camunda.bpm.engine.repository.Deployment deployment : this.repositoryService.createDeploymentQuery().list()) {
            this.repositoryService.deleteDeployment(deployment.getId(), true);
        }
    }

    protected DefaultStartFormHandler getStartFormHandler() {
        return (DefaultStartFormHandler)((DelegateFormHandler)this.getProcessDefinition().getStartFormHandler()).getFormHandler();
    }

    private ProcessDefinitionEntity getProcessDefinition() {
        ProcessDefinition processDefinition = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().singleResult();
        ProcessDefinitionEntity cachedProcessDefinition = (ProcessDefinitionEntity)this.processEngineConfiguration.getDeploymentCache().getProcessDefinitionCache().get((Object)processDefinition.getId());
        return cachedProcessDefinition;
    }

    @Test
    @Deployment
    public void shouldParseCamundaFormDefinitionVersionBinding() {
        DefaultStartFormHandler startFormHandler = this.getStartFormHandler();
        Assertions.assertThat((String)startFormHandler.getCamundaFormDefinitionKey().getExpressionText()).isEqualTo((Object)"formId");
        Assertions.assertThat((String)startFormHandler.getCamundaFormDefinitionBinding()).isEqualTo((Object)"version");
        Assertions.assertThat((String)startFormHandler.getCamundaFormDefinitionVersion().getExpressionText()).isEqualTo((Object)"1");
    }

    @Test
    @Deployment
    public void shouldParseCamundaFormDefinitionLatestBinding() {
        DefaultStartFormHandler startFormHandler = this.getStartFormHandler();
        Assertions.assertThat((String)startFormHandler.getCamundaFormDefinitionKey().getExpressionText()).isEqualTo((Object)"formId");
        Assertions.assertThat((String)startFormHandler.getCamundaFormDefinitionBinding()).isEqualTo((Object)"latest");
    }

    @Test
    @Deployment
    public void shouldParseCamundaFormDefinitionMultipleStartEvents() {
        DefaultStartFormHandler startFormHandler = this.getStartFormHandler();
        Assertions.assertThat((String)startFormHandler.getCamundaFormDefinitionKey().getExpressionText()).isEqualTo((Object)"formId");
        Assertions.assertThat((String)startFormHandler.getCamundaFormDefinitionBinding()).isEqualTo((Object)"latest");
    }

    @Test
    @Deployment
    public void shouldParseCamundaFormDefinitionDeploymentBinding() {
        DefaultStartFormHandler startFormHandler = this.getStartFormHandler();
        Assertions.assertThat((String)startFormHandler.getCamundaFormDefinitionKey().getExpressionText()).isEqualTo((Object)"formId");
        Assertions.assertThat((String)startFormHandler.getCamundaFormDefinitionBinding()).isEqualTo((Object)"deployment");
    }

    @Test
    public void shouldNotParseCamundaFormDefinitionUnsupportedBinding() {
        String resource = TestHelper.getBpmnProcessDefinitionResource(this.getClass(), (String)"shouldNotParseCamundaFormDefinitionUnsupportedBinding");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.repositoryService.createDeployment().name(resource).addClasspathResource(resource).deploy()).isInstanceOf(ParseException.class)).hasMessageContaining("Invalid element definition: value for formRefBinding attribute has to be one of [deployment, latest, version] but was unsupported");
    }

    public void shouldNotParseCamundaFormDefinitionAndFormKey() {
        String resource = TestHelper.getBpmnProcessDefinitionResource(this.getClass(), (String)"shouldNotParseCamundaFormDefinitionAndFormKey");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.repositoryService.createDeployment().name(resource).addClasspathResource(resource).deploy()).isInstanceOf(ParseException.class)).hasMessageContaining("Invalid element definition: only one of the attributes formKey and formRef is allowed.");
    }
}

