/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.standalone.deploy;

import org.camunda.bpm.engine.RepositoryService;
import org.camunda.bpm.engine.RuntimeService;
import org.camunda.bpm.engine.impl.persistence.entity.ProcessDefinitionEntity;
import org.camunda.bpm.engine.impl.persistence.entity.ProcessInstanceWithVariablesImpl;
import org.camunda.bpm.engine.impl.pvm.process.ActivityImpl;
import org.camunda.bpm.engine.runtime.ProcessInstance;
import org.camunda.bpm.engine.test.Deployment;
import org.camunda.bpm.engine.test.standalone.deploy.TestBPMNParseListener;
import org.camunda.bpm.engine.test.util.ProcessEngineBootstrapRule;
import org.camunda.bpm.engine.test.util.ProvidedProcessEngineRule;
import org.junit.Assert;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

public class BPMNParseListenerTest {
    @ClassRule
    public static ProcessEngineBootstrapRule bootstrapRule = new ProcessEngineBootstrapRule("org/camunda/bpm/engine/test/standalone/deploy/bpmn.parse.listener.camunda.cfg.xml");
    @Rule
    public ProvidedProcessEngineRule engineRule = new ProvidedProcessEngineRule(bootstrapRule);
    protected RuntimeService runtimeService;
    protected RepositoryService repositoryService;

    @Before
    public void setUp() {
        this.runtimeService = this.engineRule.getRuntimeService();
        this.repositoryService = this.engineRule.getRepositoryService();
    }

    @Deployment
    @Test
    public void testAlterProcessDefinitionKeyWhenDeploying() throws Exception {
        Assert.assertEquals((long)0L, (long)this.repositoryService.createProcessDefinitionQuery().processDefinitionKey("oneTaskProcess").count());
        Assert.assertEquals((long)1L, (long)this.repositoryService.createProcessDefinitionQuery().processDefinitionKey("oneTaskProcess-modified").count());
    }

    @Deployment
    @Test
    public void testAlterActivityBehaviors() throws Exception {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("oneTaskWithIntermediateThrowEvent-modified");
        ProcessDefinitionEntity processDefinition = ((ProcessInstanceWithVariablesImpl)processInstance).getExecutionEntity().getProcessDefinition();
        ActivityImpl cancelThrowEvent = processDefinition.findActivity("CancelthrowEvent");
        Assert.assertTrue((boolean)(cancelThrowEvent.getActivityBehavior() instanceof TestBPMNParseListener.TestCompensationEventActivityBehavior));
        ActivityImpl startEvent = processDefinition.findActivity("theStart");
        Assert.assertTrue((boolean)(startEvent.getActivityBehavior() instanceof TestBPMNParseListener.TestNoneStartEventActivityBehavior));
        ActivityImpl endEvent = processDefinition.findActivity("theEnd");
        Assert.assertTrue((boolean)(endEvent.getActivityBehavior() instanceof TestBPMNParseListener.TestNoneEndEventActivityBehavior));
    }
}

