/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.persistence.entity;

import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.camunda.bpm.engine.externaltask.ExternalTask;
import org.camunda.bpm.engine.history.HistoricExternalTaskLog;
import org.camunda.bpm.engine.impl.HistoricExternalTaskLogQueryImpl;
import org.camunda.bpm.engine.impl.Page;
import org.camunda.bpm.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.camunda.bpm.engine.impl.context.Context;
import org.camunda.bpm.engine.impl.db.ListQueryParameterObject;
import org.camunda.bpm.engine.impl.db.entitymanager.operation.DbOperation;
import org.camunda.bpm.engine.impl.history.HistoryLevel;
import org.camunda.bpm.engine.impl.history.event.HistoricExternalTaskLogEntity;
import org.camunda.bpm.engine.impl.history.event.HistoryEvent;
import org.camunda.bpm.engine.impl.history.event.HistoryEventProcessor;
import org.camunda.bpm.engine.impl.history.event.HistoryEventType;
import org.camunda.bpm.engine.impl.history.event.HistoryEventTypes;
import org.camunda.bpm.engine.impl.history.producer.HistoryEventProducer;
import org.camunda.bpm.engine.impl.persistence.AbstractManager;
import org.camunda.bpm.engine.impl.persistence.entity.ByteArrayEntity;
import org.camunda.bpm.engine.impl.persistence.entity.ExternalTaskEntity;
import org.camunda.bpm.engine.impl.util.EnsureUtil;

public class HistoricExternalTaskLogManager
extends AbstractManager {
    public HistoricExternalTaskLogEntity findHistoricExternalTaskLogById(String HistoricExternalTaskLogId) {
        return (HistoricExternalTaskLogEntity)this.getDbEntityManager().selectOne("selectHistoricExternalTaskLog", HistoricExternalTaskLogId);
    }

    public List<HistoricExternalTaskLog> findHistoricExternalTaskLogsByQueryCriteria(HistoricExternalTaskLogQueryImpl query, Page page) {
        this.configureQuery(query);
        return this.getDbEntityManager().selectList("selectHistoricExternalTaskLogByQueryCriteria", query, page);
    }

    public long findHistoricExternalTaskLogsCountByQueryCriteria(HistoricExternalTaskLogQueryImpl query) {
        this.configureQuery(query);
        return (Long)this.getDbEntityManager().selectOne("selectHistoricExternalTaskLogCountByQueryCriteria", query);
    }

    public void addRemovalTimeToExternalTaskLogByRootProcessInstanceId(String rootProcessInstanceId, Date removalTime) {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("rootProcessInstanceId", rootProcessInstanceId);
        parameters.put("removalTime", removalTime);
        this.getDbEntityManager().updatePreserveOrder(HistoricExternalTaskLogEntity.class, "updateExternalTaskLogByRootProcessInstanceId", parameters);
    }

    public void addRemovalTimeToExternalTaskLogByProcessInstanceId(String processInstanceId, Date removalTime) {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("processInstanceId", processInstanceId);
        parameters.put("removalTime", removalTime);
        this.getDbEntityManager().updatePreserveOrder(HistoricExternalTaskLogEntity.class, "updateExternalTaskLogByProcessInstanceId", parameters);
    }

    public void deleteHistoricExternalTaskLogsByProcessInstanceIds(List<String> processInstanceIds) {
        this.deleteExceptionByteArrayByParameterMap("processInstanceIdIn", processInstanceIds.toArray());
        this.getDbEntityManager().deletePreserveOrder(HistoricExternalTaskLogEntity.class, "deleteHistoricExternalTaskLogByProcessInstanceIds", processInstanceIds);
    }

    public DbOperation deleteExternalTaskLogByRemovalTime(Date removalTime, int minuteFrom, int minuteTo, int batchSize) {
        HashMap<String, Comparable<Date>> parameters = new HashMap<String, Comparable<Date>>();
        parameters.put("removalTime", removalTime);
        if (minuteTo - minuteFrom + 1 < 60) {
            parameters.put("minuteFrom", Integer.valueOf(minuteFrom));
            parameters.put("minuteTo", Integer.valueOf(minuteTo));
        }
        parameters.put("batchSize", Integer.valueOf(batchSize));
        return this.getDbEntityManager().deletePreserveOrder(HistoricExternalTaskLogEntity.class, "deleteExternalTaskLogByRemovalTime", new ListQueryParameterObject(parameters, 0, batchSize));
    }

    protected void deleteExceptionByteArrayByParameterMap(String key, Object value) {
        EnsureUtil.ensureNotNull(key, value);
        HashMap<String, Object> parameterMap = new HashMap<String, Object>();
        parameterMap.put(key, value);
        this.getDbEntityManager().delete(ByteArrayEntity.class, "deleteErrorDetailsByteArraysByIds", parameterMap);
    }

    public void fireExternalTaskCreatedEvent(final ExternalTask externalTask) {
        if (this.isHistoryEventProduced(HistoryEventTypes.EXTERNAL_TASK_CREATE, externalTask)) {
            HistoryEventProcessor.processHistoryEvents(new HistoryEventProcessor.HistoryEventCreator(){

                @Override
                public HistoryEvent createHistoryEvent(HistoryEventProducer producer) {
                    return producer.createHistoricExternalTaskLogCreatedEvt(externalTask);
                }
            });
        }
    }

    public void fireExternalTaskFailedEvent(final ExternalTask externalTask) {
        if (this.isHistoryEventProduced(HistoryEventTypes.EXTERNAL_TASK_FAIL, externalTask)) {
            HistoryEventProcessor.processHistoryEvents(new HistoryEventProcessor.HistoryEventCreator(){

                @Override
                public HistoryEvent createHistoryEvent(HistoryEventProducer producer) {
                    return producer.createHistoricExternalTaskLogFailedEvt(externalTask);
                }

                @Override
                public void postHandleSingleHistoryEventCreated(HistoryEvent event) {
                    ((ExternalTaskEntity)externalTask).setLastFailureLogId(event.getId());
                }
            });
        }
    }

    public void fireExternalTaskSuccessfulEvent(final ExternalTask externalTask) {
        if (this.isHistoryEventProduced(HistoryEventTypes.EXTERNAL_TASK_SUCCESS, externalTask)) {
            HistoryEventProcessor.processHistoryEvents(new HistoryEventProcessor.HistoryEventCreator(){

                @Override
                public HistoryEvent createHistoryEvent(HistoryEventProducer producer) {
                    return producer.createHistoricExternalTaskLogSuccessfulEvt(externalTask);
                }
            });
        }
    }

    public void fireExternalTaskDeletedEvent(final ExternalTask externalTask) {
        if (this.isHistoryEventProduced(HistoryEventTypes.EXTERNAL_TASK_DELETE, externalTask)) {
            HistoryEventProcessor.processHistoryEvents(new HistoryEventProcessor.HistoryEventCreator(){

                @Override
                public HistoryEvent createHistoryEvent(HistoryEventProducer producer) {
                    return producer.createHistoricExternalTaskLogDeletedEvt(externalTask);
                }
            });
        }
    }

    protected boolean isHistoryEventProduced(HistoryEventType eventType, ExternalTask externalTask) {
        ProcessEngineConfigurationImpl configuration = Context.getProcessEngineConfiguration();
        HistoryLevel historyLevel = configuration.getHistoryLevel();
        return historyLevel.isHistoryEventProduced(eventType, externalTask);
    }

    protected void configureQuery(HistoricExternalTaskLogQueryImpl query) {
        this.getAuthorizationManager().configureHistoricExternalTaskLogQuery(query);
        this.getTenantManager().configureQuery(query);
    }
}

