/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.bpmn.gateway;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import org.assertj.core.api.Assertions;
import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.history.HistoricProcessInstance;
import org.camunda.bpm.engine.impl.persistence.entity.ExecutionEntity;
import org.camunda.bpm.engine.impl.persistence.entity.JobEntity;
import org.camunda.bpm.engine.impl.util.CollectionUtil;
import org.camunda.bpm.engine.runtime.ActivityInstance;
import org.camunda.bpm.engine.runtime.Execution;
import org.camunda.bpm.engine.runtime.Job;
import org.camunda.bpm.engine.runtime.ProcessInstance;
import org.camunda.bpm.engine.runtime.ProcessInstantiationBuilder;
import org.camunda.bpm.engine.task.Task;
import org.camunda.bpm.engine.task.TaskQuery;
import org.camunda.bpm.engine.test.Deployment;
import org.camunda.bpm.engine.test.bpmn.gateway.InclusiveGatewayTestOrder;
import org.camunda.bpm.engine.test.util.ActivityInstanceAssert;
import org.camunda.bpm.engine.test.util.PluggableProcessEngineTest;
import org.camunda.bpm.model.bpmn.Bpmn;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;

public class InclusiveGatewayTest
extends PluggableProcessEngineTest {
    private static final String TASK1_NAME = "Task 1";
    private static final String TASK2_NAME = "Task 2";
    private static final String TASK3_NAME = "Task 3";
    private static final String BEAN_TASK1_NAME = "Basic service";
    private static final String BEAN_TASK2_NAME = "Standard service";
    private static final String BEAN_TASK3_NAME = "Gold Member service";
    protected static final String ASYNC_CONCURRENT_PARALLEL_GATEWAY = "org/camunda/bpm/engine/test/bpmn/gateway/InclusiveGatewayTest.AsyncConcurrentExecutions.ParallelGateway.bpmn";
    protected static final String ASYNC_CONCURRENT_PARALLEL_INCLUSIVE_GATEWAY = "org/camunda/bpm/engine/test/bpmn/gateway/InclusiveGatewayTest.AsyncConcurrentExecutions.ParallelInclusiveGateway.bpmn";

    @Deployment
    @Test
    public void testDivergingInclusiveGateway() {
        for (int i = 1; i <= 3; ++i) {
            ProcessInstance pi = this.runtimeService.startProcessInstanceByKey("inclusiveGwDiverging", CollectionUtil.singletonMap((String)"input", (Object)i));
            List tasks = this.taskService.createTaskQuery().processInstanceId(pi.getId()).list();
            ArrayList<String> expectedNames = new ArrayList<String>();
            if (i == 1) {
                expectedNames.add(TASK1_NAME);
            }
            if (i <= 2) {
                expectedNames.add(TASK2_NAME);
            }
            expectedNames.add(TASK3_NAME);
            for (Task task : tasks) {
                System.out.println("task " + task.getName());
            }
            Assert.assertEquals((long)(4 - i), (long)tasks.size());
            for (Task task : tasks) {
                expectedNames.remove(task.getName());
            }
            Assert.assertEquals((long)0L, (long)expectedNames.size());
            this.runtimeService.deleteProcessInstance(pi.getId(), "testing deletion");
        }
    }

    @Deployment
    @Test
    public void testMergingInclusiveGateway() {
        ProcessInstance pi = this.runtimeService.startProcessInstanceByKey("inclusiveGwMerging", CollectionUtil.singletonMap((String)"input", (Object)2));
        Assert.assertEquals((long)1L, (long)this.taskService.createTaskQuery().count());
        this.runtimeService.deleteProcessInstance(pi.getId(), "testing deletion");
    }

    @Deployment
    @Test
    public void testMergingInclusiveGatewayAsync() {
        ProcessInstance pi = this.runtimeService.startProcessInstanceByKey("inclusiveGwMerging", CollectionUtil.singletonMap((String)"input", (Object)2));
        List list = this.managementService.createJobQuery().list();
        for (Job job : list) {
            this.managementService.executeJob(job.getId());
        }
        Assert.assertEquals((long)1L, (long)this.taskService.createTaskQuery().count());
        this.runtimeService.deleteProcessInstance(pi.getId(), "testing deletion");
    }

    @Deployment
    @Test
    public void testPartialMergingInclusiveGateway() {
        ProcessInstance pi = this.runtimeService.startProcessInstanceByKey("partialInclusiveGwMerging", CollectionUtil.singletonMap((String)"input", (Object)2));
        Task partialTask = (Task)this.taskService.createTaskQuery().singleResult();
        Assert.assertEquals((Object)"partialTask", (Object)partialTask.getTaskDefinitionKey());
        this.taskService.complete(partialTask.getId());
        Task fullTask = (Task)this.taskService.createTaskQuery().singleResult();
        Assert.assertEquals((Object)"theTask", (Object)fullTask.getTaskDefinitionKey());
        this.runtimeService.deleteProcessInstance(pi.getId(), "testing deletion");
    }

    @Deployment
    @Test
    public void testNoSequenceFlowSelected() {
        try {
            this.runtimeService.startProcessInstanceByKey("inclusiveGwNoSeqFlowSelected", CollectionUtil.singletonMap((String)"input", (Object)4));
            Assert.fail();
        }
        catch (ProcessEngineException e) {
            this.testRule.assertTextPresent("ENGINE-02004 No outgoing sequence flow for the element with id 'inclusiveGw' could be selected for continuing the process.", e.getMessage());
        }
    }

    @Deployment
    @Test
    public void testParentActivationOnNonJoiningEnd() throws Exception {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("parentActivationOnNonJoiningEnd");
        List executionsBefore = this.runtimeService.createExecutionQuery().list();
        Assert.assertEquals((long)3L, (long)executionsBefore.size());
        List firstTasks = this.taskService.createTaskQuery().processInstanceId(processInstance.getId()).list();
        Assert.assertEquals((long)2L, (long)firstTasks.size());
        for (Task t : firstTasks) {
            this.taskService.complete(t.getId());
        }
        List secondTasks = this.taskService.createTaskQuery().processInstanceId(processInstance.getId()).list();
        Assert.assertEquals((long)2L, (long)secondTasks.size());
        Task task = (Task)secondTasks.get(0);
        this.taskService.complete(task.getId());
        List executionsAfter = this.runtimeService.createExecutionQuery().list();
        Assert.assertEquals((long)1L, (long)executionsAfter.size());
        Execution execution = (Execution)executionsAfter.get(0);
        List activeActivityIds = this.runtimeService.getActiveActivityIds(execution.getId());
        Assert.assertEquals((long)1L, (long)activeActivityIds.size());
        Task lastTask = (Task)this.taskService.createTaskQuery().processInstanceId(processInstance.getId()).singleResult();
        this.taskService.complete(lastTask.getId());
        Assert.assertEquals((long)0L, (long)this.runtimeService.createProcessInstanceQuery().active().count());
    }

    @Deployment
    @Test
    public void testWhitespaceInExpression() {
        this.runtimeService.startProcessInstanceByKey("inclusiveWhiteSpaceInExpression", CollectionUtil.singletonMap((String)"input", (Object)1));
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/gateway/InclusiveGatewayTest.testDivergingInclusiveGateway.bpmn20.xml"})
    @Test
    public void testUnknownVariableInExpression() {
        try {
            this.runtimeService.startProcessInstanceByKey("inclusiveGwDiverging", CollectionUtil.singletonMap((String)"iinput", (Object)1));
            Assert.fail();
        }
        catch (ProcessEngineException e) {
            this.testRule.assertTextPresent("Unknown property used in expression", e.getMessage());
        }
    }

    @Deployment
    @Test
    public void testDecideBasedOnBeanProperty() {
        this.runtimeService.startProcessInstanceByKey("inclusiveDecisionBasedOnBeanProperty", CollectionUtil.singletonMap((String)"order", (Object)new InclusiveGatewayTestOrder(150)));
        List tasks = this.taskService.createTaskQuery().list();
        Assert.assertEquals((long)2L, (long)tasks.size());
        HashMap<String, String> expectedNames = new HashMap<String, String>();
        expectedNames.put(BEAN_TASK2_NAME, BEAN_TASK2_NAME);
        expectedNames.put(BEAN_TASK3_NAME, BEAN_TASK3_NAME);
        for (Task task : tasks) {
            expectedNames.remove(task.getName());
        }
        Assert.assertEquals((long)0L, (long)expectedNames.size());
    }

    @Deployment
    @Test
    public void testDecideBasedOnListOrArrayOfBeans() {
        ArrayList<InclusiveGatewayTestOrder> orders = new ArrayList<InclusiveGatewayTestOrder>();
        orders.add(new InclusiveGatewayTestOrder(50));
        orders.add(new InclusiveGatewayTestOrder(300));
        orders.add(new InclusiveGatewayTestOrder(175));
        ProcessInstance pi = null;
        try {
            pi = this.runtimeService.startProcessInstanceByKey("inclusiveDecisionBasedOnListOrArrayOfBeans", CollectionUtil.singletonMap((String)"orders", orders));
            Assert.fail();
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
        orders.set(1, new InclusiveGatewayTestOrder(175));
        pi = this.runtimeService.startProcessInstanceByKey("inclusiveDecisionBasedOnListOrArrayOfBeans", CollectionUtil.singletonMap((String)"orders", orders));
        Task task = (Task)this.taskService.createTaskQuery().processInstanceId(pi.getId()).singleResult();
        Assert.assertNotNull((Object)task);
        Assert.assertEquals((Object)BEAN_TASK3_NAME, (Object)task.getName());
        orders.set(1, new InclusiveGatewayTestOrder(125));
        pi = this.runtimeService.startProcessInstanceByKey("inclusiveDecisionBasedOnListOrArrayOfBeans", CollectionUtil.singletonMap((String)"orders", orders));
        List tasks = this.taskService.createTaskQuery().processInstanceId(pi.getId()).list();
        Assert.assertNotNull((Object)tasks);
        Assert.assertEquals((long)2L, (long)tasks.size());
        ArrayList<String> expectedNames = new ArrayList<String>();
        expectedNames.add(BEAN_TASK2_NAME);
        expectedNames.add(BEAN_TASK3_NAME);
        for (Task t : tasks) {
            expectedNames.remove(t.getName());
        }
        Assert.assertEquals((long)0L, (long)expectedNames.size());
        InclusiveGatewayTestOrder[] orderArray = orders.toArray(new InclusiveGatewayTestOrder[orders.size()]);
        orderArray[1].setPrice(10);
        pi = this.runtimeService.startProcessInstanceByKey("inclusiveDecisionBasedOnListOrArrayOfBeans", CollectionUtil.singletonMap((String)"orders", (Object)orderArray));
        tasks = this.taskService.createTaskQuery().processInstanceId(pi.getId()).list();
        Assert.assertNotNull((Object)tasks);
        Assert.assertEquals((long)3L, (long)tasks.size());
        expectedNames.clear();
        expectedNames.add(BEAN_TASK1_NAME);
        expectedNames.add(BEAN_TASK2_NAME);
        expectedNames.add(BEAN_TASK3_NAME);
        for (Task t : tasks) {
            expectedNames.remove(t.getName());
        }
        Assert.assertEquals((long)0L, (long)expectedNames.size());
    }

    @Deployment
    @Test
    public void testDecideBasedOnBeanMethod() {
        ProcessInstance pi = this.runtimeService.startProcessInstanceByKey("inclusiveDecisionBasedOnBeanMethod", CollectionUtil.singletonMap((String)"order", (Object)new InclusiveGatewayTestOrder(200)));
        Task task = (Task)this.taskService.createTaskQuery().processInstanceId(pi.getId()).singleResult();
        Assert.assertNotNull((Object)task);
        Assert.assertEquals((Object)BEAN_TASK3_NAME, (Object)task.getName());
        pi = this.runtimeService.startProcessInstanceByKey("inclusiveDecisionBasedOnBeanMethod", CollectionUtil.singletonMap((String)"order", (Object)new InclusiveGatewayTestOrder(125)));
        List tasks = this.taskService.createTaskQuery().processInstanceId(pi.getId()).list();
        Assert.assertEquals((long)2L, (long)tasks.size());
        ArrayList<String> expectedNames = new ArrayList<String>();
        expectedNames.add(BEAN_TASK2_NAME);
        expectedNames.add(BEAN_TASK3_NAME);
        for (Task t : tasks) {
            expectedNames.remove(t.getName());
        }
        Assert.assertEquals((long)0L, (long)expectedNames.size());
        try {
            this.runtimeService.startProcessInstanceByKey("inclusiveDecisionBasedOnBeanMethod", CollectionUtil.singletonMap((String)"order", (Object)new InclusiveGatewayTestOrder(300)));
            Assert.fail();
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
    }

    @Deployment
    @Test
    public void testInvalidMethodExpression() {
        try {
            this.runtimeService.startProcessInstanceByKey("inclusiveInvalidMethodExpression", CollectionUtil.singletonMap((String)"order", (Object)new InclusiveGatewayTestOrder(50)));
            Assert.fail();
        }
        catch (ProcessEngineException e) {
            this.testRule.assertTextPresent("Unknown method used in expression", e.getMessage());
        }
    }

    @Deployment
    @Test
    public void testDefaultSequenceFlow() {
        ProcessInstance pi = this.runtimeService.startProcessInstanceByKey("inclusiveGwDefaultSequenceFlow", CollectionUtil.singletonMap((String)"input", (Object)1));
        List tasks = this.taskService.createTaskQuery().processInstanceId(pi.getId()).list();
        Assert.assertEquals((long)2L, (long)tasks.size());
        HashMap<String, String> expectedNames = new HashMap<String, String>();
        expectedNames.put("Input is one", "Input is one");
        expectedNames.put("Input is three or one", "Input is three or one");
        for (Task t : tasks) {
            expectedNames.remove(t.getName());
        }
        Assert.assertEquals((long)0L, (long)expectedNames.size());
        this.runtimeService.deleteProcessInstance(pi.getId(), null);
        pi = this.runtimeService.startProcessInstanceByKey("inclusiveGwDefaultSequenceFlow", CollectionUtil.singletonMap((String)"input", (Object)3));
        Task task = (Task)this.taskService.createTaskQuery().processInstanceId(pi.getId()).singleResult();
        Assert.assertEquals((Object)"Input is three or one", (Object)task.getName());
        pi = this.runtimeService.startProcessInstanceByKey("inclusiveGwDefaultSequenceFlow", CollectionUtil.singletonMap((String)"input", (Object)5));
        task = (Task)this.taskService.createTaskQuery().processInstanceId(pi.getId()).singleResult();
        Assert.assertEquals((Object)"Default input", (Object)task.getName());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/gateway/InclusiveGatewayTest.testDefaultSequenceFlow.bpmn20.xml"})
    @Test
    public void testDefaultSequenceFlowExecutionIsActive() {
        this.runtimeService.startProcessInstanceByKey("inclusiveGwDefaultSequenceFlow", CollectionUtil.singletonMap((String)"input", (Object)5));
        ExecutionEntity execution = (ExecutionEntity)this.runtimeService.createExecutionQuery().singleResult();
        Assert.assertEquals((Object)"theTask2", (Object)execution.getActivityId());
        Assert.assertTrue((boolean)execution.isActive());
    }

    @Deployment
    @Test
    public void testSplitMergeSplit() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("inclusiveGwSplitAndMerge", CollectionUtil.singletonMap((String)"input", (Object)1));
        List tasks = this.taskService.createTaskQuery().list();
        Assert.assertEquals((long)2L, (long)tasks.size());
        this.taskService.complete(((Task)tasks.get(0)).getId());
        this.taskService.complete(((Task)tasks.get(1)).getId());
        Task task = (Task)this.taskService.createTaskQuery().singleResult();
        Assert.assertNotNull((Object)task);
        Assert.assertEquals((Object)processInstance.getId(), (Object)task.getExecutionId());
    }

    @Deployment
    @Test
    public void testNoIdOnSequenceFlow() {
        ProcessInstance pi = this.runtimeService.startProcessInstanceByKey("inclusiveNoIdOnSequenceFlow", CollectionUtil.singletonMap((String)"input", (Object)3));
        Task task = (Task)this.taskService.createTaskQuery().processInstanceId(pi.getId()).singleResult();
        Assert.assertEquals((Object)"Input is more than one", (Object)task.getName());
        pi = this.runtimeService.startProcessInstanceByKey("inclusiveNoIdOnSequenceFlow", CollectionUtil.singletonMap((String)"input", (Object)1));
        List tasks = this.taskService.createTaskQuery().processInstanceId(pi.getId()).list();
        Assert.assertEquals((long)2L, (long)tasks.size());
        HashMap<String, String> expectedNames = new HashMap<String, String>();
        expectedNames.put("Input is one", "Input is one");
        expectedNames.put("Input is more than one", "Input is more than one");
        for (Task t : tasks) {
            expectedNames.remove(t.getName());
        }
        Assert.assertEquals((long)0L, (long)expectedNames.size());
    }

    @Deployment
    @Test
    public void testLoop() {
        ProcessInstance pi = this.runtimeService.startProcessInstanceByKey("inclusiveTestLoop", CollectionUtil.singletonMap((String)"counter", (Object)1));
        Task task = (Task)this.taskService.createTaskQuery().singleResult();
        Assert.assertEquals((Object)"task C", (Object)task.getName());
        this.taskService.complete(task.getId());
        Assert.assertEquals((long)0L, (long)this.taskService.createTaskQuery().count());
        for (Execution execution : this.runtimeService.createExecutionQuery().list()) {
            System.out.println(((ExecutionEntity)execution).getActivityId());
        }
        Assert.assertEquals((String)("Found executions: " + this.runtimeService.createExecutionQuery().list()), (long)0L, (long)this.runtimeService.createExecutionQuery().count());
        this.testRule.assertProcessEnded(pi.getId());
    }

    @Deployment
    @Test
    public void testJoinAfterSubprocesses() {
        HashMap<String, Integer> variableMap = new HashMap<String, Integer>();
        variableMap.put("a", 1);
        variableMap.put("b", 1);
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("InclusiveGateway", variableMap);
        Assert.assertNotNull((Object)processInstance.getId());
        List tasks = this.taskService.createTaskQuery().processInstanceId(processInstance.getId()).list();
        Assert.assertEquals((long)2L, (long)this.taskService.createTaskQuery().count());
        this.taskService.complete(((Task)tasks.get(0)).getId());
        Assert.assertEquals((long)1L, (long)this.taskService.createTaskQuery().count());
        this.taskService.complete(((Task)tasks.get(1)).getId());
        Task task = (Task)this.taskService.createTaskQuery().taskAssignee("c").singleResult();
        Assert.assertNotNull((Object)task);
        this.taskService.complete(task.getId());
        processInstance = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().processInstanceId(processInstance.getId()).singleResult();
        Assert.assertNull((Object)processInstance);
        variableMap = new HashMap();
        variableMap.put("a", 1);
        variableMap.put("b", 2);
        processInstance = this.runtimeService.startProcessInstanceByKey("InclusiveGateway", variableMap);
        Assert.assertNotNull((Object)processInstance.getId());
        tasks = this.taskService.createTaskQuery().processInstanceId(processInstance.getId()).list();
        Assert.assertEquals((long)1L, (long)this.taskService.createTaskQuery().count());
        task = (Task)tasks.get(0);
        Assert.assertEquals((Object)"a", (Object)task.getAssignee());
        this.taskService.complete(task.getId());
        task = (Task)this.taskService.createTaskQuery().taskAssignee("c").singleResult();
        Assert.assertNotNull((Object)task);
        this.taskService.complete(task.getId());
        processInstance = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().processInstanceId(processInstance.getId()).singleResult();
        Assert.assertNull((Object)processInstance);
        variableMap = new HashMap();
        variableMap.put("a", 2);
        variableMap.put("b", 2);
        try {
            processInstance = this.runtimeService.startProcessInstanceByKey("InclusiveGateway", variableMap);
            Assert.fail();
        }
        catch (ProcessEngineException e) {
            Assert.assertTrue((boolean)e.getMessage().contains("No outgoing sequence flow"));
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/gateway/InclusiveGatewayTest.testJoinAfterCall.bpmn20.xml", "org/camunda/bpm/engine/test/bpmn/gateway/InclusiveGatewayTest.testJoinAfterCallSubProcess.bpmn20.xml"})
    @Test
    public void testJoinAfterCall() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("InclusiveGatewayAfterCall");
        Assert.assertNotNull((Object)processInstance.getId());
        Assert.assertEquals((long)3L, (long)this.taskService.createTaskQuery().count());
        Task taskA = (Task)this.taskService.createTaskQuery().taskName("Task A").singleResult();
        Assert.assertNotNull((Object)taskA);
        this.taskService.complete(taskA.getId());
        Assert.assertEquals((long)2L, (long)this.taskService.createTaskQuery().count());
        Task taskB = (Task)this.taskService.createTaskQuery().taskName("Task B").singleResult();
        Assert.assertNotNull((Object)taskB);
        this.taskService.complete(taskB.getId());
        Assert.assertEquals((long)1L, (long)this.taskService.createTaskQuery().count());
        Task taskC = (Task)this.taskService.createTaskQuery().taskName("Task C").singleResult();
        Assert.assertNotNull((Object)taskC);
        this.taskService.complete(taskC.getId());
        Assert.assertEquals((long)1L, (long)this.taskService.createTaskQuery().count());
        Task taskD = (Task)this.taskService.createTaskQuery().taskName("Task D").singleResult();
        Assert.assertNotNull((Object)taskD);
        Assert.assertEquals((Object)"Task D", (Object)taskD.getName());
        this.taskService.complete(taskD.getId());
        processInstance = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().processInstanceId(processInstance.getId()).singleResult();
        Assert.assertNull((Object)processInstance);
    }

    @Deployment
    @Test
    public void testDecisionFunctionality() {
        HashMap<String, Integer> variables = new HashMap<String, Integer>();
        variables.put("input", 1);
        ProcessInstance pi = this.runtimeService.startProcessInstanceByKey("inclusiveGateway", variables);
        List tasks = this.taskService.createTaskQuery().processInstanceId(pi.getId()).list();
        Assert.assertEquals((long)3L, (long)tasks.size());
        HashMap<String, String> expectedMessages = new HashMap<String, String>();
        expectedMessages.put(TASK1_NAME, TASK1_NAME);
        expectedMessages.put(TASK2_NAME, TASK2_NAME);
        expectedMessages.put(TASK3_NAME, TASK3_NAME);
        for (Task task : tasks) {
            expectedMessages.remove(task.getName());
        }
        Assert.assertEquals((long)0L, (long)expectedMessages.size());
        variables.put("input", 2);
        pi = this.runtimeService.startProcessInstanceByKey("inclusiveGateway", variables);
        tasks = this.taskService.createTaskQuery().processInstanceId(pi.getId()).list();
        Assert.assertEquals((long)2L, (long)tasks.size());
        expectedMessages = new HashMap();
        expectedMessages.put(TASK2_NAME, TASK2_NAME);
        expectedMessages.put(TASK3_NAME, TASK3_NAME);
        for (Task task : tasks) {
            expectedMessages.remove(task.getName());
        }
        Assert.assertEquals((long)0L, (long)expectedMessages.size());
        variables.put("input", 3);
        pi = this.runtimeService.startProcessInstanceByKey("inclusiveGateway", variables);
        tasks = this.taskService.createTaskQuery().processInstanceId(pi.getId()).list();
        Assert.assertEquals((long)1L, (long)tasks.size());
        expectedMessages = new HashMap();
        expectedMessages.put(TASK3_NAME, TASK3_NAME);
        for (Task task : tasks) {
            expectedMessages.remove(task.getName());
        }
        Assert.assertEquals((long)0L, (long)expectedMessages.size());
        variables.put("input", 4);
        try {
            this.runtimeService.startProcessInstanceByKey("inclusiveGateway", variables);
            Assert.fail();
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
    }

    @Deployment
    @Test
    public void testJoinAfterSequentialMultiInstanceSubProcess() {
        this.runtimeService.startProcessInstanceByKey("process");
        TaskQuery query = this.taskService.createTaskQuery();
        Task task = (Task)query.taskDefinitionKey("task").singleResult();
        this.taskService.complete(task.getId());
        Assert.assertNull((Object)query.taskDefinitionKey("taskAfterJoin").singleResult());
    }

    @Deployment
    @Test
    public void testJoinAfterParallelMultiInstanceSubProcess() {
        this.runtimeService.startProcessInstanceByKey("process");
        TaskQuery query = this.taskService.createTaskQuery();
        Task task = (Task)query.taskDefinitionKey("task").singleResult();
        this.taskService.complete(task.getId());
        Assert.assertNull((Object)query.taskDefinitionKey("taskAfterJoin").singleResult());
    }

    @Deployment
    @Test
    public void testJoinAfterNestedScopes() {
        this.runtimeService.startProcessInstanceByKey("process");
        TaskQuery query = this.taskService.createTaskQuery();
        Task task = (Task)query.taskDefinitionKey("task").singleResult();
        this.taskService.complete(task.getId());
        Assert.assertNull((Object)query.taskDefinitionKey("taskAfterJoin").singleResult());
    }

    @Test
    public void testTriggerGatewayWithEnoughArrivedTokens() {
        this.testRule.deploy(Bpmn.createExecutableProcess((String)"process").startEvent().userTask("beforeTask").inclusiveGateway("gw").userTask("afterTask").endEvent().done());
        ProcessInstance processInstance = ((ProcessInstantiationBuilder)((ProcessInstantiationBuilder)this.runtimeService.createProcessInstanceByKey("process").startBeforeActivity("beforeTask")).startBeforeActivity("beforeTask")).execute();
        Task task = (Task)this.taskService.createTaskQuery().list().get(0);
        this.taskService.complete(task.getId());
        ActivityInstance activityInstance = this.runtimeService.getActivityInstance(processInstance.getId());
        ActivityInstanceAssert.assertThat(activityInstance).hasStructure(ActivityInstanceAssert.describeActivityInstanceTree(processInstance.getProcessDefinitionId()).activity("beforeTask").activity("afterTask").done());
    }

    @Deployment
    @Test
    public void testLoopingInclusiveGateways() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("process");
        ActivityInstance activityInstance = this.runtimeService.getActivityInstance(processInstance.getId());
        ActivityInstanceAssert.assertThat(activityInstance).hasStructure(ActivityInstanceAssert.describeActivityInstanceTree(processInstance.getProcessDefinitionId()).activity("task1").activity("task2").activity("inclusiveGw3").done());
    }

    @Test
    public void testRemoveConcurrentExecutionLocalVariablesOnJoin() {
        this.testRule.deploy(Bpmn.createExecutableProcess((String)"process").startEvent().inclusiveGateway("fork").userTask("task1").inclusiveGateway("join").userTask("afterTask").endEvent().moveToNode("fork").userTask("task2").connectTo("join").done());
        this.runtimeService.startProcessInstanceByKey("process");
        List tasks = this.taskService.createTaskQuery().list();
        for (Task task : tasks) {
            this.runtimeService.setVariableLocal(task.getExecutionId(), "var", (Object)"value");
        }
        this.taskService.complete(((Task)tasks.get(0)).getId());
        this.taskService.complete(((Task)tasks.get(1)).getId());
        Assert.assertEquals((long)0L, (long)this.runtimeService.createVariableInstanceQuery().count());
    }

    @Deployment
    @Test
    public void testJoinAfterEventBasedGateway() {
        TaskQuery taskQuery = this.taskService.createTaskQuery();
        this.runtimeService.startProcessInstanceByKey("process");
        Task task = (Task)taskQuery.singleResult();
        this.taskService.complete(task.getId());
        Assert.assertNull((Object)taskQuery.singleResult());
        this.runtimeService.correlateMessage("foo");
        task = (Task)taskQuery.singleResult();
        Assert.assertNotNull((Object)task);
        Assert.assertEquals((Object)"taskAfterJoin", (Object)task.getTaskDefinitionKey());
    }

    @Deployment
    @Test
    public void testJoinAfterEventBasedGatewayInSubProcess() {
        TaskQuery taskQuery = this.taskService.createTaskQuery();
        this.runtimeService.startProcessInstanceByKey("process");
        Task task = (Task)taskQuery.singleResult();
        this.taskService.complete(task.getId());
        Assert.assertNull((Object)taskQuery.singleResult());
        this.runtimeService.correlateMessage("foo");
        task = (Task)taskQuery.singleResult();
        Assert.assertNotNull((Object)task);
        Assert.assertEquals((Object)"taskAfterJoin", (Object)task.getTaskDefinitionKey());
    }

    @Deployment
    @Test
    public void testJoinAfterEventBasedGatewayContainedInSubProcess() {
        TaskQuery taskQuery = this.taskService.createTaskQuery();
        this.runtimeService.startProcessInstanceByKey("process");
        Task task = (Task)taskQuery.singleResult();
        this.taskService.complete(task.getId());
        Assert.assertNull((Object)taskQuery.singleResult());
        this.runtimeService.correlateMessage("foo");
        task = (Task)taskQuery.singleResult();
        Assert.assertNotNull((Object)task);
        Assert.assertEquals((Object)"taskAfterJoin", (Object)task.getTaskDefinitionKey());
    }

    @Ignore(value="https://jira.camunda.com/browse/CAM-14116")
    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/gateway/InclusiveGatewayTest.AsyncConcurrentExecutions.ParallelGateway.bpmn"})
    @Test
    public void shouldCompleteWithConcurrentExecution_ParallelGateway_1() {
        this.runtimeService.startProcessInstanceByKey("Process_Model11842");
        AtomicReference jobIdNotifyListener = new AtomicReference();
        AtomicReference jobIdActivityEnd = new AtomicReference();
        this.managementService.createJobQuery().list().forEach(job -> {
            if ("transition-notify-listener-take$Flow_0wno03o".equals(((JobEntity)job).getJobHandlerConfigurationRaw())) {
                jobIdNotifyListener.set(job.getId());
            } else if ("activity-end".equals(((JobEntity)job).getJobHandlerConfigurationRaw())) {
                jobIdActivityEnd.set(job.getId());
            }
        });
        this.managementService.executeJob((String)jobIdNotifyListener.get());
        this.managementService.executeJob((String)jobIdActivityEnd.get());
        Assertions.assertThat((long)this.managementService.createJobQuery().count()).isEqualTo(0L);
        Assertions.assertThat((String)((HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().singleResult()).getState()).isEqualTo((Object)"COMPLETED");
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/gateway/InclusiveGatewayTest.AsyncConcurrentExecutions.ParallelGateway.bpmn"})
    @Test
    public void shouldCompleteWithConcurrentExecution_ParallelGateway_2() {
        this.runtimeService.startProcessInstanceByKey("Process_Model11842");
        AtomicReference jobIdNotifyListener = new AtomicReference();
        AtomicReference jobIdActivityEnd = new AtomicReference();
        this.managementService.createJobQuery().list().forEach(job -> {
            if ("transition-notify-listener-take$Flow_0wno03o".equals(((JobEntity)job).getJobHandlerConfigurationRaw())) {
                jobIdNotifyListener.set(job.getId());
            } else if ("activity-end".equals(((JobEntity)job).getJobHandlerConfigurationRaw())) {
                jobIdActivityEnd.set(job.getId());
            }
        });
        this.managementService.executeJob((String)jobIdActivityEnd.get());
        this.managementService.executeJob((String)jobIdNotifyListener.get());
        Assertions.assertThat((long)this.managementService.createJobQuery().count()).isEqualTo(0L);
        Assertions.assertThat((String)((HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().singleResult()).getState()).isEqualTo((Object)"COMPLETED");
    }

    @Ignore(value="https://jira.camunda.com/browse/CAM-14116")
    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/gateway/InclusiveGatewayTest.AsyncConcurrentExecutions.ParallelInclusiveGateway.bpmn"})
    @Test
    public void shouldCompleteWithConcurrentExecution_InclusiveGateway_1() {
        this.runtimeService.startProcessInstanceByKey("Process_Model11842");
        AtomicReference jobIdNotifyListener = new AtomicReference();
        AtomicReference jobIdActivityEnd = new AtomicReference();
        this.managementService.createJobQuery().list().forEach(job -> {
            if ("transition-notify-listener-take$Flow_0wno03o".equals(((JobEntity)job).getJobHandlerConfigurationRaw())) {
                jobIdNotifyListener.set(job.getId());
            } else if ("activity-end".equals(((JobEntity)job).getJobHandlerConfigurationRaw())) {
                jobIdActivityEnd.set(job.getId());
            }
        });
        this.managementService.executeJob((String)jobIdNotifyListener.get());
        this.managementService.executeJob((String)jobIdActivityEnd.get());
        Assertions.assertThat((long)this.managementService.createJobQuery().count()).isEqualTo(0L);
        Assertions.assertThat((String)((HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().singleResult()).getState()).isEqualTo((Object)"COMPLETED");
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/gateway/InclusiveGatewayTest.AsyncConcurrentExecutions.ParallelInclusiveGateway.bpmn"})
    @Test
    public void shouldCompleteWithConcurrentExecution_InclusiveGateway_2() {
        this.runtimeService.startProcessInstanceByKey("Process_Model11842");
        AtomicReference jobIdNotifyListener = new AtomicReference();
        AtomicReference jobIdActivityEnd = new AtomicReference();
        this.managementService.createJobQuery().list().forEach(job -> {
            if ("transition-notify-listener-take$Flow_0wno03o".equals(((JobEntity)job).getJobHandlerConfigurationRaw())) {
                jobIdNotifyListener.set(job.getId());
            } else if ("activity-end".equals(((JobEntity)job).getJobHandlerConfigurationRaw())) {
                jobIdActivityEnd.set(job.getId());
            }
        });
        this.managementService.executeJob((String)jobIdActivityEnd.get());
        this.managementService.executeJob((String)jobIdNotifyListener.get());
        Assertions.assertThat((long)this.managementService.createJobQuery().count()).isEqualTo(0L);
        Assertions.assertThat((String)((HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().singleResult()).getState()).isEqualTo((Object)"COMPLETED");
    }
}

