/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.bpmn.scripttask;

import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import org.camunda.bpm.engine.repository.Deployment;
import org.camunda.bpm.engine.test.util.PluggableProcessEngineTest;
import org.camunda.bpm.model.bpmn.Bpmn;
import org.camunda.bpm.model.bpmn.BpmnModelInstance;
import org.camunda.bpm.model.bpmn.builder.ScriptTaskBuilder;
import org.junit.After;
import org.junit.Assert;

public abstract class AbstractScriptTaskTest
extends PluggableProcessEngineTest {
    private List<String> deploymentIds = new ArrayList<String>();

    @After
    public void tearDown() throws Exception {
        this.deploymentIds.forEach(deploymentId -> this.repositoryService.deleteDeployment(deploymentId, true));
    }

    protected void deployProcess(BpmnModelInstance process) {
        Deployment deployment = this.repositoryService.createDeployment().addModelInstance("testProcess.bpmn", process).deploy();
        this.deploymentIds.add(deployment.getId());
    }

    protected void deployProcess(String scriptFormat, String scriptText) {
        BpmnModelInstance process = this.createProcess(scriptFormat, scriptText);
        this.deployProcess(process);
    }

    protected BpmnModelInstance createProcess(String scriptFormat, String scriptText) {
        return ((ScriptTaskBuilder)((ScriptTaskBuilder)Bpmn.createExecutableProcess((String)"testProcess").startEvent().scriptTask().scriptFormat(scriptFormat)).scriptText(scriptText)).userTask().endEvent().done();
    }

    protected String getNormalizedResourcePath(String classPathResource) {
        try {
            return Paths.get(this.getClass().getResource(classPathResource).toURI()).toString().replace('\\', '/');
        }
        catch (Exception e) {
            Assert.fail((String)("Cannot read path of '" + classPathResource + "': " + e.getMessage()));
            return null;
        }
    }
}

