/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.cmmn.required;

import java.util.Collections;
import org.assertj.core.api.Assertions;
import org.camunda.bpm.engine.exception.NotAllowedException;
import org.camunda.bpm.engine.runtime.CaseExecution;
import org.camunda.bpm.engine.runtime.CaseInstance;
import org.camunda.bpm.engine.test.Deployment;
import org.camunda.bpm.engine.test.util.PluggableProcessEngineTest;
import org.junit.Assert;
import org.junit.Test;

public class RequiredRuleTest
extends PluggableProcessEngineTest {
    @Deployment(resources={"org/camunda/bpm/engine/test/cmmn/required/RequiredRuleTest.testVariableBasedRule.cmmn"})
    @Test
    public void testRequiredRuleEvaluatesToTrue() {
        CaseInstance caseInstance = this.caseService.createCaseInstanceByKey("case", Collections.singletonMap("required", true));
        CaseExecution taskExecution = (CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_1").singleResult();
        Assert.assertNotNull((Object)taskExecution);
        Assert.assertTrue((boolean)taskExecution.isRequired());
        try {
            this.caseService.completeCaseExecution(caseInstance.getId());
            Assert.fail((String)"completing the containing stage should not be allowed");
        }
        catch (NotAllowedException notAllowedException) {
            // empty catch block
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/cmmn/required/RequiredRuleTest.testVariableBasedRule.cmmn"})
    @Test
    public void testRequiredRuleEvaluatesToFalse() {
        CaseInstance caseInstance = this.caseService.createCaseInstanceByKey("case", Collections.singletonMap("required", false));
        CaseExecution taskExecution = (CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_1").singleResult();
        Assert.assertNotNull((Object)taskExecution);
        Assert.assertFalse((boolean)taskExecution.isRequired());
        this.caseService.completeCaseExecution(caseInstance.getId());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/cmmn/required/RequiredRuleTest.testDefaultVariableBasedRule.cmmn"})
    @Test
    public void testDefaultRequiredRuleEvaluatesToTrue() {
        CaseInstance caseInstance = this.caseService.createCaseInstanceByKey("case", Collections.singletonMap("required", true));
        CaseExecution taskExecution = (CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_1").singleResult();
        Assert.assertNotNull((Object)taskExecution);
        Assert.assertTrue((boolean)taskExecution.isRequired());
        try {
            this.caseService.completeCaseExecution(caseInstance.getId());
            Assert.fail((String)"completing the containing stage should not be allowed");
        }
        catch (NotAllowedException notAllowedException) {
            // empty catch block
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/cmmn/required/RequiredRuleTest.testDefaultVariableBasedRule.cmmn"})
    @Test
    public void testDefaultRequiredRuleEvaluatesToFalse() {
        CaseInstance caseInstance = this.caseService.createCaseInstanceByKey("case", Collections.singletonMap("required", false));
        CaseExecution taskExecution = (CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_1").singleResult();
        Assert.assertNotNull((Object)taskExecution);
        Assert.assertFalse((boolean)taskExecution.isRequired());
        this.caseService.completeCaseExecution(caseInstance.getId());
    }

    @Deployment
    @Test
    public void testDefaultRequiredRuleWithoutConditionEvaluatesToTrue() {
        this.caseService.createCaseInstanceByKey("case");
        CaseExecution taskExecution = (CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_1").singleResult();
        Assertions.assertThat((Object)taskExecution).isNotNull();
        Assertions.assertThat((boolean)taskExecution.isRequired()).isTrue();
    }

    @Deployment
    @Test
    public void testDefaultRequiredRuleWithEmptyConditionEvaluatesToTrue() {
        this.caseService.createCaseInstanceByKey("case");
        CaseExecution taskExecution = (CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_1").singleResult();
        Assertions.assertThat((Object)taskExecution).isNotNull();
        Assertions.assertThat((boolean)taskExecution.isRequired()).isTrue();
    }
}

