/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.concurrency;

import java.util.List;
import org.camunda.bpm.engine.OptimisticLockingException;
import org.camunda.bpm.engine.RuntimeService;
import org.camunda.bpm.engine.TaskService;
import org.camunda.bpm.engine.impl.ProcessEngineLogger;
import org.camunda.bpm.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.camunda.bpm.engine.impl.cmd.CompleteTaskCmd;
import org.camunda.bpm.engine.task.Task;
import org.camunda.bpm.engine.test.Deployment;
import org.camunda.bpm.engine.test.concurrency.ControllableThread;
import org.camunda.bpm.engine.test.concurrency.ControlledCommand;
import org.camunda.bpm.engine.test.util.ProcessEngineTestRule;
import org.camunda.bpm.engine.test.util.ProvidedProcessEngineRule;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;
import org.slf4j.Logger;

public class CompetingSubprocessCompletionTest {
    private static Logger LOG = ProcessEngineLogger.TEST_LOGGER.getLogger();
    protected ProvidedProcessEngineRule engineRule = new ProvidedProcessEngineRule();
    protected ProcessEngineTestRule testRule = new ProcessEngineTestRule(this.engineRule);
    @Rule
    public RuleChain ruleChain = RuleChain.outerRule((TestRule)this.engineRule).around((TestRule)this.testRule);
    protected ProcessEngineConfigurationImpl processEngineConfiguration;
    protected RuntimeService runtimeService;
    protected TaskService taskService;
    static ControllableThread activeThread;

    @Before
    public void initializeServices() {
        this.processEngineConfiguration = this.engineRule.getProcessEngineConfiguration();
        this.runtimeService = this.engineRule.getRuntimeService();
        this.taskService = this.engineRule.getTaskService();
    }

    @Deployment
    @Test
    public void testCompetingSubprocessEnd() throws Exception {
        this.runtimeService.startProcessInstanceByKey("CompetingSubprocessEndProcess");
        List tasks = this.taskService.createTaskQuery().list();
        Assert.assertEquals((long)3L, (long)tasks.size());
        LOG.debug("test thread starts thread one");
        CompleteTaskThread threadOne = new CompleteTaskThread(((Task)tasks.get(0)).getId());
        threadOne.startAndWaitUntilControlIsReturned();
        LOG.debug("test thread continues to start thread two");
        CompleteTaskThread threadTwo = new CompleteTaskThread(((Task)tasks.get(1)).getId());
        threadTwo.startAndWaitUntilControlIsReturned();
        LOG.debug("test thread notifies thread 1");
        threadOne.proceedAndWaitTillDone();
        Assert.assertNull((Object)((Object)threadOne.exception));
        LOG.debug("test thread notifies thread 2");
        threadTwo.proceedAndWaitTillDone();
        Assert.assertNotNull((Object)((Object)threadTwo.exception));
        this.testRule.assertTextPresent("was updated by another transaction concurrently", threadTwo.exception.getMessage());
    }

    public class CompleteTaskThread
    extends ControllableThread {
        String taskId;
        OptimisticLockingException exception;

        public CompleteTaskThread(String taskId) {
            this.taskId = taskId;
        }

        @Override
        public synchronized void startAndWaitUntilControlIsReturned() {
            activeThread = this;
            super.startAndWaitUntilControlIsReturned();
        }

        @Override
        public void run() {
            try {
                CompetingSubprocessCompletionTest.this.processEngineConfiguration.getCommandExecutorTxRequired().execute(new ControlledCommand(activeThread, new CompleteTaskCmd(this.taskId, null)));
            }
            catch (OptimisticLockingException e) {
                this.exception = e;
            }
            LOG.debug(this.getName() + " ends");
        }
    }
}

