/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.jobexecutor;

import java.util.Date;
import org.assertj.core.api.Assertions;
import org.camunda.bpm.engine.delegate.DelegateExecution;
import org.camunda.bpm.engine.delegate.JavaDelegate;
import org.camunda.bpm.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.camunda.bpm.engine.impl.interceptor.CommandContext;
import org.camunda.bpm.engine.impl.interceptor.CommandContextFactory;
import org.camunda.bpm.engine.impl.jobexecutor.JobExecutor;
import org.camunda.bpm.engine.impl.persistence.entity.JobEntity;
import org.camunda.bpm.engine.runtime.ActivityInstance;
import org.camunda.bpm.engine.runtime.Execution;
import org.camunda.bpm.engine.runtime.ProcessInstance;
import org.camunda.bpm.engine.test.ProcessEngineRule;
import org.camunda.bpm.engine.test.concurrency.ConcurrencyTestHelper;
import org.camunda.bpm.engine.test.jobexecutor.ControllableCommandContext;
import org.camunda.bpm.engine.test.jobexecutor.ControllableJobExecutor;
import org.camunda.bpm.engine.test.util.ProcessEngineBootstrapRule;
import org.camunda.bpm.engine.test.util.ProcessEngineTestRule;
import org.camunda.bpm.engine.test.util.ProvidedProcessEngineRule;
import org.camunda.bpm.model.bpmn.Bpmn;
import org.camunda.bpm.model.bpmn.BpmnModelInstance;
import org.camunda.bpm.model.bpmn.builder.CallActivityBuilder;
import org.camunda.bpm.model.bpmn.builder.ServiceTaskBuilder;
import org.camunda.bpm.model.bpmn.builder.UserTaskBuilder;
import org.junit.After;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;

public class JobExecutorFollowUpTest {
    protected static final BpmnModelInstance TWO_TASKS_PROCESS = ((ServiceTaskBuilder)((ServiceTaskBuilder)((ServiceTaskBuilder)((ServiceTaskBuilder)Bpmn.createExecutableProcess((String)"process").startEvent().serviceTask("serviceTask1").camundaAsyncBefore()).camundaClass(SyncDelegate.class.getName())).serviceTask("serviceTask2").camundaAsyncBefore()).camundaClass(SyncDelegate.class.getName())).endEvent().done();
    protected static final BpmnModelInstance TWO_TASKS_DIFFERENT_PRIORITIES_PROCESS = ((ServiceTaskBuilder)((ServiceTaskBuilder)((ServiceTaskBuilder)((ServiceTaskBuilder)((ServiceTaskBuilder)((ServiceTaskBuilder)Bpmn.createExecutableProcess((String)"prioritizedTasksProcess").startEvent().serviceTask("prio20serviceTask").camundaAsyncBefore()).camundaClass(SyncDelegate.class.getName())).camundaJobPriority("20")).serviceTask("prio10serviceTask").camundaAsyncBefore()).camundaClass(SyncDelegate.class.getName())).camundaJobPriority("10")).endEvent().done();
    protected static final BpmnModelInstance CALL_ACTIVITY_PROCESS = ((CallActivityBuilder)((CallActivityBuilder)Bpmn.createExecutableProcess((String)"callActivityProcess").startEvent().callActivity("callActivity").camundaAsyncBefore()).calledElement("oneTaskProcess")).endEvent().done();
    protected static final BpmnModelInstance ONE_TASK_PROCESS = ((UserTaskBuilder)Bpmn.createExecutableProcess((String)"oneTaskProcess").startEvent().userTask("serviceTask").camundaAsyncBefore()).endEvent().done();
    protected boolean skipFlushControl = true;
    protected ProcessEngineBootstrapRule bootstrapRule = new ProcessEngineBootstrapRule(configuration -> {
        configuration.setJobExecutor((JobExecutor)JobExecutorFollowUpTest.buildControllableJobExecutor());
        configuration.setCommandContextFactory(new CommandContextFactory((ProcessEngineConfigurationImpl)configuration){
            final /* synthetic */ ProcessEngineConfigurationImpl val$configuration;
            {
                this.val$configuration = processEngineConfigurationImpl;
            }

            public CommandContext createCommandContext() {
                return new ControllableCommandContext(this.val$configuration, executionThread, JobExecutorFollowUpTest.this.skipFlushControl);
            }
        });
    });
    protected ProcessEngineRule engineRule = new ProvidedProcessEngineRule(this.bootstrapRule);
    protected ProcessEngineTestRule testHelper = new ProcessEngineTestRule(this.engineRule);
    @Rule
    public RuleChain ruleChain = RuleChain.outerRule((TestRule)this.bootstrapRule).around((TestRule)this.engineRule).around((TestRule)this.testHelper);
    protected ControllableJobExecutor jobExecutor;
    protected ConcurrencyTestHelper.ThreadControl acquisitionThread;
    protected static ConcurrencyTestHelper.ThreadControl executionThread;
    protected ProcessEngineConfigurationImpl configuration;
    protected Long defaultJobExecutorPriorityRangeMin;
    protected Long defaultJobExecutorPriorityRangeMax;

    protected static ControllableJobExecutor buildControllableJobExecutor() {
        ControllableJobExecutor jobExecutor = new ControllableJobExecutor();
        jobExecutor.setMaxJobsPerAcquisition(2);
        jobExecutor.proceedAndWaitOnShutdown(false);
        return jobExecutor;
    }

    @Before
    public void setUp() throws Exception {
        this.jobExecutor = (ControllableJobExecutor)((ProcessEngineConfigurationImpl)this.engineRule.getProcessEngine().getProcessEngineConfiguration()).getJobExecutor();
        this.jobExecutor.setMaxJobsPerAcquisition(2);
        this.acquisitionThread = this.jobExecutor.getAcquisitionThreadControl();
        executionThread = this.jobExecutor.getExecutionThreadControl();
        this.configuration = this.engineRule.getProcessEngineConfiguration();
        this.defaultJobExecutorPriorityRangeMin = this.configuration.getJobExecutorPriorityRangeMin();
        this.defaultJobExecutorPriorityRangeMax = this.configuration.getJobExecutorPriorityRangeMax();
    }

    @After
    public void tearDown() {
        this.jobExecutor.shutdown();
        this.configuration.setJobExecutorPriorityRangeMin(this.defaultJobExecutorPriorityRangeMin);
        this.configuration.setJobExecutorPriorityRangeMax(this.defaultJobExecutorPriorityRangeMax);
    }

    @Test
    public void shouldExecuteExclusiveFollowUpJobInSameProcessInstance() {
        this.testHelper.deploy(TWO_TASKS_PROCESS);
        ProcessInstance processInstance = this.engineRule.getRuntimeService().startProcessInstanceByKey("process");
        this.jobExecutor.start();
        this.acquisitionThread.waitForSync();
        this.acquisitionThread.makeContinueAndWaitForSync();
        this.acquisitionThread.makeContinue();
        executionThread.waitForSync();
        executionThread.makeContinueAndWaitForSync();
        ActivityInstance activityInstance = this.engineRule.getRuntimeService().getActivityInstance(processInstance.getId());
        Assertions.assertThat((Object[])activityInstance.getTransitionInstances("serviceTask2")).hasSize(1);
        JobEntity followUpJob = (JobEntity)this.engineRule.getManagementService().createJobQuery().singleResult();
        Assertions.assertThat((Object)followUpJob).isNotNull();
        Assertions.assertThat((String)followUpJob.getLockOwner()).isNotNull();
        Assertions.assertThat((Date)followUpJob.getLockExpirationTime()).isNotNull();
        executionThread.makeContinue();
        this.acquisitionThread.waitForSync();
        this.testHelper.assertProcessEnded(processInstance.getId());
    }

    @Test
    public void shouldExecuteExclusiveFollowUpJobInDifferentProcessInstance() {
        this.testHelper.deploy(CALL_ACTIVITY_PROCESS, ONE_TASK_PROCESS);
        ProcessInstance processInstance = this.engineRule.getRuntimeService().startProcessInstanceByKey("callActivityProcess");
        this.jobExecutor.start();
        this.acquisitionThread.waitForSync();
        this.acquisitionThread.makeContinueAndWaitForSync();
        this.acquisitionThread.makeContinueAndWaitForSync();
        ProcessInstance calledInstance = (ProcessInstance)this.engineRule.getRuntimeService().createProcessInstanceQuery().superProcessInstanceId(processInstance.getId()).singleResult();
        Assertions.assertThat((Object)calledInstance).isNotNull();
        ActivityInstance activityInstance = this.engineRule.getRuntimeService().getActivityInstance(calledInstance.getId());
        Assertions.assertThat((Object[])activityInstance.getTransitionInstances("serviceTask")).hasSize(1);
        JobEntity followUpJob = (JobEntity)this.engineRule.getManagementService().createJobQuery().singleResult();
        Assertions.assertThat((Object)followUpJob).isNotNull();
        Assertions.assertThat((String)followUpJob.getLockOwner()).isNull();
        Assertions.assertThat((Date)followUpJob.getLockExpirationTime()).isNull();
    }

    @Test
    public void shouldNotExecuteExclusiveFollowUpJobWithOutOfRangePriority() throws InterruptedException {
        this.testHelper.deploy(TWO_TASKS_DIFFERENT_PRIORITIES_PROCESS);
        this.configuration.setJobExecutorPriorityRangeMin(Long.valueOf(15L));
        ProcessInstance processInstance = this.engineRule.getRuntimeService().startProcessInstanceByKey("prioritizedTasksProcess");
        this.jobExecutor.start();
        this.acquireAndCompleteJob();
        ActivityInstance activityInstance = this.engineRule.getRuntimeService().getActivityInstance(processInstance.getId());
        Assertions.assertThat((Object[])activityInstance.getTransitionInstances("prio10serviceTask")).hasSize(1);
        Execution execution = (Execution)this.engineRule.getRuntimeService().createExecutionQuery().activityId("prio10serviceTask").singleResult();
        JobEntity followUpJob = (JobEntity)this.engineRule.getManagementService().createJobQuery().processInstanceId(processInstance.getId()).singleResult();
        Assertions.assertThat((String)followUpJob.getExecutionId()).isEqualTo((Object)execution.getId());
        Assertions.assertThat((Object)followUpJob).isNotNull();
        Assertions.assertThat((String)followUpJob.getLockOwner()).isNull();
        Assertions.assertThat((Date)followUpJob.getLockExpirationTime()).isNull();
        this.configuration.setJobExecutorPriorityRangeMin(Long.valueOf(5L));
        this.configuration.setJobExecutorPriorityRangeMax(Long.valueOf(15L));
        this.acquireAndCompleteJob();
        this.acquisitionThread.waitForSync();
        this.testHelper.assertProcessEnded(processInstance.getId());
    }

    private void acquireAndCompleteJob() throws InterruptedException {
        this.acquisitionThread.waitForSync();
        this.acquisitionThread.makeContinueAndWaitForSync();
        this.acquisitionThread.makeContinue();
        executionThread.waitForSync();
        this.skipFlushControl = false;
        executionThread.makeContinueAndWaitForSync();
        this.skipFlushControl = true;
        executionThread.makeContinue();
    }

    public static class SyncDelegate
    implements JavaDelegate {
        public void execute(DelegateExecution execution) throws Exception {
            executionThread.sync();
        }
    }
}

