/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl;

import java.util.UUID;
import org.camunda.bpm.engine.ProcessEngineBootstrapCommand;
import org.camunda.bpm.engine.impl.ProcessEngineLogger;
import org.camunda.bpm.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.camunda.bpm.engine.impl.context.Context;
import org.camunda.bpm.engine.impl.db.DbEntity;
import org.camunda.bpm.engine.impl.db.EnginePersistenceLogger;
import org.camunda.bpm.engine.impl.db.entitymanager.OptimisticLockingListener;
import org.camunda.bpm.engine.impl.db.entitymanager.OptimisticLockingResult;
import org.camunda.bpm.engine.impl.db.entitymanager.operation.DbOperation;
import org.camunda.bpm.engine.impl.interceptor.CommandContext;
import org.camunda.bpm.engine.impl.persistence.entity.EverLivingJobEntity;
import org.camunda.bpm.engine.impl.persistence.entity.PropertyEntity;
import org.camunda.bpm.engine.impl.persistence.entity.PropertyManager;
import org.camunda.bpm.engine.impl.telemetry.dto.LicenseKeyDataImpl;
import org.camunda.bpm.engine.impl.telemetry.dto.TelemetryDataImpl;
import org.camunda.bpm.engine.impl.telemetry.reporter.TelemetryReporter;
import org.camunda.bpm.engine.impl.util.LicenseKeyUtil;
import org.camunda.bpm.engine.impl.util.TelemetryUtil;

public class BootstrapEngineCommand
implements ProcessEngineBootstrapCommand {
    private static final EnginePersistenceLogger LOG = ProcessEngineLogger.PERSISTENCE_LOGGER;
    protected static final String TELEMETRY_PROPERTY_NAME = "camunda.telemetry.enabled";
    protected static final String TELEMETRY_INIT_MESSAGE_SENT_NAME = "camunda.telemetry.initial.message.sent";
    protected static final String INSTALLATION_PROPERTY_NAME = "camunda.installation.id";
    protected boolean sendInitialTelemetryMessage = false;

    @Override
    public Void execute(CommandContext commandContext) {
        this.initializeInstallationId(commandContext);
        this.checkDeploymentLockExists(commandContext);
        if (this.isHistoryCleanupEnabled(commandContext)) {
            this.checkHistoryCleanupLockExists(commandContext);
            this.createHistoryCleanupJob(commandContext);
        }
        this.initializeTelemetryProperty(commandContext);
        this.updateTelemetryData(commandContext);
        this.startTelemetryReporter(commandContext);
        return null;
    }

    protected void createHistoryCleanupJob(CommandContext commandContext) {
        if (Context.getProcessEngineConfiguration().getManagementService().getTableMetaData("ACT_RU_JOB") != null) {
            commandContext.getDbEntityManager().registerOptimisticLockingListener(new OptimisticLockingListener(){

                @Override
                public Class<? extends DbEntity> getEntityType() {
                    return EverLivingJobEntity.class;
                }

                @Override
                public OptimisticLockingResult failedOperation(DbOperation operation) {
                    return OptimisticLockingResult.IGNORE;
                }
            });
            Context.getProcessEngineConfiguration().getHistoryService().cleanUpHistoryAsync();
        }
    }

    public void checkDeploymentLockExists(CommandContext commandContext) {
        PropertyEntity deploymentLockProperty = commandContext.getPropertyManager().findPropertyById("deployment.lock");
        if (deploymentLockProperty == null) {
            LOG.noDeploymentLockPropertyFound();
        }
    }

    public void checkHistoryCleanupLockExists(CommandContext commandContext) {
        PropertyEntity historyCleanupLockProperty = commandContext.getPropertyManager().findPropertyById("history.cleanup.job.lock");
        if (historyCleanupLockProperty == null) {
            LOG.noHistoryCleanupLockPropertyFound();
        }
    }

    protected boolean isHistoryCleanupEnabled(CommandContext commandContext) {
        return commandContext.getProcessEngineConfiguration().isHistoryCleanupEnabled();
    }

    public void initializeTelemetryProperty(CommandContext commandContext) {
        try {
            this.checkTelemetryLockExists(commandContext);
            this.acquireExclusiveTelemetryLock(commandContext);
            PropertyEntity databaseTelemetryProperty = this.databaseTelemetryConfiguration(commandContext);
            PropertyEntity databaseTelemetryInitMessageProperty = this.databaseTelemetryInitialMessageSent(commandContext);
            ProcessEngineConfigurationImpl processEngineConfiguration = commandContext.getProcessEngineConfiguration();
            if (databaseTelemetryProperty == null) {
                LOG.noTelemetryPropertyFound();
                this.createTelemetryProperty(commandContext);
            } else if (databaseTelemetryInitMessageProperty == null) {
                this.initializeInitialTelemetryMessage();
            }
            if (databaseTelemetryProperty == null && processEngineConfiguration.isInitializeTelemetry().booleanValue() || Boolean.valueOf(databaseTelemetryProperty.getValue()).booleanValue()) {
                TelemetryUtil.toggleLocalTelemetry(true, processEngineConfiguration.getTelemetryRegistry(), processEngineConfiguration.getMetricsRegistry());
            }
        }
        catch (Exception e) {
            LOG.errorConfiguringTelemetryProperty(e);
        }
    }

    protected void checkTelemetryLockExists(CommandContext commandContext) {
        PropertyEntity telemetryLockProperty = commandContext.getPropertyManager().findPropertyById("telemetry.lock");
        if (telemetryLockProperty == null) {
            LOG.noTelemetryLockPropertyFound();
        }
    }

    protected PropertyEntity databaseTelemetryConfiguration(CommandContext commandContext) {
        try {
            return commandContext.getPropertyManager().findPropertyById(TELEMETRY_PROPERTY_NAME);
        }
        catch (Exception e) {
            LOG.errorFetchingTelemetryPropertyInDatabase(e);
            return null;
        }
    }

    protected PropertyEntity databaseTelemetryInitialMessageSent(CommandContext commandContext) {
        try {
            return commandContext.getPropertyManager().findPropertyById(TELEMETRY_INIT_MESSAGE_SENT_NAME);
        }
        catch (Exception e) {
            LOG.errorFetchingTelemetryInitialMessagePropertyInDatabase(e);
            return null;
        }
    }

    protected void createTelemetryProperty(CommandContext commandContext) {
        Boolean telemetryEnabled = commandContext.getProcessEngineConfiguration().isInitializeTelemetry();
        PropertyEntity property = null;
        property = telemetryEnabled != null ? new PropertyEntity(TELEMETRY_PROPERTY_NAME, Boolean.toString(telemetryEnabled)) : new PropertyEntity(TELEMETRY_PROPERTY_NAME, "null");
        commandContext.getPropertyManager().insert(property);
        LOG.creatingTelemetryPropertyInDatabase(telemetryEnabled);
        this.initializeInitialTelemetryMessage();
    }

    protected void initializeInitialTelemetryMessage() {
        this.sendInitialTelemetryMessage = true;
    }

    public void initializeInstallationId(CommandContext commandContext) {
        this.checkInstallationIdLockExists(commandContext);
        String databaseInstallationId = this.databaseInstallationId(commandContext);
        if (databaseInstallationId == null || databaseInstallationId.isEmpty()) {
            this.acquireExclusiveInstallationIdLock(commandContext);
            databaseInstallationId = this.databaseInstallationId(commandContext);
            if (databaseInstallationId == null || databaseInstallationId.isEmpty()) {
                LOG.noInstallationIdPropertyFound();
                this.createInstallationProperty(commandContext);
            }
        } else {
            LOG.installationIdPropertyFound(databaseInstallationId);
            commandContext.getProcessEngineConfiguration().setInstallationId(databaseInstallationId);
        }
    }

    protected void createInstallationProperty(CommandContext commandContext) {
        String installationId = UUID.randomUUID().toString();
        PropertyEntity property = new PropertyEntity(INSTALLATION_PROPERTY_NAME, installationId);
        commandContext.getPropertyManager().insert(property);
        LOG.creatingInstallationPropertyInDatabase(property.getValue());
        commandContext.getProcessEngineConfiguration().setInstallationId(installationId);
    }

    protected String databaseInstallationId(CommandContext commandContext) {
        try {
            PropertyEntity installationIdProperty = commandContext.getPropertyManager().findPropertyById(INSTALLATION_PROPERTY_NAME);
            return installationIdProperty != null ? installationIdProperty.getValue() : null;
        }
        catch (Exception e) {
            LOG.couldNotSelectInstallationId(e.getMessage());
            return null;
        }
    }

    protected void checkInstallationIdLockExists(CommandContext commandContext) {
        PropertyEntity installationIdProperty = commandContext.getPropertyManager().findPropertyById("installationId.lock");
        if (installationIdProperty == null) {
            LOG.noInstallationIdLockPropertyFound();
        }
    }

    protected void updateTelemetryData(CommandContext commandContext) {
        ProcessEngineConfigurationImpl processEngineConfiguration = commandContext.getProcessEngineConfiguration();
        String installationId = processEngineConfiguration.getInstallationId();
        TelemetryDataImpl telemetryData = processEngineConfiguration.getTelemetryData();
        telemetryData.setInstallation(installationId);
        String licenseKey = processEngineConfiguration.getManagementService().getLicenseKey();
        if (licenseKey != null) {
            LicenseKeyDataImpl licenseKeyData = LicenseKeyUtil.getLicenseKeyData(licenseKey);
            processEngineConfiguration.getTelemetryRegistry().setLicenseKey(licenseKeyData);
            telemetryData.getProduct().getInternals().setLicenseKey(licenseKeyData);
        }
    }

    protected void startTelemetryReporter(CommandContext commandContext) {
        ProcessEngineConfigurationImpl processEngineConfiguration = commandContext.getProcessEngineConfiguration();
        TelemetryReporter telemetryReporter = processEngineConfiguration.getTelemetryReporter();
        boolean telemetryReporterActivate = processEngineConfiguration.isTelemetryReporterActivate();
        if (telemetryReporter != null && telemetryReporterActivate) {
            try {
                telemetryReporter.start(this.sendInitialTelemetryMessage);
            }
            catch (Exception e) {
                ProcessEngineLogger.TELEMETRY_LOGGER.schedulingTaskFailsOnEngineStart(e);
            }
        }
    }

    protected void acquireExclusiveTelemetryLock(CommandContext commandContext) {
        PropertyManager propertyManager = commandContext.getPropertyManager();
        propertyManager.acquireExclusiveLockForTelemetry();
    }

    protected void acquireExclusiveInstallationIdLock(CommandContext commandContext) {
        PropertyManager propertyManager = commandContext.getPropertyManager();
        propertyManager.acquireExclusiveLockForInstallationId();
    }

    @Override
    public boolean isRetryable() {
        return true;
    }
}

