/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.telemetry;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import org.camunda.bpm.engine.impl.telemetry.CommandCounter;
import org.camunda.bpm.engine.impl.telemetry.PlatformTelemetryRegistry;
import org.camunda.bpm.engine.impl.telemetry.dto.ApplicationServerImpl;
import org.camunda.bpm.engine.impl.telemetry.dto.LicenseKeyDataImpl;

public class TelemetryRegistry {
    protected Map<String, CommandCounter> commands = new HashMap<String, CommandCounter>();
    protected ApplicationServerImpl applicationServer;
    protected LicenseKeyDataImpl licenseKey;
    protected String camundaIntegration;
    protected Set<String> webapps = new HashSet<String>();
    protected AtomicBoolean telemetryLocallyActivated = new AtomicBoolean(false);

    public synchronized ApplicationServerImpl getApplicationServer() {
        if (this.applicationServer == null) {
            this.applicationServer = PlatformTelemetryRegistry.getApplicationServer();
        }
        return this.applicationServer;
    }

    public synchronized void setApplicationServer(ApplicationServerImpl applicationServer) {
        this.applicationServer = applicationServer;
    }

    public synchronized void setApplicationServer(String applicationServerVersion) {
        this.applicationServer = new ApplicationServerImpl(applicationServerVersion);
    }

    public Map<String, CommandCounter> getCommands() {
        return this.commands;
    }

    public String getCamundaIntegration() {
        return this.camundaIntegration;
    }

    public void setCamundaIntegration(String camundaIntegration) {
        this.camundaIntegration = camundaIntegration;
    }

    public LicenseKeyDataImpl getLicenseKey() {
        return this.licenseKey;
    }

    public void setLicenseKey(LicenseKeyDataImpl licenseKey) {
        this.licenseKey = licenseKey;
    }

    public synchronized Set<String> getWebapps() {
        return this.webapps;
    }

    public synchronized void setWebapps(Set<String> webapps) {
        this.webapps = webapps;
    }

    public void markOccurrence(String name) {
        this.markOccurrence(name, 1L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void markOccurrence(String name, long times) {
        CommandCounter counter = this.commands.get(name);
        if (counter == null) {
            Map<String, CommandCounter> map = this.commands;
            synchronized (map) {
                if (counter == null) {
                    counter = new CommandCounter(name);
                    this.commands.put(name, counter);
                }
            }
        }
        counter.mark(times);
    }

    public synchronized void addWebapp(String webapp) {
        if (!this.webapps.contains(webapp)) {
            this.webapps.add(webapp);
        }
    }

    public boolean isTelemetryLocallyActivated() {
        return this.telemetryLocallyActivated.get();
    }

    public boolean setTelemetryLocallyActivated(boolean activated) {
        return this.telemetryLocallyActivated.getAndSet(activated);
    }

    public void clearCommandCounts() {
        this.commands.clear();
    }

    public void clear() {
        this.commands.clear();
        this.licenseKey = null;
        this.applicationServer = null;
        this.webapps.clear();
    }
}

