/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.mgmt;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.camunda.bpm.engine.ManagementService;
import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.RuntimeService;
import org.camunda.bpm.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.camunda.bpm.engine.impl.metrics.Meter;
import org.camunda.bpm.engine.impl.metrics.MetricsRegistry;
import org.camunda.bpm.engine.impl.telemetry.TelemetryRegistry;
import org.camunda.bpm.engine.impl.telemetry.dto.CommandImpl;
import org.camunda.bpm.engine.impl.telemetry.dto.DatabaseImpl;
import org.camunda.bpm.engine.impl.telemetry.dto.InternalsImpl;
import org.camunda.bpm.engine.impl.telemetry.dto.JdkImpl;
import org.camunda.bpm.engine.impl.telemetry.dto.LicenseKeyDataImpl;
import org.camunda.bpm.engine.impl.telemetry.dto.MetricImpl;
import org.camunda.bpm.engine.impl.telemetry.dto.ProductImpl;
import org.camunda.bpm.engine.impl.telemetry.dto.TelemetryDataImpl;
import org.camunda.bpm.engine.impl.telemetry.reporter.TelemetryReporter;
import org.camunda.bpm.engine.impl.util.ParseUtil;
import org.camunda.bpm.engine.telemetry.Command;
import org.camunda.bpm.engine.telemetry.Metric;
import org.camunda.bpm.engine.telemetry.TelemetryData;
import org.camunda.bpm.engine.test.Deployment;
import org.camunda.bpm.engine.test.util.ProvidedProcessEngineRule;
import org.junit.After;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;

public class ManagementServiceGetTelemetryDataTest {
    protected static final String INSTALLATION_ID = "cb07ce31-c8e3-4f5f-94c2-1b28175c2022";
    protected static final String PRODUCT_NAME = "Runtime";
    protected static final String PRODUCT_VERSION = "7.14.0";
    protected static final String PRODUCT_EDITION = "special";
    protected static final String DB_VENDOR = "mySpecialDb";
    protected static final String DB_VERSION = "v.1.2.3";
    protected static final String APP_SERVER_VENDOR = "Apache Tomcat";
    protected static final String APP_SERVER_VERSION = "Apache Tomcat/10.0.1";
    protected static final String TELEMETRY_CONFIGURE_CMD_NAME = "TelemetryConfigureCmd";
    protected static final String IS_TELEMETRY_ENABLED_CMD_NAME = "IsTelemetryEnabledCmd";
    protected static final String GET_TELEMETRY_DATA_CMD_NAME = "GetTelemetryDataCmd";
    protected static final String LICENSE_CUSTOMER_NAME = "customer a";
    @Rule
    public ProvidedProcessEngineRule engineRule = new ProvidedProcessEngineRule();
    protected ProcessEngineConfigurationImpl configuration;
    protected ManagementService managementService;
    protected RuntimeService runtimeService;
    protected TelemetryRegistry telemetryRegistry;
    protected MetricsRegistry metricsRegistry;
    protected TelemetryDataImpl defaultTelemetryData;
    protected TelemetryReporter defaultTelemetryReporter;

    @Before
    public void setup() {
        this.configuration = this.engineRule.getProcessEngineConfiguration();
        this.managementService = this.engineRule.getManagementService();
        this.runtimeService = this.engineRule.getRuntimeService();
        this.telemetryRegistry = this.configuration.getTelemetryRegistry();
        this.metricsRegistry = this.configuration.getMetricsRegistry();
        this.clearMetrics();
        this.configuration.getTelemetryRegistry().clear();
        this.defaultTelemetryData = new TelemetryDataImpl(this.configuration.getTelemetryData());
        this.defaultTelemetryReporter = this.configuration.getTelemetryReporter();
    }

    @After
    public void tearDown() {
        if (Boolean.TRUE.equals(this.managementService.isTelemetryEnabled())) {
            this.managementService.toggleTelemetry(false);
        }
        this.clearMetrics();
        this.configuration.getTelemetryRegistry().clear();
        this.configuration.setTelemetryData(this.defaultTelemetryData);
        this.configuration.setTelemetryReporter(this.defaultTelemetryReporter);
    }

    protected void clearMetrics() {
        Collection meters = this.configuration.getMetricsRegistry().getTelemetryMeters().values();
        for (Meter meter : meters) {
            meter.getAndClear();
        }
        this.managementService.deleteMetrics(null);
    }

    protected void createTestData() {
        DatabaseImpl database = new DatabaseImpl(DB_VENDOR, DB_VERSION);
        JdkImpl jdk = ParseUtil.parseJdkDetails();
        InternalsImpl internals = new InternalsImpl(database, null, null, jdk);
        internals.setCommands(this.createTestCommands());
        internals.setMetrics(this.createTestMetrics());
        ProductImpl product = new ProductImpl(PRODUCT_NAME, PRODUCT_VERSION, PRODUCT_EDITION, internals);
        TelemetryDataImpl testData = new TelemetryDataImpl(INSTALLATION_ID, product);
        this.configuration.setTelemetryData(testData);
        TelemetryRegistry registry = this.configuration.getTelemetryRegistry();
        registry.setApplicationServer(APP_SERVER_VERSION);
        registry.setLicenseKey(new LicenseKeyDataImpl(LICENSE_CUSTOMER_NAME, "UNIFIED", "2029-09-01", Boolean.valueOf(false), Collections.singletonMap("camundaBPM", "true"), "raw license"));
        registry.setWebapps((Set)Stream.of("cockpit", "admin").collect(Collectors.toCollection(HashSet::new)));
        this.configuration.setTelemetryReporter(new TelemetryReporter(this.configuration.getCommandExecutorTxRequired(), this.configuration.getTelemetryEndpoint(), this.configuration.getTelemetryRequestRetries(), this.configuration.getTelemetryReportingPeriod(), testData, this.configuration.getTelemetryHttpConnector(), this.configuration.getTelemetryRegistry(), this.configuration.getMetricsRegistry(), this.configuration.getTelemetryRequestTimeout()));
    }

    private Map<String, Metric> createTestMetrics() {
        HashMap<String, Metric> metrics = new HashMap<String, Metric>();
        metrics.put("root-process-instance-start", (Metric)new MetricImpl(2L));
        metrics.put("activity-instance-start", (Metric)new MetricImpl(4L));
        metrics.put("executed-decision-elements", (Metric)new MetricImpl(8L));
        metrics.put("executed-decision-instances", (Metric)new MetricImpl(16L));
        for (Map.Entry entry : metrics.entrySet()) {
            this.metricsRegistry.markTelemetryOccurrence((String)entry.getKey(), ((Metric)entry.getValue()).getCount());
        }
        return metrics;
    }

    private Map<String, Command> createTestCommands() {
        HashMap<String, Command> commands = new HashMap<String, Command>();
        commands.put(GET_TELEMETRY_DATA_CMD_NAME, (Command)new CommandImpl(3L));
        commands.put(IS_TELEMETRY_ENABLED_CMD_NAME, (Command)new CommandImpl(6L));
        for (Map.Entry entry : commands.entrySet()) {
            this.telemetryRegistry.markOccurrence((String)entry.getKey(), ((Command)entry.getValue()).getCount());
        }
        return commands;
    }

    @Test
    public void shouldReturnTelemetryData_TelemetryEnabled() {
        this.managementService.toggleTelemetry(true);
        this.createTestData();
        TelemetryData telemetryData = this.managementService.getTelemetryData();
        this.assertTelemetryData(telemetryData, true);
    }

    @Test
    public void shouldReturnTelemetryData_TelemetryDisabled() {
        this.managementService.toggleTelemetry(false);
        this.createTestData();
        TelemetryData telemetryData = this.managementService.getTelemetryData();
        this.assertTelemetryData(telemetryData, false);
    }

    @Test
    public void shouldReturnCommands() {
        TelemetryRegistry telemetryRegistry = this.configuration.getTelemetryRegistry();
        telemetryRegistry.markOccurrence(GET_TELEMETRY_DATA_CMD_NAME, 10L);
        telemetryRegistry.markOccurrence(IS_TELEMETRY_ENABLED_CMD_NAME, 20L);
        telemetryRegistry.markOccurrence(TELEMETRY_CONFIGURE_CMD_NAME, 30L);
        TelemetryData telemetryData = this.managementService.getTelemetryData();
        Map commands = telemetryData.getProduct().getInternals().getCommands();
        Assertions.assertThat((Map)commands).containsOnlyKeys((Object[])new String[]{GET_TELEMETRY_DATA_CMD_NAME, IS_TELEMETRY_ENABLED_CMD_NAME, TELEMETRY_CONFIGURE_CMD_NAME});
        Assertions.assertThat((long)((Command)commands.get(GET_TELEMETRY_DATA_CMD_NAME)).getCount()).isEqualTo(10L);
        Assertions.assertThat((long)((Command)commands.get(IS_TELEMETRY_ENABLED_CMD_NAME)).getCount()).isEqualTo(20L);
        Assertions.assertThat((long)((Command)commands.get(TELEMETRY_CONFIGURE_CMD_NAME)).getCount()).isEqualTo(30L);
    }

    @Test
    public void shouldReturnMetrics() {
        this.configuration.initDatabaseType();
        MetricsRegistry metricsRegistry = this.configuration.getMetricsRegistry();
        metricsRegistry.markTelemetryOccurrence("activity-instance-start", 5L);
        metricsRegistry.markTelemetryOccurrence("root-process-instance-start", 15L);
        metricsRegistry.markTelemetryOccurrence("executed-decision-elements", 25L);
        metricsRegistry.markTelemetryOccurrence("executed-decision-instances", 35L);
        TelemetryData telemetryData = this.managementService.getTelemetryData();
        Map metrics = telemetryData.getProduct().getInternals().getMetrics();
        Assertions.assertThat((Map)metrics).containsOnlyKeys((Object[])new String[]{"flow-node-instances-start", "process-instances", "executed-decision-elements", "decision-instances"});
        Assertions.assertThat((long)((Metric)metrics.get("flow-node-instances-start")).getCount()).isEqualTo(5L);
        Assertions.assertThat((long)((Metric)metrics.get("process-instances")).getCount()).isEqualTo(15L);
        Assertions.assertThat((long)((Metric)metrics.get("executed-decision-elements")).getCount()).isEqualTo(25L);
        Assertions.assertThat((long)((Metric)metrics.get("decision-instances")).getCount()).isEqualTo(35L);
    }

    @Test
    public void shouldNotResetCommandCount() {
        TelemetryRegistry telemetryRegistry = this.configuration.getTelemetryRegistry();
        telemetryRegistry.markOccurrence(IS_TELEMETRY_ENABLED_CMD_NAME, 10L);
        TelemetryData firstTelemetryData = this.managementService.getTelemetryData();
        TelemetryData secondTelemetryData = this.managementService.getTelemetryData();
        Assertions.assertThat((long)((Command)firstTelemetryData.getProduct().getInternals().getCommands().get(IS_TELEMETRY_ENABLED_CMD_NAME)).getCount()).isEqualTo(10L);
        Assertions.assertThat((long)((Command)secondTelemetryData.getProduct().getInternals().getCommands().get(IS_TELEMETRY_ENABLED_CMD_NAME)).getCount()).isEqualTo(10L);
    }

    @Test
    public void shouldNotResetMetricsCount() {
        MetricsRegistry metricsRegistry = this.configuration.getMetricsRegistry();
        metricsRegistry.markTelemetryOccurrence("activity-instance-start", 5L);
        TelemetryData firstTelemetryData = this.managementService.getTelemetryData();
        TelemetryData secondTelemetryData = this.managementService.getTelemetryData();
        Assertions.assertThat((long)((Metric)firstTelemetryData.getProduct().getInternals().getMetrics().get("flow-node-instances-start")).getCount()).isEqualTo(5L);
        Assertions.assertThat((long)((Metric)secondTelemetryData.getProduct().getInternals().getMetrics().get("flow-node-instances-start")).getCount()).isEqualTo(5L);
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    public void shouldCollectMetrics_TelemetryEnabled() {
        this.managementService.toggleTelemetry(true);
        TelemetryData telemetryDataBeforePiStart = this.managementService.getTelemetryData();
        this.engineRule.getRuntimeService().startProcessInstanceByKey("oneTaskProcess");
        TelemetryData telemetryDataAfterPiStart = this.managementService.getTelemetryData();
        Assertions.assertThat((long)((Metric)telemetryDataBeforePiStart.getProduct().getInternals().getMetrics().get("process-instances")).getCount()).isEqualTo(0L);
        Assertions.assertThat((long)((Metric)telemetryDataAfterPiStart.getProduct().getInternals().getMetrics().get("process-instances")).getCount()).isEqualTo(1L);
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    public void shouldCollectMetrics_TelemetryDisabled() {
        this.managementService.toggleTelemetry(false);
        TelemetryData telemetryDataBeforePiStart = this.managementService.getTelemetryData();
        this.engineRule.getRuntimeService().startProcessInstanceByKey("oneTaskProcess");
        TelemetryData telemetryDataAfterPiStart = this.managementService.getTelemetryData();
        Metric rootPiStartMetricBeforePiStart = (Metric)telemetryDataBeforePiStart.getProduct().getInternals().getMetrics().get("process-instances");
        Metric rootPiStartMetricAfterPiStart = (Metric)telemetryDataAfterPiStart.getProduct().getInternals().getMetrics().get("process-instances");
        Assertions.assertThat((long)rootPiStartMetricBeforePiStart.getCount()).isEqualTo(0L);
        Assertions.assertThat((long)rootPiStartMetricAfterPiStart.getCount()).isEqualTo(1L);
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    public void shouldCollectCommands_TelemetryEnabled() {
        this.managementService.toggleTelemetry(true);
        TelemetryData telemetryDataBeforePiStart = this.managementService.getTelemetryData();
        this.managementService.isTelemetryEnabled();
        TelemetryData telemetryDataAfterPiStart = this.managementService.getTelemetryData();
        Assertions.assertThat((Object)((Command)telemetryDataBeforePiStart.getProduct().getInternals().getCommands().get(IS_TELEMETRY_ENABLED_CMD_NAME))).isNull();
        Assertions.assertThat((long)((Command)telemetryDataAfterPiStart.getProduct().getInternals().getCommands().get(IS_TELEMETRY_ENABLED_CMD_NAME)).getCount()).isEqualTo(1L);
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    public void shouldCollectCommands_TelemetryDisabled() {
        this.managementService.toggleTelemetry(false);
        TelemetryData telemetryDataBeforePiStart = this.managementService.getTelemetryData();
        this.managementService.isTelemetryEnabled();
        TelemetryData telemetryDataAfterPiStart = this.managementService.getTelemetryData();
        Assertions.assertThat((Object)((Command)telemetryDataBeforePiStart.getProduct().getInternals().getCommands().get(IS_TELEMETRY_ENABLED_CMD_NAME))).isNull();
        Assertions.assertThat((long)((Command)telemetryDataAfterPiStart.getProduct().getInternals().getCommands().get(IS_TELEMETRY_ENABLED_CMD_NAME)).getCount()).isEqualTo(1L);
    }

    @Test
    public void shouldThrowExceptionOnNullTelemetryReporter() {
        this.configuration.setTelemetryReporter(null);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.managementService.getTelemetryData()).isInstanceOf(ProcessEngineException.class)).hasMessageContaining("Error while retrieving telemetry data. Telemetry registry was not initialized.");
    }

    @Test
    public void shouldResetCollectedCommandsDataWhenTelemetryEnabled() {
        this.managementService.getHistoryLevel();
        this.managementService.getLicenseKey();
        this.managementService.toggleTelemetry(true);
        this.managementService.getTelemetryData();
        this.managementService.getTelemetryData();
        this.managementService.isTelemetryEnabled();
        TelemetryData telemetryData = this.managementService.getTelemetryData();
        Map commands = telemetryData.getProduct().getInternals().getCommands();
        Assertions.assertThat((int)commands.size()).isEqualTo(3);
        Assertions.assertThat((long)((Command)commands.get(GET_TELEMETRY_DATA_CMD_NAME)).getCount()).isEqualTo(2L);
        Assertions.assertThat((long)((Command)commands.get(IS_TELEMETRY_ENABLED_CMD_NAME)).getCount()).isEqualTo(1L);
        Assertions.assertThat((long)((Command)commands.get(TELEMETRY_CONFIGURE_CMD_NAME)).getCount()).isEqualTo(1L);
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    public void shouldResetCollectedMetricsDataWhenTelemetryEnabled() {
        this.runtimeService.startProcessInstanceByKey("oneTaskProcess");
        this.managementService.toggleTelemetry(true);
        this.runtimeService.startProcessInstanceByKey("oneTaskProcess");
        TelemetryData telemetryData = this.managementService.getTelemetryData();
        Map metrics = telemetryData.getProduct().getInternals().getMetrics();
        Assertions.assertThat((int)metrics.size()).isEqualTo(4);
        Assertions.assertThat((long)((Metric)metrics.get("flow-node-instances-start")).getCount()).isEqualTo(2L);
        Assertions.assertThat((long)((Metric)metrics.get("process-instances")).getCount()).isEqualTo(1L);
        Assertions.assertThat((long)((Metric)metrics.get("decision-instances")).getCount()).isEqualTo(0L);
        Assertions.assertThat((long)((Metric)metrics.get("executed-decision-elements")).getCount()).isEqualTo(0L);
    }

    protected void assertTelemetryData(TelemetryData data, boolean telemetryEnabled) {
        Assertions.assertThat((Object)data).isNotNull();
        Assertions.assertThat((String)data.getInstallation()).isEqualTo((Object)INSTALLATION_ID);
        Assertions.assertThat((String)data.getProduct().getName()).isEqualTo((Object)PRODUCT_NAME);
        Assertions.assertThat((String)data.getProduct().getVersion()).isEqualTo((Object)PRODUCT_VERSION);
        Assertions.assertThat((String)data.getProduct().getEdition()).isEqualTo((Object)PRODUCT_EDITION);
        Assertions.assertThat((String)data.getProduct().getInternals().getDatabase().getVendor()).isEqualTo((Object)DB_VENDOR);
        Assertions.assertThat((String)data.getProduct().getInternals().getDatabase().getVersion()).isEqualTo((Object)DB_VERSION);
        Assertions.assertThat((String)data.getProduct().getInternals().getApplicationServer().getVendor()).isEqualTo((Object)APP_SERVER_VENDOR);
        Assertions.assertThat((String)data.getProduct().getInternals().getApplicationServer().getVersion()).isEqualTo((Object)APP_SERVER_VERSION);
        Assertions.assertThat((String)data.getProduct().getInternals().getJdk().getVendor()).isNotNull();
        Assertions.assertThat((String)data.getProduct().getInternals().getJdk().getVersion()).isNotNull();
        Assertions.assertThat((String)data.getProduct().getInternals().getLicenseKey().getCustomer()).isEqualTo((Object)LICENSE_CUSTOMER_NAME);
        Assertions.assertThat((Map)data.getProduct().getInternals().getCommands()).containsKeys((Object[])new String[]{GET_TELEMETRY_DATA_CMD_NAME, IS_TELEMETRY_ENABLED_CMD_NAME});
        Assertions.assertThat((long)((Command)data.getProduct().getInternals().getCommands().get(GET_TELEMETRY_DATA_CMD_NAME)).getCount()).isEqualTo(3L);
        Assertions.assertThat((long)((Command)data.getProduct().getInternals().getCommands().get(IS_TELEMETRY_ENABLED_CMD_NAME)).getCount()).isEqualTo(6L);
        if (telemetryEnabled) {
            Assertions.assertThat((Map)data.getProduct().getInternals().getCommands()).containsKeys((Object[])new String[]{TELEMETRY_CONFIGURE_CMD_NAME});
            Assertions.assertThat((long)((Command)data.getProduct().getInternals().getCommands().get(TELEMETRY_CONFIGURE_CMD_NAME)).getCount()).isEqualTo(1L);
        }
        Assertions.assertThat((Map)data.getProduct().getInternals().getMetrics()).containsOnlyKeys((Object[])new String[]{"process-instances", "flow-node-instances-start", "executed-decision-elements", "decision-instances"});
        Assertions.assertThat((long)((Metric)data.getProduct().getInternals().getMetrics().get("process-instances")).getCount()).isEqualTo(2L);
        Assertions.assertThat((long)((Metric)data.getProduct().getInternals().getMetrics().get("flow-node-instances-start")).getCount()).isEqualTo(4L);
        Assertions.assertThat((long)((Metric)data.getProduct().getInternals().getMetrics().get("executed-decision-elements")).getCount()).isEqualTo(8L);
        Assertions.assertThat((long)((Metric)data.getProduct().getInternals().getMetrics().get("decision-instances")).getCount()).isEqualTo(16L);
        Assertions.assertThat((Iterable)data.getProduct().getInternals().getWebapps()).containsExactlyInAnyOrder((Object[])new String[]{"cockpit", "admin"});
    }
}

